;	===============================================================
;	XPTEST - ASM Test XP (V7)
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 4-Nov-99
;	---------------------------------------------------------------
XPID		equ	0		;this modules' XP ID #
Main		equ	1		;this is the main prog module

		include	\fcw7\XP7DEV\XP.CPY

		Public	DllMain

;	---------------------------------------------------------------
.data
XPVer		equ	versionNr		;XP version #
XPDef		XPHDR	<,,XPName,CList,PList>
XPName		db	"MASM Test XP - V7",0
CList		db	"ATEST1",0
		db	"ATEST2",0
		db	"ATEST3",0
		db	0
PList		dword	About			;about this XP...
		dword	ATest1Cmd
		dword	ATest2Cmd
		dword	ATest3Cmd
.code

;	===============================================================
;	DllMain - DLL Init/End processing procedure
;	===============================================================

DllMain		proc	stdcall,
			hInstDLL:DWORD,fdwReason:DWORD,lpvReserved:DWORD
		WENTRY
		cmp	fdwReason,DLL_PROCESS_ATTACH
		jz	init
		cmp	fdwReason,DLL_PROCESS_DETACH
		jz	atend
		mov	eax,1			;return TRUE
		WEXIT

;	Initialize this XP (do no output yet!)

init:		mov	eax,hInstDLL		;save instance handle
		mov	XPDef.ModHdl,eax
		INVOKE	XPRegister,ADDR XPDef	;connect module
		mov	eax,1			;return TRUE
		WEXIT

;	End using this XP

atend:		INVOKE	XPUnRegister,ADDR XPDef
		mov	eax,1			;return TRUE
		WEXIT
DllMain		endp

;	===============================================================
;	About - About this XP...
;	===============================================================
.data
APkt		dword	AText
AText		db	"XPTest - MASM Language Test XP",13
		db	"Version ",versionStr,13,13
		db	"Copyright 1999 Evolution Computing",13
		db	"All rights reserved",13,13
		db	"ATEST1 - Mimic the LINE command",13
		db	"ATEST2 - Mimic the MOVE command",0
.code

About		proc	stdcall
		WENTRY
		INVOKE	FormSt,ADDR APkt,FV_ASM,NULL,FD_MsgBox
		WEXIT
About		endp

;	===============================================================
;	ATEST1 - create a line entity
;	===============================================================
.data
BuildL		Line2	<>
hDwgDL		dword	0			;work DL
.code

ATest1B		proto	stdcall,Result:dword
ATest1C		proto	stdcall,Result:dword

ATest1Cmd	proc	stdcall
		WENTRY
		INVOKE	ReqData,\		;ask for command
			RD_2dC8,
			ADDR BuildL.Geo.P1,
			RSC_FirstPt,
			RDC_RXH2,
			ADDR ATest1B,
			RDF_NONE,
			IDH_LINE2
		WEXIT
ATest1Cmd	endp

ATest1B		proc	stdcall,Result:dword
		WENTRY
		cmp	Result,RD_OK
		jz	Ok
		INVOKE	CmdEnd
		WEXIT
Ok:		INVOKE	GetWorkDL		;get current work DList
		mov	hDwgDL,eax
		INVOKE	ClearSelect		;for sel by prior
		COBJ	DLMarkUndo,hDwgDL	;set undo op on it
		INVOKE	SetCursorOrg2,BuildL.Geo.P1.X,BuildL.Geo.P1.Y

		INVOKE	ReqData,\		;ask for P2
			RD_2dC8,
			ADDR BuildL.Geo.P2,
			RSC_NextPt,
			RDC_RBand2,
			ADDR ATest1C,
			RDF_ORTHO,
			IDH_LINE2
		WEXIT
ATest1B		endp

ATest1C		proc	stdcall,Result:dword
		WENTRY
		cmp	Result,RD_OK
		jz	Ok
		INVOKE	CmdEnd
		WEXIT
Ok:		COBJ	DLApnd,hDwgDL,<offset BuildL>
		mov	ebx,eax
		INVOKE	SetCStuff,ebx
		COBJ	DLSelect,hDwgDL,ebx
		INVOKE	EDraw,NULL,ebx
		INVOKE	ShowChanges

;	Set up for chained operation

		fdmove	BuildL.Geo.P1.X,BuildL.Geo.P2.X
		fndmove	BuildL.Geo.P1.Y,BuildL.Geo.P2.Y

		INVOKE	SetCursorOrg2,BuildL.Geo.P1.X,BuildL.Geo.P1.Y

		INVOKE	ReqData,\		;ask for P2
			RD_2dC8,
			ADDR BuildL.Geo.P2,
			RSC_NextPt,
			RDC_RBand2,
			ADDR ATest1C,
			RDF_ORTHO,
			IDH_LINE2
		WEXIT
ATest1C		endp

;	===============================================================
;	ATEST2 - select & move entities
;	===============================================================
.data
MFrom		GPnt3	<>
MTo		GPnt3	<>
MoveTM		TMat	<>
.code

ATest2CmdB	proto	stdcall,Result:dword
ATest2CmdC	proto	stdcall,Result:dword
ATest2CmdD	proto	stdcall,Result:dword

ATest2Cmd	proc	stdcall
		WENTRY
		INVOKE	ReqData,\		;ask for entities
			RD_Pick,
			NULL,
			RSC_Select,
			RDC_Arrow,
			ADDR ATest2CmdB,
			RDF_NONE,
			IDH_SELECT
		WEXIT
ATest2Cmd	endp

ATest2CmdB	proc	stdcall,Result:dword
		WENTRY
		cmp	Result,RD_OK
		jz	Ok
		INVOKE	CmdEnd
		WEXIT
Ok:
		INVOKE	ReqData,\		;ask for P2
			RD_3dC8,
			ADDR MFrom,
			RSC_MoveFrom,
			RDC_RXH3,
			ADDR ATest2CmdC,
			RDF_NONE,
			IDH_MOVE
		WEXIT
ATest2CmdB	endp

ATest2CmdC	proc	stdcall,Result:dword
		WENTRY
		cmp	Result,RD_OK
		jz	Ok
		INVOKE	ClearSelect		;unhilight
		INVOKE	CmdEnd
		WEXIT
Ok:
		INVOKE	SetCursorOrg3,MFrom.X,MFrom.Y,MFrom.Z

		INVOKE	ReqData,\		;ask for P2
			RD_3dC8,
			ADDR MTo,
			RSC_MoveTo,
			RDC_RBand3,
			ADDR ATest2CmdD,
			RDF_ORTHO,
			IDH_MOVE
		WEXIT
ATest2CmdC	endp

ATest2Rec	proc	stdcall,hDList:dword,pRecd:dword,\
			Parm1:dword,Parm2:dword
		local	pNew:dword
		WENTRY
		COBJ	DLClone,hDwgDL,pRecd	;make clone to change
		mov	pNew,eax
		INVOKE	ETran,pNew,ADDR MoveTM
		INVOKE	EErase,NULL,pRecd	;undraw the original
		INVOKE	EDraw,NULL,pNew		;redraw the entity
		mov	eax,0			;continue the scan
		WEXIT
ATest2Rec		endp

ATest2CmdD	proc	stdcall,Result:dword
		WENTRY
		cmp	Result,RD_OK
		jz	Ok
		INVOKE	ClearSelect		;unhilight
		INVOKE	CmdEnd
		WEXIT
Ok:
		INVOKE	GetWorkDL		;get current work DList
		mov	hDwgDL,eax
		COBJ	DLMarkUndo,hDwgDL

		INVOKE	CTMPSH
		INVOKE	CTMI3			;setup CTM for transform
		fld	MTo.X
		fsub	MFrom.X
		fld	MTo.Y
		fsub	MFrom.Y
		fld	MTo.Z
		fsub	MFrom.Z
		INVOKE	CTMT3S
		INVOKE	STCTM,ADDR MoveTM
		INVOKE	CTMPOP

		COBJ	DLScan,hDwgDL,<offset ATest2Rec>,DLS_Edit,0,0
		INVOKE	ShowChanges
		INVOKE	CmdEnd
		WEXIT
ATest2CmdD	endp

;	===============================================================
;	ATEST3 - Test A Dialog
;	===============================================================
.data
.data
CheckValue	dword	0
OldCheckValue	dword	0
ExitCode	dword	0
RBValue		dword	1	;selected radio button
OldRBValue	dword	0
ListIdx		dword	2	;selected item in list box
OldListIdx	dword	0
CmbIdx		dword	4	;selected item in combo box
OldCmbIdx	dword	0

LstData		db	"Apples",0
		db	"Pears",0
		db	"Cantelope",0
		db	"Oranges",0
		db	"Bananas",0
		db	0

CmbData		db	"Red Beans",0
		db	"Peas",0
		db	"Carrots",0
		db	"Corn",0
		db	"Broccoli",0
		db	"Lima Beans",0
		db	0

TestPt		GPnt2	<1.0,2.0>
OldPt		GPnt2	<>

DlgXtPkt	dword	szDlgXt
		ItemFmt	<ExitCode,FT_Dec4,FJ_Var>
szDlgXt		db	"Dialog exit code = !01",13,0

AT3Dlg		label	byte
		DLG	"AT3DLG",0,0
		CHKCTL	200,0,0,CheckValue,1,NULL
		RBCTL	201,0,0,RBValue,1,NULL
		RBCTL	202,0,0,RBValue,2,NULL
		RBCTL	203,0,0,RBValue,3,NULL
		BTNCTL	204,0,0,AT6Btn204,NULL
		BTNCTL	205,0,0,AT6Btn205,NULL
		EDCTL	206,0,FT_2dC8,64,TestPt,NULL
		LSTCTL	207,0,0,ListIdx,LstData,NULL,NULL
		CMBCTL	208,0,0,CmbIdx,CmbData,NULL,NULL
		ENDDLG
.code

ATest3Cmd	proc	stdcall
		WENTRY
		MOVED	OldCheckValue,CheckValue
		MOVED	OldRBValue,RBValue
		MOVED	OldListIdx,ListIdx
		MOVED	OldCmbIdx,CmbIdx
		fdmove	OldPt.X,TestPt.X
		fndmove	OldPt.Y,TestPt.Y

		mov	ebx,XPDef.ModHdl
		INVOKE	Dialog,ADDR AT3Dlg,ebx,NULL
		mov	ExitCode,eax

		cmp	eax,IDOK		;unless the exit code is
		jz	done			;IDOK or IDCANCEL (those
		cmp	eax,IDCANCEL		; buttons caused dialog to
		jz	Cancel			; exit), show the exit code
		INVOKE	FormSt,ADDR DlgXtPkt,FV_ASM,NULL,FD_MsgBox
		jmp	done			;then end command

Cancel:		MOVED	CheckValue,OldCheckValue ;CANCEL = undo any changes
		MOVED	RBValue,OldRBValue
		MOVED	ListIdx,OldListIdx
		MOVED	CmbIdx,OldCmbIdx
		fdmove	TestPt.X,OldPt.X
		fndmove	TestPt.Y,OldPt.Y

done:		INVOKE	CmdEnd
		WEXIT
ATest3Cmd	endp

;	Button 204 pressed callback

.data
lpsz204		dword	sz204
sz204		db	"Button 204 pressed.",0
.code

AT6Btn204	proc	stdcall
		WENTRY
		INVOKE	FormSt,ADDR lpsz204,FV_ASM,NULL,FD_MsgBox
		mov	eax,0			;don't end dialog
		WEXIT
AT6Btn204	endp

;	Button 205 pressed callback

AT6Btn205	proc	stdcall
		WENTRY
		mov	eax,VCF_ENDDIALOG	;do exit the dialog
		WEXIT
AT6Btn205	endp

;	===============================================================
END
