;	===============================================================
;	SaveEXF - EXF Drawing Export XP (V7)
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 10-Dec-99
;	---------------------------------------------------------------
XPID		equ	0		;this modules' XP ID #
Main		equ	0		;this is not the main prog module

		include	\fcw7\XP7DEV\XP.CPY

		Public	SaveEXFFile

;	Local forward references:

SaveRec		proto	stdcall,hDList:dword,pRecd:dword,\
			pSRef:dword,Parm2:dword

;	===============================================================
.data
pFName		dword	0		;file name address
pIOBfr		dword	0		;I/O buffer handle
pFile		dword	0		;system file handle
hDwgDL		dword	0		;DList to save
pEntity		dword	0		;entity being exported

BFRSIZE		equ	4000h		;16k i/o buffer size

ExfHdr		db	"EXF3 6.035",13,10
		db	"C:\FCAD3\WORK.FC7",13,10
		db	"FCAD v6.035 drawing file:  Unlabeled drawing.",13,10
		db	"1.000000,Units",13,10
		db	"0,1,3,3,Dim Specs",13,10
		db	"2.932150,5,1.250000,Arrowhead Specs",13,10
		db	"2,03333",13,10
		db	"3,05555",13,10
		db	"4,05F5F",13,10
		db	"5,0FC9F",13,10
		db	"6,09F9F",13,10
		db	"7,00F0F",13,10
		db	"8,00303",13,10
		db	"9,0FFFF",13,10
		db	"10,0FFFF",13,10
		db	"11,0FFFF",13,10
		db	"12,0FFFF",13,10
		db	"13,0FFFF",13,10
		db	"14,0FFFF",13,10
		db	"15,0FFFF",13,10
		db	"16,0FFFF",13,10
		db	"*",13,10,0

ExfEOF		db	"0,EOF",13,10

.code
;	===============================================================
;	Write String to buffered I/O
;	===============================================================

WriteStg	proc	stdcall,pStg:dword
		WENTRY
		INVOKE	StLen,pStg	;calc data length
		dec	eax
		mov	ecx,eax
		INVOKE	WriteBfr,pIOBfr,pStg,ecx
		WEXIT
WriteStg	endp

;	===============================================================
;	SaveEXFFile - Save hDList as RSC_SaveFileName
;	===============================================================

SaveEXFFile	proc	stdcall,hDList:dword
		WENTRY
		MOVED	hDwgDL,hDList		;make global copy

;	Create the file and its I/O Buffer structure

		COBJ	DLGetFileName,hDList	;get file name address
		mov	pFName,eax
		INVOKE	FCreate,pFName		;create the file
		jc	bad
		mov	pFile,eax
		INVOKE	CreateWriteBfr,pFile,BFRSIZE ;and its IO buffer
		mov	pIOBfr,eax
		jc	bad

;	Write the EXF header lines

		INVOKE	WriteStg,ADDR ExfHdr
		jc	bad

;	Scan the database and write entities

		COBJ	DLScan,hDwgDL,<offset SaveRec>,DLS_Std,0,0

;	Write the EXF end of file line

		INVOKE	WriteStg,ADDR ExfEOF

;	Save complete

done:		INVOKE	DestroyWriteBfr,pIOBfr
		mov	pIOBfr,0
		mov	eax,1
		clc
		WEXIT
bad:		INVOKE	DestroyWriteBfr,pIOBfr
		mov	pIOBfr,0
		mov	eax,0
		stc
		WEXIT
SaveEXFFile	endp

;	===============================================================
;	SaveRec - Write each entity
;	===============================================================
.data
SavePTbl	dword	0		;0=InfoBlocks
		dword	0		;1=2d point
		dword	EXFLine2	;2=2d line
		dword	EXFPath2	;3=2d path
		dword	EXFPoly2	;4=2d polygon
		dword	EXFText2	;5=2d text
		dword	EXFCircle2	;6=2d circle
		dword	EXFArc2		;7=2d arc
		dword	EXFElp2		;8=2d ellipse
		dword	EXFElA2		;9=2d elliptical arc
		dword	EXFPart2	;10=2d group (part)
		dword	(256-11) dup (0)
.code

SaveRec		proc	stdcall,hDList:dword,pRecd:dword,\
			Parm1:dword,Parm2:dword
		WENTRY
		mov	esi,pRecd		;get entity type code
		mov	pEntity,esi
		movzx	eax,CStuff.EType[esi]
		mov	ebx,SavePTbl[eax*4]	;get save proc for it
		cmp	ebx,0			;unavailable?
		jz	done
		call	ebx			;call it
done:		mov	eax,0			;continue the scan
		WEXIT
SaveRec		endp

;	===============================================================
;	Write Entity Common Stuff
;	===============================================================
.data
CStuffPkt	dword	CStuffFmt
		ItemFmt	<CStuff.EColor,FT_UDec1+FT_EBX,FJ_Var>
CStuffFmt	db	"1,!01,0,0,1",13,10,0
WorkStg		db	256 dup (0)
.code

EXFCStuff	proc	stdcall
		WENTRY
		INVOKE	FormSt,ADDR CStuffPkt,FV_ASM,pEntity,ADDR WorkStg
		INVOKE	WriteStg,ADDR WorkStg
		INVOKE	StLen,ADDR WorkStg	;calc data length
		WEXIT
EXFCStuff	endp

;	===============================================================
;	2d Line entity
;	===============================================================
.data
L2Pfx		db	"2,LINE",13,10,0
L2Pkt		dword	L2Fmt
		ItemFmt	<Line2.Geo.P1.X,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Line2.Geo.P1.Y,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Line2.Geo.P2.X,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Line2.Geo.P2.Y,FT_Real8+FT_EBX,FJ_Var>
L2Fmt		db	"!01,!02,!03,!04",13,10
		db	"*",13,10,0
.code

EXFLine2	proc	stdcall
		WENTRY
		INVOKE	WriteStg,ADDR L2Pfx	;entity prefix
		INVOKE	EXFCStuff		;write common stuff
		INVOKE	FormSt,ADDR L2Pkt,FV_ASM,pEntity,ADDR WorkStg
		INVOKE	WriteStg,ADDR WorkStg
		WEXIT
EXFLine2	endp

;	===============================================================
;	2d Path entity
;	===============================================================
.data
Pth2Pfx		db	"6,PATH",13,10,0

Pth2Pkt		dword	Pth2Fmt
		ItemFmt	<Path2.Geo.nNodes,FT_UDec2+FT_EBX,FJ_Var>
Pth2Fmt		db	"!01",13,10,0

Pth2NPkt	dword	Pth2NFmt
		ItemFmt	<GPnt2.X,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<GPnt2.Y,FT_Real8+FT_EBX,FJ_Var>
Pth2NFmt	db	"!01,!02",13,10,0

EndEnt		db	"*",13,10,0
.code

EXFPath2	proc	stdcall
		WENTRY
		INVOKE	WriteStg,ADDR Pth2Pfx	;entity prefix

		INVOKE	EXFCStuff		;write common stuff
		INVOKE	FormSt,ADDR Pth2Pkt,FV_ASM,pEntity,ADDR WorkStg
		INVOKE	WriteStg,ADDR WorkStg

		mov	ebx,pEntity		;write node data
		add	ebx,Path2.Geo
		movzx	ecx,GPath2.nNodes[ebx]
		add	ebx,GPath2.Nodes
		jecxz	done

Lup:		push	ecx			;write next node
		INVOKE	FormSt,ADDR Pth2NPkt,FV_ASM,ebx,ADDR WorkStg
		INVOKE	WriteStg,ADDR WorkStg
		pop	ecx			;setup next node
		add	ebx,sizeof(GPnt2)
		loop	Lup

done:		INVOKE	WriteStg,ADDR EndEnt
		WEXIT
EXFPath2	endp

;	===============================================================
;	2d Polygon entity
;	===============================================================
.data
Poly2Pfx	db	"7,POLYGON",13,10,0
NodeCnt		word	0
Poly2Pkt	dword	Pth2Fmt
		ItemFmt	<NodeCnt,FT_UDec2,FJ_Var>
Poly2Fmt	db	"!01",13,10,0
.code

EXFPoly2	proc	stdcall
		WENTRY
		INVOKE	WriteStg,ADDR Poly2Pfx	;entity prefix

		mov	ebx,pEntity		;don't count closing node
		mov	ax,Poly2.Geo.nNodes[ebx]
		dec	ax
		mov	NodeCnt,ax

		INVOKE	EXFCStuff		;write common stuff
		INVOKE	FormSt,ADDR Poly2Pkt,FV_ASM,pEntity,ADDR WorkStg
		INVOKE	WriteStg,ADDR WorkStg

		mov	ebx,pEntity		;write node data
		add	ebx,Poly2.Geo
		movzx	ecx,GPath2.nNodes[ebx]
		dec	ecx			;don't send closing node
		add	ebx,GPath2.Nodes
		jecxz	done

Lup:		push	ecx			;write next node
		INVOKE	FormSt,ADDR Pth2NPkt,FV_ASM,ebx,ADDR WorkStg
		INVOKE	WriteStg,ADDR WorkStg
		pop	ecx			;setup next node
		add	ebx,sizeof(GPnt2)
		loop	Lup

done:		INVOKE	WriteStg,ADDR EndEnt
		WEXIT
EXFPoly2	endp

;	===============================================================
;	2d Text entity
;	===============================================================
.data
Text2Pfx	db	"3,TEXT",13,10,0
TFontEXF	db	1			;force font=1
TJustEXF	word	0
Text2Pkt	dword	Text2Fmt
		ItemFmt	<Text2.Geo.At.X,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Text2.Geo.At.Y,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Text2.Geo.TS.Hgt,FT_Real4+FT_EBX,FJ_Var>
		ItemFmt	<Text2.Geo.TS.BAng,FT_Real4+FT_EBX,FJ_Var>
		ItemFmt	<TFontEXF,FT_UDec1,FJ_Var>		;use fake font style=1
;		ItemFmt	<Text2.Geo.TS.Font,FT_UDec2+FT_EBX,FJ_Var>
		ItemFmt	<TJustEXF,FT_UDec2,FJ_Var>
		ItemFmt	<Text2.Geo.TData,FT_Stg+FT_EBX,FJ_Var>
		ItemFmt	<Text2.Geo.TS.Stretch,FT_Real4+FT_EBX,FJ_Var>

Text2Fmt	db	"!01,!02,!03,!04",13,10
		db	"!05,!06",13,10
		db	"!07",13,10
		db	"!08",13,10
		db	"*",13,10,0

TTableJ		db	0,1,2,0,1,2,0,1,2,0,2
		db	0,0,1,2,2,0,0,1,2,2

.code

EXFText2	proc	stdcall
		WENTRY
		INVOKE	WriteStg,ADDR Text2Pfx	;entity prefix
		INVOKE	EXFCStuff		;write common stuff

		mov	ebx,pEntity		;back-convert extended justifications
		movzx	eax,Text2.Geo.TS.Just[ebx]
		movzx	eax,TTableJ[eax]
		mov	TJustEXF,ax

		INVOKE	FormSt,ADDR Text2Pkt,FV_ASM,pEntity,ADDR WorkStg
		INVOKE	WriteStg,ADDR WorkStg
		WEXIT
EXFText2	endp

;	===============================================================
;	2d Circle entity
;	===============================================================
.data
Cir2Pfx		db	"4,CIRCLE",13,10,0
Cir2Pkt		dword	Cir2Fmt
		ItemFmt	<Cir2.Geo.Cen.X,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Cir2.Geo.Cen.Y,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Cir2.Geo.Radius,FT_Real8+FT_EBX,FJ_Var>
Cir2Fmt		db	"!01,!02,!03",13,10
		db	"*",13,10,0
.code

EXFCircle2	proc	stdcall
		WENTRY
		INVOKE	WriteStg,ADDR Cir2Pfx	;entity prefix
		INVOKE	EXFCStuff		;write common stuff
		INVOKE	FormSt,ADDR Cir2Pkt,FV_ASM,pEntity,ADDR WorkStg
		INVOKE	WriteStg,ADDR WorkStg
		WEXIT
EXFCircle2	endp

;	===============================================================
;	2d Arc entity
;	===============================================================
.data
Arc2Pfx		db	"5,ARC",13,10,0
Arc2Pkt		dword	Arc2Fmt
		ItemFmt	<Arc2.Geo.Cen.X,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Arc2.Geo.Cen.Y,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Arc2.Geo.Radius,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Arc2.Geo.SAng,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Arc2.Geo.AngW,FT_Real8+FT_EBX,FJ_Var>
Arc2Fmt		db	"!01,!02,!03",13,10
		db	"!04,!05",13,10
		db	"*",13,10,0
.code

EXFArc2		proc	stdcall
		WENTRY
		INVOKE	WriteStg,ADDR Arc2Pfx	;entity prefix
		INVOKE	EXFCStuff		;write common stuff
		INVOKE	FormSt,ADDR Arc2Pkt,FV_ASM,pEntity,ADDR WorkStg
		INVOKE	WriteStg,ADDR WorkStg
		WEXIT
EXFArc2		endp

;	===============================================================
;	2d Ellipse entity
;	===============================================================
.data
Elp2Pfx		db	"19,ELLIPSE",13,10,0
Elp2Pkt		dword	Elp2Fmt
		ItemFmt	<Elp2.Geo.Cen.X,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Elp2.Geo.Cen.Y,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Elp2.Geo.Radius,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Elp2.Geo.Ecc,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<Elp2.Geo.Incl,FT_Real8+FT_EBX,FJ_Var>
Elp2Fmt		db	"!01,!02,!03",13,10
		db	"!04,!05",13,10
		db	"*",13,10,0
.code

EXFElp2		proc	stdcall
		WENTRY
		INVOKE	WriteStg,ADDR Elp2Pfx	;entity prefix
		INVOKE	EXFCStuff		;write common stuff
		INVOKE	FormSt,ADDR Elp2Pkt,FV_ASM,pEntity,ADDR WorkStg
		INVOKE	WriteStg,ADDR WorkStg
		WEXIT
EXFElp2		endp

;	===============================================================
;	2d Elliptical arc entity
;	===============================================================
.data
ElA2Pfx		db	"20,ELLIPTICAL ARC",13,10,0
ElA2Pkt		dword	ElA2Fmt
		ItemFmt	<ElA2.Geo.Cen.X,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<ElA2.Geo.Cen.Y,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<ElA2.Geo.Radius,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<ElA2.Geo.Ecc,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<ElA2.Geo.Incl,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<ElA2.Geo.SAng,FT_Real8+FT_EBX,FJ_Var>
		ItemFmt	<ElA2.Geo.AngW,FT_Real8+FT_EBX,FJ_Var>
ElA2Fmt		db	"!01,!02,!03",13,10
		db	"!04,!05",13,10
		db	"!06,!07",13,10
		db	"*",13,10,0
.code

EXFElA2		proc	stdcall
		WENTRY
		INVOKE	WriteStg,ADDR ElA2Pfx	;entity prefix
		INVOKE	EXFCStuff		;write common stuff
		INVOKE	FormSt,ADDR ElA2Pkt,FV_ASM,pEntity,ADDR WorkStg
		INVOKE	WriteStg,ADDR WorkStg
		WEXIT
EXFElA2		endp


;	===============================================================
;	2d Group Mark
;	===============================================================
.data
PartPfx		db	"14,START GROUP",13,10
		db	"1",13,10
		db	"*",13,10,0

PartSfx		db	"14,END GROUP",13,10
		db	"0",13,10
		db	"*",13,10,0
.code

EXFPart2	proc	stdcall
	;	local	hSL:dword
	;	WENTRY
	;	INVOKE	WriteStg,ADDR PartPfx	;entity prefix

	;	COBJ	DLGetSubList,hDwgDL,pEntity
	;	cmp	eax,0
	;	jz	done
	;	mov	hSL,eax

	;	COBJ	DLScan,hSL,<offset SaveRec>,DLS_Std,0,0

	;	COBJ	DLRelSubList,hSL

	;	INVOKE	FormSt,ADDR ElA2Pkt,FV_ASM,pEntity,ADDR WorkStg
	;	INVOKE	WriteStg,ADDR PartSfx	;entity suffix
	;	INVOKE	WriteStg,ADDR WorkStg
;done:		WEXIT
EXFPart2		endp



;	===============================================================
END
