//////////////////// XP7.H - Master FastCAD7 XP include file ////////////
//
//	Written by Mike Riddle 4-Nov-1999
//	(C)1999-2003 Evolution Computing
//	All rights reserved
//
//////////////////////////////////////////////////////////////////////////

#ifndef _XP_H_
#define _XP_H_

#pragma warning(disable: 4200)

#pragma pack(push,1)	// no packing for alignment

#define XPCALL _stdcall

typedef void (_stdcall *PCMDPROC)(void);
typedef void (_stdcall *PMSGPROC)(int nMsg,int wParam,int lParam);

typedef struct 
{
	DWORD	fwd;		// forward link pointer
	DWORD	back;		// back link pointer
	char	*pXPName;	// adr of short XP name string (<32 chars)
	char	*CmdList;	// adrs of CList list of strings
	PCMDPROC *ProcList;	// adrs of PList list of functions
	PMSGPROC *MsgProc;	// adrs of Message Processor
	HINSTANCE ModHdl;	// our modules' LoadResource handle
}XP;

extern "C"
{
	#include "FORMST.H"
	#include "GEOMETRY.H"
	#include "TFORM.H"
	#include "ESTRUC.H"
	#include "RDATA.H"
	#include "DLMGR.H"
	#include "RSCID.H"
	#include "HELP.H"
	#include "RSCMGR.H"
	#include "CSRMGR.H"
	#include "FONTS.H"
	#include "LAYERS.H"
	#include "CRENDER.H"
	#include "LIGHTIB.H"
	#include "BKIMAGE.H"
	#include "XPMSG.H"
	#include "HEADER.H"
	#include "ENTOPS.H"
	#include "DIALOG.H"
	#include "STSUBS.H"
	#include "MEMMGR.H"
	#include "GDRAW.H"
	#include "DWINCTRL.H"
	#include "TRIG.H"
	#include "GDATAFN.H"
	#include "FILEIO.H"
	#include "REGMGR.H"
	#include "MATH2.H"
	#include "MATH3.H"
	#include "MISC.H"
	#include "FSTYLES.H"
	#include "LSTYLES.H"
	#include "COLORS.H"
	#include "DWINIB.H"
}

/////////////////////// function prototypes ////////////////////////////////

extern "C"
{
	void _stdcall XPRegister(void *xpdef);
	void _stdcall XPRegisterHelpSvc(void *hsvc);
	void _stdcall XPUnRegister(void *xpdef);
	void _stdcall CmdEnd();
	XTNT3* _stdcall CalcExtents(void);
	IDList* _stdcall DListFindDL(char* pFName);

	void _stdcall XPRegEntSvc(DWORD xpid, DWORD ppSvcTbl);

	void _stdcall SendXPMsgA(DWORD iMsg, DWORD Parm1, DWORD Parm2);

	HWND _stdcall GetMainWin(void);
	void _stdcall XPRegImport(void* pProc, TCHAR* pDesc, TCHAR* pFType);
	void _stdcall XPRegExport(void* pProc, TCHAR* pDesc, TCHAR* pFType);
	void _stdcall RegXPSvc(int nsvc,void* psvc);
	void* _stdcall GetXPSvc(int nsvc);
	int _stdcall XRefAdd(char* pFName,UINT classflags,UINT flags);
	int _stdcall XRefAddEx(IDList* hDList,char* pFName,UINT classflags,UINT flags);
}

#pragma pack(pop)	// restore prior packing alignment

#endif
