;	===============================================================
;	StList.cpy - String List Workspace Object
;	===============================================================
;	Copyright 2002 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 14-Sep-2002
;	===============================================================
;	A string list object maintains a list of variable-length
;	ANSIZ strings, one after the other, followed by an end of
;	table marker (0xFF byte). Empty strings are represented with
;	just their 0x00 byte end marker. Strings are accessed by
;	index number starting with 0.
;	===============================================================

CreateStList	proto	stdcall,nBytes:dword,nGrow:dword

STLDestroy	equ	0	;COBJ hStList
STLEmpty	equ	1	;COBJ hStList
STLCheck	equ	2	;COBJ hStList,nBytes
STLCheckA	equ	3	;COBJ hStList,nBytes
STLPack		equ	4	;COBJ hStList

STLLoadImage	equ	5	;COBJ hStList,pImage
STLGetImageSize	equ	6	;COBJ hStList
STLGetImageAdr	equ	7	;COBJ hStList
STLGetImage	equ	8	;COBJ hStList,pDest
STLCount	equ	9	;COBJ hStList

STLGetStgAdr	equ	10	;COBJ hStList,index
STLGetStgAdrX	equ	11	;COBJ hStList,index
STLGetStg	equ	12	;COBJ hStList,index,pDest
STLPutStg	equ	13	;COBJ hStList,index,pSource
STLInsStg	equ	14	;COBJ hStList,index,pSource
STLDelStg	equ	15	;COBJ hStList,index

STLImportCSV	equ	16	;COBJ hStList,index,ncols,pStg
STLExportCSV	equ	17	;COBJ hStList,index,ncols,pStg,&ptext,&ntext

;	===============================================================
