// 	===============================================================
// 	FCW7RSC.CPY - FastCAD V7 Resource Data Equates
// 	===============================================================
// 	Copyright 1999 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 1-7-1999
// 	===============================================================

#ifndef _RSCID_H_
#define _RSCID_H_


#define FCW7RSC		1*4096		// table #1 base id

#define RSC_AboutTitle	    FCW7RSC+1		// about title (no .MNU)
#define RSC_AboutText		    FCW7RSC+2		// about text (no .MNU)
#define REG_FCW7Key			    FCW7RSC+3		// main registry key
#define REG_SUPName			    FCW7RSC+4		// startup posn subkey name
#define RSC_CmdPrompt		    FCW7RSC+5		// command prompt
#define RSC_CmdTable		    FCW7RSC+6		// command keyword table
#define RSC_BadCmdTitle	    FCW7RSC+7		// bad command box title
#define RSC_LockBtn			    FCW7RSC+8		// Lock button text
#define RSC_AttachBtn		    FCW7RSC+9		// Attach button text
#define RSC_SnapBtn			    FCW7RSC+10	// Snap button text
#define RSC_CsrSnapBtn	    FCW7RSC+11	// Cursor Snap button text
#define RSC_OrthoBtn		    FCW7RSC+12	// Ortho button text
#define RSC_GridBtn	        FCW7RSC+13	// Grid button text
#define RSC_DepthBtn	      FCW7RSC+14	// Depth button text
#define RSC_CBarTip	        FCW7RSC+15	// color bar tooltip
#define RSC_PromptTip	      FCW7RSC+16	// prompt display tooltip
#define RSC_GridTip	        FCW7RSC+17	// grid button tooltip
#define RSC_SnapTip	        FCW7RSC+18	// snap button tooltip
#define RSC_CSnapTip	      FCW7RSC+19	// csrsnap button tooltip
#define RSC_OrthoTip	      FCW7RSC+20	// ortho button tooltip
#define RSC_AttachTip	      FCW7RSC+21	// attach button tooltip
#define RSC_LockTip	        FCW7RSC+22	// lock button tooltip
#define RSC_DepthTip	      FCW7RSC+23	// depth button tooltip
#define RSC_ToolsTip	      FCW7RSC+24	// tools icon button tooltip
#define RSC_StatusTip	      FCW7RSC+25	// status display tooltip
#define RSC_Status	        FCW7RSC+26	// status ctrl variable
#define RSC_FStyleV	        FCW7RSC+27	// fstyle ctrl variable
#define RSC_LStyleV	        FCW7RSC+28	// lstyle ctrl variable
#define RSC_LayerV	        FCW7RSC+29	// layer ctrl variable
#define RSC_LWidV	          FCW7RSC+30	// width ctrl variable
#define RSC_PThkV	          FCW7RSC+31	// pen thickness ctrl variable
#define RSC_Color	          FCW7RSC+32	// color ctrl variable
#define RSC_FStyleTip	      FCW7RSC+33	// fstyle ctrl tooltip
#define RSC_LStyleTip	      FCW7RSC+34	// lstyle ctrl tooltip
#define RSC_LayerTip	      FCW7RSC+35	// layer ctrl tooltip
#define RSC_LWidTip	        FCW7RSC+36	// width ctrl tooltip
#define RSC_PThkTip	        FCW7RSC+37	// pen thickness ctrl tooltip
#define RSC_ColorTip	      FCW7RSC+38	// color ctrl tooltip
#define RSC_StdMenu	        FCW7RSC+39	// standard menu file name
#define RSC_StdIcons	      FCW7RSC+40	// standard .IMN file name

#define RSC_LoadTitle	      FCW7RSC+41	// get load file name box title
#define RSC_SaveTitle	      FCW7RSC+42	// get save file name box title
#define RSC_LdType	        FCW7RSC+43	// get ld fn file type stg
#define RSC_DwgLFltrs	      FCW7RSC+44	// drawing file load filters list
#define RSC_DwgSFltrs	      FCW7RSC+45	// drawing file save filters list
#define RSC_DfltFileName    FCW7RSC+46	// default file name
#define RSC_NewDwgName	    FCW7RSC+47	// (work.fc7)
#define RSC_SUName	        FCW7RSC+48	// start up file name to iload
#define REG_DwgName	        FCW7RSC+49	// reg key to save SUName
#define RSC_PriorP3	        FCW7RSC+50	// @ prior point coordinate
#define RSC_CurP3	          FCW7RSC+51	// csr current point coordinate
#define RSC_FirstPt	        FCW7RSC+52	// 1st point
#define RSC_NextPt	        FCW7RSC+53	// next point [done]
#define RSC_OrgP3	          FCW7RSC+54	// cursor origin point
#define RSC_NCmdTable	      FCW7RSC+55	// nestable command keyword table
#define RSC_ScaleF	        FCW7RSC+56	// scale factor [!01]
#define RSC_VCenter	        FCW7RSC+57	// view center
#define RSC_SelAW	          FCW7RSC+58	// select active window
#define RSC_Corner1	        FCW7RSC+59	// rwin 1st corner
#define RSC_Corner2	        FCW7RSC+60	// rwin 2nd corner
#define RSC_DfltGridIB	    FCW7RSC+61	// default grid system IB
#define RSC_ClrNrSel	      FCW7RSC+62	// color dialog selected #
#define RSC_ColorTipPkt	    FCW7RSC+63	// current color tooltip format
// // REG_CBarIndex	equ	FCW7RSC+64	// reg key for color bar index
#define RSC_HelpFile7	      FCW7RSC+65	// FCW7 help file name
#define RSC_HelpNr	        FCW7RSC+66	// help context # prompt
#define RSC_DynPanPrmp	    FCW7RSC+67	// dynpan prompt
#define RSC_Dflt_DWinIB	    FCW7RSC+68	// DWINIB default
#define RSC_Dflt_HDRIB	    FCW7RSC+69	// HDRIB default
#define RSC_CenPt	          FCW7RSC+70	// arc/circle center point
#define RSC_PointOnC	      FCW7RSC+71	// point on circle
#define RSC_StartPtA	      FCW7RSC+72	// arc start point
#define RSC_EndPtA	        FCW7RSC+73	// arc end point
#define RSC_ColorVal	      FCW7RSC+74	// color index value
#define RSC_MajAxisPt	      FCW7RSC+75	// elip major axis point
#define RSC_MinAxisPt	      FCW7RSC+76	// elip minor axis point
#define RSC_StartAng	      FCW7RSC+77	// elip start angle point
#define RSC_EndAng	        FCW7RSC+78	// elip end angle point
#define RSC_Text	          FCW7RSC+79	// text input prompt
#define RSC_TWSave	        FCW7RSC+80	// text window menu
#define RSC_TWPrint	        FCW7RSC+81	// text window menu
#define RSC_TWSetup	        FCW7RSC+82	// text window menu
#define RSC_ListTitle	      FCW7RSC+83	// LIST window title
#define RSC_NameLine2	      FCW7RSC+84	// name line2
#define RSC_ListLine2	      FCW7RSC+85	// list line2
#define RSC_ListIdxRGB	    FCW7RSC+86	// list indexed color
#define RSC_ListRGB	        FCW7RSC+87	// list unindexed RGB
#define RSC_NamePath2	      FCW7RSC+88	// name path2
#define RSC_NamePoly2	      FCW7RSC+89	// name poly2
#define RSC_ListPath2	      FCW7RSC+90	// list path2
#define RSC_NameCir2	      FCW7RSC+91	// name cir2
#define RSC_ListCir2	      FCW7RSC+92	// list cir2
#define RSC_NameArc2	      FCW7RSC+93	// name arc2
#define RSC_ListArc2	      FCW7RSC+94	// list arc2
#define RSC_NameElp2	      FCW7RSC+95	// name elp2
#define RSC_ListElp2	      FCW7RSC+96	// list elp2
#define RSC_NameElA2	      FCW7RSC+97	// name elp arc2
#define RSC_ListElA2	      FCW7RSC+98	// list elp arc2
#define RSC_NameText2	      FCW7RSC+99	// name 2d text
#define RSC_ListText2	      FCW7RSC+100	// list 2d text
#define RSC_Select	        FCW7RSC+101	// select entities
#define RSC_LastDig	        FCW7RSC+102	// last dig data
#define RSC_NamePart	      FCW7RSC+103	// PART entity type name
#define RSC_NameSRef	      FCW7RSC+104	// SYMREF name
#define RSC_NameMPoly	      FCW7RSC+105	// MPOLY name
#define RSC_NameLine3	      FCW7RSC+106	// LINE3 name
#define RSC_ListLine3	      FCW7RSC+107	// list 3d line
#define RSC_NamePath3	      FCW7RSC+108	// PATH3 name
#define RSC_NamePoly3	      FCW7RSC+109	// POLY3 name
#define RSC_ListPath3	      FCW7RSC+110	// list 3d path vertex
#define RSC_Z3LFrom	        FCW7RSC+111	// look from point
#define RSC_Z3LAt	          FCW7RSC+112	// look at point
#define RSC_Z3LUp	          FCW7RSC+113	// look up point
#define RSC_Z3Dist	        FCW7RSC+114	// 3d pan distance
#define RSC_Z3Ang	          FCW7RSC+115	// 3d zoom angle
#define RSC_Depth3	        FCW7RSC+116	// 3d depth mode depth
#define REG_OptName	        FCW7RSC+117	// options data subkey name
#define RSC_LdTypeIndex	    FCW7RSC+118	// index of load file types
#define RSC_NameSolid3	    FCW7RSC+119	// SOLID3 entity name
#define RSC_ListSSec	      FCW7RSC+120	// SOLID3 section list hdr
#define RSC_NameSRev3	      FCW7RSC+121	// SREV3 entity name
#define RSC_NameTPro3	      FCW7RSC+122	// TPRO3 entity name
#define RSC_NameCir3	      FCW7RSC+123	// 3d Circle entity name
#define RSC_NameArc3	      FCW7RSC+124	// 3d Arc entity name
#define RSC_NameSphere	    FCW7RSC+125	// 3d Sphere entity name
#define RSC_NameMPoly3	    FCW7RSC+126	// 3d MPOLY name
#define RSC_NameRSurf3	    FCW7RSC+127	// 3d Ruled Surface name
#define RSC_DynPanHelp	    FCW7RSC+128	// DYNPAN help message
#define RSC_DynPanTitle	    FCW7RSC+129	// DYNPAN Help Title
#define RSC_DfltNVIB	      FCW7RSC+130	// default Named Views IB
#define RSC_VName	          FCW7RSC+131	// prompt for view name
#define RSC_ListArc3	      FCW7RSC+132	// list Arc3 data
#define RSC_ListCir3	      FCW7RSC+133	// list Cir3 data
#define RSC_ListSRev3	      FCW7RSC+134	// list SREV3 data
#define RSC_SaveFN1	        FCW7RSC+135	// RUF file #1
#define RSC_SaveFN2	        FCW7RSC+136	// RUF file #2
#define RSC_SaveFN3	        FCW7RSC+137	// RUF file #3
#define RSC_SaveFN4	        FCW7RSC+138	// RUF file #4
#define RSC_StdExtents	    FCW7RSC+139	// empty dwg std extents (ZSTD)
#define RSC_DiscardMsg	    FCW7RSC+140	// DISCARD message
#define RSC_MoveFrom	      FCW7RSC+141	// move from point
#define RSC_MoveTo	        FCW7RSC+142	// move to point
#define RSC_DfltLyrIB	      FCW7RSC+143	// default layer IB
#define RSC_LayerName	      FCW7RSC+144	// layer name
#define RSC_LyrNotFound	    FCW7RSC+145	// can't make current: not found
#define RSC_LyrReadOnly	    FCW7RSC+146	// layer is R/o - ok to change?
#define RSC_DelNELayer	    FCW7RSC+147	// del lyr not empty
#define RSC_LyrTipFmt	      FCW7RSC+148	// layer tooltip format
#define RSC_TagNr	          FCW7RSC+149	// entity tag # for select
#define RSC_SRefName	      FCW7RSC+150	// INSSYM name
#define RSC_SRefScaleX	    FCW7RSC+151	// INSSYM x scale
#define RSC_SRefScaleY	    FCW7RSC+152	// INSSYM y scale
#define RSC_SRefScaleZ	    FCW7RSC+153	// INSSYM z scale
#define RSC_SRefRotXY	      FCW7RSC+154	// INSSYM xy rotation
#define RSC_SRefRotYZ	      FCW7RSC+155	// INSSYM yz rotation
#define RSC_SRefRotZX	      FCW7RSC+156	// INSSYM zx rotation
#define RSC_SRefAt	        FCW7RSC+157	// INSSYM origin at 3d point
#define RSC_MissingSDef	    FCW7RSC+158	// INSSYM SymDef missing
#define RSC_SDefName	      FCW7RSC+159	// DEFSYM name
#define RSC_SDefOrg	        FCW7RSC+160	// DEFSYM origin at 3d point
#define RSC_SDefNameUsed    FCW7RSC+161	// DEFSYM name already used
#define RSC_ScaleBy	        FCW7RSC+162	// SCALE factor
#define RSC_Origin	        FCW7RSC+163	// SCALE origin
#define RSC_RotBy	          FCW7RSC+164	// ROTATE by angle
#define RSC_RotAxis	        FCW7RSC+165	// ROTATE Axis Point
#define RSC_DragFrom	      FCW7RSC+166	// DRAG from point
#define RSC_DragTo	        FCW7RSC+167	// DRAG to point
#define RSC_DfltFSIB	      FCW7RSC+168	// default FStyle IB
#define RSC_FStyleName	    FCW7RSC+169	// FStyle name
#define RSC_FSNotFound	    FCW7RSC+170	// can't make current: not found
#define RSC_FSTipFmt	      FCW7RSC+171	// FStyle tooltip format
#define RSC_CopyFrom	      FCW7RSC+172	// copy from point
#define RSC_CopyTo	        FCW7RSC+173	// copy to point
#define RSC_RptCols	        FCW7RSC+174	// repeat # columns
#define RSC_RptRows	        FCW7RSC+175	// repeat # rows
#define RSC_RptOrg	        FCW7RSC+176	// repeat origin
#define RSC_RptDelta	      FCW7RSC+177	// repeat 2nd row 2nd column
#define RSC_CASpokes	      FCW7RSC+178	// CARY # spokes
#define RSC_CARings	        FCW7RSC+179	// CARY # rings
#define RSC_CACen	          FCW7RSC+180	// CARY center
#define RSC_CAOrg	          FCW7RSC+181	// CARY origin
#define RSC_CASDelta	      FCW7RSC+182	// CARY spoke delta
#define RSC_CARDelta	      FCW7RSC+183	// CARY ring delta
#define RSC_MirAxis1	      FCW7RSC+184	// MIRROR p1
#define RSC_MirAxis2	      FCW7RSC+185	// MIRROR p2
#define RSC_ConnectF1	      FCW7RSC+186	// CONNECT from p1
#define RSC_ConnectT1	      FCW7RSC+187	// CONNECT to p1
#define RSC_ConnectF2	      FCW7RSC+188	// CONNECT from p2
#define RSC_ConnectT2	      FCW7RSC+189	// CONNECT to p2
#define RSC_ConnectF3	      FCW7RSC+190	// CONNECT from p3
#define RSC_ConnectT3	      FCW7RSC+191	// CONNECT to p3
#define RSC_NoDefPr	        FCW7RSC+192	// PRINT - No printer exists
#define RSC_OpenP2F	        FCW7RSC+193	// Print to File Name Dlg Title
#define RSC_P2FFltrs	      FCW7RSC+194	// Print to file filters
#define RSC_PrintSheetCB    FCW7RSC+195	// Print Dlg Sheet ComboBox data
#define RSC_RPolyN	        FCW7RSC+196	// RPOLY # nodes
#define RSC_RPolyC	        FCW7RSC+197	// RPOLY center
#define RSC_RPoly1	        FCW7RSC+198	// RPOLY starting node
#define RSC_ModPtTable	    FCW7RSC+199	// modifiers valid for 2d/3d points
#define RSC_ModPtPrompts    FCW7RSC+200	// modifiers prompts
#define RSC_Percent	        FCW7RSC+201	// % value 0.0->100.0
#define RSC_ExtrudeP1	      FCW7RSC+202	// extrude axis start point
#define RSC_ExtrudeP2	      FCW7RSC+203	// extrude axis end point
#define RSC_CirD	          FCW7RSC+204	// CIRD diameter
#define RSC_CirR	          FCW7RSC+205	// CIRR radius
#define RSC_CirC	          FCW7RSC+206	// CIRD/CIRR center
#define RSC_Cir1	          FCW7RSC+207	// CIR2/CIR3 1st point
#define RSC_Cir2	          FCW7RSC+208	// CIR2/CIR3 2nd point
#define RSC_Cir3	          FCW7RSC+209	// CIR3 3rd point
#define RSC_ArcRS	          FCW7RSC+210	// ARCR start angle/pt
#define RSC_ArcRE	          FCW7RSC+211	// ARCR end angle/pt
#define RSC_Degree	        FCW7RSC+212	// DEG mod degrees prompt
#define RSC_SaveTypeIndex   FCW7RSC+213	// save file types index list
#define RSC_SaveFileName    FCW7RSC+214	// name to save file as
#define RSC_DfltWPIB	      FCW7RSC+215	// default workplane IB
#define RSC_WPNameV	        FCW7RSC+216	// name of current WP for status
#define RSC_WPlaneTip	      FCW7RSC+217	// tooltip of WPlane control
#define RSC_WPTipFmt	      FCW7RSC+218	// format WP name tooltip
#define RSC_WPNewName	      FCW7RSC+219	// WPDEF name
#define RSC_WPOriginPt	    FCW7RSC+220	// WPDEF origin
#define RSC_WPPlusXPt	      FCW7RSC+221	// WPDEF plus x axis point
#define RSC_WPPlusYPt	      FCW7RSC+222	// WPDEF plus y point
#define RSC_WPExists	      FCW7RSC+223	// WPDEF name already exists
#define RSC_NVUsed	        FCW7RSC+224	// SVNAME name in use
#define RSC_SolidSec	      FCW7RSC+225	// SOLID start section
#define RSC_SolidNode	      FCW7RSC+226	// SOLID next node
#define RSC_Box3Corner1	    FCW7RSC+227	// BOX3 1st corner
#define RSC_Box3Corner2	    FCW7RSC+228	// BOX3 2nd corner
#define RSC_SRevP1	        FCW7RSC+229	// SREV axis p1
#define RSC_SRevP2	        FCW7RSC+230	// SREV axis p2
#define RSC_SRevAW	        FCW7RSC+231	// SREV revolve for ang width
#define RSC_TProPt	        FCW7RSC+232	// TPRO path point
#define RSC_TProScl	        FCW7RSC+233	// TPRO node scale
#define RSC_RSurfE1	        FCW7RSC+234	// RSURF 1st entity
#define RSC_RSurfE2	        FCW7RSC+235	// RSURF 2nd entity
#define RSC_SphereCen	      FCW7RSC+236	// SPHERE center
#define RSC_SpherePole	    FCW7RSC+237	// SPHERE pole pt/diameter
#define RSC_NameCyl3	      FCW7RSC+238	// 3d cylinder entity name
#define RSC_CylBCen	        FCW7RSC+239	// CYL bottom center
#define RSC_CylTCen	        FCW7RSC+240	// CYL top center
#define RSC_CylBRadius	    FCW7RSC+241	// CYL bottom radius
#define RSC_CylTRadius	    FCW7RSC+242	// CYL top radius
#define RSC_FCW7Title	      FCW7RSC+243	// FastCAD V7 for msg box titles
#define RSC_XPErr	          FCW7RSC+244	// Error loading XP
#define RSC_UnitList	      FCW7RSC+245	// UNITS dialog
#define RSC_DFmtList	      FCW7RSC+246	// UNITS dialog
#define RSC_FRndList	      FCW7RSC+247	// UNITS dialog
#define RSC_ScType	        FCW7RSC+248	// SCRIPT file type
#define RSC_ScFltr	        FCW7RSC+249	// SCRIPT file filters
#define RSC_SelScript	      FCW7RSC+250	// SCRIPT dialog title
#define RSC_DefScript	      FCW7RSC+251	// SCRIPT default path & name
#define RSC_ScriptName	    FCW7RSC+252	// SCRIPTM name
#define RSC_MnuType	        FCW7RSC+253	// MENU file type
#define RSC_MnuFltr	        FCW7RSC+254	// MENU file filters
#define RSC_SelMenu	        FCW7RSC+255	// MENU dialog title
#define RSC_MenuName	      FCW7RSC+256	// MENU name
#define RSC_DefMenuName	    FCW7RSC+257	// default load mnu name (variable)
#define REG_DefMenu	        FCW7RSC+258	// reg key for RSC_DefMenuName
#define RSC_MenuDName	      FCW7RSC+259	// MENUDM prompt
#define RSC_Template	      FCW7RSC+260	// TEMPLATE drawing name (var)
#define REG_TDwgName	      FCW7RSC+261	// TEMPLATE name reg key
#define RSC_LoadMName	      FCW7RSC+262	// LOADM prompt
#define RSC_TplType	        FCW7RSC+263	// .FCT
#define RSC_DwgTFltrs	      FCW7RSC+264	// *.FCT
#define RSC_LoadTTitle	    FCW7RSC+265	// TEMPLATE dlg title
#define RSC_DfltTName	      FCW7RSC+266	// TEMPLATE default path & name
#define RSC_TplPrompt	      FCW7RSC+267	// TEMPLATEM prompt
#define RSC_ExtentsTitle    FCW7RSC+268	// EXTENTS msg box title
#define RSC_ExtentsMsg	    FCW7RSC+269	// EXTENTS msg box format
#define RSC_IdPt	          FCW7RSC+270	// ID point prompt
#define RSC_IdMsg	          FCW7RSC+271	// ID msg box format
#define RSC_IdTitle	        FCW7RSC+272	// ID msg box title
#define RSC_BrngMsg	        FCW7RSC+273	// BRNG msg box format
#define RSC_BrngTitle	      FCW7RSC+274	// BRNG msg box title
#define RSC_DistMsg	        FCW7RSC+275	// DIST msg box format
#define RSC_DistTitle	      FCW7RSC+276	// DIST msg box title
#define RSC_LNPEnt	        FCW7RSC+277	// LNPRP ref entity
#define RSC_LNPPt	          FCW7RSC+278	// LNPRP at point
#define RSC_LNPLen	        FCW7RSC+279	// LNPRPL length
#define RSC_FilEnt1	        FCW7RSC+280	// FILLET entity 1
#define RSC_FilEnt2	        FCW7RSC+281	// FILLET entity 2
#define RSC_FilRadErr	      FCW7RSC+282	// FILLET radius error
#define RSC_FilRad	        FCW7RSC+283	// FILLET radius prompt
#define RSC_IBName	        FCW7RSC+284	// InfoBlock entity name
#define RSC_SDName	        FCW7RSC+285	// SymDef entity name
#define RSC_OfstDist	      FCW7RSC+286	// OFFSET distance
#define RSC_OfstEnt	        FCW7RSC+287	// OFFSET1 entity
#define RSC_OfstChain	      FCW7RSC+288	// OFFSET entity chain
#define RSC_OfstSide	      FCW7RSC+289	// OFFSET side
#define RSC_DfltLStyleIB    FCW7RSC+290	// Default LStyle IB
#define RSC_LSTipFmt	      FCW7RSC+291	// LSTYLE tip format
#define RSC_LSNotFound	    FCW7RSC+292	// LSTYLE not found
#define RSC_LStyleName	    FCW7RSC+293	// LSTYLE cmd prompt
#define RSC_SRefList	      FCW7RSC+294	// SymRef list data
#define RSC_NameSpline2	    FCW7RSC+295	// Spline2 entity name
#define RSC_ListSpl2	      FCW7RSC+296	// Spline2 parm list
#define RSC_NameSPoly2	    FCW7RSC+297	// SPoly2 entity name
#define RSC_SplRes	        FCW7RSC+298	// prompt for spline resolution
#define RSC_DfltFntIB	      FCW7RSC+299	// default font IBlock
#define RSC_FontTip	        FCW7RSC+300	// font tooltip value
#define RSC_FntTipFmt	      FCW7RSC+301	// font tooltip format
#define RSC_FntNotFound	    FCW7RSC+302	// font not defined
#define RSC_FontName	      FCW7RSC+303	// font cmd prompt
#define RSC_FontV	          FCW7RSC+304	// font stat bar current text
#define RSC_ListTSty	      FCW7RSC+305	// list text style data
#define RSC_ListFont	      FCW7RSC+306	// list font name and id
#define RSC_DelFontU	      FCW7RSC+307	// can't delete font in use
#define RSC_THgtV	          FCW7RSC+308	// text hgt status ctl value
#define RSC_THgtTip	        FCW7RSC+309	// text hgt stat ctrl tooltip text
#define RSC_THgtTipFmt	    FCW7RSC+310	// text hgt stat ctrl tooltip fmt
#define RSC_THgtFmt	        FCW7RSC+311	// text hgt stat ctrl fmt
#define RSC_JustLst	        FCW7RSC+312	// justification list
#define RSC_SubFont	        FCW7RSC+313	// font substituted
#define RSC_TFTitle	        FCW7RSC+314	// TFILE file dlg title
#define RSC_TFFltr	        FCW7RSC+315	// TFILE file dlg filters
#define RSC_TFType	        FCW7RSC+316	// TFILE file dlg file type
#define RSC_TxAt	          FCW7RSC+317	// TFILE etc. text at point
#define RSC_DfltDStyIB	    FCW7RSC+318	// default Dim Style IB
#define RSC_NameDimL2	      FCW7RSC+319	// DIML entity name
#define RSC_DimLP1	        FCW7RSC+320	// DIML geo pt 1
#define RSC_DimLP2	        FCW7RSC+321	// DIML geo pt 2
#define RSC_DimLP3	        FCW7RSC+322	// DIML baseline pt
#define RSC_VTxtPos	        FCW7RSC+323	// DSTYLE dlg Vert Tx CB
#define RSC_HTxtPos	        FCW7RSC+324	// DSTYLE dlg Hz Tx CB
#define RSC_ListDimL2	      FCW7RSC+325	// DIML2 list
#define RSC_ListDimL2FTP    FCW7RSC+326	// DIML2 list fixed text position
#define RSC_ACode0	        FCW7RSC+327	// DIML2 list acode=0
#define RSC_ACode1	        FCW7RSC+328	// DIML2 list acode=1
#define RSC_ACode2	        FCW7RSC+329	// DIML2 list acode=2
#define RSC_NameDimC2D	    FCW7RSC+330	// DIMC2 diameter entity name string
#define RSC_DimCEnt	        FCW7RSC+331	// DIMC geo pick point
#define RSC_DimCBend	      FCW7RSC+332	// DIMC bend point
#define RSC_DimCLdr	        FCW7RSC+333	// DIMC leader point
#define RSC_NameDimA2	      FCW7RSC+334	// DIMA2 entity name string
#define RSC_NameDimO2	      FCW7RSC+335	// DIMO2 entity name string
#define RSC_DimAVertex	    FCW7RSC+336	// DIMA vertex point
#define RSC_DimAStartA	    FCW7RSC+337	// DIMA start angle point
#define RSC_DimALdr0	      FCW7RSC+338	// DIMA start leader point
#define RSC_DimAEndA	      FCW7RSC+339	// DIMA end angle
#define RSC_DimALdr1	      FCW7RSC+340	// DIMA end leader point
#define RSC_DimAQLdr0	      FCW7RSC+341	// DIMAQ start leader point
#define RSC_DimAQLdr1	      FCW7RSC+342	// DIMAQ end leader point
#define RSC_DimAQOnPt	      FCW7RSC+343	// DIMAQ point on arc
#define RSC_ListDimA2	      FCW7RSC+344	// DIMA2 list
#define RSC_NameDimC2R	    FCW7RSC+345	// DIMC2 radius entity name string
#define RSC_ListDimC2A	    FCW7RSC+346	// DIMC2 list std
#define RSC_ListDimC2B	    FCW7RSC+347	// DIMC2 list pbend
#define RSC_ListDimC2C	    FCW7RSC+348	// DIMC2 list pldr
#define RSC_ListDimC2D	    FCW7RSC+349	// DIMC2 list finish
#define RSC_DimOOrg	        FCW7RSC+350	// DIMO2 geo origin
#define RSC_DimOTPt	        FCW7RSC+351	// DIMO2 text position
#define RSC_DimODPt	        FCW7RSC+352	// DIMO2 dimension geo pt
#define RSC_ListDimO2A	    FCW7RSC+353	// DIMO2 list data
#define RSC_ListDimO2B	    FCW7RSC+354	// DIMO2 list leader data
#define RSC_ListDSty	      FCW7RSC+355	// list DStyle
#define RSC_DfltTStyIB	    FCW7RSC+356	// default Text Style IB
#define RSC_EditSel	        FCW7RSC+357	// EDIT entity to edit
#define RSC_DynSRefAt	      FCW7RSC+358	// INSSYMD at point prompt
#define RSC_NameXPEnt	      FCW7RSC+359	// name of XP entity (nonspecific)
#define RSC_ETypeN	        FCW7RSC+360	// sel by ent type id # prompt
#define RSC_TStyleName	    FCW7RSC+361	// prompt for text style name
#define RSC_DStyleName	    FCW7RSC+362	// prompt for dim style name
#define RSC_Unknown	        FCW7RSC+363	// (Unknown)
#define RSC_NameAct2	      FCW7RSC+364	// Act2 entity name
#define RSC_ListAct2	      FCW7RSC+365	// list Act2 data
#define RSC_ActP1	          FCW7RSC+366	// ACTION window p1
#define RSC_ActP2	          FCW7RSC+367	// ACTION window p2
#define RSC_AboveEnt	      FCW7RSC+368	// ABOVE ref ent prompt
#define RSC_BelowEnt	      FCW7RSC+369	// BELOW ref ent prompt
#define RSC_CurPartName	    FCW7RSC+370	// PART file name var
#define RSC_PartAt	        FCW7RSC+371	// PART at pt prompt
#define RSC_PartTitle	      FCW7RSC+372	// PART fn dlg title
#define RSC_PartError	      FCW7RSC+373	// PART load error msg
#define RSC_OpenDoc	        FCW7RSC+374	// OPENDOC filename
#define RSC_PartFName	      FCW7RSC+375	// PARTM file nmae prompt
#define RSC_PartScale	      FCW7RSC+376	// PARTM scale prompt
#define RSC_PartRXY	        FCW7RSC+377	// PARTM rot xy prompt
#define RSC_PartInsAt	      FCW7RSC+378	// PARY 1st part at
#define RSC_Part22	        FCW7RSC+379	// PARY 2nd col 2nd row
#define RSC_PartCen	        FCW7RSC+380	// CPARY center
#define RSC_PartNCol	      FCW7RSC+381	// PARYM # rows
#define RSC_PartNRow	      FCW7RSC+382	// PARYM #cols
#define RSC_PartNSpokes	    FCW7RSC+383	// CPARYM # spokes
#define RSC_PartNRings	    FCW7RSC+384	// CPARYM # rings
#define RSC_PartAng	        FCW7RSC+385	// CPARYM ang between spokes
#define RSC_PartDist	      FCW7RSC+386	// CPARYM dist between rings
#define RSC_CPartTitle	    FCW7RSC+387	// CPART dialog title
#define RSC_CPartOrigin	    FCW7RSC+388	// CPART origin
#define RSC_DwgOrigin	      FCW7RSC+389	// ORIGIN prompt
#define RSC_ClipOrigin	    FCW7RSC+390	// CLIPCUT/COPY origin
#define RSC_ClipbdFN	      FCW7RSC+391	// clipboard file name
#define RSC_BadPaste	      FCW7RSC+392	// unable to paste any avail fmt
#define RSC_CBEmpty	        FCW7RSC+393	// clipboard is empty
#define RSC_SaveCB	        FCW7RSC+394	// save clipboard at close?
#define RSC_Warning	        FCW7RSC+395	// warning msg box title
#define REG_CBName	        FCW7RSC+396	// clipboard data key
#define RSC_MetaFileDesc    FCW7RSC+397	// export desc of EMF
#define RSC_MetaFileType    FCW7RSC+398	// export .TYP of EMF
#define RSC_BitmapDesc	    FCW7RSC+399	// export desc of DIB
#define RSC_BitmapType	    FCW7RSC+400	// export .TYP of DIB
#define RSC_BitmapDesc2	    FCW7RSC+401	// export desc of BMP
#define RSC_BitmapType2	    FCW7RSC+402	// export .TYP of BMP
#define RSC_RunApp	        FCW7RSC+403	// RUNAPP prompt
#define RSC_MacCmdTable	    FCW7RSC+404	// macro fixed command table
#define RSC_MacFName	      FCW7RSC+405	// macro def file name
#define RSC_MacType	        FCW7RSC+406	// .MAC
#define RSC_MacFltr	        FCW7RSC+407	// macro load dlg filters
#define RSC_LdMacTitle	    FCW7RSC+408	// macro load dlg title
#define RSC_InitMacroFN	    FCW7RSC+409	// initial macro load file name
#define RSC_ListVars	      FCW7RSC+410	// LISTVAR title
#define RSC_Variable	      FCW7RSC+411	// variable name prompt
#define RSC_GP		          FCW7RSC+412	// GP data prompt
#define RSC_GL		          FCW7RSC+413	// GL data prompt
#define RSC_GO		          FCW7RSC+414	// GO label prompt
#define RSC_TargNF	        FCW7RSC+415	// GO Target label not found
#define RSC_GV		          FCW7RSC+416	// GV data prompt
#define RSC_GN		          FCW7RSC+417	// GN data prompt
#define RSC_GD		          FCW7RSC+418	// GD data prompt
#define RSC_GA		          FCW7RSC+419	// GA data prompt
#define RSC_GW		          FCW7RSC+420	// GW data prompt
#define RSC_GE		          FCW7RSC+421	// GE data prompt
#define RSC_GEXP	          FCW7RSC+422	// IFXXX Expr data prompt
#define RSC_NamePt2	        FCW7RSC+423	// 2d point entity name
#define RSC_ListPt2	        FCW7RSC+424	// 2d point entity list
#define RSC_Point	          FCW7RSC+425	// 2d point prompt
#define RSC_SaveMac	        FCW7RSC+426	// save mac filename dbox title
#define RSC_UserMacFName    FCW7RSC+427	// user-selected macro file name
#define RSC_SaveVarsName    FCW7RSC+428	// prompt for SAVEVARS
#define RSC_LoadMacM	      FCW7RSC+429	// cmd prompt
#define RSC_SaveMacM	      FCW7RSC+430	// cmd prompt
#define RSC_DfltCfgName	    FCW7RSC+431	// #FCW7.CFG
#define RSC_CurCfgName	    FCW7RSC+432	// current cfg file name
#define REG_CfgName	        FCW7RSC+433	// reg key for RSC_CurCfgName
#define RSC_MissingCfg	    FCW7RSC+434	// .CFG file missing
#define RSC_BadCfg	        FCW7RSC+435	// error in CFG file
#define RSC_TStyleV	        FCW7RSC+436	// TStyle control display value
#define RSC_TStyleTip	      FCW7RSC+437	// TStyle control tooltip
#define RSC_DStyleV	        FCW7RSC+438	// DStyle control display value
#define RSC_DStyleTip	      FCW7RSC+439	// DStyle control tooltip
#define RSC_AWSpecsV	      FCW7RSC+440	// AWSpecs control display value
#define RSC_AWSpecsTip	    FCW7RSC+441	// AWSpecs control tooltip
#define RSC_UseCfgName	    FCW7RSC+442	// .CFG file to save
#define RSC_DwgBtnTxt	      FCW7RSC+443	// SYMCAT btn text
#define RSC_CatBtnTxt	      FCW7RSC+444	// SYMCAT btn text
#define RSC_SymTipFmt	      FCW7RSC+445	// SYMCAT ttip fmt
#define RSC_CatTipFmt	      FCW7RSC+446	// SYMCAT ttip fmt
#define RSC_LoadCatTitle    FCW7RSC+447	// SYMCAT dlg title
#define RSC_CatLFltrs	      FCW7RSC+448	// SYMCAT load filters
#define RSC_CatType	        FCW7RSC+449	// SYMCAT dflt file type
#define RSC_CatLabel	      FCW7RSC+450	// SYMCAT tools label
#define RSC_PThkFmt	        FCW7RSC+451	// pen thickness control format
#define RSC_PThkTipFmt	    FCW7RSC+452	// pen thickness control tip format
#define RSC_PThickP	        FCW7RSC+453	// PTHICK cmd prompt
#define RSC_LWidFmt	        FCW7RSC+454	// line width control format
#define RSC_LWidTipFmt	    FCW7RSC+455	// line width control tip format
#define RSC_LWidthP	        FCW7RSC+456	// LWIDTH cmd prompt
#define RSC_TrimEnt	        FCW7RSC+457	// entity to trim
#define RSC_TrimToP	        FCW7RSC+458	// trim entity to point
#define RSC_TrimToE	        FCW7RSC+459	// entity to trim to
#define RSC_TrimI1	        FCW7RSC+460	// 1st entity to trim int
#define RSC_TrimI2	        FCW7RSC+461	// 2nd entity to trim int
#define RSC_TrimL	          FCW7RSC+462	// trim to length
#define RSC_TrimIE1	        FCW7RSC+463	// trim edge entity 1
#define RSC_TrimIE2	        FCW7RSC+464	// trim edge entity 2
#define RSC_SplitEnt	      FCW7RSC+465	// split entity
#define RSC_SplitAt	        FCW7RSC+466	// split entity at
#define RSC_BreakEnt	      FCW7RSC+467	// break entity
#define RSC_BreakAt1	      FCW7RSC+468	// break entity start at
#define RSC_BreakAt2	      FCW7RSC+469	// break entity end at
#define RSC_ListHdr	        FCW7RSC+470	// LIST entity header
#define RSC_ListSDHdr	      FCW7RSC+471	// LISTSYM header
#define RSC_ChamDist	      FCW7RSC+472	// CHAMFER distance
#define RSC_ModPtTable2	    FCW7RSC+473	// 2 entity modifiers table
#define RSC_IntE1	          FCW7RSC+474	// 1st entity to intersect
#define RSC_IntE2	          FCW7RSC+475	// 2nd entity to intersect
#define RSC_LyrFmt	        FCW7RSC+476	// layer control format
#define RSC_FSFmt	          FCW7RSC+477	// fill style control format
#define RSC_LSFmt	          FCW7RSC+478	// line style control format
#define RSC_PrPrvTitle	    FCW7RSC+479	// print preview title
#define RSC_Dflt_PRIB	      FCW7RSC+480	// default print infoblock
#define RSC_NameArrow	      FCW7RSC+481	// Arrow entity name
#define RSC_TogAHead	      FCW7RSC+482	// Toggle arrowhead
#define RSC_MDwgNameV	      FCW7RSC+483	// multidwg CB current dwg name
#define RSC_MDwgTip	        FCW7RSC+484	// multidwg CB current tooltip
#define RSC_MDwgTipFmt	    FCW7RSC+485	// multidwg CB tooltip format
#define RSC_MDwgFmt	        FCW7RSC+486	// multidwg CB dwg name format
#define RSC_ClosePvt	      FCW7RSC+487	// can't close private dwg
#define RSC_OpenSDef	      FCW7RSC+488	// saving: SymDef edit open
#define RSC_NoUndo	        FCW7RSC+489	// command can not be undone
#define RSC_DelSymOk	      FCW7RSC+490	// verify DELSYM ok
#define RSC_DelSymUsed	    FCW7RSC+491	// unable to DELSYM//  SYMDEF uses it
#define RSC_NameXRef	      FCW7RSC+492	// entity name
#define RSC_DfltXRefIB	    FCW7RSC+493	// default XREF infoblock
#define RSC_ListXRef	      FCW7RSC+494	// list XREF data
#define RSC_XRefClass	      FCW7RSC+495	// class name list for dialog
#define RSC_CfgType	        FCW7RSC+496	// .CFG file type
#define RSC_CfgFltrs	      FCW7RSC+497	// cfg file save filters
#define RSC_SaveCfgTitle    FCW7RSC+498	// CFG file save dialog title
#define RSC_CfgSrchPath	    FCW7RSC+499	// srch for CFG files
#define RSC_SheetNameV	    FCW7RSC+500	// sheet CB ctrl display value
#define RSC_SheetTip	      FCW7RSC+501	// sheet CB ctrl tooltip value
#define RSC_SheetFmt	      FCW7RSC+502	// sheet CB value format
#define RSC_SheetTipFmt	    FCW7RSC+503	// sheet CB ctrl tooltip format
#define RSC_CmnSheetName    FCW7RSC+504	// common sheet name
#define RSC_SelSheet	      FCW7RSC+505	// specify sheet name [common]
#define RSC_SheetName	      FCW7RSC+506	// specify sheet name
#define RSC_NoHideCSht	    FCW7RSC+507	// can't hide current sheet
#define RSC_NoDelCSht	      FCW7RSC+508	// can't delete current sheet
#define RSC_ShtNoShowAH	    FCW7RSC+509	// can't show - qautohide enabled
#define RSC_SelSheetD	      FCW7RSC+510	// spec sheet name [dialog]
#define RSC_NameAtrib2	    FCW7RSC+511	// Attribute entity name text
#define RSC_ListAtrib2	    FCW7RSC+512	// list attribute data
#define REG_AddSelName	    FCW7RSC+513	// add select reg key name
#define RSC_DefBookmarkFile FCW7RSC+514	// default bookmark title
#define RSC_BookmarkType    FCW7RSC+515	// bookmark files dlg
#define RSC_BkmFltrs	      FCW7RSC+516	// bookmark files dlg
#define RSC_BkmLTitle	      FCW7RSC+517	// bookmark files dlg
#define RSC_BkmSTitle	      FCW7RSC+518	// bookmark files dlg
#define RSC_SearchEmpty	    FCW7RSC+519	// search found nothing
#define RSC_AskExistErr	    FCW7RSC+520	// file not exist error
#define RSC_Searching	      FCW7RSC+521	// status
#define RSC_SearchResults   FCW7RSC+522	// title
#define RSC_DfltSrchParms   FCW7RSC+523	// parm data
#define RSC_Aborting	      FCW7RSC+524	// status
#define REG_SearchParms	    FCW7RSC+525	// reg key for search parms
#define RSC_IndexPath	      FCW7RSC+526	// index cmd path
#define RSC_WMFDesc	        FCW7RSC+527	// WMF export description
#define RSC_WMFType	        FCW7RSC+528	// WMF export file type
#define RSC_AngModPt	      FCW7RSC+529	// ANG mod bearing pt
#define RSC_Mid2P1	        FCW7RSC+530	// MID2 modifier p1
#define RSC_Mid2P2	        FCW7RSC+531	// MID2 modifier p2
#define RSC_DistMod	        FCW7RSC+532	// DIST modifier distance prompt
#define RSC_ProdName	      FCW7RSC+533	// product name 'FastCAD'
#define RSC_DefGuide	      FCW7RSC+534	// File name used by GUIDE cmd
#define RSC_GuidePath	      FCW7RSC+535	// Giude files in directory
#define RSC_TxtType	        FCW7RSC+536	// save text file type
#define RSC_TxtFltrs	      FCW7RSC+537	// text file filters
#define RSC_SaveTxtTitle    FCW7RSC+538	// save text dialog title
#define RSC_NameWall2	      FCW7RSC+539	// Wall2 entity name
#define RSC_Wall2ListN	    FCW7RSC+540	// list Wall2 node
#define RSC_Wall2ListS	    FCW7RSC+541	// list Wall2 span
#define RSC_WallAdd	        FCW7RSC+542	// WLADD prompt
#define RSC_WallNode1	      FCW7RSC+543	// WALL node 1 prompt
#define RSC_WallNode2	      FCW7RSC+544	// WALL next node prompt
#define RSC_WallWidth	      FCW7RSC+545	// WALL thickness
#define RSC_WallChgW	      FCW7RSC+546	// WALL change width
#define RSC_WallEdit	      FCW7RSC+547	// pick existing wall
#define RSC_Room1	          FCW7RSC+548	// room 1st corner
#define RSC_Room2	          FCW7RSC+549	// room opposite corner
#define RSC_WallOffset	    FCW7RSC+550	// wall offset distance
#define RSC_WallCut1	      FCW7RSC+551	// wall cut corner 1
#define RSC_WallCut2	      FCW7RSC+552	// wall cut corner 2
#define RSC_WallInError	    FCW7RSC+553	// node pt not inside wall
#define RSC_WallNSError	    FCW7RSC+554	// cur nodes not on same segment
#define RSC_SideError	      FCW7RSC+555	// offset side pt invalid
#define RSC_DfltExtents	    FCW7RSC+556	// extents to use if ZEXT invalid
#define RSC_NameCtrlP	      FCW7RSC+557	// CtrlP entity name text
#define RSC_ListCtrlP	      FCW7RSC+558	// CtrlP entity list format
#define RSC_DynSRefOfst	    FCW7RSC+559	// SmartSym offset point
#define RSC_NoteNameW	      FCW7RSC+560	// Note name already in use
#define RSC_FSClass	        FCW7RSC+561	// Fill style class names list
#define RSC_FSTitle	        FCW7RSC+562	// Fill Style Dialog Title
#define RSC_CurGalleryFN    FCW7RSC+563	// cur gallery file name
#define RSC_FSHatchLNr	    FCW7RSC+564	// hatch style line set # format
#define RSC_FSNrSegs	      FCW7RSC+565	// hatch line # segments btn label
#define RSC_FSEndSegEdit    FCW7RSC+566	// hatch seg edit close label
#define RSC_FSRenUsedErr    FCW7RSC+567	// FStyle name already in use
#define RSC_FStyNoDelete    FCW7RSC+568	// FStyle can not be deleted
#define RSC_FStyUsed	      FCW7RSC+569	// FStyle in use - can't delete
#define RSC_DfltFSPat	      FCW7RSC+570	// Default new pattern FStyle
#define RSC_DfltFSHatch	    FCW7RSC+571	// Default new hatch FStyle
#define RSC_DfltFSBmp	      FCW7RSC+572	// Default new bitmap FStyle
#define RSC_DfltFSSym	      FCW7RSC+573	// Default new symbol FStyle
#define RSC_FSBmpNExist	    FCW7RSC+574	// Bmp FStyle file does not exist
#define RSC_BmpTitle	      FCW7RSC+575	// get bitmap title
#define RSC_BmpType	        FCW7RSC+576	// get bitmap file type
#define RSC_BmpFltr	        FCW7RSC+577	// get bitmap filter
#define RSC_DwgGFltrs	      FCW7RSC+578	// select gallery file filters
#define RSC_GalleryTitle    FCW7RSC+579	// gallery dbox title
#define RSC_GalleryType	    FCW7RSC+580	// gallery file type
#define RSC_DfltGalleryName FCW7RSC+581	// dflt gallery file name
#define RSC_AskGallerySave  FCW7RSC+582	// ask if save changes to gallery
#define RSC_PEditEnt	      FCW7RSC+583	// PEDIT entity select
#define RSC_PChangeEnt	    FCW7RSC+584	// PCHANGE entities select
#define RSC_PEditFrz	      FCW7RSC+585	// entities can't be on fozen layer
#define RSC_LSTitle	        FCW7RSC+586	// Line Style Dialog Title
#define RSC_LSRenUsedErr    FCW7RSC+587	// LStyle name already in use
#define RSC_LStyNoDelete    FCW7RSC+588	// LStyle can not be deleted
#define RSC_LStyUsed	      FCW7RSC+589	// LStyle in use - can't delete
#define RSC_LSClass	        FCW7RSC+590	// Line style class names list
#define RSC_DfltNewLSty	    FCW7RSC+591	// default new line style
#define RSC_DemoNoSave	    FCW7RSC+592	// demo can not save files
#define RSC_DemoFmt	        FCW7RSC+593	// demo days left format
#define RSC_LoadErrMsg	    FCW7RSC+594	// error loading file
#define RSC_SaveErrMsg	    FCW7RSC+595	// error saving file
#define RSC_BrowseSource    FCW7RSC+596	// convert browse for source path
#define RSC_BrowseDest	    FCW7RSC+597	// convert browse for destination path
#define RSC_ZText	          FCW7RSC+598	// zoom to text prompt
#define RSC_GridClassNames  FCW7RSC+599	// grid system class names list
#define RSC_NewGridR	      FCW7RSC+600	// new Grid+GridR dflt image
#define RSC_GridNameUsed    FCW7RSC+601	// new name for grid is already used
#define RSC_NewGridC	      FCW7RSC+602	// new Grid+GridC dflt image
#define RSC_NewGridA	      FCW7RSC+603	// new Grid+GridA dflt image
#define REG_BkmName	        FCW7RSC+604	// cur bookmark file name key
#define RSC_CalcPrompt	    FCW7RSC+605	// CALC cmd prompt
#define RSC_CalcResult	    FCW7RSC+606	// CALC cmd result display fmt
#define RSC_Length1	        FCW7RSC+607	// LENGTH prompt
#define RSC_Length2	        FCW7RSC+608	// LENGTH prompt
#define RSC_Length3	        FCW7RSC+609	// LENGTH prompt
#define RSC_LengthResult    FCW7RSC+610	// LENGTH result display
#define RSC_Area1	          FCW7RSC+611	// Area prompt
#define RSC_Area2	          FCW7RSC+612	// Area prompt
#define RSC_Area3	          FCW7RSC+613	// Area prompt
#define RSC_AreaResult	    FCW7RSC+614	// Area result display
#define RSC_LdSymDef	      FCW7RSC+615	// LDSYMDEF from script prompt
#define RSC_LdSymDefBrowse  FCW7RSC+616	// LDSYMDEF browse title
#define REG_BrowseName	    FCW7RSC+617	// OPENPD/OPENND browse list key
#define RSC_TooOldFCW	      FCW7RSC+618	// FCW file too old a version
#define RSC_PThickChgP	    FCW7RSC+619	// change pen thickness
#define RSC_DWToolTips	    FCW7RSC+620	// tooltips for DWIN icons
#define RSC_PathDynEdit	    FCW7RSC+621	// path2/poly2 DYNEDIT prompt
#define RSC_DfltLightsIB    FCW7RSC+622	// default lights infoblock
#define RSC_DfltLightName   FCW7RSC+623	// default light name (ambient light)
#define RSC_LightRenUsedErr FCW7RSC+624	// Light name already in use
#define RSC_DfltNewLight    FCW7RSC+625	// default new light
#define RSC_LightAt	        FCW7RSC+626	// light at point
#define RSC_LightTo	        FCW7RSC+627	// light towards point
#define RSC_SelRender	      FCW7RSC+628	// select renderer
#define RSC_RenderName	    FCW7RSC+629	// renderer dll to use
#define REG_Render	        FCW7RSC+630	// reg key for RenderName
#define RSC_SelRenderFltrs  FCW7RSC+631	// select renderer file dlg filters
#define RSC_DomeAng	        FCW7RSC+632	// dome coverage arc width
#define RSC_SpSegAng	      FCW7RSC+633	// spherical seg meridian arc width
#define RSC_ARatio0	        FCW7RSC+634	// spseg ratio 1
#define RSC_ARatio90	      FCW7RSC+635	// spseg ratio 2
#define RSC_ListSphere	    FCW7RSC+636	// list sphere
#define RSC_GuideName	      FCW7RSC+637	// guide file name
#define REG_CMap	          FCW7RSC+638	// color map reg key
#define RSC_DfltCMapIB	    FCW7RSC+639	// default color map IBlock
#define RSC_ListCyl3	      FCW7RSC+640	// list cyl3 data
 
#define XRSC_AboutText	    FCW7RSC+641	// about box text
#define XRSC_DWGDesc	      FCW7RSC+642	// file type description
#define XRSC_DWGType	      FCW7RSC+643	// file type, ie: "DWG",0
#define XRSC_DXFDesc	      FCW7RSC+644	// file type description
#define XRSC_DXFType	      FCW7RSC+645	// file type, ie: "DXF",0
#define XRSC_InitErr	      FCW7RSC+646	// error initializing AD2
#define XRSC_LoadErr	      FCW7RSC+647	// error loading file
#define XRSC_MemErr	        FCW7RSC+648	// error allocating memory
#define XRSC_SaveErr	      FCW7RSC+649	// error saving file
#define XRSC_VerList	      FCW7RSC+650	// save version # list
#define REG_DWGSUName	      FCW7RSC+651	// DWG/DXF options key

#define RSC_TabCal0R		    FCW7RSC+652	// real area ll
#define RSC_TabCal1R		    FCW7RSC+653	// real area ur
#define RSC_TabCal0M		    FCW7RSC+654	// menu area ll
#define RSC_TabCal1M		    FCW7RSC+655	// menu area ur
#define RSC_TabCal0S		    FCW7RSC+656	// screen area ll
#define RSC_TabCal1S		    FCW7RSC+657	// screen area ur
#define RSC_NoTablet		    FCW7RSC+658	// tablet unavailable
#define RSC_TabNoCfg		    FCW7RSC+659	// configuration not completed
#define RSC_TabColPrmp		  FCW7RSC+660	// menu # columns
#define RSC_TabRowPrmp		  FCW7RSC+661	// menu # rows
#define RSC_TabCalPrmp0		  FCW7RSC+662	// calibrate dig pt 0
#define RSC_TabCalPrmp1		  FCW7RSC+663	// calibrate dig pt 1
#define RSC_TabCalPrmp0V	  FCW7RSC+664	// calibrate pt 0 coordinate
#define RSC_TabCalPrmp1V	  FCW7RSC+665	// calibrate pt 1 coordinate
#define RSC_TabNeedCfg		  FCW7RSC+666	// tablet need configuration
#define REG_TabName		      FCW7RSC+667	// registry key for tab data
#define RSC_TabNoCal		    FCW7RSC+668	// calibration not completed
#define RSC_TabNoOrtho		  FCW7RSC+669	// cal pts must not be ortho

#define RSC_NamePov	        FCW7RSC+670	// animate pov ent name
#define RSC_ListPov	        FCW7RSC+671	// list apov entity
#define RSC_PovEnt	        FCW7RSC+672	// apov path entity pick1 prompt
#define RSC_AnimPath	      FCW7RSC+673	// pick path to animate
#define RSC_AnimPathName    FCW7RSC+674	// pick path to animate by name
#define RSC_ALookAt	        FCW7RSC+675	// anim look at
#define RSC_ALookUF	        FCW7RSC+676	// anim look up from
#define RSC_ALookUT	        FCW7RSC+677	// anim look up to
#define RSC_LockBtnOff			FCW7RSC+695	// Lock button off text
#define RSC_Unnamed	        FCW7RSC+696	// unnamed view
#define RSC_SaveErr	        FCW7RSC+697	// error saving file
#define RSC_TStyleFmt	      FCW7RSC+698	// TStyle ctrl format
#define RSC_TStyleTipFmt    FCW7RSC+699	// TStyle ctrl tooltip format
#define RSC_DStyleFmt	      FCW7RSC+700	// DStyle ctrl format
#define RSC_DStyleTipFmt    FCW7RSC+701	// DStyle ctrl tooltip format
#define RSC_CSurfE1	        FCW7RSC+702	// coons surface edge 1 entity
#define RSC_CSurfE2	        FCW7RSC+703	// coons surface edge 2 entity
#define RSC_CSurfE3	        FCW7RSC+704	// coons surface edge 3 entity
#define RSC_CSurfE4	        FCW7RSC+705	// coons surface edge 4 entity
#define RSC_NameCSurf3	    FCW7RSC+706	// coons surface entity name text
#define RSC_TanEnt	        FCW7RSC+707	// pick ent tangent to
#define RSC_DonutIR	        FCW7RSC+708	// DONUT inner radius
#define RSC_DonutOR	        FCW7RSC+709	// DONUT outter radius
#define RSC_DonutC	        FCW7RSC+710	// DONUT center
#define RSC_CArcP1	        FCW7RSC+711	// CARCD 1st point
#define RSC_CArcP2	        FCW7RSC+712	// CARCD next point
#define RSC_RMode	          FCW7RSC+713	// RMODE number
#define RSC_Matrl	          FCW7RSC+714	// material name/id #
#define RSC_MaterialV	      FCW7RSC+715	// material control value
#define RSC_MaterialTip	    FCW7RSC+716	// material control tooltip value
#define RSC_MatrlFmt	      FCW7RSC+717	// material control fmt
#define RSC_MatrlTipFmt	    FCW7RSC+718	// material control tooltip fmt
#define RSC_DfltMatrlIB	    FCW7RSC+719	// default material Infoblock
#define RSC_MatrlNotFound   FCW7RSC+720	// MATRL command err msg
#define RSC_MtrlScaleId	    FCW7RSC+721	// MATRLSCL material id
#define RSC_MtrlScaleV	    FCW7RSC+722	// MATRLSCL material scale value
#define RSC_RendXFTitle	    FCW7RSC+723	// RENDXF file name dialog title
#define RSC_LockOut	        FCW7RSC+724	// different demo lockout
#define RSC_RendGeo	        FCW7RSC+725	// xfr geo to renderer
#define RSC_Rendering	      FCW7RSC+726	// rendering now
#define RSC_DbLnSep	        FCW7RSC+727	// DBLN separation
#define RSC_DbLn1st	        FCW7RSC+728	// DBLN first point
#define RSC_DbLnNxt	        FCW7RSC+729	// DBLN next point
#define RSC_DimOIns	        FCW7RSC+730	// DYNED DIMO insert
#define RSC_DimODel	        FCW7RSC+731	// DYNED DIMO delete
#define RSC_DistTo	        FCW7RSC+732	// RD_DistX 2nd point
#define RSC_GridAlign	      FCW7RSC+733	// AGRID prompt
#define RSC_GridV	          FCW7RSC+734	// GRIDV prompt
#define RSC_SnapV	          FCW7RSC+735	// SNAPV prompt
#define RSC_NotAngGrid	    FCW7RSC+736	// GRIDANG not angular grid
#define RSC_GridAng	        FCW7RSC+737	// GRIDANG prompt
#define RSC_ZHgt	          FCW7RSC+738	// ZHGT prompt
#define RSC_ZWid	          FCW7RSC+739	// ZWID prompt
#define RSC_PanFrom	        FCW7RSC+740	// PAN prompt
#define RSC_PanTo	          FCW7RSC+741	// PAN prompt
#define RSC_PanDisp	        FCW7RSC+742	// PAN prompt
#define RSC_InsNode1	      FCW7RSC+743	// INSNODE prompt
#define RSC_InsNode2	      FCW7RSC+744	// INSNODE prompt
#define RSC_DelNode	        FCW7RSC+745	// DELNODE prompt
#define RSC_AutoSave	      FCW7RSC+746	// now autosaving
#define REG_ASave	          FCW7RSC+747	// autosave data regkey
#define RSC_ElipAng					FCW7RSC+748	// ELIPI angle
#define RSC_ElipIncl				FCW7RSC+749	// ELIPC inclination
#define RSC_ElipDia1	      FCW7RSC+750	// ELIPC diameter 1
#define RSC_ElipDia2	      FCW7RSC+751	// ELIPC diameter 2
#define RSC_LLTitle	        FCW7RSC+752	// LISTLYR window title
#define RSC_AETitle	        FCW7RSC+753	// EXTRACT window title
#define RSC_Atr2Ex	        FCW7RSC+754	// EXTRACT format
#define RSC_RotAln1	        FCW7RSC+755	// ROTALN prompt
#define RSC_RotAln2	        FCW7RSC+756	// ROTALN prompt
#define RSC_NameBez2	      FCW7RSC+757	// BEZ2 entity name
#define RSC_NameBez3	      FCW7RSC+758	// BEZ3 entity name
#define RSC_ChangeLW	      FCW7RSC+759	// CHANGELW prompt
#define RSC_DynEdCir2	      FCW7RSC+760	// DYNEDIT Cir2
#define RSC_DynEdArc2	      FCW7RSC+761	// DYNEDIT Arc2
#define RSC_UpDVec	        FCW7RSC+762	// RC3D up dir vector
#define RSC_PalName	        FCW7RSC+763	// palette file name
#define RSC_DefPalName	    FCW7RSC+764	// default palette file name
#define RSC_NextPriorP3	    FCW7RSC+765	// next value for RSC_PriorP3
#define RSC_Prior2P3	      FCW7RSC+766	// prior prior point
#define RSC_MsgBoxTitle	    FCW7RSC+767	// MSGBOX title prompt
#define RSC_MsgBoxText	    FCW7RSC+768	// MSGBOX text line prompt
#define RSC_GFNTitle	      FCW7RSC+769	// GFNO/GFNS dialog title
#define RSC_GRFN	          FCW7RSC+770	// GRFN file name prompt
#define RSC_Pattern	        FCW7RSC+771	// GFNOP/GFNSP pattern prompt
#define RSC_Pause	          FCW7RSC+772	// PAUSE prompt
#define RSC_DistFmt	        FCW7RSC+773	// DISTFMT prompt
#define RSC_SetDecP	        FCW7RSC+774	// SETDECP prompt
#define RSC_SetFrac	        FCW7RSC+775	// SETFRAC prompt
#define RSC_UnitM	          FCW7RSC+776	// UNITM prompt
#define RSC_TSPECA	        FCW7RSC+777	// command prompt
#define RSC_TSPECH	        FCW7RSC+778	// command prompt
#define RSC_TSPECJ	        FCW7RSC+779	// command prompt
#define RSC_TSPECP	        FCW7RSC+780	// command prompt
#define RSC_TSPECS	        FCW7RSC+781	// command prompt
#define RSC_TSPECT	        FCW7RSC+782	// command prompt
#define RSC_DSPECH	        FCW7RSC+783	// command prompt
#define RSC_SaveAsMName	    FCW7RSC+784	// command prompt
#define RSC_TFile	          FCW7RSC+785	// command prompt
#define RSC_AtrTag	        FCW7RSC+786	// ATTRIBM prompt
#define RSC_AtrPrmp	        FCW7RSC+787	// ATTRIBM prompt
#define RSC_AtrVal	        FCW7RSC+788	// ATTRIBM prompt
#define RSC_WRITEM	        FCW7RSC+789	// WRITEM prompt
#define RSC_ListPath2P	    FCW7RSC+790	// path2 length listing
#define RSC_Like	          FCW7RSC+791	// LIKE keyword
#define RSC_LikeEnt	        FCW7RSC+792	// LIKE entity prompt
#define RSC_BezPL	          FCW7RSC+793	// bezier last point
#define RSC_BezP2	          FCW7RSC+794	// bezier 2nd point
#define RSC_BezP3	          FCW7RSC+795	// bezier 3rd point
#define RSC_AngTo	          FCW7RSC+796	// RD_AngW/BrngW 2nd pt prompt
#define RSC_TopView	        FCW7RSC+797	// zstd view name
#define RSC_FrontView	      FCW7RSC+798	// zstd view name
#define RSC_RightView	      FCW7RSC+799	// zstd view name
#define RSC_LeftView	      FCW7RSC+800	// zstd view name
#define RSC_RObliqueView    FCW7RSC+801	// zstd view name
#define RSC_LObliqueView    FCW7RSC+802	// zstd view name
#define RSC_XYPlaneView	    FCW7RSC+803	// zstd view name
#define RSC_CurCPartName    FCW7RSC+804	// current CPART file name
#define REG_CPartName	      FCW7RSC+805	// CPART prior name
#define RSC_ListPoly2P	    FCW7RSC+806	// list poly preface
#define RSC_CmdFlags	      FCW7RSC+807	// command flags
#define RSC_IsProtected	    FCW7RSC+808	// protected file error
#define RSC_BadKeyMatch	    FCW7RSC+809	// protect key error
#define RSC_BadNewKey	      FCW7RSC+810	// protect key error
#define RSC_NameVPort	      FCW7RSC+811	// VPort entity name
#define RSC_LowRes	        FCW7RSC+813	// warn of low color resolution issues
#define RSC_FilSameErr	    FCW7RSC+814	// can't fillet same entity
#define RSC_ErrSave	        FCW7RSC+815	// warning
#define RSC_ErrSaveTitle    FCW7RSC+816	// warning title
#define RSC_WPlane	        FCW7RSC+817	// Workplane [dialog]
#define RSC_DelNEWPlane	    FCW7RSC+818	// del wplane not empty
#define REG_DWGSUName2	      FCW7RSC+819	// xpdwg2 options key

#endif