;	===============================================================
;	FCW7RSC.CPY - FastCAD V7 Resource Data Equates
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 1-7-1999
;	===============================================================

FCW7RSC		equ	1*4096		;table #1 base id

RSC_AboutTitle	equ	FCW7RSC+1	;about title (no .MNU)
RSC_AboutText	equ	FCW7RSC+2	;about text (no .MNU)
REG_FCW7Key	equ	FCW7RSC+3	;main registry key
REG_SUPName	equ	FCW7RSC+4	;startup posn subkey name
RSC_CmdPrompt	equ	FCW7RSC+5	;command prompt
RSC_CmdTable	equ	FCW7RSC+6	;command keyword table
RSC_BadCmdTitle	equ	FCW7RSC+7	;bad command box title
RSC_LockBtn	equ	FCW7RSC+8	;Lock button text
RSC_AttachBtn	equ	FCW7RSC+9	;Attach button text
RSC_SnapBtn	equ	FCW7RSC+10	;Snap button text
RSC_CsrSnapBtn	equ	FCW7RSC+11	;Cursor Snap button text
RSC_OrthoBtn	equ	FCW7RSC+12	;Ortho button text
RSC_GridBtn	equ	FCW7RSC+13	;Grid button text
RSC_DepthBtn	equ	FCW7RSC+14	;Depth button text
RSC_CBarTip	equ	FCW7RSC+15	;color bar tooltip
RSC_PromptTip	equ	FCW7RSC+16	;prompt display tooltip
RSC_GridTip	equ	FCW7RSC+17	;grid button tooltip
RSC_SnapTip	equ	FCW7RSC+18	;snap button tooltip
RSC_CSnapTip	equ	FCW7RSC+19	;csrsnap button tooltip
RSC_OrthoTip	equ	FCW7RSC+20	;ortho button tooltip
RSC_AttachTip	equ	FCW7RSC+21	;attach button tooltip
RSC_LockTip	equ	FCW7RSC+22	;lock button tooltip
RSC_DepthTip	equ	FCW7RSC+23	;depth button tooltip
RSC_ToolsTip	equ	FCW7RSC+24	;tools icon button tooltip
RSC_StatusTip	equ	FCW7RSC+25	;status display tooltip
RSC_Status	equ	FCW7RSC+26	;status ctrl variable
RSC_FStyleV	equ	FCW7RSC+27	;fstyle ctrl variable
RSC_LStyleV	equ	FCW7RSC+28	;lstyle ctrl variable
RSC_LayerV	equ	FCW7RSC+29	;layer ctrl variable
RSC_LWidV	equ	FCW7RSC+30	;width ctrl variable
RSC_PThkV	equ	FCW7RSC+31	;pen thickness ctrl variable
RSC_Color	equ	FCW7RSC+32	;color ctrl variable
RSC_FStyleTip	equ	FCW7RSC+33	;fstyle ctrl tooltip
RSC_LStyleTip	equ	FCW7RSC+34	;lstyle ctrl tooltip
RSC_LayerTip	equ	FCW7RSC+35	;layer ctrl tooltip
RSC_LWidTip	equ	FCW7RSC+36	;width ctrl tooltip
RSC_PThkTip	equ	FCW7RSC+37	;pen thickness ctrl tooltip
RSC_ColorTip	equ	FCW7RSC+38	;color ctrl tooltip
RSC_StdMenu	equ	FCW7RSC+39	;standard menu file name
RSC_StdIcons	equ	FCW7RSC+40	;standard .IMN file name

RSC_LoadTitle	equ	FCW7RSC+41	;get load file name box title
RSC_SaveTitle	equ	FCW7RSC+42	;get save file name box title
RSC_LdType	equ	FCW7RSC+43	;get ld fn file type stg
RSC_DwgLFltrs	equ	FCW7RSC+44	;drawing file load filters list
RSC_DwgSFltrs	equ	FCW7RSC+45	;drawing file save filters list
RSC_DfltFileName equ	FCW7RSC+46	;default file name
RSC_NewDwgName	equ	FCW7RSC+47	;(work.fc7)
RSC_SUName	equ	FCW7RSC+48	;start up file name to iload
REG_DwgName	equ	FCW7RSC+49	;reg key to save SUName
RSC_PriorP3	equ	FCW7RSC+50	;@ prior point coordinate
RSC_CurP3	equ	FCW7RSC+51	;csr current point coordinate
RSC_FirstPt	equ	FCW7RSC+52	;1st point
RSC_NextPt	equ	FCW7RSC+53	;next point [done]
RSC_OrgP3	equ	FCW7RSC+54	;cursor origin point
RSC_NCmdTable	equ	FCW7RSC+55	;nestable command keyword table
RSC_ScaleF	equ	FCW7RSC+56	;scale factor [!01]
RSC_VCenter	equ	FCW7RSC+57	;view center
RSC_SelAW	equ	FCW7RSC+58	;select active window
RSC_Corner1	equ	FCW7RSC+59	;rwin 1st corner
RSC_Corner2	equ	FCW7RSC+60	;rwin 2nd corner
RSC_DfltGridIB	equ	FCW7RSC+61	;default grid system IB
RSC_ClrNrSel	equ	FCW7RSC+62	;color dialog selected #
RSC_ColorTipPkt	equ	FCW7RSC+63	;current color tooltip format
;;REG_CBarIndex	equ	FCW7RSC+64	;reg key for color bar index
RSC_HelpFile7	equ	FCW7RSC+65	;FCW7 help file name
RSC_HelpNr	equ	FCW7RSC+66	;help context # prompt
RSC_DynPanPrmp	equ	FCW7RSC+67	;dynpan prompt
RSC_Dflt_DWinIB	equ	FCW7RSC+68	;DWINIB default
RSC_Dflt_HDRIB	equ	FCW7RSC+69	;HDRIB default
RSC_CenPt	equ	FCW7RSC+70	;arc/circle center point
RSC_PointOnC	equ	FCW7RSC+71	;point on circle
RSC_StartPtA	equ	FCW7RSC+72	;arc start point
RSC_EndPtA	equ	FCW7RSC+73	;arc end point
RSC_ColorVal	equ	FCW7RSC+74	;color index value
RSC_MajAxisPt	equ	FCW7RSC+75	;elip major axis point
RSC_MinAxisPt	equ	FCW7RSC+76	;elip minor axis point
RSC_StartAng	equ	FCW7RSC+77	;elip start angle point
RSC_EndAng	equ	FCW7RSC+78	;elip end angle point
RSC_Text	equ	FCW7RSC+79	;text input prompt
RSC_TWSave	equ	FCW7RSC+80	;text window menu
RSC_TWPrint	equ	FCW7RSC+81	;text window menu
RSC_TWSetup	equ	FCW7RSC+82	;text window menu
RSC_ListTitle	equ	FCW7RSC+83	;LIST window title
RSC_NameLine2	equ	FCW7RSC+84	;name line2
RSC_ListLine2	equ	FCW7RSC+85	;list line2
RSC_ListIdxRGB	equ	FCW7RSC+86	;list indexed color
RSC_ListRGB	equ	FCW7RSC+87	;list unindexed RGB
RSC_NamePath2	equ	FCW7RSC+88	;name path2
RSC_NamePoly2	equ	FCW7RSC+89	;name poly2
RSC_ListPath2	equ	FCW7RSC+90	;list path2
RSC_NameCir2	equ	FCW7RSC+91	;name cir2
RSC_ListCir2	equ	FCW7RSC+92	;list cir2
RSC_NameArc2	equ	FCW7RSC+93	;name arc2
RSC_ListArc2	equ	FCW7RSC+94	;list arc2
RSC_NameElp2	equ	FCW7RSC+95	;name elp2
RSC_ListElp2	equ	FCW7RSC+96	;list elp2
RSC_NameElA2	equ	FCW7RSC+97	;name elp arc2
RSC_ListElA2	equ	FCW7RSC+98	;list elp arc2
RSC_NameText2	equ	FCW7RSC+99	;name 2d text
RSC_ListText2	equ	FCW7RSC+100	;list 2d text
RSC_Select	equ	FCW7RSC+101	;select entities
RSC_LastDig	equ	FCW7RSC+102	;last dig data
RSC_NamePart	equ	FCW7RSC+103	;PART entity type name
RSC_NameSRef	equ	FCW7RSC+104	;SYMREF name
RSC_NameMPoly	equ	FCW7RSC+105	;MPOLY name
RSC_NameLine3	equ	FCW7RSC+106	;LINE3 name
RSC_ListLine3	equ	FCW7RSC+107	;list 3d line
RSC_NamePath3	equ	FCW7RSC+108	;PATH3 name
RSC_NamePoly3	equ	FCW7RSC+109	;POLY3 name
RSC_ListPath3	equ	FCW7RSC+110	;list 3d path vertex
RSC_Z3LFrom	equ	FCW7RSC+111	;look from point
RSC_Z3LAt	equ	FCW7RSC+112	;look at point
RSC_Z3LUp	equ	FCW7RSC+113	;look up point
RSC_Z3Dist	equ	FCW7RSC+114	;3d pan distance
RSC_Z3Ang	equ	FCW7RSC+115	;3d zoom angle
RSC_Depth3	equ	FCW7RSC+116	;3d depth mode depth
REG_OptName	equ	FCW7RSC+117	;options data subkey name
RSC_LdTypeIndex	equ	FCW7RSC+118	;index of load file types
RSC_NameSolid3	equ	FCW7RSC+119	;SOLID3 entity name
RSC_ListSSec	equ	FCW7RSC+120	;SOLID3 section list hdr
RSC_NameSRev3	equ	FCW7RSC+121	;SREV3 entity name
RSC_NameTPro3	equ	FCW7RSC+122	;TPRO3 entity name
RSC_NameCir3	equ	FCW7RSC+123	;3d Circle entity name
RSC_NameArc3	equ	FCW7RSC+124	;3d Arc entity name
RSC_NameSphere	equ	FCW7RSC+125	;3d Sphere entity name
RSC_NameMPoly3	equ	FCW7RSC+126	;3d MPOLY name
RSC_NameRSurf3	equ	FCW7RSC+127	;3d Ruled Surface name
RSC_DynPanHelp	equ	FCW7RSC+128	;DYNPAN help message
RSC_DynPanTitle	equ	FCW7RSC+129	;DYNPAN Help Title
RSC_DfltNVIB	equ	FCW7RSC+130	;default Named Views IB
RSC_VName	equ	FCW7RSC+131	;prompt for view name
RSC_ListArc3	equ	FCW7RSC+132	;list Arc3 data
RSC_ListCir3	equ	FCW7RSC+133	;list Cir3 data
RSC_ListSRev3	equ	FCW7RSC+134	;list SREV3 data
RSC_SaveFN1	equ	FCW7RSC+135	;RUF file #1
RSC_SaveFN2	equ	FCW7RSC+136	;RUF file #2
RSC_SaveFN3	equ	FCW7RSC+137	;RUF file #3
RSC_SaveFN4	equ	FCW7RSC+138	;RUF file #4
RSC_StdExtents	equ	FCW7RSC+139	;empty dwg std extents (ZSTD)
RSC_DiscardMsg	equ	FCW7RSC+140	;DISCARD message
RSC_MoveFrom	equ	FCW7RSC+141	;move from point
RSC_MoveTo	equ	FCW7RSC+142	;move to point
RSC_DfltLyrIB	equ	FCW7RSC+143	;default layer IB
RSC_LayerName	equ	FCW7RSC+144	;layer name
RSC_LyrNotFound	equ	FCW7RSC+145	;can't make current: not found
RSC_LyrReadOnly	equ	FCW7RSC+146	;layer is R/o - ok to change?
RSC_DelNELayer	equ	FCW7RSC+147	;del lyr not empty
RSC_LyrTipFmt	equ	FCW7RSC+148	;layer tooltip format
RSC_TagNr	equ	FCW7RSC+149	;entity tag # for select
RSC_SRefName	equ	FCW7RSC+150	;INSSYM name
RSC_SRefScaleX	equ	FCW7RSC+151	;INSSYM x scale
RSC_SRefScaleY	equ	FCW7RSC+152	;INSSYM y scale
RSC_SRefScaleZ	equ	FCW7RSC+153	;INSSYM z scale
RSC_SRefRotXY	equ	FCW7RSC+154	;INSSYM xy rotation
RSC_SRefRotYZ	equ	FCW7RSC+155	;INSSYM yz rotation
RSC_SRefRotZX	equ	FCW7RSC+156	;INSSYM zx rotation
RSC_SRefAt	equ	FCW7RSC+157	;INSSYM origin at 3d point
RSC_MissingSDef	equ	FCW7RSC+158	;INSSYM SymDef missing
RSC_SDefName	equ	FCW7RSC+159	;DEFSYM name
RSC_SDefOrg	equ	FCW7RSC+160	;DEFSYM origin at 3d point
RSC_SDefNameUsed equ	FCW7RSC+161	;DEFSYM name already used
RSC_ScaleBy	equ	FCW7RSC+162	;SCALE factor
RSC_Origin	equ	FCW7RSC+163	;SCALE origin
RSC_RotBy	equ	FCW7RSC+164	;ROTATE by angle
RSC_RotAxis	equ	FCW7RSC+165	;ROTATE Axis Point
RSC_DragFrom	equ	FCW7RSC+166	;DRAG from point
RSC_DragTo	equ	FCW7RSC+167	;DRAG to point
RSC_DfltFSIB	equ	FCW7RSC+168	;default FStyle IB
RSC_FStyleName	equ	FCW7RSC+169	;FStyle name
RSC_FSNotFound	equ	FCW7RSC+170	;can't make current: not found
RSC_FSTipFmt	equ	FCW7RSC+171	;FStyle tooltip format
RSC_CopyFrom	equ	FCW7RSC+172	;copy from point
RSC_CopyTo	equ	FCW7RSC+173	;copy to point
RSC_RptCols	equ	FCW7RSC+174	;repeat # columns
RSC_RptRows	equ	FCW7RSC+175	;repeat # rows
RSC_RptOrg	equ	FCW7RSC+176	;repeat origin
RSC_RptDelta	equ	FCW7RSC+177	;repeat 2nd row 2nd column
RSC_CASpokes	equ	FCW7RSC+178	;CARY # spokes
RSC_CARings	equ	FCW7RSC+179	;CARY # rings
RSC_CACen	equ	FCW7RSC+180	;CARY center
RSC_CAOrg	equ	FCW7RSC+181	;CARY origin
RSC_CASDelta	equ	FCW7RSC+182	;CARY spoke delta
RSC_CARDelta	equ	FCW7RSC+183	;CARY ring delta
RSC_MirAxis1	equ	FCW7RSC+184	;MIRROR p1
RSC_MirAxis2	equ	FCW7RSC+185	;MIRROR p2
RSC_ConnectF1	equ	FCW7RSC+186	;CONNECT from p1
RSC_ConnectT1	equ	FCW7RSC+187	;CONNECT to p1
RSC_ConnectF2	equ	FCW7RSC+188	;CONNECT from p2
RSC_ConnectT2	equ	FCW7RSC+189	;CONNECT to p2
RSC_ConnectF3	equ	FCW7RSC+190	;CONNECT from p3
RSC_ConnectT3	equ	FCW7RSC+191	;CONNECT to p3
RSC_NoDefPr	equ	FCW7RSC+192	;PRINT - No printer exists
RSC_OpenP2F	equ	FCW7RSC+193	;Print to File Name Dlg Title
RSC_P2FFltrs	equ	FCW7RSC+194	;Print to file filters
RSC_PrintSheetCB equ	FCW7RSC+195	;Print Dlg Sheet ComboBox data
RSC_RPolyN	equ	FCW7RSC+196	;RPOLY # nodes
RSC_RPolyC	equ	FCW7RSC+197	;RPOLY center
RSC_RPoly1	equ	FCW7RSC+198	;RPOLY starting node
RSC_ModPtTable	equ	FCW7RSC+199	;modifiers valid for 2d/3d points
RSC_ModPtPrompts equ	FCW7RSC+200	;modifiers prompts
RSC_Percent	equ	FCW7RSC+201	;% value 0.0->100.0
RSC_ExtrudeP1	equ	FCW7RSC+202	;extrude axis start point
RSC_ExtrudeP2	equ	FCW7RSC+203	;extrude axis end point
RSC_CirD	equ	FCW7RSC+204	;CIRD diameter
RSC_CirR	equ	FCW7RSC+205	;CIRR radius
RSC_CirC	equ	FCW7RSC+206	;CIRD/CIRR center
RSC_Cir1	equ	FCW7RSC+207	;CIR2/CIR3 1st point
RSC_Cir2	equ	FCW7RSC+208	;CIR2/CIR3 2nd point
RSC_Cir3	equ	FCW7RSC+209	;CIR3 3rd point
RSC_ArcRS	equ	FCW7RSC+210	;ARCR start angle/pt
RSC_ArcRE	equ	FCW7RSC+211	;ARCR end angle/pt
RSC_Degree	equ	FCW7RSC+212	;DEG mod degrees prompt
RSC_SaveTypeIndex equ	FCW7RSC+213	;save file types index list
RSC_SaveFileName equ	FCW7RSC+214	;name to save file as
RSC_DfltWPIB	equ	FCW7RSC+215	;default workplane IB
RSC_WPNameV	equ	FCW7RSC+216	;name of current WP for status
RSC_WPlaneTip	equ	FCW7RSC+217	;tooltip of WPlane control
RSC_WPTipFmt	equ	FCW7RSC+218	;format WP name tooltip
RSC_WPNewName	equ	FCW7RSC+219	;WPDEF name
RSC_WPOriginPt	equ	FCW7RSC+220	;WPDEF origin
RSC_WPPlusXPt	equ	FCW7RSC+221	;WPDEF plus x axis point
RSC_WPPlusYPt	equ	FCW7RSC+222	;WPDEF plus y point
RSC_WPExists	equ	FCW7RSC+223	;WPDEF name already exists
RSC_NVUsed	equ	FCW7RSC+224	;SVNAME name in use
RSC_SolidSec	equ	FCW7RSC+225	;SOLID start section
RSC_SolidNode	equ	FCW7RSC+226	;SOLID next node
RSC_Box3Corner1	equ	FCW7RSC+227	;BOX3 1st corner
RSC_Box3Corner2	equ	FCW7RSC+228	;BOX3 2nd corner
RSC_SRevP1	equ	FCW7RSC+229	;SREV axis p1
RSC_SRevP2	equ	FCW7RSC+230	;SREV axis p2
RSC_SRevAW	equ	FCW7RSC+231	;SREV revolve for ang width
RSC_TProPt	equ	FCW7RSC+232	;TPRO path point
RSC_TProScl	equ	FCW7RSC+233	;TPRO node scale
RSC_RSurfE1	equ	FCW7RSC+234	;RSURF 1st entity
RSC_RSurfE2	equ	FCW7RSC+235	;RSURF 2nd entity
RSC_SphereCen	equ	FCW7RSC+236	;SPHERE center
RSC_SpherePole	equ	FCW7RSC+237	;SPHERE pole pt/diameter
RSC_NameCyl3	equ	FCW7RSC+238	;3d cylinder entity name
RSC_CylBCen	equ	FCW7RSC+239	;CYL bottom center
RSC_CylTCen	equ	FCW7RSC+240	;CYL top center
RSC_CylBRadius	equ	FCW7RSC+241	;CYL bottom radius
RSC_CylTRadius	equ	FCW7RSC+242	;CYL top radius
RSC_FCW7Title	equ	FCW7RSC+243	;FastCAD V7 for msg box titles
RSC_XPErr	equ	FCW7RSC+244	;Error loading XP
RSC_UnitList	equ	FCW7RSC+245	;UNITS dialog
RSC_DFmtList	equ	FCW7RSC+246	;UNITS dialog
RSC_FRndList	equ	FCW7RSC+247	;UNITS dialog
RSC_ScType	equ	FCW7RSC+248	;SCRIPT file type
RSC_ScFltr	equ	FCW7RSC+249	;SCRIPT file filters
RSC_SelScript	equ	FCW7RSC+250	;SCRIPT dialog title
RSC_DefScript	equ	FCW7RSC+251	;SCRIPT default path & name
RSC_ScriptName	equ	FCW7RSC+252	;SCRIPTM name
RSC_MnuType	equ	FCW7RSC+253	;MENU file type
RSC_MnuFltr	equ	FCW7RSC+254	;MENU file filters
RSC_SelMenu	equ	FCW7RSC+255	;MENU dialog title
RSC_MenuName	equ	FCW7RSC+256	;MENU name
RSC_DefMenuName	equ	FCW7RSC+257	;default load mnu name (variable)
REG_DefMenu	equ	FCW7RSC+258	;reg key for RSC_DefMenuName
RSC_MenuDName	equ	FCW7RSC+259	;MENUDM prompt
RSC_Template	equ	FCW7RSC+260	;TEMPLATE drawing name (var)
REG_TDwgName	equ	FCW7RSC+261	;TEMPLATE name reg key
RSC_LoadMName	equ	FCW7RSC+262	;LOADM prompt
RSC_TplType	equ	FCW7RSC+263	;.FCT
RSC_DwgTFltrs	equ	FCW7RSC+264	;*.FCT
RSC_LoadTTitle	equ	FCW7RSC+265	;TEMPLATE dlg title
RSC_DfltTName	equ	FCW7RSC+266	;TEMPLATE default path & name
RSC_TplPrompt	equ	FCW7RSC+267	;TEMPLATEM prompt
RSC_ExtentsTitle equ	FCW7RSC+268	;EXTENTS msg box title
RSC_ExtentsMsg	equ	FCW7RSC+269	;EXTENTS msg box format
RSC_IdPt	equ	FCW7RSC+270	;ID point prompt
RSC_IdMsg	equ	FCW7RSC+271	;ID msg box format
RSC_IdTitle	equ	FCW7RSC+272	;ID msg box title
RSC_BrngMsg	equ	FCW7RSC+273	;BRNG msg box format
RSC_BrngTitle	equ	FCW7RSC+274	;BRNG msg box title
RSC_DistMsg	equ	FCW7RSC+275	;DIST msg box format
RSC_DistTitle	equ	FCW7RSC+276	;DIST msg box title
RSC_LNPEnt	equ	FCW7RSC+277	;LNPRP ref entity
RSC_LNPPt	equ	FCW7RSC+278	;LNPRP at point
RSC_LNPLen	equ	FCW7RSC+279	;LNPRPL length
RSC_FilEnt1	equ	FCW7RSC+280	;FILLET entity 1
RSC_FilEnt2	equ	FCW7RSC+281	;FILLET entity 2
RSC_FilRadErr	equ	FCW7RSC+282	;FILLET radius error
RSC_FilRad	equ	FCW7RSC+283	;FILLET radius prompt
RSC_IBName	equ	FCW7RSC+284	;InfoBlock entity name
RSC_SDName	equ	FCW7RSC+285	;SymDef entity name
RSC_OfstDist	equ	FCW7RSC+286	;OFFSET distance
RSC_OfstEnt	equ	FCW7RSC+287	;OFFSET1 entity
RSC_OfstChain	equ	FCW7RSC+288	;OFFSET entity chain
RSC_OfstSide	equ	FCW7RSC+289	;OFFSET side
RSC_DfltLStyleIB equ	FCW7RSC+290	;Default LStyle IB
RSC_LSTipFmt	equ	FCW7RSC+291	;LSTYLE tip format
RSC_LSNotFound	equ	FCW7RSC+292	;LSTYLE not found
RSC_LStyleName	equ	FCW7RSC+293	;LSTYLE cmd prompt
RSC_SRefList	equ	FCW7RSC+294	;SymRef list data
RSC_NameSpline2	equ	FCW7RSC+295	;Spline2 entity name
RSC_ListSpl2	equ	FCW7RSC+296	;Spline2 parm list
RSC_NameSPoly2	equ	FCW7RSC+297	;SPoly2 entity name
RSC_SplRes	equ	FCW7RSC+298	;prompt for spline resolution
RSC_DfltFntIB	equ	FCW7RSC+299	;default font IBlock
RSC_FontTip	equ	FCW7RSC+300	;font tooltip value
RSC_FntTipFmt	equ	FCW7RSC+301	;font tooltip format
RSC_FntNotFound	equ	FCW7RSC+302	;font not defined
RSC_FontName	equ	FCW7RSC+303	;font cmd prompt
RSC_FontV	equ	FCW7RSC+304	;font stat bar current text
RSC_ListTSty	equ	FCW7RSC+305	;list text style data
RSC_ListFont	equ	FCW7RSC+306	;list font name and id
RSC_DelFontU	equ	FCW7RSC+307	;can't delete font in use
RSC_THgtV	equ	FCW7RSC+308	;text hgt status ctl value
RSC_THgtTip	equ	FCW7RSC+309	;text hgt stat ctrl tooltip text
RSC_THgtTipFmt	equ	FCW7RSC+310	;text hgt stat ctrl tooltip fmt
RSC_THgtFmt	equ	FCW7RSC+311	;text hgt stat ctrl fmt
RSC_JustLst	equ	FCW7RSC+312	;justification list
RSC_SubFont	equ	FCW7RSC+313	;font substituted
RSC_TFTitle	equ	FCW7RSC+314	;TFILE file dlg title
RSC_TFFltr	equ	FCW7RSC+315	;TFILE file dlg filters
RSC_TFType	equ	FCW7RSC+316	;TFILE file dlg file type
RSC_TxAt	equ	FCW7RSC+317	;TFILE etc. text at point
RSC_DfltDStyIB	equ	FCW7RSC+318	;default Dim Style IB
RSC_NameDimL2	equ	FCW7RSC+319	;DIML entity name
RSC_DimLP1	equ	FCW7RSC+320	;DIML geo pt 1
RSC_DimLP2	equ	FCW7RSC+321	;DIML geo pt 2
RSC_DimLP3	equ	FCW7RSC+322	;DIML baseline pt
RSC_VTxtPos	equ	FCW7RSC+323	;DSTYLE dlg Vert Tx CB
RSC_HTxtPos	equ	FCW7RSC+324	;DSTYLE dlg Hz Tx CB
RSC_ListDimL2	equ	FCW7RSC+325	;DIML2 list
RSC_ListDimL2FTP equ	FCW7RSC+326	;DIML2 list fixed text position
RSC_ACode0	equ	FCW7RSC+327	;DIML2 list acode=0
RSC_ACode1	equ	FCW7RSC+328	;DIML2 list acode=1
RSC_ACode2	equ	FCW7RSC+329	;DIML2 list acode=2
RSC_NameDimC2D	equ	FCW7RSC+330	;DIMC2 diameter entity name string
RSC_DimCEnt	equ	FCW7RSC+331	;DIMC geo pick point
RSC_DimCBend	equ	FCW7RSC+332	;DIMC bend point
RSC_DimCLdr	equ	FCW7RSC+333	;DIMC leader point
RSC_NameDimA2	equ	FCW7RSC+334	;DIMA2 entity name string
RSC_NameDimO2	equ	FCW7RSC+335	;DIMO2 entity name string
RSC_DimAVertex	equ	FCW7RSC+336	;DIMA vertex point
RSC_DimAStartA	equ	FCW7RSC+337	;DIMA start angle point
RSC_DimALdr0	equ	FCW7RSC+338	;DIMA start leader point
RSC_DimAEndA	equ	FCW7RSC+339	;DIMA end angle
RSC_DimALdr1	equ	FCW7RSC+340	;DIMA end leader point
RSC_DimAQLdr0	equ	FCW7RSC+341	;DIMAQ start leader point
RSC_DimAQLdr1	equ	FCW7RSC+342	;DIMAQ end leader point
RSC_DimAQOnPt	equ	FCW7RSC+343	;DIMAQ point on arc
RSC_ListDimA2	equ	FCW7RSC+344	;DIMA2 list
RSC_NameDimC2R	equ	FCW7RSC+345	;DIMC2 radius entity name string
RSC_ListDimC2A	equ	FCW7RSC+346	;DIMC2 list std
RSC_ListDimC2B	equ	FCW7RSC+347	;DIMC2 list pbend
RSC_ListDimC2C	equ	FCW7RSC+348	;DIMC2 list pldr
RSC_ListDimC2D	equ	FCW7RSC+349	;DIMC2 list finish
RSC_DimOOrg	equ	FCW7RSC+350	;DIMO2 geo origin
RSC_DimOTPt	equ	FCW7RSC+351	;DIMO2 text position
RSC_DimODPt	equ	FCW7RSC+352	;DIMO2 dimension geo pt
RSC_ListDimO2A	equ	FCW7RSC+353	;DIMO2 list data
RSC_ListDimO2B	equ	FCW7RSC+354	;DIMO2 list leader data
RSC_ListDSty	equ	FCW7RSC+355	;list DStyle
RSC_DfltTStyIB	equ	FCW7RSC+356	;default Text Style IB
RSC_EditSel	equ	FCW7RSC+357	;EDIT entity to edit
RSC_DynSRefAt	equ	FCW7RSC+358	;INSSYMD at point prompt
RSC_NameXPEnt	equ	FCW7RSC+359	;name of XP entity (nonspecific)
RSC_ETypeN	equ	FCW7RSC+360	;sel by ent type id # prompt
RSC_TStyleName	equ	FCW7RSC+361	;prompt for text style name
RSC_DStyleName	equ	FCW7RSC+362	;prompt for dim style name
RSC_Unknown	equ	FCW7RSC+363	;(Unknown)
RSC_NameAct2	equ	FCW7RSC+364	;Act2 entity name
RSC_ListAct2	equ	FCW7RSC+365	;list Act2 data
RSC_ActP1	equ	FCW7RSC+366	;ACTION window p1
RSC_ActP2	equ	FCW7RSC+367	;ACTION window p2
RSC_AboveEnt	equ	FCW7RSC+368	;ABOVE ref ent prompt
RSC_BelowEnt	equ	FCW7RSC+369	;BELOW ref ent prompt
RSC_CurPartName	equ	FCW7RSC+370	;PART file name var
RSC_PartAt	equ	FCW7RSC+371	;PART at pt prompt
RSC_PartTitle	equ	FCW7RSC+372	;PART fn dlg title
RSC_PartError	equ	FCW7RSC+373	;PART load error msg
RSC_OpenDoc	equ	FCW7RSC+374	;OPENDOC filename
RSC_PartFName	equ	FCW7RSC+375	;PARTM file nmae prompt
RSC_PartScale	equ	FCW7RSC+376	;PARTM scale prompt
RSC_PartRXY	equ	FCW7RSC+377	;PARTM rot xy prompt
RSC_PartInsAt	equ	FCW7RSC+378	;PARY 1st part at
RSC_Part22	equ	FCW7RSC+379	;PARY 2nd col 2nd row
RSC_PartCen	equ	FCW7RSC+380	;CPARY center
RSC_PartNCol	equ	FCW7RSC+381	;PARYM # rows
RSC_PartNRow	equ	FCW7RSC+382	;PARYM #cols
RSC_PartNSpokes	equ	FCW7RSC+383	;CPARYM # spokes
RSC_PartNRings	equ	FCW7RSC+384	;CPARYM # rings
RSC_PartAng	equ	FCW7RSC+385	;CPARYM ang between spokes
RSC_PartDist	equ	FCW7RSC+386	;CPARYM dist between rings
RSC_CPartTitle	equ	FCW7RSC+387	;CPART dialog title
RSC_CPartOrigin	equ	FCW7RSC+388	;CPART origin
RSC_DwgOrigin	equ	FCW7RSC+389	;ORIGIN prompt
RSC_ClipOrigin	equ	FCW7RSC+390	;CLIPCUT/COPY origin
RSC_ClipbdFN	equ	FCW7RSC+391	;clipboard file name
RSC_BadPaste	equ	FCW7RSC+392	;unable to paste any avail fmt
RSC_CBEmpty	equ	FCW7RSC+393	;clipboard is empty
RSC_SaveCB	equ	FCW7RSC+394	;save clipboard at close?
RSC_Warning	equ	FCW7RSC+395	;warning msg box title
REG_CBName	equ	FCW7RSC+396	;clipboard data key
RSC_MetaFileDesc equ	FCW7RSC+397	;export desc of EMF
RSC_MetaFileType equ	FCW7RSC+398	;export .TYP of EMF
RSC_BitmapDesc	equ	FCW7RSC+399	;export desc of DIB
RSC_BitmapType	equ	FCW7RSC+400	;export .TYP of DIB
RSC_BitmapDesc2	equ	FCW7RSC+401	;export desc of BMP
RSC_BitmapType2	equ	FCW7RSC+402	;export .TYP of BMP
RSC_RunApp	equ	FCW7RSC+403	;RUNAPP prompt
RSC_MacCmdTable	equ	FCW7RSC+404	;macro fixed command table
RSC_MacFName	equ	FCW7RSC+405	;macro def file name
RSC_MacType	equ	FCW7RSC+406	;.MAC
RSC_MacFltr	equ	FCW7RSC+407	;macro load dlg filters
RSC_LdMacTitle	equ	FCW7RSC+408	;macro load dlg title
RSC_InitMacroFN	equ	FCW7RSC+409	;initial macro load file name
RSC_ListVars	equ	FCW7RSC+410	;LISTVAR title
RSC_Variable	equ	FCW7RSC+411	;variable name prompt
RSC_GP		equ	FCW7RSC+412	;GP data prompt
RSC_GL		equ	FCW7RSC+413	;GL data prompt
RSC_GO		equ	FCW7RSC+414	;GO label prompt
RSC_TargNF	equ	FCW7RSC+415	;GO Target label not found
RSC_GV		equ	FCW7RSC+416	;GV data prompt
RSC_GN		equ	FCW7RSC+417	;GN data prompt
RSC_GD		equ	FCW7RSC+418	;GD data prompt
RSC_GA		equ	FCW7RSC+419	;GA data prompt
RSC_GW		equ	FCW7RSC+420	;GW data prompt
RSC_GE		equ	FCW7RSC+421	;GE data prompt
RSC_GEXP	equ	FCW7RSC+422	;IFXXX Expr data prompt
RSC_NamePt2	equ	FCW7RSC+423	;2d point entity name
RSC_ListPt2	equ	FCW7RSC+424	;2d point entity list
RSC_Point	equ	FCW7RSC+425	;2d point prompt
RSC_SaveMac	equ	FCW7RSC+426	;save mac filename dbox title
RSC_UserMacFName equ	FCW7RSC+427	;user-selected macro file name
RSC_SaveVarsName equ	FCW7RSC+428	;prompt for SAVEVARS
RSC_LoadMacM	equ	FCW7RSC+429	;cmd prompt
RSC_SaveMacM	equ	FCW7RSC+430	;cmd prompt
RSC_DfltCfgName	equ	FCW7RSC+431	;#FCW7.CFG
RSC_CurCfgName	equ	FCW7RSC+432	;current cfg file name
REG_CfgName	equ	FCW7RSC+433	;reg key for RSC_CurCfgName
RSC_MissingCfg	equ	FCW7RSC+434	;.CFG file missing
RSC_BadCfg	equ	FCW7RSC+435	;error in CFG file
RSC_TStyleV	equ	FCW7RSC+436	;TStyle control display value
RSC_TStyleTip	equ	FCW7RSC+437	;TStyle control tooltip
RSC_DStyleV	equ	FCW7RSC+438	;DStyle control display value
RSC_DStyleTip	equ	FCW7RSC+439	;DStyle control tooltip
RSC_AWSpecsV	equ	FCW7RSC+440	;AWSpecs control display value
RSC_AWSpecsTip	equ	FCW7RSC+441	;AWSpecs control tooltip
RSC_UseCfgName	equ	FCW7RSC+442	;.CFG file to save
RSC_DwgBtnTxt	equ	FCW7RSC+443	;SYMCAT btn text
RSC_CatBtnTxt	equ	FCW7RSC+444	;SYMCAT btn text
RSC_SymTipFmt	equ	FCW7RSC+445	;SYMCAT ttip fmt
RSC_CatTipFmt	equ	FCW7RSC+446	;SYMCAT ttip fmt
RSC_LoadCatTitle equ	FCW7RSC+447	;SYMCAT dlg title
RSC_CatLFltrs	equ	FCW7RSC+448	;SYMCAT load filters
RSC_CatType	equ	FCW7RSC+449	;SYMCAT dflt file type
RSC_CatLabel	equ	FCW7RSC+450	;SYMCAT tools label
RSC_PThkFmt	equ	FCW7RSC+451	;pen thickness control format
RSC_PThkTipFmt	equ	FCW7RSC+452	;pen thickness control tip format
RSC_PThickP	equ	FCW7RSC+453	;PTHICK cmd prompt
RSC_LWidFmt	equ	FCW7RSC+454	;line width control format
RSC_LWidTipFmt	equ	FCW7RSC+455	;line width control tip format
RSC_LWidthP	equ	FCW7RSC+456	;LWIDTH cmd prompt
RSC_TrimEnt	equ	FCW7RSC+457	;entity to trim
RSC_TrimToP	equ	FCW7RSC+458	;trim entity to point
RSC_TrimToE	equ	FCW7RSC+459	;entity to trim to
RSC_TrimI1	equ	FCW7RSC+460	;1st entity to trim int
RSC_TrimI2	equ	FCW7RSC+461	;2nd entity to trim int
RSC_TrimL	equ	FCW7RSC+462	;trim to length
RSC_TrimIE1	equ	FCW7RSC+463	;trim edge entity 1
RSC_TrimIE2	equ	FCW7RSC+464	;trim edge entity 2
RSC_SplitEnt	equ	FCW7RSC+465	;split entity
RSC_SplitAt	equ	FCW7RSC+466	;split entity at
RSC_BreakEnt	equ	FCW7RSC+467	;break entity
RSC_BreakAt1	equ	FCW7RSC+468	;break entity start at
RSC_BreakAt2	equ	FCW7RSC+469	;break entity end at
RSC_ListHdr	equ	FCW7RSC+470	;LIST entity header
RSC_ListSDHdr	equ	FCW7RSC+471	;LISTSYM header
RSC_ChamDist	equ	FCW7RSC+472	;CHAMFER distance
RSC_ModPtTable2	equ	FCW7RSC+473	;2 entity modifiers table
RSC_IntE1	equ	FCW7RSC+474	;1st entity to intersect
RSC_IntE2	equ	FCW7RSC+475	;2nd entity to intersect
RSC_LyrFmt	equ	FCW7RSC+476	;layer control format
RSC_FSFmt	equ	FCW7RSC+477	;fill style control format
RSC_LSFmt	equ	FCW7RSC+478	;line style control format
RSC_PrPrvTitle	equ	FCW7RSC+479	;print preview title
RSC_Dflt_PRIB	equ	FCW7RSC+480	;default print infoblock
RSC_NameArrow	equ	FCW7RSC+481	;Arrow entity name
RSC_TogAHead	equ	FCW7RSC+482	;Toggle arrowhead
RSC_MDwgNameV	equ	FCW7RSC+483	;multidwg CB current dwg name
RSC_MDwgTip	equ	FCW7RSC+484	;multidwg CB current tooltip
RSC_MDwgTipFmt	equ	FCW7RSC+485	;multidwg CB tooltip format
RSC_MDwgFmt	equ	FCW7RSC+486	;multidwg CB dwg name format
RSC_ClosePvt	equ	FCW7RSC+487	;can't close private dwg
RSC_OpenSDef	equ	FCW7RSC+488	;saving: SymDef edit open
RSC_NoUndo	equ	FCW7RSC+489	;command can not be undone
RSC_DelSymOk	equ	FCW7RSC+490	;verify DELSYM ok
RSC_DelSymUsed	equ	FCW7RSC+491	;unable to DELSYM; SYMDEF uses it
RSC_NameXRef	equ	FCW7RSC+492	;entity name
RSC_DfltXRefIB	equ	FCW7RSC+493	;default XREF infoblock
RSC_ListXRef	equ	FCW7RSC+494	;list XREF data
RSC_XRefClass	equ	FCW7RSC+495	;class name list for dialog
RSC_CfgType	equ	FCW7RSC+496	;.CFG file type
RSC_CfgFltrs	equ	FCW7RSC+497	;cfg file save filters
RSC_SaveCfgTitle equ	FCW7RSC+498	;CFG file save dialog title
RSC_CfgSrchPath	equ	FCW7RSC+499	;srch for CFG files
RSC_SheetNameV	equ	FCW7RSC+500	;sheet CB ctrl display value
RSC_SheetTip	equ	FCW7RSC+501	;sheet CB ctrl tooltip value
RSC_SheetFmt	equ	FCW7RSC+502	;sheet CB value format
RSC_SheetTipFmt	equ	FCW7RSC+503	;sheet CB ctrl tooltip format
RSC_CmnSheetName equ	FCW7RSC+504	;common sheet name
RSC_SelSheet	equ	FCW7RSC+505	;specify sheet name [common]
RSC_SheetName	equ	FCW7RSC+506	;specify sheet name
RSC_NoHideCSht	equ	FCW7RSC+507	;can't hide current sheet
RSC_NoDelCSht	equ	FCW7RSC+508	;can't delete current sheet
RSC_ShtNoShowAH	equ	FCW7RSC+509	;can't show - qautohide enabled
RSC_SelSheetD	equ	FCW7RSC+510	;spec sheet name [dialog]
RSC_NameAtrib2	equ	FCW7RSC+511	;Attribute entity name text
RSC_ListAtrib2	equ	FCW7RSC+512	;list attribute data
REG_AddSelName	equ	FCW7RSC+513	;add select reg key name
RSC_DefBookmarkFile equ	FCW7RSC+514	;default bookmark title
RSC_BookmarkType equ	FCW7RSC+515	;bookmark files dlg
RSC_BkmFltrs	equ	FCW7RSC+516	;bookmark files dlg
RSC_BkmLTitle	equ	FCW7RSC+517	;bookmark files dlg
RSC_BkmSTitle	equ	FCW7RSC+518	;bookmark files dlg
RSC_SearchEmpty	equ	FCW7RSC+519	;search found nothing
RSC_AskExistErr	equ	FCW7RSC+520	;file not exist error
RSC_Searching	equ	FCW7RSC+521	;status
RSC_SearchResults equ	FCW7RSC+522	;title
RSC_DfltSrchParms equ	FCW7RSC+523	;parm data
RSC_Aborting	equ	FCW7RSC+524	;status
REG_SearchParms	equ	FCW7RSC+525	;reg key for search parms
RSC_IndexPath	equ	FCW7RSC+526	;index cmd path
RSC_WMFDesc	equ	FCW7RSC+527	;WMF export description
RSC_WMFType	equ	FCW7RSC+528	;WMF export file type
RSC_AngModPt	equ	FCW7RSC+529	;ANG mod bearing pt
RSC_Mid2P1	equ	FCW7RSC+530	;MID2 modifier p1
RSC_Mid2P2	equ	FCW7RSC+531	;MID2 modifier p2
RSC_DistMod	equ	FCW7RSC+532	;DIST modifier distance prompt
RSC_ProdName	equ	FCW7RSC+533	;product name 'FastCAD'
RSC_DefGuide	equ	FCW7RSC+534	;File name used by GUIDE cmd
RSC_GuidePath	equ	FCW7RSC+535	;Giude files in directory
RSC_TxtType	equ	FCW7RSC+536	;save text file type
RSC_TxtFltrs	equ	FCW7RSC+537	;text file filters
RSC_SaveTxtTitle equ	FCW7RSC+538	;save text dialog title
RSC_NameWall2	equ	FCW7RSC+539	;Wall2 entity name
RSC_Wall2ListN	equ	FCW7RSC+540	;list Wall2 node
RSC_Wall2ListS	equ	FCW7RSC+541	;list Wall2 span
RSC_WallAdd	equ	FCW7RSC+542	;WLADD prompt
RSC_WallNode1	equ	FCW7RSC+543	;WALL node 1 prompt
RSC_WallNode2	equ	FCW7RSC+544	;WALL next node prompt
RSC_WallWidth	equ	FCW7RSC+545	;WALL thickness
RSC_WallChgW	equ	FCW7RSC+546	;WALL change width
RSC_WallEdit	equ	FCW7RSC+547	;pick existing wall
RSC_Room1	equ	FCW7RSC+548	;room 1st corner
RSC_Room2	equ	FCW7RSC+549	;room opposite corner
RSC_WallOffset	equ	FCW7RSC+550	;wall offset distance
RSC_WallCut1	equ	FCW7RSC+551	;wall cut corner 1
RSC_WallCut2	equ	FCW7RSC+552	;wall cut corner 2
RSC_WallInError	equ	FCW7RSC+553	;node pt not inside wall
RSC_WallNSError	equ	FCW7RSC+554	;cur nodes not on same segment
RSC_SideError	equ	FCW7RSC+555	;offset side pt invalid
RSC_DfltExtents	equ	FCW7RSC+556	;extents to use if ZEXT invalid
RSC_NameCtrlP	equ	FCW7RSC+557	;CtrlP entity name text
RSC_ListCtrlP	equ	FCW7RSC+558	;CtrlP entity list format
RSC_DynSRefOfst	equ	FCW7RSC+559	;SmartSym offset point
RSC_NoteNameW	equ	FCW7RSC+560	;Note name already in use
RSC_FSClass	equ	FCW7RSC+561	;Fill style class names list
RSC_FSTitle	equ	FCW7RSC+562	;Fill Style Dialog Title
RSC_CurGalleryFN equ	FCW7RSC+563	;cur gallery file name
RSC_FSHatchLNr	equ	FCW7RSC+564	;hatch style line set # format
RSC_FSNrSegs	equ	FCW7RSC+565	;hatch line # segments btn label
RSC_FSEndSegEdit equ	FCW7RSC+566	;hatch seg edit close label
RSC_FSRenUsedErr equ	FCW7RSC+567	;FStyle name already in use
RSC_FStyNoDelete equ	FCW7RSC+568	;FStyle can not be deleted
RSC_FStyUsed	equ	FCW7RSC+569	;FStyle in use - can't delete
RSC_DfltFSPat	equ	FCW7RSC+570	;Default new pattern FStyle
RSC_DfltFSHatch	equ	FCW7RSC+571	;Default new hatch FStyle
RSC_DfltFSBmp	equ	FCW7RSC+572	;Default new bitmap FStyle
RSC_DfltFSSym	equ	FCW7RSC+573	;Default new symbol FStyle
RSC_FSBmpNExist	equ	FCW7RSC+574	;Bmp FStyle file does not exist
RSC_BmpTitle	equ	FCW7RSC+575	;get bitmap title
RSC_BmpType	equ	FCW7RSC+576	;get bitmap file type
RSC_BmpFltr	equ	FCW7RSC+577	;get bitmap filter
RSC_DwgGFltrs	equ	FCW7RSC+578	;select gallery file filters
RSC_GalleryTitle equ	FCW7RSC+579	;gallery dbox title
RSC_GalleryType	equ	FCW7RSC+580	;gallery file type
RSC_DfltGalleryName equ	FCW7RSC+581	;dflt gallery file name
RSC_AskGallerySave equ	FCW7RSC+582	;ask if save changes to gallery
RSC_PEditEnt	equ	FCW7RSC+583	;PEDIT entity select
RSC_PChangeEnt	equ	FCW7RSC+584	;PCHANGE entities select
RSC_PEditFrz	equ	FCW7RSC+585	;entities can't be on fozen layer
RSC_LSTitle	equ	FCW7RSC+586	;Line Style Dialog Title
RSC_LSRenUsedErr equ	FCW7RSC+587	;LStyle name already in use
RSC_LStyNoDelete equ	FCW7RSC+588	;LStyle can not be deleted
RSC_LStyUsed	equ	FCW7RSC+589	;LStyle in use - can't delete
RSC_LSClass	equ	FCW7RSC+590	;Line style class names list
RSC_DfltNewLSty	equ	FCW7RSC+591	;default new line style
RSC_DemoNoSave	equ	FCW7RSC+592	;demo can not save files
RSC_DemoFmt	equ	FCW7RSC+593	;demo days left format
RSC_LoadErrMsg	equ	FCW7RSC+594	;error loading file
RSC_SaveErrMsg	equ	FCW7RSC+595	;error saving file
RSC_BrowseSource equ	FCW7RSC+596	;convert browse for source path
RSC_BrowseDest	equ	FCW7RSC+597	;convert browse for destination path
RSC_ZText	equ	FCW7RSC+598	;zoom to text prompt
RSC_GridClassNames equ	FCW7RSC+599	;grid system class names list
RSC_NewGridR	equ	FCW7RSC+600	;new Grid+GridR dflt image
RSC_GridNameUsed equ	FCW7RSC+601	;new name for grid is already used
RSC_NewGridC	equ	FCW7RSC+602	;new Grid+GridC dflt image
RSC_NewGridA	equ	FCW7RSC+603	;new Grid+GridA dflt image
REG_BkmName	equ	FCW7RSC+604	;cur bookmark file name key
RSC_CalcPrompt	equ	FCW7RSC+605	;CALC cmd prompt
RSC_CalcResult	equ	FCW7RSC+606	;CALC cmd result display fmt
RSC_Length1	equ	FCW7RSC+607	;LENGTH prompt
RSC_Length2	equ	FCW7RSC+608	;LENGTH prompt
RSC_Length3	equ	FCW7RSC+609	;LENGTH prompt
RSC_LengthResult equ	FCW7RSC+610	;LENGTH result display
RSC_Area1	equ	FCW7RSC+611	;Area prompt
RSC_Area2	equ	FCW7RSC+612	;Area prompt
RSC_Area3	equ	FCW7RSC+613	;Area prompt
RSC_AreaResult	equ	FCW7RSC+614	;Area result display
RSC_LdSymDef	equ	FCW7RSC+615	;LDSYMDEF from script prompt
RSC_LdSymDefBrowse equ	FCW7RSC+616	;LDSYMDEF browse title
REG_BrowseName	equ	FCW7RSC+617	;OPENPD/OPENND browse list key
RSC_TooOldFCW	equ	FCW7RSC+618	;FCW file too old a version
RSC_PThickChgP	equ	FCW7RSC+619	;change pen thickness
RSC_DWToolTips	equ	FCW7RSC+620	;tooltips for DWIN icons
RSC_PathDynEdit	equ	FCW7RSC+621	;path2/poly2 DYNEDIT prompt
RSC_DfltLightsIB equ	FCW7RSC+622	;default lights infoblock
RSC_DfltLightName equ	FCW7RSC+623	;default light name (ambient light)
RSC_LightRenUsedErr equ	FCW7RSC+624	;Light name already in use
RSC_DfltNewLight equ	FCW7RSC+625	;default new light
RSC_LightAt	equ	FCW7RSC+626	;light at point
RSC_LightTo	equ	FCW7RSC+627	;light towards point
RSC_SelRender	equ	FCW7RSC+628	;select renderer
RSC_RenderName	equ	FCW7RSC+629	;renderer dll to use
REG_Render	equ	FCW7RSC+630	;reg key for RenderName
RSC_SelRenderFltrs equ	FCW7RSC+631	;select renderer file dlg filters
RSC_DomeAng	equ	FCW7RSC+632	;dome coverage arc width
RSC_SpSegAng	equ	FCW7RSC+633	;spherical seg meridian arc width
RSC_ARatio0	equ	FCW7RSC+634	;spseg ratio 1
RSC_ARatio90	equ	FCW7RSC+635	;spseg ratio 2
RSC_ListSphere	equ	FCW7RSC+636	;list sphere
RSC_GuideName	equ	FCW7RSC+637	;guide file name
REG_CMap	equ	FCW7RSC+638	;color map reg key
RSC_DfltCMapIB	equ	FCW7RSC+639	;default color map IBlock
RSC_ListCyl3	equ	FCW7RSC+640	;list cyl3 data
;
XRSC_AboutDwg	equ	FCW7RSC+641	;about box text
XRSC_DWGDesc	equ	FCW7RSC+642	;file type description
XRSC_DWGType	equ	FCW7RSC+643	;file type, ie: "DWG",0
XRSC_DXFDesc	equ	FCW7RSC+644	;file type description
XRSC_DXFType	equ	FCW7RSC+645	;file type, ie: "DXF",0
XRSC_InitErr	equ	FCW7RSC+646	;error initializing AD2
XRSC_LoadErr	equ	FCW7RSC+647	;error loading file
XRSC_MemErr	equ	FCW7RSC+648	;error allocating memory
XRSC_SaveErr	equ	FCW7RSC+649	;error saving file
XRSC_VerList	equ	FCW7RSC+650	;save version # list
REG_DWGSUName	equ	FCW7RSC+651	;DWG/DXF options key

RSC_TabCal0R		equ	FCW7RSC+652	;real area ll
RSC_TabCal1R		equ	FCW7RSC+653	;real area ur
RSC_TabCal0M		equ	FCW7RSC+654	;menu area ll
RSC_TabCal1M		equ	FCW7RSC+655	;menu area ur
RSC_TabCal0S		equ	FCW7RSC+656	;screen area ll
RSC_TabCal1S		equ	FCW7RSC+657	;screen area ur
RSC_NoTablet		equ	FCW7RSC+658	;tablet unavailable
RSC_TabNoCfg		equ	FCW7RSC+659	;configuration not completed
RSC_TabColPrmp		equ	FCW7RSC+660	;menu # columns
RSC_TabRowPrmp		equ	FCW7RSC+661	;menu # rows
RSC_TabCalPrmp0		equ	FCW7RSC+662	;calibrate dig pt 0
RSC_TabCalPrmp1		equ	FCW7RSC+663	;calibrate dig pt 1
RSC_TabCalPrmp0V	equ	FCW7RSC+664	;calibrate pt 0 coordinate
RSC_TabCalPrmp1V	equ	FCW7RSC+665	;calibrate pt 1 coordinate
RSC_TabNeedCfg		equ	FCW7RSC+666	;tablet need configuration
REG_TabName		equ	FCW7RSC+667	;registry key for tab data
RSC_TabNoCal		equ	FCW7RSC+668	;calibration not completed
RSC_TabNoOrtho		equ	FCW7RSC+669	;cal pts must not be ortho

RSC_NamePov	equ	FCW7RSC+670	;animate pov ent name
RSC_ListPov	equ	FCW7RSC+671	;list apov entity
RSC_PovEnt	equ	FCW7RSC+672	;apov path entity pick1 prompt
RSC_AnimPath	equ	FCW7RSC+673	;pick path to animate
RSC_AnimPathName equ	FCW7RSC+674	;pick path to animate by name
RSC_ALookAt	equ	FCW7RSC+675	;anim look at
RSC_ALookUF	equ	FCW7RSC+676	;anim look up from
RSC_ALookUT	equ	FCW7RSC+677	;anim look up to
RSC_MissingXRef	equ	FCW7RSC+678	;XREF file not located
RSC_NameSpline3	equ	FCW7RSC+679	;Spline3 entity name
RSC_ListSpl3	equ	FCW7RSC+680	;list 3d spline
RSC_NameSPoly3	equ	FCW7RSC+681	;SPoly3 entity name
RSC_ListSPly3	equ	FCW7RSC+682	;list 3d SPoly
RSC_NameMSurf	equ	FCW7RSC+683	;MSURF entity name
RSC_ListMSrfN	equ	FCW7RSC+684	;msurf node list fmt
RSC_MSurfNC	equ	FCW7RSC+685	;msurf # columns
RSC_MSurfNR	equ	FCW7RSC+686	;msurf # rows
RSC_MSurfNode	equ	FCW7RSC+687	;msurf node entry prompt
RSC_WebInfo	equ	FCW7RSC+688	;WEBINFO text
RSC_CheckSave	equ	FCW7RSC+689	;Want to save changes?
RSC_CheckSaveTitle equ	FCW7RSC+690	;title for CheckSave
REG_PartName	equ	FCW7RSC+691	;reg key for prior part name
RSC_ScaleByX	equ	FCW7RSC+692	;SCALE factor
RSC_ScaleByY	equ	FCW7RSC+693	;SCALE factor
RSC_ScaleByZ	equ	FCW7RSC+694	;SCALE factor
RSC_LockBtnOff	equ	FCW7RSC+695	;Lock button off text
RSC_Unnamed	equ	FCW7RSC+696	;unnamed view
RSC_SaveErr	equ	FCW7RSC+697	;error saving file
RSC_TStyleFmt	equ	FCW7RSC+698	;TStyle ctrl format
RSC_TStyleTipFmt equ	FCW7RSC+699	;TStyle ctrl tooltip format
RSC_DStyleFmt	equ	FCW7RSC+700	;DStyle ctrl format
RSC_DStyleTipFmt equ	FCW7RSC+701	;DStyle ctrl tooltip format
RSC_CSurfE1	equ	FCW7RSC+702	;coons surface edge 1 entity
RSC_CSurfE2	equ	FCW7RSC+703	;coons surface edge 2 entity
RSC_CSurfE3	equ	FCW7RSC+704	;coons surface edge 3 entity
RSC_CSurfE4	equ	FCW7RSC+705	;coons surface edge 4 entity
RSC_NameCSurf3	equ	FCW7RSC+706	;coons surface entity name text
RSC_TanEnt	equ	FCW7RSC+707	;pick ent tangent to
RSC_DonutIR	equ	FCW7RSC+708	;DONUT inner radius
RSC_DonutOR	equ	FCW7RSC+709	;DONUT outter radius
RSC_DonutC	equ	FCW7RSC+710	;DONUT center
RSC_CArcP1	equ	FCW7RSC+711	;CARCD 1st point
RSC_CArcP2	equ	FCW7RSC+712	;CARCD next point
RSC_RMode	equ	FCW7RSC+713	;RMODE number
RSC_Matrl	equ	FCW7RSC+714	;material name/id #
RSC_MaterialV	equ	FCW7RSC+715	;material control value
RSC_MaterialTip	equ	FCW7RSC+716	;material control tooltip value
RSC_MatrlFmt	equ	FCW7RSC+717	;material control fmt
RSC_MatrlTipFmt	equ	FCW7RSC+718	;material control tooltip fmt
RSC_DfltMatrlIB	equ	FCW7RSC+719	;default material Infoblock
RSC_MatrlNotFound equ	FCW7RSC+720	;MATRL command err msg
RSC_MtrlScaleId	equ	FCW7RSC+721	;MATRLSCL material id
RSC_MtrlScaleV	equ	FCW7RSC+722	;MATRLSCL material scale value
RSC_RendXFTitle	equ	FCW7RSC+723	;RENDXF file name dialog title
RSC_LockOut	equ	FCW7RSC+724	;different demo lockout
RSC_RendGeo	equ	FCW7RSC+725	;xfr geo to renderer
RSC_Rendering	equ	FCW7RSC+726	;rendering now
RSC_DbLnSep	equ	FCW7RSC+727	;DBLN separation
RSC_DbLn1st	equ	FCW7RSC+728	;DBLN first point
RSC_DbLnNxt	equ	FCW7RSC+729	;DBLN next point
RSC_DimOIns	equ	FCW7RSC+730	;DYNED DIMO insert
RSC_DimODel	equ	FCW7RSC+731	;DYNED DIMO delete
RSC_DistTo	equ	FCW7RSC+732	;RD_DistX 2nd point
RSC_GridAlign	equ	FCW7RSC+733	;AGRID prompt
RSC_GridV	equ	FCW7RSC+734	;GRIDV prompt
RSC_SnapV	equ	FCW7RSC+735	;SNAPV prompt
RSC_NotAngGrid	equ	FCW7RSC+736	;GRIDANG not angular grid
RSC_GridAng	equ	FCW7RSC+737	;GRIDANG prompt
RSC_ZHgt	equ	FCW7RSC+738	;ZHGT prompt
RSC_ZWid	equ	FCW7RSC+739	;ZWID prompt
RSC_PanFrom	equ	FCW7RSC+740	;PAN prompt
RSC_PanTo	equ	FCW7RSC+741	;PAN prompt
RSC_PanDisp	equ	FCW7RSC+742	;PAN prompt
RSC_InsNode1	equ	FCW7RSC+743	;INSNODE prompt
RSC_InsNode2	equ	FCW7RSC+744	;INSNODE prompt
RSC_DelNode	equ	FCW7RSC+745	;DELNODE prompt
RSC_AutoSave	equ	FCW7RSC+746	;now autosaving
REG_ASave	equ	FCW7RSC+747	;autosave data regkey
RSC_ElipAng	equ	FCW7RSC+748	;ELIPI angle
RSC_ElipIncl	equ	FCW7RSC+749	;ELIPC inclination
RSC_ElipDia1	equ	FCW7RSC+750	;ELIPC diameter 1
RSC_ElipDia2	equ	FCW7RSC+751	;ELIPC diameter 2
RSC_LLTitle	equ	FCW7RSC+752	;LISTLYR window title
RSC_AETitle	equ	FCW7RSC+753	;EXTRACT window title
RSC_Atr2Ex	equ	FCW7RSC+754	;EXTRACT format
RSC_RotAln1	equ	FCW7RSC+755	;ROTALN prompt
RSC_RotAln2	equ	FCW7RSC+756	;ROTALN prompt
RSC_NameBez2	equ	FCW7RSC+757	;BEZ2 entity name
RSC_NameBez3	equ	FCW7RSC+758	;BEZ3 entity name
RSC_ChangeLW	equ	FCW7RSC+759	;CHANGELW prompt
RSC_DynEdCir2	equ	FCW7RSC+760	;DYNEDIT Cir2
RSC_DynEdArc2	equ	FCW7RSC+761	;DYNEDIT Arc2
RSC_UpDVec	equ	FCW7RSC+762	;ARC3D up dir vector
RSC_PalName	equ	FCW7RSC+763	;palette file name
RSC_DefPalName	equ	FCW7RSC+764	;default palette file name
RSC_NextPriorP3	equ	FCW7RSC+765	;next value for RSC_PriorP3
RSC_Prior2P3	equ	FCW7RSC+766	;prior prior point
RSC_MsgBoxTitle	equ	FCW7RSC+767	;MSGBOX title prompt
RSC_MsgBoxText	equ	FCW7RSC+768	;MSGBOX text line prompt
RSC_GFNTitle	equ	FCW7RSC+769	;GFNO/GFNS dialog title
RSC_GRFN	equ	FCW7RSC+770	;GRFN file name prompt
RSC_Pattern	equ	FCW7RSC+771	;GFNOP/GFNSP pattern prompt
RSC_Pause	equ	FCW7RSC+772	;PAUSE prompt
RSC_DistFmt	equ	FCW7RSC+773	;DISTFMT prompt
RSC_SetDecP	equ	FCW7RSC+774	;SETDECP prompt
RSC_SetFrac	equ	FCW7RSC+775	;SETFRAC prompt
RSC_UnitM	equ	FCW7RSC+776	;UNITM prompt
RSC_TSPECA	equ	FCW7RSC+777	;command prompt
RSC_TSPECH	equ	FCW7RSC+778	;command prompt
RSC_TSPECJ	equ	FCW7RSC+779	;command prompt
RSC_TSPECP	equ	FCW7RSC+780	;command prompt
RSC_TSPECS	equ	FCW7RSC+781	;command prompt
RSC_TSPECT	equ	FCW7RSC+782	;command prompt
RSC_DSPECH	equ	FCW7RSC+783	;command prompt
RSC_SaveAsMName	equ	FCW7RSC+784	;command prompt
RSC_TFile	equ	FCW7RSC+785	;command prompt
RSC_AtrTag	equ	FCW7RSC+786	;ATTRIBM prompt
RSC_AtrPrmp	equ	FCW7RSC+787	;ATTRIBM prompt
RSC_AtrVal	equ	FCW7RSC+788	;ATTRIBM prompt
RSC_WRITEM	equ	FCW7RSC+789	;WRITEM prompt
RSC_ListPath2P	equ	FCW7RSC+790	;path2 length listing
RSC_Like	equ	FCW7RSC+791	;LIKE keyword
RSC_LikeEnt	equ	FCW7RSC+792	;LIKE entity prompt
RSC_BezPL	equ	FCW7RSC+793	;bezier last point
RSC_BezP2	equ	FCW7RSC+794	;bezier 2nd point
RSC_BezP3	equ	FCW7RSC+795	;bezier 3rd point
RSC_AngTo	equ	FCW7RSC+796	;RD_AngW/BrngW 2nd pt prompt
RSC_TopView	equ	FCW7RSC+797	;zstd view name
RSC_FrontView	equ	FCW7RSC+798	;zstd view name
RSC_RightView	equ	FCW7RSC+799	;zstd view name
RSC_LeftView	equ	FCW7RSC+800	;zstd view name
RSC_RObliqueView equ	FCW7RSC+801	;zstd view name
RSC_LObliqueView equ	FCW7RSC+802	;zstd view name
RSC_XYPlaneView	equ	FCW7RSC+803	;zstd view name
RSC_CurCPartName equ	FCW7RSC+804	;current CPART file name
REG_CPartName	equ	FCW7RSC+805	;CPART prior name
RSC_ListPoly2P	equ	FCW7RSC+806	;list poly preface
RSC_CmdFlags	equ	FCW7RSC+807	;command flags
RSC_IsProtected	equ	FCW7RSC+808	;protected file error
RSC_BadKeyMatch	equ	FCW7RSC+809	;protect key error
RSC_BadNewKey	equ	FCW7RSC+810	;protect key error
RSC_NameVPort	equ	FCW7RSC+811	;VPort entity name
RSC_VPort	equ	FCW7RSC+812	;ask for viewport entity
RSC_LowRes	equ	FCW7RSC+813	;warn of low color resolution issues
RSC_FilSameErr	equ	FCW7RSC+814	;can't fillet same entity
RSC_ErrSave	equ	FCW7RSC+815	;warning
RSC_ErrSaveTitle equ	FCW7RSC+816	;warning title
RSC_WPlane	equ	FCW7RSC+817	;Workplane [dialog]
RSC_DelNEWPlane	equ	FCW7RSC+818	;del wplane not empty
RSC_NewGridX	equ	FCW7RSC+819	;default gridx data
RSC_NameTTbl	equ	FCW7RSC+820	;text table name
RSC_ListTTbl	equ	FCW7RSC+821	;list text table entity
RSC_TTOCodeLst	equ	FCW7RSC+822	;Table origin code name list
RSC_ImportTitle	equ	FCW7RSC+823	;Table import title
RSC_ImportFName	equ	FCW7RSC+824	;Table import default name
RSC_ImportType	equ	FCW7RSC+825	;Table import default type
RSC_ImportFltr	equ	FCW7RSC+826	;Table import filters
RSC_SoundFile	equ	FCW7RSC+827	;Sound file name prompt
RSC_ExportTitle	equ	FCW7RSC+828	;Table export title
RSC_TImport	equ	FCW7RSC+829	;TIMPORT ent pick prompt
RSC_TExport	equ	FCW7RSC+830	;TEXPORT ent pick prompt
RSC_FIXDNew	equ	FCW7RSC+831	;FIXD modifier ref pt
RSC_NameTItem2	equ	FCW7RSC+832	;Text Item entity name
RSC_ListTItem2	equ	FCW7RSC+833	;Text Item listing format
RSC_LoadCfg	equ	FCW7RSC+834	;get cfg file name (macro)
RSC_TrackP3	equ	FCW7RSC+835	;@ prior point coordinate
RSC_BendEnt	equ	FCW7RSC+836	;bend entity pick
RSC_BendAt	equ	FCW7RSC+837	;bend entity to point
RSC_DimEnt	equ	FCW7RSC+838	;entity edge to dimension
RSC_ChgRad	equ	FCW7RSC+839	;new radius
RSC_ChgDia	equ	FCW7RSC+840	;new diameter
RSC_CenterPt	equ	FCW7RSC+841	;new diameter
RSC_TitleText	equ	FCW7RSC+842	;new diameter
RSC_NameCard	equ	FCW7RSC+843	;new diameter
RSC_ListCard	equ	FCW7RSC+844	;new diameter
REG_DWGSUName2	equ	FCW7RSC+845	;xpdwg2 options key
RSC_CatalogType	equ	FCW7RSC+846	;FSC file type
RSC_CatalogName	equ	FCW7RSC+847	;catalog name prompt
RSC_ActText		equ	FCW7RSC+848	;ACTIONM text prompt
RSC_Timeout		equ	FCW7RSC+849	;demo has timed out warning
RSC_LSUReason1	equ	FCW7RSC+850	;LSU error code
RSC_LSUReason2	equ	FCW7RSC+851	;LSU error code
RSC_LSUReason3	equ	FCW7RSC+852	;LSU error code
RSC_LSUReason4	equ	FCW7RSC+853	;LSU error code
RSC_LSUReason5	equ	FCW7RSC+854	;LSU error code
RSC_LSUReason6	equ	FCW7RSC+855	;LSU error code
RSC_LSUReason7	equ	FCW7RSC+856	;LSU error code
RSC_LSUReason8	equ	FCW7RSC+857	;LSU error code
RSC_LSUReason9	equ	FCW7RSC+858	;LSU error code
RSC_LSUReason10	equ	FCW7RSC+859	;LSU error code
RSC_LSUReason11	equ	FCW7RSC+860	;LSU error code
RSC_LSUReason12	equ	FCW7RSC+861	;LSU error code
RSC_NextAIV		equ	FCW7RSC+862	;next autoincrement value