// 	===============================================================
// 	GEOMETRY.CPY - Real Geometry Structures
// 	===============================================================
// 	Copyright 1999 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 20-July-1999
// 	===============================================================
//  Converted to C-Style 28-Feb-2000
//

#ifndef _GEOMTRY_H_
#define _GEOMTRY_H_

#include <TStyles.h>

typedef struct
{
	double cA;		
	double cB;		
	double cC;		
	double cD;
}GPLANE;

typedef struct
{
	float x;		
	float y;		
}GPNT2S;

typedef struct
{
	double x;		
	double y;		
}GPNT2;

typedef struct
{
	float x;	
	float y;	
	float z;	
}GPNT3S;

typedef struct
{
	double x;		
	double y;		
	double z;		
}GPNT3;

typedef struct
{
	GPNT2	p1;
	GPNT2	p2;		
	char	Valid;		
}XTNT2;

typedef struct
{
	GPNT3	p1;		
	GPNT3	p2;	
	DWORD	Valid;
}XTNT3;

typedef struct
{
	GPNT2	p1;		
	GPNT2	p2;		
}GLINE2;

typedef struct
{
	GPNT3	p1;		
	GPNT3	p2;
}GLINE3;

typedef struct
{
	WORD	nNodes;			// # def nodes
	GPNT2	p1;		
	GPNT2	p2;		
	GPNT2	p3;		
	GPNT2	p4;
	GPNT2	p1b;		
}GBOX2;

typedef struct
{
	WORD	nNodes;			// # def nodes
	GPNT2	Nodes[1];
}GPATH2;


typedef struct
{
	char	SmType;			// smoother type
	char	SRes;			// smoothing resolution
	double	SParm;			// start parameter
	double	EParm;			// end parameter
 							// full draw = # nodes-1 if open
 							//           = # nodes if closed
	WORD	nNodes;			// # def nodes
	GPNT2	Nodes[1];
}GSPLINE2;

#define SM_NO		0		// no smoothing
#define SM_CB		1		// Cubic B-Spline (as in FastCAD 2.x)
#define SM_PB		2		// Parabolic Blend (through-point)
#define SM_BZ		3		// Bezier

typedef struct
{
	char	SmType;			// moother type
	char	SRes;			// smoothing resolution
	double	SParm;			// start parameter
	double	EParm;			// end parameter
							// full draw = # nodes-1 if open
							//           = # nodes if closed
	WORD	nNodes;			// # def nodes
	GPNT3	Nodes[1];		
}GSPLINE3;

typedef struct
{
	char	SmType;			// smoother type
	char	SRes;			// smoothing resolution
	double	SParm;			// start parameter
	double	EParm;			// end parameter
					 		// full draw = # nodes-1 if open
					 		//           = # nodes if closed
	WORD	nNodes;			// # def nodes
	GPNT2	Nodes[1];
}GBEZ2;

typedef struct
{
	char	SmType;			// smoother type
	char	SRes;			// smoothing resolution
	double	SParm;			// start parameter
	double	EParm;			// end parameter
					 		// full draw = # nodes-1 if open
							//           = # nodes if closed
	WORD	nNodes;			// # def nodes
	GPNT3	Nodes[1];		
}GBEZ3;


typedef struct
{
	WORD	nNodes;
	GPNT3	Nodes[1];
}GPATH3;

typedef struct
{
	GPNT2	Cen;
	double	Radius;
}GCIR2;

typedef struct
{
	GPNT2	Cen;
	double	Radius;
	double	Ecc;				// eccentricity minor/major (0..1)
	double	Incl;				// major axis inclination angle 0..2pi
}GELP2;

typedef struct
{
	GPNT2	Cen;
	double	Radius;
	double	SAng;				// start angle 0..2pi
	double	AngW;				// arc width 0..2pi
}GARC2;

typedef struct
{
	GPNT2	Cen;
	double	Radius;
	double	Ecc;				// eccentricity minor/major (0..1)
	double	Incl;				// major axis inclination angle 0..2pi
	double	SAng;				// start angle 0..2pi
	double	AngW;				// arc width 0..2pi
}GELA2;

typedef struct
{
	GPNT2	AT;		
	XTNT2	XT;		
	TSTY	TS;
	char	TData[1];
}GTEXT2;

// 	Values for MFlags:

#define TM_FIT	1			// text to fit in At/At2 rect

typedef struct
{
	GPNT2	At;
	double BAng;
}AHEAD;

typedef struct
{
	double x1;		
	double y1;		
	double x2;		
	double y2;
}GWIN2;

typedef struct
{
	GPNT3	p1;
	GPNT3	p2;		
}GWIN3;

typedef struct
{
	POINT	Pt;
	DWORD	hCtrl;	
	GPNT3	RPt;			// world or wp coord
	GPNT3	RPtW;			// RPt world coord
}DIG;

typedef struct
{
	double XY;
	double YZ;
	double ZX;
}OANG;

typedef struct
{
	GPNT3	Cen;
	double	Radius;
	OANG	OA;
}GCIR3;

typedef struct
{
	GPNT3	Cen;
	double	Radius;
	OANG	OA;
	double	SAng;				// start angle 0..2pi (added 7.13b17)
	double	AngW;				// arc width 0..2pi
}GARC3;

typedef struct
{
	GPNT3	Cen;
	double	Radius;
	OANG	OA;
	double	Incl;				// major axis inclination angle 0..2pi
	double	Ecc;				// eccentricity minor/major (0..1)
}GELP3;

typedef struct
{
	GPNT3	Cen;
	double	Radius;
	OANG	OA;
	double	Ecc;				// eccentricity minor/major (0..1)
	double	Incl;				// major axis inclination angle 0..2pi
	double	SAng;				// start angle 0..2pi
	double	AngW;				// arc width 0..2pi
}GELA3;

typedef struct
{
	GPNT3	AT;		
	XTNT3	XT;		
	TSTY	TS;
	OANG	OA;
	char	TData[1];
}GTEXT3;

typedef struct
{
	GPNT3	Cen;
	double	Radius;
	OANG	OA;
	double	TopSA;			// Top start angle
	double	DomeAW;			// dome arc width +Z to -Z 360 max
	double	SecAW;			// Section Arc Width +X ccw 360 max
	double	PRZX;			// polar ratio Z to X
	double	PRZY;			// polar ratio Z to Y
}GSPH3;

typedef struct
{
	GPNT3	BCen;			// bottom center
	double	BRadius;		// bottom radius
	GPNT3	TCen;			// top center
	double	TRadius;		// top radius
}GCYL3;

typedef struct
{
	GPNT3	Cen;		    // bottom center
	double	Radius;			// bottom radius
	GPNT3	NormDV;		    // Normal Direction Vector
}GDISC3;

typedef struct
{
	DWORD	flags;			// 1=close nCol direction
							// 2=close nRow direction
							// 4=Cubic B-Spline smoothing
							// 8=indexed, 4-int index faces follow nodes
	DWORD	nCols;			// # rows of nodes (or # of indexed vertices)
	DWORD	nRows;			// # columns of nRows of nodes(or # of faces)
 
	GPNT3	Nodes[1];		// all nCol then nRow
							// if indexed, nRows sets of 4-integer face
							// indexes follow nCols verticies)
} GMESH3;

typedef struct
{
	float	ALen;			// arrowhead length
	float	AHgt;			// arrowhead height
	char	AStyle;			// arrowhead type id
	char	AThick;			// arrowhead line thickness
}ASTY;

typedef struct				// must be multiple of 4 bytes
{
	double	VWidth;			// view size (both must fit)
	double	VHeight;		
	GPNT3	VCen;			// view center
	OANG	VRot;			// rotation from normal 2d XY
	DWORD	Flags;			// view control flags
	double	FOV;			// 2.792526803 = 160 in radians
}VIEWP;

// 	Values for ViewP.Flags:

#define VT_3d			1	// view is 3d
#define VT_Persp		2	// perspective
#define VT_Hide			4	// hidden surface view
#define VT_OpenGL		8	// view is OpenGL

typedef struct
{
	DWORD	Tag;			// entity tag
	DWORD	pEnt;			// pointer to entity (0=need to find)
}TREF;

// 	===============================================================

#endif
