;	===============================================================
;	GEOMETRY.CPY - Real Geometry Structures
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 20-July-1999
;	===============================================================

GPlane		struc
cA		real8	0.0
cB		real8	0.0
cC		real8	0.0
cD		real8	0.0
GPlane		ends

GPnt2S		struc
X		real4	0.0
Y		real4	0.0
GPnt2S		ends

GPnt2		struc
X		real8	0.0
Y		real8	0.0
GPnt2		ends

GPnt3S		struc
X		real4	0.0
Y		real4	0.0
Z		real4	0.0
GPnt3S		ends

GPnt3		struc
X		real8	0.0
Y		real8	0.0
Z		real8	0.0
GPnt3		ends

Xtnt2		struc
P1		GPnt2	<>
P2		GPnt2	<>
Valid		db	0
Xtnt2		ends

Xtnt3		struc
P1		GPnt3	<>
P2		GPnt3	<>
Valid		dword	0
Xtnt3		ends

GLine2		struc
P1		GPnt2	<>
P2		GPnt2	<>
GLine2		ends

GLine3		struc
P1		GPnt3	<>
P2		GPnt3	<>
GLine3		ends

GBox2		struc
P1		GPnt2	<>
P2		GPnt2	<>
P3		GPnt2	<>
P4		GPnt2	<>
GBox2		ends

GPath2		struc
nNodes		word	0
Nodes		GPnt2	<>
GPath2		ends

GSpline2	struc
SmType		db	SM_NO		;smoother type
SRes		db	8		;smoothing resolution
SParm		real8	0.0		;start parameter
EParm		real8	1.0		;end parameter
;					;full draw = # nodes-1 if open
;					;          = # nodes if closed
nNodes		word	0		;# def nodes
Nodes		GPnt2	<>
GSpline2	ends

SM_NO	equ	0	;no smoothing
SM_CB	equ	1	;Cubic B-Spline (as in FastCAD 2.x)
SM_PB	equ	2	;Parabolic Blend (through-point)
SM_BZ	equ	3	;Bezier

GSpline3	struc
SmType		db	SM_NO		;smoother type
SRes		db	8		;smoothing resolution
SParm		real8	0.0		;start parameter
EParm		real8	1.0		;end parameter
;					;full draw = # nodes-1 if open
;					;          = # nodes if closed
nNodes		word	0		;# def nodes
Nodes		GPnt3	<>
GSpline3	ends

GBez2		struc
SmType		db	SM_BZ		;smoother type
SRes		db	8		;smoothing resolution
SParm		real8	0.0		;start parameter
EParm		real8	1.0		;end parameter
;					;full draw = # nodes-1 if open
;					;          = # nodes if closed
nNodes		word	4		;# def nodes
Node0		GPnt2	<>
Node1		GPnt2	<>
Node2		GPnt2	<>
Node3		GPnt2	<>
GBez2		ends

GBez3		struc
SmType		db	SM_BZ		;smoother type
SRes		db	8		;smoothing resolution
SParm		real8	0.0		;start parameter
EParm		real8	1.0		;end parameter
;					;full draw = # nodes-1 if open
;					;          = # nodes if closed
nNodes		word	4		;# def nodes
Node0		GPnt3	<>
Node1		GPnt3	<>
Node2		GPnt3	<>
Node3		GPnt3	<>
GBez3		ends

GPath3		struc
nNodes		word	0
Nodes		GPnt3	<>
GPath3		ends

GCir2		struc
Cen		GPnt2	<>
Radius		real8	1.0
GCir2		ends

GElp2		struc
Cen		GPnt2	<>
Radius		real8	1.0
Ecc		real8	1.0		;eccentricity minor/major (0..1)
Incl		real8	0.0		;major axis inclination angle 0..2pi
GElp2		ends

GArc2		struc
Cen		GPnt2	<>
Radius		real8	1.0
SAng		real8	0.0		;start angle 0..2pi (added 7.13b17)
AngW		real8	0.0		;arc width 0..2pi
GArc2		ends

GElA2		struc
Cen		GPnt2	<>
Radius		real8	1.0
Ecc		real8	1.0		;eccentricity minor/major (0..1)
Incl		real8	0.0		;major axis inclination angle 0..2pi
SAng		real8	0.0		;start angle 0..2pi
AngW		real8	0.0		;arc width 0..2pi
GElA2		ends

GText2		struc
At		GPnt2	<>
XT		Xtnt2	<>
TS		TSty	<>
TData		db	0
GText2		ends

;	Values for MFlags:

TM_FIT		equ	1	;text to fit in At/At2 rect

AHead		struc
X		real8	0.0
Y		real8	0.0
BAng		real8	0.0
AHead		ends

GWin2		struc
X1		real8	0.0
Y1		real8	0.0
X2		real8	0.0
Y2		real8	0.0
GWin2		ends

GWin3		struc
P1		GPnt3	<>
P2		GPnt3	<>
GWin3		ends

DIG		struc
Pt		POINT	<>
hCtrl		dword	0
RPt		GPnt3	<>	;world or wp coord
RPtW		GPnt3	<>	;RPt world coord
DIG		ends

OAng		struc
XY		real8	0.0
YZ		real8	0.0
ZX		real8	0.0
OAng		ends

GText3		struc
At		GPnt3	<>
XT		Xtnt3	<>
TS		TSty	<>
OA		OAng	<>
TData		db	0
GText3		ends

GCir3		struc
Cen		GPnt3	<>
Radius		real8	0.0
OA		OAng	<>
GCir3		ends

GArc3		struc
Cen		GPnt3	<>
Radius		real8	0.0
OA		OAng	<>
SAng		real8	0.0		;start angle 0..2pi
AngW		real8	0.0
GArc3		ends

GElp3		struc
Cen		GPnt3	<>
Radius		real8	1.0
OA		OAng	<>
Ecc		real8	1.0		;eccentricity minor/major (0..1)
Incl		real8	0.0		;major axis inclination angle 0..2pi
GElp3		ends

GElA3		struc
Cen		GPnt3	<>
Radius		real8	1.0
OA		OAng	<>
Ecc		real8	1.0		;eccentricity minor/major (0..1)
Incl		real8	0.0		;major axis inclination angle 0..2pi
SAng		real8	0.0		;start angle 0..2pi
AngW		real8	0.0		;arc width 0..2pi
GElA3		ends

GSph3		struc
Cen		GPnt3	<>
Radius		real8	1.0
OA		OAng	<>
TopSA		real8	1.570796327	;Top start angle
DomeAW		real8	6.283185307	;dome arc width +Z to -Z 360 max
SecAW		real8	6.283185307	;Section Arc Width +X ccw 360 max
PRZX		real8	1.0		;polar ratio Z to X
PRZY		real8	1.0		;polar ratio Z to Y
GSph3		ends

GCyl3		struc
BCen		GPnt3	<>		;bottom center
BRadius		real8	1.0		;bottom radius
TCen		GPnt3	<>		;top center
TRadius		real8	1.0		;top radius
GCyl3		ends

GDisc3		struc
Cen		GPnt3	<>		;bottom center
Radius		real8	1.0		;bottom radius
NormDV		GPnt3	<>		;Normal Direction Vector
GDisc3		ends

ASty		struc
ALen		real4	0.18		;arrowhead length
AHgt		real4	0.08		;arrowhead height
AStyle		db	0		;arrowhead type id
AThick		db	0		;arrowhead line thickness
ASty		ends

ViewP		struc			;must be multiple of 4 bytes
VWidth		real8	1.0		;view size (both must fit)
VHeight		real8	1.0
VCen		GPnt3	<>		;view center
VRot		OAng	<>		;rotation from normal 2d XY
Flags		dword	0		;view control flags
FOV		real8	0.610865238	;35 in radians
ViewP		ends

;	Values for ViewP.Flags:

VT_3d		equ	1		;view is 3d
VT_Persp	equ	2		;perspective
VT_Hide		equ	4		;hidden surface view
VT_OpenGL	equ	8		;view is OpenGL

TREF		struc
Tag		dword	0		;entity tag
pEnt		dword	0		;pointer to entity (0=need to find)
TREF		ends

QROT		struc			;3d orientation quaternion
w		real8	1.0		;init values are identity quaternion
x		real8	0.0
y		real8	0.0
z		real8	0.0
QROT		ends

;	===============================================================
