;	===============================================================
;	DWinCtrl.CPY - Drawing Window Control Object
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 20-July-1999
;	===============================================================

CreateDWCtrl	proto	stdcall,hPWinO:dword,hPCtrl:dword,pDWDEF:dword
CreateXWCtrl	proto	stdcall,pViewP:dword,pDevRect:dword,hXDC:dword
ChangeAW	proto	stdcall,hCtrl:dword
DWinClipGWin2	proto	stdcall,hDW:dword,hGWin2:dword,hRWin2:dword
DWinFwdDV	proto	stdcall,hDW:dword,pDV:dword
DWinBackDV	proto	stdcall,hDW:dword,pDV:dword
Redraw		proto	stdcall

DWDEF		struc
Scrn		RECT	<>		;proportional rectangle loc
View		ViewP	<>		;window view spec
DWDEF		ends

DWIN2		equ	0		;type of window in MDWin

DWCtrl		struc
ppCtrlVTbl	dword	0		;methods VTable
hPWinO		dword	0		;parent window Win object
hPCtrl		dword	0		;parent control object
Loc		RECT	<>		;location rectangle
Free		RECT	<>		;unallocated rectangle
;					;This rectangle is the real dwg area
;					;DWCtrl.wid & .hgt calc from it
take		dword	0		;take flags
tsize		dword	0		;take size
tsizea		dword	0		;apportioned take
frame		dword	0		;frame style
flags		dword	0		;general flags
CType		word	0		;control type
Stat		word	1		;1=control visible
CName		db	64 dup (0)	;control name
;
WClass		dword	DWIN2		;type of window
hBkImage	dword	0		;handle of DWIN BkImage
uBkImage	dword	0		;handle of BkImage to use
DWFlags		dword	0		;this DWIN flags
Scrn		RECT	<>		;proportional rectangle loc
Rest		RECT	<>		;scrn rect for restore
;					;right=0=not maximized
TBRect		RECT	<>		;title bar rect
VIRect		RECT	<>		;View information rectangle
DIRect		RECT	<>		;DList information rectangle
CIRect		RECT	<>		;ctrl icon rectangle
;
hDList		dword	0		;DList to redraw
View		ViewP	<>		;window view spec
AWidth		real8	0.0		;window actual width
AHeight		real8	0.0		;window actual height
Xtnt		GWin2	<>		;current window edges
wid		dword	0		;win width in pixels
hgt		dword	0		;win hgt in pixels
ppi		dword	0		;pixels per inch
;
W2VTM		TMat	<>		;world to view transform
V2WTM		TMat	<>		;view to world transform
;
XLow3		real8	0.0		;3d clipping extents
YLow3		real8	0.0
XHi3		real8	0.0
YHi3		real8	0.0
;
PSpecD		real8	1.0		;eye distance for perspective
hRender		dword	0		;active render object
PSOfst		real8	-1.0		;perspective offset (VNear)
WName		db	64 dup (0)	;window/view name
;
fSBVis		dword	1		;1 = scroll bars vis, 0=hide, 2=never
hVSBar		dword	0		;vertical scroll bar
hHSBar		dword	0		;horiz scroll bar
;
DWCtrl		ends

;	===============================================================
;	Ctrl Object Method Equates
;	===============================================================

DWDelete	equ	0		;delete the control
DWUpdate	equ	1		;update ctrl to the screen
DWResize	equ	2		;move/resize the control
DWDraw		equ	3		;draw the control
DWMouse		equ	4		;process mouse event
;
DWAddCtrl	equ	5		;** add contained control
DWRmvCtrl	equ	6		;** remove contained control
DWDrawFrame	equ	7		;draw frame & winctrl icon
DWReScale	equ	8		;rescale view
DWReOrg		equ	9		;reorigin view
;
;	The following functions are not valid for the main container
;	drawing window:

DWSetView2	equ	10		;set view for DWIN
DWSetEPick	equ	11		;set each pick window
DWSetWPick	equ	12		;set win pick window
DWPaperScale	equ	13		;paperscale value -> matching dwgUnits
DWSetWName	equ	14		;specify window name string
DWAskXYAlign	equ	15		;ask if DWIN aligned with XY plane
DWScrollUpdate	equ	16	;update scroll bars for current position

;	The following functions are for the main drawing window
;	container object only:

MDWinEmpty	equ	10		;empty main dwin container
MDWinWalkFront	equ	11		;walk windows to front

;	===============================================================
