;	===============================================================
;	XREF.CPY - XREF Infoblock Structure
;	===============================================================
;	Copyright 2000 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 9-April-2000
;	===============================================================

XRefGetDL	proto	stdcall,id:dword
XRefAdd		proto	stdcall,pFName:dword,XClass:dword,flags:dword
XRefAddEx	proto	stdcall,hDList:dword,\
			pFName:dword,XClass:dword,flags:dword

XRef		struc
rlen		dword	0		;size of XRef record
id		word	0		;xref id
xclass		db	0		;class of xref file
rsvd		db	0		;type of xref use
flags		dword	0
hDList		dword	0		;current DList holding file
hOther		dword	0		;other object handle
FName		db	0		;ANSIZ string (var length)
XRef		ends

;	Values for handles:

XREF_NEEDLD	equ	0		;need to load object
XREF_UNAVAIL	equ	-1		;object unavailable

;	Values for XRef.xclass: (defined in ESTRUC.CPY)

; XREF_OVL	equ	1		;used by overlays
; XREF_PART	equ	2		;used by XREFs

;	Values for XRef.flags:

XREF_RO		equ	4		;file data is read-only
XREF_HIDE	equ	8		;hide XREF
XREF_DEL	equ	10h		;delete this XREF
XREF_USED	equ	20h		;this XREF is used

;	===============================================================

IB_XREF		equ	12
IB_XREF_VER	equ	0

XRefIB		struc
ERLen		dword	sizeof(XRefIB)
EType		db	ET_IB
IType		db	IB_XREF		;type of infoblock
Ver		db	IB_XREF_VER	;IB version number
Valid		db	0		;0=just loaded, 1=links valid
NextId		word	1		;next free id # for new XRef
XRefIB		ends

;	There are 0 or more XRef structures after NextID,
;	followed by a dword=0 end marker (included in length).

;	===============================================================
;	Access Tools
;	===============================================================

XRefAdd		proto	stdcall,pFName:dword,XClass:dword,flags:dword
XRefGetDL	proto	stdcall,id:dword
XRefGetDef	proto	stdcall,id:dword
