;	===============================================================
;	XPENT - ASM Custom Entity XP (V7) - PICTs
;	===============================================================
;	Copyright 2000 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 29-Feb-2000
;	---------------------------------------------------------------
XPID		equ	00000020h	;this modules' XP ID #
Main		equ	1		;this is the main prog module

		include	\fcw7\XP7DEV\XP.CPY
		include	RSCID.CPY

		Public	DllMain
		extern	XPRscTbl:dword

;	---------------------------------------------------------------
.data
hPict		dword	PictSVC			;hdl to pict object

XPVer		equ	versionNr		;XP version #
XPDef		XPHDR	<,,,CList,PList>
CList		db	"PICT",0
		db	0
PList		dword	About			;about this XP...
		dword	PictCmd			;PICT

;	---------------------------------------------------------------
;	Picture Custom Entity
;	---------------------------------------------------------------

PictE		struc
ERLen		dword	sizeof(PictE)
EType		db	ET_XP
EThick		db	0		;pen thickness 0->25.4 mm paper scale
EColor		dword	0		;outline color
EColor2		dword	0		;fill color
EFStyle		word	0		;0 hollow, 1 solid
ELStyle		word	0		;0 solid
EMatrl		word	0		;render material 0=plain
ELayer		word	1		;layer 0 merge 1 standard
EWidth		real4	0.0		;entity edge width (geometric)
EWPlane		word	0		;3d workplane
ETag		dword	0		;entity tag #
;
XPID		dword	XPID		;XP ID # for custom entity SVC
;
;	------------------------	;xp-specific data starts here
;
flags		dword	FS_COPY		;option flags
X1		real8	0.0		;lower left corner
Y1		real8	0.0
X2		real8	1.0		;upper-right corner
Y2		real8	0.0
OfstX		dword	0		;offset image from left
OfstY		dword	0		;offset image from top
BMPName		db	256 dup (0)	;bitmap file name
PictE		ends

;	Values for PictE.flags:

;FS_STRETCH	equ	0
;FS_TILE	equ	1
;FS_EXPFILL	equ	2
;FS_EXPFIT	equ	3
;FS_TILE	equ	4
P_NoOutLine	equ	80000000h
P_LocalBitmap	equ	40000000h

.code
;	===============================================================
;	PICT entity service object
;	===============================================================
.data

PictSVC		dword	PictDraw	;0:Draw the entity
		dword	PictXCheck	;1:Extents check the entity
		dword	PictInfo	;2:give entity info
		dword	PictList	;3:list entity data
		dword	PictPick	;4:pick test entity
		dword	PictEdge	;5:gen entity edges
		dword	PictGenNL	;6:gen entity node list
		dword	PictGet		;7:get entity data
		dword	PictRender	;8:render entity in OpenGL
		dword	PictTran	;9:transform 2d entity
		dword	PictStretch	;10:stretch 2d entity
		dword	PictExtrude	;11:extrude 2d entity to 3d plane
		dword	PictTrim	;12:Trim entity
		dword	PictExplode	;13:Explode Entity
		dword	PictMake3d	;14:Make entity 3d
		dword	PictSplit	;15:Split entity at T
		dword	PictOffset	;16:Offset entity by distance
		dword	PictEdit	;17:Edit (dialog) entity
		dword	PictDynEd	;18:DynEdit entity
		dword	PictAct		;19:Actuate entity
		dword	PictPlace	;20:Place SmartSym on entity
.code
;	===============================================================
;	DllMain - DLL Init/End processing procedure
;	===============================================================

DllMain		proc	stdcall,
			hInstDLL:DWORD,fdwReason:DWORD,lpvReserved:DWORD
		WENTRY
		cmp	fdwReason,DLL_PROCESS_ATTACH
		jz	init
		cmp	fdwReason,DLL_PROCESS_DETACH
		jz	atend
		mov	eax,1			;return TRUE
		WEXIT

;	Initialize this XP (do no output yet!)

init:		mov	eax,hInstDLL		;save instance handle
		mov	XPDef.ModHdl,eax
		INVOKE	XPRegister,ADDR XPDef	;connect module
		INVOKE	RscSetPtr,ADDR XPRscTbl,XPRSCTBL
		INVOKE	RscAdr,XRSC_XPName	;get name stg adrs
		mov	XPDef.pXPName,eax
		INVOKE	XPRegEntSvc,XPID,ADDR hPict
		mov	eax,1			;return TRUE
		WEXIT

;	End using this XP

atend:		INVOKE	XPUnRegister,ADDR XPDef
		mov	eax,1			;return TRUE
		WEXIT
DllMain		endp

;	===============================================================
;	About - About this XP...
;	===============================================================
.data
APkt		dword	XRSC_AboutText
.code

About		proc	stdcall
		WENTRY
		INVOKE	RscSetPtr,ADDR XPRscTbl,XPRSCTBL
		INVOKE	FormSt,ADDR APkt,FV_ASM,NULL,FD_MsgBox
		WEXIT
About		endp

;	===============================================================
;	PICT;BmpFileNameDlg;OptionsDlg;p1;p2;
;	===============================================================
.data
Build		PictE	<>
hDwgDL		dword	0
BMPFNPkt	GETFN	<RSC_Temp,PriorPic,XRSC_BMPType,\
			XRSC_BMPFltr,OFN_FILEMUSTEXIST>
PriorPic	db	MAXPATH dup (0)

PictDlg		label	byte
		DLG	"PICTOPTIONS",0,IDH_PICTDLG
		CHKCTL	200,0,0,OutFlag,P_NoOutLine
		RBCTL	201,0,0,BtnNum,FS_COPY
		RBCTL	202,0,0,BtnNum,FS_STRETCH
		RBCTL	203,0,0,BtnNum,FS_EXPFIT
		RBCTL	204,0,0,BtnNum,FS_EXPFILL
		RBCTL	205,0,0,BtnNum,FS_TILE
		CHKCTL	210,0,0,FixAR,1
		CHKCTL	220,0,0,LBmpFlag,P_LocalBitmap
		ENDDLG

BtnNum		dword	0
LBmpFlag	dword	0
OutFlag		dword	0
FixAR		dword	0
BMPAdr		dword	0
BMPSize		dword	0

BMPDta		BITMAP	<>		;bitmap data
.code

PictCmdB	proto	stdcall,Result:dword
PictCmdC	proto	stdcall,Result:dword

PictCmd		proc	stdcall
		WENTRY
		INVOKE	RscSetPtr,ADDR XPRscTbl,XPRSCTBL

;	Get the BMP filename

		INVOKE	GetOpenFN,XRSC_BMPTitle,ADDR BMPFNPkt
		jnc	Ok			;cancel?
bad:		INVOKE	CmdEnd			;yes
		WEXIT
Ok:		INVOKE	FullFileName,RSC_Temp,ADDR Build.BMPName
		INVOKE	StCopy,ADDR Build.BMPName,ADDR PriorPic

;	conduct the options dialog

		mov	eax,Build.flags		;decode flag values
		and	eax,0FFh
		mov	BtnNum,eax
		mov	eax,Build.flags
		and	eax,P_NoOutLine
		mov	OutFlag,eax
		mov	eax,Build.flags
		and	eax,P_LocalBitmap
		mov	LBmpFlag,eax

		INVOKE	Dialog,ADDR PictDlg,XPDef.ModHdl,NULL
		cmp	eax,IDOK
		jnz	bad

		mov	eax,BtnNum		;encode flag values
		or	eax,OutFlag
		or	eax,LBmpFlag
		mov	Build.flags,eax

;	Ask for the 1st corner of the box

		INVOKE	ReqData,\
			RD_2dC8,
			ADDR Build.X1,
			RSC_Corner1,
			RDC_RXH2,
			ADDR PictCmdB,
			RDF_NONE,
			IDH_BOX
		WEXIT

PictCmd		endp

PictCmdB	proc	stdcall,Result:dword
		local	hBMP:dword,LockLine:GLine3
		WENTRY
		cmp	Result,RD_OK
		jz	Ok
		INVOKE	CmdEnd
		WEXIT
Ok:
		cmp	FixAR,1			;fixed aspect ratio?
		jz	DoFixAR

norm:		INVOKE	RscSetPtr,ADDR XPRscTbl,XPRSCTBL
		INVOKE	SetCursorOrg2,Build.X1,Build.Y1
		INVOKE	ReqData,\		;ask for P2
			RD_2dC8,
			ADDR Build.X2,
			RSC_Corner2,
			RDC_RWin2,
			ADDR PictCmdC,
			RDF_NONE,
			IDH_BOX
		WEXIT

;	Ask for Box with same aspect ratio as the bitmap

DoFixAR:	INVOKE	GetDDBitmap,ADDR Build.BMPName,NULL
		cmp	eax,0
		jz	norm
		mov	hBMP,eax
		INVOKE	GetObject,hBMP,sizeof(BITMAP),ADDR BMPDta
		INVOKE	RelDDBitmap,hBMP	;release the bitmap

		fdmove	LockLine.P1.X,Build.X1
		fdmove	LockLine.P1.Y,Build.Y1
		fdzero	LockLine.P1.Z
		fld	LockLine.P1.X
		fiadd	BMPDta.bmWidth
		fstp	LockLine.P2.X
		fld	LockLine.P1.Y
		fiadd	BMPDta.bmHeight
		fstp	LockLine.P2.Y
		fdzero	LockLine.P2.Z

		INVOKE	RscSetPtr,ADDR XPRscTbl,XPRSCTBL
		INVOKE	SetCursorOrg2,Build.X1,Build.Y1
		INVOKE	ReqDataX,\		;ask for P2
			RD_2dC8,
			ADDR Build.X2,
			RSC_Corner2,
			RDC_RWin2,
			ADDR PictCmdC,
			RDF_ONVEC,
			IDH_BOX,
			ADDR LockLine
		WEXIT
PictCmdB	endp

PictCmdC	proc	stdcall,Result:dword
		WENTRY
		cmp	Result,RD_OK
		jz	Ok
		INVOKE	CmdEnd
		WEXIT
Ok:
;	Sort the box corners

		fld	Build.X1		;sort x
		fld	Build.X2
		fcom	st(1)
		fjge	xok
		fxch
xok:		fstp	Build.X2
		fstp	Build.X1

		fld	Build.Y1		;sort y
		fld	Build.Y2
		fcom	st(1)
		fjge	yok
		fxch
yok:		fstp	Build.Y2
		fstp	Build.Y1

;	Append the picture entity

		INVOKE	GetWorkDL		;get current work DList
		mov	hDwgDL,eax
		INVOKE	ClearSelect		;for sel by prior
		COBJ	DLMarkUndo,hDwgDL	;undo to now

		COBJ	DLApnd,hDwgDL,<offset Build>
		mov	ebx,eax
		INVOKE	SetCStuff,ebx

;	Load local copy of bitmap if option selected

		test	Build.flags,P_LocalBitmap
		jz	noload
		INVOKE	LoadFile,ADDR Build.BMPName,ADDR BMPAdr,ADDR BMPSize
		jc	noload

		mov	eax,BMPSize		;make room to append bitmap
		add	eax,sizeof(PictE)
		COBJ	DLResize,hDwgDL,ebx,eax
		mov	ebx,eax

		mov	esi,BMPAdr		;append bitmap file image
		mov	edi,ebx
		add	edi,sizeof(PictE)
		mov	ecx,BMPSize
		cld
		rep	movsb

		INVOKE	RelMem,BMPAdr		;release file image
noload:
		INVOKE	EDraw,NULL,ebx
		COBJ	DLSelect,hDwgDL,ebx
		INVOKE	ShowChanges

		INVOKE	CmdEnd
		WEXIT
PictCmdC	endp

;	===============================================================
;	PictDraw - Draw the entity
;	===============================================================

PictDraw	proc	stdcall,pObj:dword,hDW:dword,pEnt:dword
		local	TLine:GLine2,hGDraw2:dword,DrawMode:dword
		local	hBI:dword,hDC:dword,hBMP:dword
		local	CRect:GWin2,PRect:RECT,GWin:GLine2
		local	LocalCopy:dword
		WENTRY

		INVOKE	GetDrawMode		;get drawing mode
		mov	DrawMode,eax

		INVOKE	GetGDraw2		;access geometry draw
		mov	hGDraw2,eax

;	Determine the window device context and backimage object

		mov	ebx,hDW			;dwin bkimage object
		mov	eax,DWCtrl.uBkImage[ebx]
		mov	hBI,eax
		mov	eax,BkImage.UseDC[eax]	;win API DC to use
		mov	hDC,eax

;	Get the clipped real draw rectangle

		mov	ebx,pEnt		;pict may be in sym or xref
		add	ebx,PictE.X1
		fld	GLine2.P1.X[ebx]
		fld	GLine2.P1.Y[ebx]
		INVOKE	SymTMSP2
		fstp	GWin.P1.Y
		fstp	GWin.P1.X

		mov	ebx,pEnt
		add	ebx,PictE.X1
		fld	GLine2.P2.X[ebx]
		fld	GLine2.P2.Y[ebx]
		INVOKE	SymTMSP2
		fstp	GWin.P2.Y
		fstp	GWin.P2.X

		lea	ebx,GWin
		INVOKE	DWinClipGWin2,hDW,ebx,ADDR CRect
		cmp	eax,0			;0=offscreen?
		jz	done

;	Determine the covered rectangle (BkImage coordinates)

		lea	ebx,CRect
		add	ebx,GWin2.X1
		INVOKE	CvtP2VX,hDW,ebx,ADDR PRect.left
		lea	ebx,CRect
		add	ebx,GWin2.X2
		INVOKE	CvtP2VX,hDW,ebx,ADDR PRect.right
		fwait
		mov	eax,PRect.top		;flip for l t r b order
		xchg	eax,PRect.bottom
		mov	PRect.top,eax

;	Fill the covered rectangle

		mov	ebx,hBI			;unless XOR cursor
		cmp	BkImage.XORMode[ebx],1
		jz	bmok

		cmp	DrawMode,DM_DRAW	;(erase/mark always fill)
		jnz	dofill

		mov	esi,pEnt		;or no outline
		test	PictE.flags[esi],P_NoOutLine
		jnz	fillok

dofill:
		mov	eax,Color_Bkgnd		;fill in bkgnd color
		cmp	DrawMode,DM_MARK	;unless marking
		jnz	clrok
		mov	eax,Color_Mark
clrok:		INVOKE	LookupColor,eax		;get RGB color values
		COBJ	BIFillColor,hBI,eax	;set fill color
		lea	ebx,PRect		;fill the covered rect
		COBJ	BIFRect,hBI,ebx		;and...
fillok:

;	Draw the bitmap

		cmp	DrawMode,DM_DRAW	;only if draw mode
		jnz	bmok

		mov	LocalCopy,0
		mov	ebx,pEnt		;load the bitmap
		test	PictE.flags[ebx],P_LocalBitmap
		jz	norm
		cmp	PictE.ERLen[ebx],sizeof(PictE)
		jle	norm

;	Use local copy of bitmap

		mov	LocalCopy,1
		mov	eax,ebx			;read from appended image
		add	eax,sizeof(PictE)
		jmp	loaded

;	Load bitmap from file

norm:		add	ebx,PictE.BMPName
		INVOKE	GetDIBImage,ebx
loaded:		mov	hBMP,eax
		cmp	eax,0			;unable to load DIB
		jz	bmok
		mov	ebx,pEnt		;draw it
		mov	eax,PictE.flags[ebx]	;type of bitmap draw
		movzx	eax,al
		and	al,7
		add	ebx,PictE.X1
		INVOKE	DrawDWinDIBI,hDW,hBMP,ebx,eax

		cmp	LocalCopy,1		;only release if load from file
		jz	bmok
		INVOKE	RelMem,hBMP		;release the bitmap
bmok:

;	Draw the frame

		mov	esi,pEnt
		test	PictE.flags[esi],P_NoOutLine
		jnz	done

		INVOKE	GDrawUsePen,hDW		;setup line draw

		fdmove	TLine.P1.X,PictE.X1[esi] ;bottom edge
		fndmove	TLine.P1.Y,PictE.Y1[esi]
		fndmove	TLine.P2.X,PictE.X2[esi]
		fndmove	TLine.P2.Y,PictE.Y1[esi]
		lea	ebx,TLine
		COBJ	GDLine2,hGDraw2,hDW,ebx

		fndmove	TLine.P1.X,PictE.X2[esi] ;right edge
		fndmove	TLine.P1.Y,PictE.Y2[esi]
		lea	ebx,TLine
		COBJ	GDLine2,hGDraw2,hDW,ebx

		fndmove	TLine.P2.X,PictE.X1[esi] ;top edge
		fndmove	TLine.P2.Y,PictE.Y2[esi]
		lea	ebx,TLine
		COBJ	GDLine2,hGDraw2,hDW,ebx

		fdmove	TLine.P1.X,PictE.X1[esi] ;bottom edge
		fndmove	TLine.P1.Y,PictE.Y1[esi]
		lea	ebx,TLine
		COBJ	GDLine2,hGDraw2,hDW,ebx

done:		WEXIT
PictDraw	endp

;	===============================================================
;	PictXCheck - Extents Check the entity
;	===============================================================

PictXCheck	proc	stdcall,pObj:dword,pEnt:dword,pXT:dword
		WENTRY
		mov	ebx,pEnt
		INVOKE	GXCheckP2,ADDR PictE.X1[ebx],pXT
		INVOKE	GXCheckP2,ADDR PictE.X2[ebx],pXT
		WEXIT
PictXCheck	endp

;	===============================================================
;	PictTran - Translate the entity
;	===============================================================

PictTran	proc	stdcall,pObj:dword,pEnt:dword,pTM:dword
		WENTRY
		mov	ebx,pEnt		;transform p1
		add	ebx,PictE.X1
		INVOKE	TRNP2M,ebx,pTM
		mov	ebx,pEnt		;transform p2
		add	ebx,PictE.X2
		INVOKE	TRNP2M,ebx,pTM
		mov	eax,pEnt
		WEXIT
PictTran	endp

;	===============================================================
;	PictStretch - Stretch the entity
;	===============================================================

PictStretch	proc	stdcall,pObj:dword,pEnt:dword
		WENTRY
		mov	ebx,pEnt		;transform p1
		add	ebx,PictE.X1
		INVOKE	StrP2,ebx
		mov	ebx,pEnt		;transform p2
		add	ebx,PictE.X2
		INVOKE	StrP2,ebx
		WEXIT
PictStretch	endp

;	===============================================================
;	PictInfo - Give entity info
;	===============================================================

PictInfo	proc	stdcall,pObj:dword,pEnt:dword,nAsk:dword
		WENTRY
		INVOKE	RscSetPtr,ADDR XPRscTbl,XPRSCTBL
		mov	eax,nAsk
		CASEOF	EI_EName,isName
		CASEOF	EI_Class,isClass
		CASEOF	EI_Caps,isCaps
		mov	eax,0
		stc
		WEXIT
isClass:	mov	eax,EC_XP
		clc
		WEXIT
isCaps:		mov	eax,EH_XP
		clc
		WEXIT
isName:		INVOKE	RscAdr,XRSC_NamePict
		clc
		WEXIT
PictInfo	endp

;	===============================================================
;	PictList - List entity Data
;	===============================================================
.data
PictListPkt	dword	XRSC_ListPict
		ItemFmt	<PictE.X1,FT_Dist8+FT_EBX,FJ_Var>
		ItemFmt	<PictE.Y1,FT_Dist8+FT_EBX,FJ_Var>
		ItemFmt	<PictE.X2,FT_Dist8+FT_EBX,FJ_Var>
		ItemFmt	<PictE.Y2,FT_Dist8+FT_EBX,FJ_Var>
		ItemFmt	<PictE.BMPName,FT_Stg+FT_EBX,FJ_Var>
.code

PictList	proc	stdcall,pPict:dword,pEnt:dword
		WENTRY
		INVOKE	RscSetPtr,ADDR XPRscTbl,XPRSCTBL
		INVOKE	FormSt,ADDR PictListPkt,FV_ASM,pEnt,FD_TxWin
		WEXIT
PictList	endp

;	===============================================================
;	PictPick - Pick Test the entity
;	===============================================================
.data
TLine		GLine2	<>
.code

PictPick	proc	stdcall,pObj:dword,hDW:dword,\
			pEnt:dword,flags:dword
		local	hGDraw2:dword
		WENTRY
		INVOKE	GetGDraw2		;access geometry draw
		mov	hGDraw2,eax

		mov	esi,pEnt
		fdmove	TLine.P1.X,PictE.X1[esi] ;bottom edge
		fndmove	TLine.P1.Y,PictE.Y1[esi]
		fndmove	TLine.P2.X,PictE.X2[esi]
		fndmove	TLine.P2.Y,PictE.Y1[esi]
		lea	ebx,TLine
		COBJ	GPkLine2,hGDraw2,hDW,ebx
		cmp	eax,0			;picked?
		jnz	done

		fndmove	TLine.P1.X,PictE.X2[esi] ;right edge
		fndmove	TLine.P1.Y,PictE.Y2[esi]
		lea	ebx,TLine
		COBJ	GPkLine2,hGDraw2,hDW,ebx
		cmp	eax,0			;picked?
		jnz	done

		fndmove	TLine.P2.X,PictE.X1[esi] ;top edge
		fndmove	TLine.P2.Y,PictE.Y2[esi]
		lea	ebx,TLine
		COBJ	GPkLine2,hGDraw2,hDW,ebx
		cmp	eax,0			;picked?
		jnz	done

		fdmove	TLine.P1.X,PictE.X1[esi] ;bottom edge
		fndmove	TLine.P1.Y,PictE.Y1[esi]
		lea	ebx,TLine
		COBJ	GPkLine2,hGDraw2,hDW,ebx

done:		WEXIT
PictPick	endp

;	===============================================================
;	PictEdges - Generate Edges of entity
;	===============================================================

PictEdge	proc	stdcall,pObj:dword,pEnt:dword,hEL3:dword
		WENTRY
		WEXIT
PictEdge	endp

;	===============================================================
;	PictGenNL - Generate Nodes of entity
;	===============================================================

PictGenNL	proc	stdcall,pObj:dword,pEnt:dword,phNL3:dword,\
			LType:dword,ARes:dword,LRes:dword
		WENTRY
		WEXIT
PictGenNL	endp

;	===============================================================
;	PictRender - Render the entity
;	===============================================================

PictRender	proc	stdcall,pObj:dword,hDW:dword,pEnt:dword
		WENTRY
		WEXIT
PictRender	endp

;	===============================================================
;	PictGet(pEnt,GType,pParm,pResult);
;	===============================================================

PictGet		proc	stdcall,pObj:dword,pEnt:dword,\
			GType:dword,pParm:dword,pResult:dword
		WENTRY
		lea	ebx,TLine	;line seg last picked
		INVOKE	GGetL2,ebx,GType,pParm,pResult
		WEXIT
PictGet		endp

;	===============================================================
;	PictExtrude - Extrude the entity
;	===============================================================

PictExtrude	proc	stdcall,pObj:dword,pEnt:dword,\
			pTM:dword,hDList:dword
		WENTRY
		WEXIT
PictExtrude	endp

;	===============================================================
;	PictTrim - Trim the entity
;	===============================================================

PictTrim	proc	stdcall,pObj:dword,pEnt:dword,\
			TTrim:real8,TPick:real8
		WENTRY
		mov	eax,0			;no trim
		stc
		WEXIT
PictTrim	endp

;	===============================================================
;	PictExplode - Explode the Entity
;	===============================================================

PictExplode	proc	stdcall,pObj:dword,pEnt:dword,pCallback:dword
		WENTRY
		mov	eax,0			;no change
		clc
		WEXIT
PictExplode	endp

;	===============================================================
;	PictMake3d - Make the Entity 3d
;	===============================================================

PictMake3d	proc	stdcall,pObj:dword,pEnt:dword
		WENTRY
		mov	eax,0			;no change
		clc
		WEXIT
PictMake3d	endp

;	===============================================================
;	PictSplit - Split the Entity at T
;	===============================================================

PictSplit	proc	stdcall,pObj:dword,pEnt:dword,T:real8,\
			ppNew1:dword,ppNew2:dword
		WENTRY
		mov	eax,0			;can't split
		clc
		WEXIT
PictSplit	endp

;	===============================================================
;	PictOffset - Offset the Entity by Distance
;	===============================================================

PictOffset	proc	stdcall,pObj:dword,pEnt:dword,pDV:dword,\
			pCallback:dword
		WENTRY
		mov	eax,0			;no offset ent created
		stc
		WEXIT
PictOffset	endp

;	===============================================================
;	EEdit - Edit (Dialog) the Entity
;	===============================================================

PictEdit	proc	stdcall,pObj:dword,pEnt:dword
		local	NoRelease:dword
		WENTRY
		INVOKE	RscSetPtr,ADDR XPRscTbl,XPRSCTBL
		INVOKE	CopyCStuff,pEnt,ADDR Build

;	Get the BMP filename

		mov	BMPSize,0
		mov	esi,pEnt
		add	esi,PictE.BMPName
		INVOKE	StCopy,esi,ADDR PriorPic
		INVOKE	GetOpenFN,XRSC_BMPTitle,ADDR BMPFNPkt
		jnc Ok

;	Continue to use prior local copy if one exists

		mov	ebx,pEnt
		mov	eax,PictE.ERLen[ebx]
		sub	eax,sizeof(PictE)
		mov	BMPSize,eax
		mov	ebx,pEnt
		add	ebx,sizeof(PictE)
		mov	BMPAdr,ebx

Ok:		INVOKE	FullFileName,RSC_Temp,ADDR Build.BMPName
		INVOKE	StCopy,ADDR Build.BMPName,ADDR PriorPic

;	conduct the options dialog

		mov	edx,pEnt		;decode flag values
		mov	eax,PictE.flags[edx]
		and	eax,0FFh
		mov	BtnNum,eax
		mov	eax,PictE.flags[edx]
		and	eax,P_NoOutLine
		mov	OutFlag,eax
		mov	eax,PictE.flags[edx]
		and	eax,P_LocalBitmap
		mov	LBmpFlag,eax

		INVOKE	Dialog,ADDR PictDlg,XPDef.ModHdl,NULL
		cmp	eax,IDOK
		jnz	bad

		mov	eax,BtnNum		;encode flag values
		or	eax,OutFlag
		or	eax,LBmpFlag
		mov	Build.flags,eax

		mov	esi,pEnt		;copy old location
		add	esi,PictE.X1
		mov	edi,offset Build.X1
		mov	ecx,(2*sizeof(GPnt2)+2*sizeof(dword))/4
		cld
		rep	movsd

		INVOKE	GetWorkDL		;get current DL
		mov	hDwgDL,eax
		INVOKE	EErase,NULL,pEnt	;erase old PICT
		COBJ	DLClone,hDwgDL,pEnt	;clone for undo
		mov	pEnt,eax
		COBJ	DLReplace,hDwgDL,pEnt,<offset Build>
		mov	pEnt,eax
		COBJ	DLSelect,hDwgDL,pEnt	;select for undo

;	Load local copy of bitmap if option selected

		mov	NoRelease,0
		mov	ebx,pEnt
		test	PictE.flags[ebx],P_LocalBitmap
		jz	noload
		INVOKE	LoadFile,ADDR PictE.BMPName[ebx],ADDR BMPAdr,ADDR BMPSize
		jnc	loadok
		cmp	BMPSize,0
		jz	noload
		mov	NoRelease,1

loadok:		mov	eax,BMPSize		;make room to append bitmap
		add	eax,sizeof(PictE)
		COBJ	DLResize,hDwgDL,pEnt,eax
		mov	pEnt,eax

		mov	esi,BMPAdr		;append bitmap file image
		mov	edi,pEnt
		add	edi,sizeof(PictE)
		mov	ecx,BMPSize
		cld
		rep	movsb

		cmp	NoRelease,1
		jz	noload
		INVOKE	RelMem,BMPAdr		;release file image
noload:

bad:		INVOKE	EDraw,NULL,pEnt		;clear hilight
		mov	eax,0			;not changed
		clc
		WEXIT
PictEdit	endp

;	===============================================================
;	EDynEdit - Edit (Dynamic) the Entity
;	===============================================================
.data
pDynEd		dword	0
.code

PictDynEdB	proto	stdcall,Result:dword
PictDynEdC	proto	stdcall,Result:dword

PictDynEd	proc	stdcall,pObj:dword,pEnt:dword
		WENTRY
		mov	esi,pEnt		;copy to edit
		mov	pDynEd,esi
		mov	edi,offset Build
		mov	ecx,sizeof(PictE)
		cld
		fwait
		rep	movsb

		INVOKE	SetCursorOrg2,Build.X1,Build.Y1

		INVOKE	ReqData,\		;as for new 1st corner
			RD_2dC8,
			ADDR Build.X1,
			RSC_Corner1,
			RDC_RBand2,
			ADDR PictDynEdB,
			RDF_NONE,
			IDH_BOX
		mov	eax,1			;we will do CmdEnd
		WEXIT
PictDynEd	endp

PictDynEdB	proc	stdcall,Result:dword
		local	hBMP:dword,LockLine:GLine3
		WENTRY
		cmp	Result,RD_OK
		jz	Ok
		INVOKE	CmdEnd
		WEXIT
Ok:
		cmp	FixAR,1			;fixed aspect ratio?
		jz	DoFixAR

norm:		INVOKE	RscSetPtr,ADDR XPRscTbl,XPRSCTBL
		INVOKE	SetCursorOrg2,Build.X1,Build.Y1
		INVOKE	ReqData,\		;ask for P2
			RD_2dC8,
			ADDR Build.X2,
			RSC_Corner2,
			RDC_RWin2,
			ADDR PictDynEdC,
			RDF_NONE,
			IDH_BOX
		WEXIT

;	Ask for Box with same aspect ratio as the bitmap

DoFixAR:	INVOKE	GetDDBitmap,ADDR Build.BMPName,NULL
		cmp	eax,0
		jz	norm
		mov	hBMP,eax
		INVOKE	GetObject,hBMP,sizeof(BITMAP),ADDR BMPDta
		INVOKE	RelDDBitmap,hBMP	;release the bitmap

		fdmove	LockLine.P1.X,Build.X1
		fdmove	LockLine.P1.Y,Build.Y1
		fdzero	LockLine.P1.Z
		fld	LockLine.P1.X
		fiadd	BMPDta.bmWidth
		fstp	LockLine.P2.X
		fld	LockLine.P1.Y
		fiadd	BMPDta.bmHeight
		fstp	LockLine.P2.Y
		fdzero	LockLine.P2.Z

		INVOKE	RscSetPtr,ADDR XPRscTbl,XPRSCTBL
		INVOKE	SetCursorOrg2,Build.X1,Build.Y1
		INVOKE	ReqDataX,\		;ask for P2
			RD_2dC8,
			ADDR Build.X2,
			RSC_Corner2,
			RDC_RWin2,
			ADDR PictDynEdC,
			RDF_ONVEC,
			IDH_BOX,
			ADDR LockLine
		WEXIT
PictDynEdB	endp

PictDynEdC	proc	stdcall,Result:dword
		WENTRY
		cmp	Result,RD_OK
		jz	Ok
		INVOKE	CmdEnd
		WEXIT
Ok:
;	Sort the box corners

		fld	Build.X1		;sort x
		fld	Build.X2
		fcom	st(1)
		fjge	xok
		fxch
xok:		fstp	Build.X2
		fstp	Build.X1

		fld	Build.Y1		;sort y
		fld	Build.Y2
		fcom	st(1)
		fjge	yok
		fxch
yok:		fstp	Build.Y2
		fstp	Build.Y1

;	Replace the picture entity with the repositioned one

		INVOKE	GetWorkDL		;get current work DList
		mov	hDwgDL,eax
		INVOKE	EErase,NULL,pDynEd	;undraw old
		COBJ	DLClone,hDwgDL,pDynEd
		mov	pDynEd,eax
		COBJ	DLReplace,hDwgDL,pDynEd,<offset Build>
		mov	pDynEd,eax
		INVOKE	EDraw,NULL,pDynEd
		INVOKE	ShowChanges

		INVOKE	CmdEnd
		WEXIT
PictDynEdC	endp

;	===============================================================
;	EAct - Actuate the Entity
;	===============================================================

PictAct		proc	stdcall,pObj:dword,pEnt:dword,ACode:dword
		WENTRY
		mov	eax,0			;no action
		clc
		WEXIT
PictAct		endp

;	===============================================================
;	EPlace - Place SmartSym on the entity
;	===============================================================

PictPlace	proc	stdcall,pObj:dword,pEnt:dword,pPlSpec:dword
		WENTRY
		mov	eax,0			;no action
		clc
		WEXIT
PictPlace	endp

;	===============================================================
END
