;	===============================================================
;	WPlane.CPY - WorkPlane Infoblock Structure
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 11-Dec-1999
;	===============================================================

GetCurWPlane	proto	stdcall
GetCurWPlaneId	proto	stdcall
AskWPlane	proto	stdcall
WPTMSP3		proto	stdcall
WPTMSP2		proto	stdcall
WP2World3	proto	stdcall,pPt3:dword
WP2World2	proto	stdcall,pPt2:dword
CvtL3toWP	proto	stdcall,pGLine3:dword,nWPID:dword
CvtP3fromWP	proto	stdcall,pGPt3:dword,nWPID:dword
CvtP3toWP	proto	stdcall,pGPt3:dword,nWPID:dword
FindWPlaneID	proto	stdcall,nID:dword
FindWPlaneName	proto	stdcall,pName:dword
UseWPlaneID	proto	stdcall,nID:dword
SetCurWPlane	proto	stdcall,nID:dword
DelWPlane	proto	stdcall,pName:dword
MarkUsedWPlane	proto	stdcall

CURWPLANE	equ	-1		;for nWPID to above functions

WPLANE		struc
RLen		dword	sizeof(WPLANE)
id		word	0		;id # of this workplane
flags		word	0		;flags
Geo		GPlane	<>		;cooeficients of the plane
WP2W		TMat	<>		;workplane to world (to draw)
W2WP		TMat	<>		;world to workplane (dig translate)
WPName		db	0		;ANSIZ string if named
WPLANE		ends

;	Values for WPLANE.flags

WP_PROT		equ	1		;1=can not erase or rename
WP_USED		equ	2		;entities exist on this workplane

;	===============================================================

IB_WPLANE	equ	6
IB_WPLANE_VER	equ	0

WPlaneIB	struc
ERLen		dword	sizeof(WPlaneIB)
EType		db	ET_IB
IType		db	IB_WPLANE	;type of infoblock
Ver		db	IB_WPLANE_VER	;IB version number
NextId		word	1		;next free id # for new workplane
CurWPId		word	0		;id # of current workplane
CurWPOfst	dword	0		;offset of CurWPId's WPLANE struc
WPlaneIB	ends

;	There are 1 or more WPLANE structures after CurWPOfst,
;	followed by a dword=0 end marker (included in length).

