;	===============================================================
;	WINENV.CPY - Windows Environment Interface Macros
;	===============================================================
;	Copyright 1995 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 4-24-95
;	---------------------------------------------------------------
;	This should be the first non-comment code in any module
;	---------------------------------------------------------------

option expr32
option casemap:none
.586
.MODEL flat, stdcall

;	---------------------------------------------------------------
;	Symbolic Constants
;	---------------------------------------------------------------

NULL		equ	0
FALSE		equ	0
TRUE		equ	1

;	---------------------------------------------------------------

	include	WIN32EQU.INC	;symbolic constant equates
	include	WIN32API.INC	;API prototypes
	include	WIN32DTA.INC	;data types & structures

;	===============================================================
;	WENTRY/WEXIT - Windows Callback function ENTRY & EXIT macros
;	---------------------------------------------------------------

WENTRY	macro
	push	ebx
	push	esi
	push	edi
	endm

WEXIT	macro
	pop	edi
	pop	esi
	pop	ebx
	ret
	endm

;	---------------------------------------------------------------
;	SVC - General service call macro
;	---------------------------------------------------------------

SVC	macro	p,Arg1,Arg2,Arg3
	ifnb	<Arg1>
	mov	esi,Arg1
	endif
	ifnb	<Arg2>
	mov	edi,Arg2
	endif
	ifnb	<Arg3>
	mov	eax,Arg3
	endif
	call	p
	endm

;	---------------------------------------------------------------
;	SVCO - General service call to our SVC's
;		Loads OFFSET of arguments
;		into esi and edi
;	---------------------------------------------------------------

SVCO	macro	p,Arg1,Arg2
	ifnb	<Arg1>
	mov	esi,offset Arg1
	endif
	ifnb	<Arg2>
	mov	edi,offset Arg2
	endif
	call	p
	endm

;	===============================================================
