;	===============================================================
;	WIN32EQU.INC - Windows32 Equates
;	===============================================================
;	Copyright 1995 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 3-25-95
;	---------------------------------------------------------------

MAXPATH			equ	260	;# bytes to store a full path name

;	Window styles

WS_OVERLAPPED		equ	000000000h
WS_POPUP		equ	080000000h
WS_CHILD		equ	040000000h
WS_MINIMIZE		equ	020000000h
WS_VISIBLE		equ	010000000h
WS_DISABLED		equ	008000000h
WS_CLIPSIBLINGS		equ	004000000h
WS_CLIPCHILDREN		equ	002000000h
WS_MAXIMIZE		equ	001000000h
WS_CAPTION		equ	000c00000h
WS_BORDER		equ	000800000h
WS_DLGFRAME		equ	000400000h
WS_VSCROLL		equ	000200000h
WS_HSCROLL		equ	000100000h
WS_SYSMENU		equ	000080000h
WS_THICKFRAME		equ	000040000h
WS_GROUP		equ	000020000h
WS_TABSTOP		equ	000010000h
WS_MINIMIZEBOX		equ	000020000h
WS_MAXIMIZEBOX		equ	000010000h
WS_TILED		equ	000000000h
WS_ICONIC		equ	020000000h
WS_SIZEBOX		equ	000040000h
WS_OVERLAPPEDWINDOW	equ	000cf0000h
WS_POPUPWINDOW		equ	080880000h
WS_CHILDWINDOW		equ	040000000h
WS_EX_DLGMODALFRAME	equ	000000001h
WS_EX_NOPARENTNOTIFY	equ	000000004h
WS_EX_TOPMOST		equ	000000008h
WS_EX_ACCEPTFILES	equ	000000010h
WS_EX_TRANSPARENT	equ	000000020h

LBS_NOTIFY		equ	000000001h
CBS_DROPDOWNLIST	equ	3

CW_USEDEFAULT		equ	080000000h

;	Hit Test equates

HTCAPTION		equ	2

;	Key State Masks for Mouse Messages

MK_LBUTTON          equ	0001h
MK_RBUTTON          equ	0002h
MK_SHIFT            equ	0004h
MK_CONTROL          equ	0008h
MK_MBUTTON          equ	0010h

;	Class Styles

CS_VREDRAW		equ	000000001h
CS_HREDRAW		equ	000000002h
CS_KEYCVTWINDOW		equ	000000004h
CS_DBLCLKS		equ	000000008h
CS_OWNDC		equ	000000020h
CS_CLASSDC		equ	000000040h
CS_PARENTDC		equ	000000080h
CS_NOKEYCVT		equ	000000100h
CS_NOCLOSE		equ	000000200h
CS_SAVEBITS		equ	000000800h
CS_BYTEALIGNCLIENT	equ	000001000h
CS_BYTEALIGNWINDOW	equ	000002000h
CS_GLOBALCLASS		equ	000004000h

;	Message box types

MB_SYSTEMMODAL		equ	000001000h
MB_TASKMODAL		equ	000002000h

MB_ICONERROR		equ	000000010h
MB_ICONQUESTION		equ	000000020h
MB_ICONWARNING		equ	000000030h
MB_ICONINFORMATION	equ	000000040h
MB_ICONSTOP		equ	MB_ICONERROR

MB_OK			equ	000000000h
MB_OKCANCEL		equ	000000001h
MB_YESNO		equ	000000004h
MB_YESNOCANCEL		equ	000000003h
MB_RETRYCANCEL		equ	000000005h

;	Standard Cursor IDs

IDC_ARROW      	     	equ	32512
IDC_IBEAM       	equ	32513
IDC_WAIT	  	equ	32514
IDC_CROSS	 	equ	32515
IDC_UPARROW       	equ	32516
IDC_SIZE	  	equ	32640
IDC_ICON		equ	32641
IDC_SIZENWSE      	equ	32642
IDC_SIZENESW      	equ	32643
IDC_SIZEWE	 	equ	32644
IDC_SIZENS		equ	32645
IDC_SIZEALL  	  	equ	32646
IDC_NO		  	equ	32648
IDC_APPSTARTING 	equ	32650

;	Stock Logical Objects

WHITE_BRUSH		equ	0t
LTGRAY_BRUSH		equ	1t
GRAY_BRUSH		equ	2t
DKGRAY_BRUSH		equ	3t
BLACK_BRUSH		equ	4t
NULL_BRUSH		equ	5t
HOLLOW_BRUSH		equ	000000005h
WHITE_PEN		equ	6t
BLACK_PEN		equ	7t
NULL_PEN		equ	8t
OEM_FIXED_FONT		equ	10t
ANSI_FIXED_FONT		equ	11t
ANSI_VAR_FONT		equ	12t
SYSTEM_FONT		equ	13t
DEVICE_DEFAULT_FONT	equ	14t
DEFAULT_PALETTE		equ	15t
SYSTEM_FIXED_FONT	equ	16t
STOCK_LAST		equ	16t
DEFAULT_GUI_FONT	equ	17t
CLR_INVALID		equ	0ffffffffh

;	Brush Styles

BS_SOLID		equ	0t
BS_NULL			equ	1t
BS_HOLLOW		equ	000000001h
BS_HATCHED		equ	2t
BS_PATTERN		equ	3t
BS_INDEXED		equ	4t
BS_DIBPATTERN		equ	5t
BS_DIBPATTERNPT		equ	6t
BS_PATTERN8X8		equ	7t
BS_DIBPATTERN8X8	equ	8t

;	Hatch Styles

HS_HORIZONTAL		equ	0t
HS_VERTICAL		equ	1t
HS_FDIAGONAL		equ	2t
HS_BDIAGONAL		equ	3t
HS_CROSS		equ	4t
HS_DIAGCROSS		equ	5t

;	Pen Styles

PS_SOLID		equ	0t
PS_DASH			equ	1t
PS_DOT			equ	2t
PS_DASHDOT		equ	3t
PS_DASHDOTDOT		equ	4t
PS_NULL			equ	5t
PS_INSIDEFRAME		equ	6t
PS_USERSTYLE		equ	7t
PS_ALTERNATE		equ	8t
PS_STYLE_MASK		equ	00000000fh
PS_ENDCAP_ROUND		equ	000000000h
PS_ENDCAP_SQUARE	equ	000000100h
PS_ENDCAP_FLAT		equ	000000200h
PS_ENDCAP_MASK		equ	000000f00h
PS_JOIN_ROUND		equ	000000000h
PS_JOIN_BEVEL		equ	000001000h
PS_JOIN_MITER		equ	000002000h
PS_JOIN_MASK		equ	00000f000h
PS_COSMETIC		equ	000000000h
PS_GEOMETRIC		equ	000010000h
PS_TYPE_MASK		equ	0000f0000h

;	ShowWindow parameters

SW_HIDE			equ	0t
SW_SHOWNORMAL		equ	1t
SW_NORMAL		equ	1t
SW_SHOWMINIMIZED	equ	2t
SW_SHOWMAXIMIZED	equ	3t
SW_MAXIMIZE		equ	3t
SW_SHOWNOACTIVATE	equ	4t
SW_SHOW			equ	5t
SW_MINIMIZE		equ	6t
SW_SHOWMINNOACTIVE	equ	7t
SW_SHOWNA		equ	8t
SW_RESTORE		equ	9t
SW_SHOWDEFAULT		equ	10t
SW_MAX			equ	10t

;	WM_SIZE values

SIZE_RESTORED		equ	0
SIZE_MINIMIZED		equ	1
SIZE_MAXIMIZED		equ	2

;	Draw text formats

DT_TOP			equ	0
DT_LEFT			equ	0
DT_CENTER		equ	1
DT_RIGHT		equ	2
DT_VCENTER		equ	4
DT_BOTTOM		equ	8
DT_WORDBREAK		equ	10h
DT_SINGLELINE		equ	20h
DT_EXPANDTABS		equ	40h
DT_TABSTOP		equ	80h
DT_NOCLIP		equ	100h
DT_EXTERNALLEADING	equ	200h
DT_CALCRECT		equ	400h
DT_NOPREFIX		equ	800h
DT_INTERNAL		equ	1000h

;	System Color Types

COLOR_SCROLLBAR			EQU	0
COLOR_BACKGROUND		EQU	1
COLOR_ACTIVECAPTION		EQU	2
COLOR_INACTIVECAPTION		EQU	3
COLOR_MENU			EQU	4
COLOR_WINDOW			EQU	5
COLOR_WINDOWFRAME		EQU	6
COLOR_MENUTEXT			EQU	7
COLOR_WINDOWTEXT		EQU	8
COLOR_CAPTIONTEXT		EQU	9
COLOR_ACTIVEBORDER		EQU	10
COLOR_INACTIVEBORDER		EQU	11
COLOR_APPWORKSPACE		EQU	12
COLOR_HIGHLIGHT			EQU	13
COLOR_HIGHLIGHTTEXT		EQU	14
COLOR_BTNFACE			EQU	15
COLOR_BTNSHADOW			EQU	16
COLOR_GRAYTEXT			EQU	17
COLOR_BTNTEXT			EQU	18
COLOR_INACTIVECAPTIONTEXT	EQU	19
COLOR_BTNHIGHLIGHT		EQU	20
COLOR_INFOBK			equ	24
COLOR_INFOTEXT			equ	23

COLOR_DESKTOP			equ	1

;	Binary raster ops

R2_BLACK            equ		1 	; 0
R2_NOTMERGEPEN      equ		2 	;DPon
R2_MASKNOTPEN       equ		3 	;DPna
R2_NOTCOPYPEN       equ		4 	;PN
R2_MASKPENNOT       equ		5 	;PDna
R2_NOT              equ		6 	;Dn
R2_XORPEN           equ		7 	;DPx
R2_NOTMASKPEN       equ		8 	;DPan
R2_MASKPEN          equ		9 	;DPa
R2_NOTXORPEN        equ		10	;DPxn
R2_NOP              equ		11	;D
R2_MERGENOTPEN      equ		12	;DPno
R2_COPYPEN          equ		13	;P
R2_MERGEPENNOT      equ		14	;PDno
R2_MERGEPEN         equ		15	;DPo
R2_WHITE            equ		16	; 1
R2_LAST             equ		16

;	Ternary raster operations

SRCCOPY             equ	000CC0020h	;dest = source
SRCPAINT            equ	000EE0086h	;dest = source OR dest
SRCAND              equ	0008800C6h	;dest = source AND dest        
SRCINVERT           equ	000660046h	;dest = source XOR dest        
SRCERASE            equ	000440328h	;dest = source AND (NOT dest ) 
NOTSRCCOPY          equ	000330008h	;dest = (NOT source)           
NOTSRCERASE         equ	0001100A6h	;dest = (NOT src) AND (NOT dest
MERGECOPY           equ	000C000CAh	;dest = (source AND pattern)   
MERGEPAINT          equ	000BB0226h	;dest = (NOT source) OR dest   
PATCOPY             equ	000F00021h	;dest = pattern                
PATPAINT            equ	000FB0A09h	;dest = DPSnoo                 
PATINVERT           equ	0005A0049h	;dest = pattern XOR dest       
DSTINVERT           equ	000550009h	;dest = (NOT dest)             
BLACKNESS           equ	000000042h	;dest = BLACK                  
WHITENESS           equ	000FF0062h	;dest = WHITE                  

;	System Metrics

SM_CXSCREEN		equ	0
SM_CYSCREEN		equ	1
SM_CXVSCROLL		equ	2
SM_CYHSCROLL		equ	3
SM_CYCAPTION		equ	4
SM_CXBORDER		equ	5
SM_CYBORDER		equ	6
SM_CXDLGFRAME		equ	7
SM_CYDLGFRAME		equ	8
SM_CYVTHUMB		equ	9
SM_CXHTHUMB		equ	10
SM_CXICON		equ	11
SM_CYICON		equ	12
SM_CXCURSOR		equ	13
SM_CYCURSOR		equ	14
SM_CYMENU		equ	15
SM_CXFULLSCREEN		equ	16
SM_CYFULLSCREEN		equ	17
SM_MOUSEPRESENT		equ	19
SM_CYVSCROLL		equ	20
SM_CXHSCROLL		equ	21
SM_DEBUG		equ	22
SM_SWAPBUTTON		equ	23
SM_CXMIN		equ	28
SM_CYMIN		equ	29
SM_CXSIZE		equ	30
SM_CYSIZE		equ	31
SM_CXFRAME		equ	32
SM_CYFRAME		equ	33
SM_CXMINTRACK		equ	34
SM_CYMINTRACK		equ	35
SM_CXDOUBLECLK		equ	36
SM_CYDOUBLECLK		equ	37
SM_CXICONSPACING	equ	38
SM_CYICONSPACING	equ	39
SM_CMETRICS		equ	71

;	File I/O equates

INVALID_HANDLE_VALUE	equ	-1

GENERIC_READ		equ	080000000h
GENERIC_WRITE		equ	040000000h
FILE_SHARE_READ		equ	000000001h
FILE_SHARE_WRITE	equ	000000002h
CREATE_NEW		equ	1
CREATE_ALWAYS		equ	2
OPEN_EXISTING		equ	3
OPEN_ALWAYS		equ	4
TRUNCATE_EXISTING	equ	5
FILE_BEGIN		equ	0
FILE_CURRENT		equ	1
FILE_END		equ	2
FILE_FLAG_DELETE_ON_CLOSE	equ	04000000h

FILE_ATTRIBUTE_READONLY		equ	00000001h
FILE_ATTRIBUTE_HIDDEN		equ	00000002h  
FILE_ATTRIBUTE_SYSTEM		equ	00000004h
FILE_ATTRIBUTE_DIRECTORY	equ	00000010h
FILE_ATTRIBUTE_ARCHIVE		equ	00000020h
FILE_ATTRIBUTE_NORMAL		equ	00000080h
FILE_ATTRIBUTE_TEMPORARY	equ	00000100h
FILE_ATTRIBUTE_COMPRESSED	equ	00000800h

FILE_WRITE_ATTRIBUTES		equ	0100h

;	AppendMenu flags

MF_ENABLED	equ	000000000h
MF_POPUP	equ	000000010h
MF_STRING	equ	000000000h
MF_SEPARATOR	equ	000000800h
MF_CHECKED	equ	000000008h
MF_UNCHECKED	equ	000000000h

;	Memory Allocation Flags

GMEM_MOVEABLE	equ	000000002h
GMEM_FIXED	equ	000000000h
GMEM_SHARE	equ	000002000h
GMEM_ZEROINIT	equ	000000040h

;	---------------------------------------------------------------
;	Virtual Keys, Standard Set
;	---------------------------------------------------------------

VK_LBUTTON        equ	001h
VK_RBUTTON        equ	002h
VK_CANCEL         equ	003h
VK_MBUTTON        equ	004    ;NOT contiguous with L & RBUTTONh

VK_BACK           equ	008h
VK_TAB            equ	009h

VK_CLEAR          equ	00Ch
VK_RETURN         equ	00Dh

VK_SHIFT          equ	010h
VK_CONTROL        equ	011h
VK_MENU           equ	012h
VK_PAUSE          equ	013h
VK_CAPITAL        equ	014h

VK_ESCAPE         equ	01Bh

VK_ext		equ	80000000h	;we add this to extended keys
;					;because the VK equiv. overlap
;					;the ANSI char set.

VK_SPACE          equ	020h
VK_PRIOR          equ	021h
VK_NEXT           equ	022h
VK_END            equ	023h
VK_HOME           equ	024h
VK_LEFT           equ	025h
VK_UP             equ	026h
VK_RIGHT          equ	027h
VK_DOWN           equ	028h
VK_SELECT         equ	029h
VK_PRINT          equ	02Ah
VK_EXECUTE        equ	02Bh
VK_SNAPSHOT       equ	02Ch
VK_INSERT         equ	02Dh
VK_DELETE         equ	02Eh
VK_HELP           equ	02Fh

; VK_0 thru VK_9 are the same as ASCII '0' thru '9' (030h - 039h)
; VK_A thru VK_Z are the same as ASCII 'A' thru 'Z' (041h - 05Ah)

VK_LWIN           equ	05Bh
VK_RWIN           equ	05Ch
VK_APPS           equ	05Dh

VK_NUMPAD0        equ	060h
VK_NUMPAD1        equ	061h
VK_NUMPAD2        equ	062h
VK_NUMPAD3        equ	063h
VK_NUMPAD4        equ	064h
VK_NUMPAD5        equ	065h
VK_NUMPAD6        equ	066h
VK_NUMPAD7        equ	067h
VK_NUMPAD8        equ	068h
VK_NUMPAD9        equ	069h
VK_MULTIPLY       equ	06Ah
VK_ADD            equ	06Bh
VK_SEPARATOR      equ	06Ch
VK_SUBTRACT       equ	06Dh
VK_DECIMAL        equ	06Eh
VK_DIVIDE         equ	06Fh
VK_F1             equ	070h
VK_F2             equ	071h
VK_F3             equ	072h
VK_F4             equ	073h
VK_F5             equ	074h
VK_F6             equ	075h
VK_F7             equ	076h
VK_F8             equ	077h
VK_F9             equ	078h
VK_F10            equ	079h
VK_F11            equ	07Ah
VK_F12            equ	07Bh
VK_F13            equ	07Ch
VK_F14            equ	07Dh
VK_F15            equ	07Eh
VK_F16            equ	07Fh
VK_F17            equ	080h
VK_F18            equ	081h
VK_F19            equ	082h
VK_F20            equ	083h
VK_F21            equ	084h
VK_F22            equ	085h
VK_F23            equ	086h
VK_F24            equ	087h

VK_NUMLOCK        equ	090h
VK_SCROLL         equ	091h

VK_ATTN           equ	0F6h
VK_CRSEL          equ	0F7h
VK_EXSEL          equ	0F8h
VK_EREOF          equ	0F9h
VK_PLAY           equ	0FAh
VK_ZOOM           equ	0FBh
VK_NONAME         equ	0FCh
VK_PA1            equ	0FDh
VK_OEM_CLEAR      equ	0FEh

VK_LCONTROL	equ	0A2h
VK_RCONTROL	equ	0A3h
VK_LMENU	equ	0A4h
VK_RMENU	equ	0A5h
VK_LSHIFT	equ	0A2h
VK_RSHIFT	equ	0A3h

;	---------------------------------------------------------------
;	Window Message symbolic constants
;	---------------------------------------------------------------

WM_NOTIFY		EQU	004Eh
WM_NULL			equ	000000000h
WM_CREATE		equ	000000001h
WM_DESTROY		equ	000000002h
WM_MOVE			equ	000000003h
WM_SIZE			equ	000000005h
WM_ACTIVATE		equ	000000006h
WA_INACTIVE		equ	0t
WA_ACTIVE		equ	1t
WA_CLICKACTIVE		equ	2t
WM_SETFOCUS		equ	000000007h
WM_KILLFOCUS		equ	000000008h
WM_ENABLE		equ	00000000ah
WM_SETREDRAW		equ	00000000bh
WM_SETTEXT		equ	00000000ch
WM_GETTEXT		equ	00000000dh
WM_GETTEXTLENGTH	equ	00000000eh
WM_PAINT		equ	00000000fh
WM_CLOSE		equ	000000010h
WM_QUERYENDSESSION	equ	000000011h
WM_QUIT			equ	000000012h
WM_QUERYOPEN		equ	000000013h
WM_ERASEBKGND		equ	000000014h
WM_SYSCOLORCHANGE	equ	000000015h
WM_ENDSESSION		equ	000000016h
WM_SHOWWINDOW		equ	000000018h
WM_WININICHANGE		equ	00000001ah
WM_DEVMODECHANGE	equ	00000001bh
WM_ACTIVATEAPP		equ	00000001ch
WM_FONTCHANGE		equ	00000001dh
WM_TIMECHANGE		equ	00000001eh
WM_CANCELMODE		equ	00000001fh
WM_SETCURSOR		equ	000000020h
WM_MOUSEACTIVATE	equ	000000021h
WM_CHILDACTIVATE	equ	000000022h
WM_QUEUESYNC		equ	000000023h
WM_GETMINMAXINFO	equ	000000024h
WM_PAINTICON		equ	000000026h
WM_ICONERASEBKGND	equ	000000027h
WM_NEXTDLGCTL		equ	000000028h
WM_SPOOLERSTATUS	equ	00000002ah
WM_DRAWITEM		equ	00000002bh
WM_MEASUREITEM		equ	00000002ch
WM_DELETEITEM		equ	00000002dh
WM_VKEYTOITEM		equ	00000002eh
WM_CHARTOITEM		equ	00000002fh
WM_SETFONT		equ	000000030h
WM_GETFONT		equ	000000031h
WM_SETHOTKEY		equ	000000032h
WM_GETHOTKEY		equ	000000033h
WM_QUERYDRAGICON	equ	000000037h
WM_COMPAREITEM		equ	000000039h
WM_COMPACTING		equ	000000041h
WM_WINDOWPOSCHANGING	equ	000000046h
WM_WINDOWPOSCHANGED	equ	000000047h
WM_POWER		equ	000000048h
PWR_OK			equ	1t
PWR_FAIL		equ	0ffffffffh
PWR_SUSPENDREQUEST	equ	1t
PWR_SUSPENDRESUME	equ	2t
PWR_CRITICALRESUME	equ	3t
WM_COPYDATA		equ	00000004ah
WM_CANCELJOURNAL	equ	00000004bh
WM_NCCREATE		equ	000000081h
WM_NCDESTROY		equ	000000082h
WM_NCCALCSIZE		equ	000000083h
WM_NCHITTEST		equ	000000084h
WM_NCPAINT		equ	000000085h
WM_NCACTIVATE		equ	000000086h
WM_GETDLGCODE		equ	000000087h
WM_NCMOUSEMOVE		equ	0000000a0h
WM_NCLBUTTONDOWN	equ	0000000a1h
WM_NCLBUTTONUP		equ	0000000a2h
WM_NCLBUTTONDBLCLK	equ	0000000a3h
WM_NCRBUTTONDOWN	equ	0000000a4h
WM_NCRBUTTONUP		equ	0000000a5h
WM_NCRBUTTONDBLCLK	equ	0000000a6h
WM_NCMBUTTONDOWN	equ	0000000a7h
WM_NCMBUTTONUP		equ	0000000a8h
WM_NCMBUTTONDBLCLK	equ	0000000a9h
WM_KEYFIRST		equ	000000100h
WM_KEYDOWN		equ	000000100h
WM_KEYUP		equ	000000101h
WM_CHAR			equ	000000102h
WM_DEADCHAR		equ	000000103h
WM_SYSKEYDOWN		equ	000000104h
WM_SYSKEYUP		equ	000000105h
WM_SYSCHAR		equ	000000106h
WM_SYSDEADCHAR		equ	000000107h
WM_KEYLAST		equ	000000108h
WM_INITDIALOG		equ	000000110h
WM_COMMAND		equ	000000111h
WM_SYSCOMMAND		equ	000000112h
WM_TIMER		equ	000000113h
WM_HSCROLL		equ	000000114h
WM_VSCROLL		equ	000000115h
WM_INITMENU		equ	000000116h
WM_INITMENUPOPUP	equ	000000117h
WM_MENUSELECT		equ	00000011fh
WM_MENUCHAR		equ	000000120h
WM_ENTERIDLE		equ	000000121h
WM_CTLCOLORMSGBOX	equ	000000132h
WM_CTLCOLOREDIT		equ	000000133h
WM_CTLCOLORLISTBOX	equ	000000134h
WM_CTLCOLORBTN		equ	000000135h
WM_CTLCOLORDLG		equ	000000136h
WM_CTLCOLORSCROLLBAR	equ	000000137h
WM_CTLCOLORSTATIC	equ	000000138h
WM_MOUSEFIRST		equ	000000200h
WM_MOUSEMOVE		equ	000000200h
WM_LBUTTONDOWN		equ	000000201h
WM_LBUTTONUP		equ	000000202h
WM_LBUTTONDBLCLK	equ	000000203h
WM_RBUTTONDOWN		equ	000000204h
WM_RBUTTONUP		equ	000000205h
WM_RBUTTONDBLCLK	equ	000000206h
WM_MBUTTONDOWN		equ	000000207h
WM_MBUTTONUP		equ	000000208h
WM_MBUTTONDBLCLK	equ	000000209h
WM_MOUSELAST		equ	000000209h
WM_MOUSEWHEEL		equ	00000020Ah
WM_PARENTNOTIFY		equ	000000210h
WM_ENTERMENULOOP	equ	000000211h
WM_EXITMENULOOP		equ	000000212h
WM_MDICREATE		equ	000000220h
WM_MDIDESTROY		equ	000000221h
WM_MDIACTIVATE		equ	000000222h
WM_MDIRESTORE		equ	000000223h
WM_MDINEXT		equ	000000224h
WM_MDIMAXIMIZE		equ	000000225h
WM_MDITILE		equ	000000226h
WM_MDICASCADE		equ	000000227h
WM_MDIICONARRANGE	equ	000000228h
WM_MDIGETACTIVE		equ	000000229h
WM_MDISETMENU		equ	000000230h
WM_DROPFILES		equ	000000233h
WM_MDIREFRESHMENU	equ	000000234h
WM_CUT			equ	000000300h
WM_COPY			equ	000000301h
WM_PASTE		equ	000000302h
WM_CLEAR		equ	000000303h
WM_UNDO			equ	000000304h
WM_RENDERFORMAT		equ	000000305h
WM_RENDERALLFORMATS	equ	000000306h
WM_DESTROYCLIPBOARD	equ	000000307h
WM_DRAWCLIPBOARD	equ	000000308h
WM_PAINTCLIPBOARD	equ	000000309h
WM_VSCROLLCLIPBOARD	equ	00000030ah
WM_SIZECLIPBOARD	equ	00000030bh
WM_ASKCBFORMATNAME	equ	00000030ch
WM_CHANGECBCHAIN	equ	00000030dh
WM_HSCROLLCLIPBOARD	equ	00000030eh
WM_QUERYNEWPALETTE	equ	00000030fh
WM_PALETTEISCHANGING	equ	000000310h
WM_PALETTECHANGED	equ	000000311h
WM_HOTKEY		equ	000000312h
WM_PENWINFIRST		equ	000000380h
WM_PENWINLAST		equ	00000038fh
WM_USER			equ	000000400h

;	Progress bar messages

PBM_SETRANGE		equ	WM_USER+1
PBM_SETPOS		equ	WM_USER+2

;	Text Alignment

TA_UPDATECP		equ	1
TA_NOUPDATECP		equ	0

;	Windows Help

HELP_CONTEXT		equ	00000001h	;display ulTopic
HELP_QUIT		equ	00000002h	;end help system
HELP_INDEX		equ	00000003h	;display index
HELP_CONTENTS		equ	HELP_INDEX	;display contents
HELP_HELPONHELP		equ	00000004h	;help on the help system
HELP_SETINDEX		equ	00000005h	;set current idx for multiidx
HELP_SETCONTENTS	equ	HELP_SETINDEX
HELP_CONTEXTPOPUP	equ	00000008h
HELP_FORCEFILE		equ	00000009h
HELP_KEY		equ	00000101h	;topic for keyword
HELP_COMMAND		equ	00000102h
HELP_PARTIALKEY		equ	00000105h
HELP_MULTIKEY		equ	00000201h
HELP_SETWINPOS		equ	00000203h
HELP_FINDER		equ	0000000bh	;w95 contents dialog

;	Get window long data

GWL_ID		equ	-12	;child window id
GWL_EXSTYLE	equ	-20	;extended style
GWL_WNDPROC	equ	-4	;windows procedure
GWL_USERDATA	equ	-21	;user data word
GWL_STYLE	equ	-16	;window style

;	Set window position

SWP_NOSIZE          equ	00001h
SWP_NOMOVE          equ	00002h
SWP_NOZORDER        equ	00004h
SWP_NOREDRAW        equ	00008h
SWP_NOACTIVATE      equ	00010h
SWP_FRAMECHANGED    equ	00020h	;The frame changed: send WM_NCCALCSIZE
SWP_SHOWWINDOW      equ	00040h
SWP_HIDEWINDOW      equ	00080h
SWP_NOCOPYBITS      equ	00100h
SWP_NOOWNERZORDER   equ	00200h  ;Don't do owner Z ordering
SWP_DRAWFRAME       equ	SWP_FRAMECHANGED
SWP_NOREPOSITION    equ	SWP_NOOWNERZORDER

HWND_TOP	equ	0
HWND_TOPMOST	equ	-1
HWND_BOTTOM	equ	1
HWND_NOTOPMOST	equ	-2

;	Track popup menu

TPM_LEFTALIGN	equ	0
TPM_CENTERALIGN	equ	4
TPM_RIGHTALIGN	equ	8
TPM_LEFTBUTTON	equ	0
TPM_RIGHTBUTTON	equ	2

;	Menu flags for Add/Check/EnableMenuItem

MF_BYCOMMAND		equ	0000h
MF_BYPOSITION		equ	0400h
MF_ENABLED		equ	0000h
MF_GRAYED		equ	0001h
MF_DISABLED		equ	0002h

;	Common Dialog error values

CDERR_DIALOGFAILURE		EQU		00000ffffh
CDERR_GENERALCODES		EQU		000000000h
CDERR_STRUCTSIZE		EQU		000000001h
CDERR_INITIALIZATION		EQU		000000002h
CDERR_NOTEMPLATE		EQU		000000003h
CDERR_NOHINSTANCE		EQU		000000004h
CDERR_LOADSTRFAILURE		EQU		000000005h
CDERR_FINDRESFAILURE		EQU		000000006h
CDERR_LOADRESFAILURE		EQU		000000007h
CDERR_LOCKRESFAILURE		EQU		000000008h
CDERR_MEMALLOCFAILURE		EQU		000000009h
CDERR_MEMLOCKFAILURE		EQU		00000000ah
CDERR_NOHOOK			EQU		00000000bh
CDERR_REGISTERMSGFAIL		EQU		00000000ch
PDERR_PRINTERCODES		EQU		000001000h
PDERR_SETUPFAILURE		EQU		000001001h
PDERR_PARSEFAILURE		EQU		000001002h
PDERR_RETDEFFAILURE		EQU		000001003h
PDERR_LOADDRVFAILURE		EQU		000001004h
PDERR_GETDEVMODEFAIL		EQU		000001005h
PDERR_INITFAILURE		EQU		000001006h
PDERR_NODEVICES			EQU		000001007h
PDERR_NODEFAULTPRN		EQU		000001008h
PDERR_DNDMMISMATCH		EQU		000001009h
PDERR_CREATEICFAILURE		EQU		00000100ah
PDERR_PRINTERNOTFOUND		EQU		00000100bh
PDERR_DEFAULTDIFFERENT		EQU		00000100ch
CFERR_CHOOSEFONTCODES		EQU		000002000h
CFERR_NOFONTS			EQU		000002001h
CFERR_MAXLESSTHANMIN		EQU		000002002h
FNERR_FILENAMECODES		EQU		000003000h
FNERR_SUBCLASSFAILURE		EQU		000003001h
FNERR_INVALIDFILENAME		EQU		000003002h
FNERR_BUFFERTOOSMALL		EQU		000003003h
FRERR_FINDREPLACECODES		EQU		000004000h
FRERR_BUFFERLENGTHZERO		EQU		000004001h
CCERR_CHOOSECOLORCODES		EQU		000005000h

;	Printer Enumeration codes

PRINTER_ENUM_DEFAULT		equ	1
PRINTER_ENUM_LOCAL		equ	2
PRINTER_ENUM_NAME		equ	8
PRINTER_ENUM_CONNECTIONS	equ	4
PRINTER_ENUM_NETWORK		equ	40h

;	Open filename flags

OFN_READONLY                 equ	00000001h
OFN_OVERWRITEPROMPT          equ	00000002h
OFN_HIDEREADONLY             equ	00000004h
OFN_NOCHANGEDIR              equ	00000008h
OFN_SHOWHELP                 equ	00000010h
OFN_ENABLEHOOK               equ	00000020h
OFN_ENABLETEMPLATE           equ	00000040h
OFN_ENABLETEMPLATEHANDLE     equ	00000080h
OFN_NOVALIDATE               equ	00000100h
OFN_ALLOWMULTISELECT         equ	00000200h
OFN_EXTENSIONDIFFERENT       equ	00000400h
OFN_PATHMUSTEXIST            equ	00000800h
OFN_FILEMUSTEXIST            equ	00001000h
OFN_CREATEPROMPT             equ	00002000h
OFN_SHAREAWARE               equ	00004000h
OFN_NOREADONLYRETURN         equ	00008000h
OFN_NOTESTFILECREATE         equ	00010000h
OFN_NONETWORKBUTTON          equ	00020000h
OFN_NOLONGNAMES              equ	00040000h
OFN_EXPLORER		     equ	00080000h

;	Print dialog flags

PD_ALLPAGES                  equ	00000000h
PD_SELECTION                 equ	00000001h
PD_PAGENUMS                  equ	00000002h
PD_NOSELECTION               equ	00000004h
PD_NOPAGENUMS                equ	00000008h
PD_COLLATE                   equ	00000010h
PD_PRINTTOFILE               equ	00000020h
PD_PRINTSETUP                equ	00000040h
PD_NOWARNING                 equ	00000080h
PD_RETURNDC                  equ	00000100h
PD_RETURNIC                  equ	00000200h
PD_RETURNDEFAULT             equ	00000400h
PD_SHOWHELP                  equ	00000800h
PD_ENABLEPRINTHOOK           equ	00001000h
PD_ENABLESETUPHOOK           equ	00002000h
PD_ENABLEPRINTTEMPLATE       equ	00004000h
PD_ENABLESETUPTEMPLATE       equ	00008000h
PD_ENABLEPRINTTEMPLATEHANDLE equ	00010000h
PD_ENABLESETUPTEMPLATEHANDLE equ	00020000h
PD_USEDEVMODECOPIES          equ	00040000h
PD_DISABLEPRINTTOFILE        equ	00080000h
PD_HIDEPRINTTOFILE           equ	00100000h
PD_NONETWORKBUTTON           equ	00200000h

;	Device Parameters for GetDeviceCaps()

DRIVERVERSION	equ	0     ;Device driver version
TECHNOLOGY    	equ	2     ;Device classification
HORZSIZE      	equ	4     ;Horizontal size in millimeters
VERTSIZE      	equ	6     ;Vertical size in millimeters
HORZRES       	equ	8     ;Horizontal width in pixels
VERTRES       	equ	10    ;Vertical height in pixels
BITSPIXEL     	equ	12    ;Number of bits per pixel
PLANES        	equ	14    ;Number of planes
NUMBRUSHES    	equ	16    ;Number of brushes the device has
NUMPENS       	equ	18    ;Number of pens the device has
NUMMARKERS    	equ	20    ;Number of markers the device has
NUMFONTS      	equ	22    ;Number of fonts the device has
NUMCOLORS     	equ	24    ;Number of colors the device supports
PDEVICESIZE   	equ	26    ;Size required for device descriptor
CURVECAPS     	equ	28    ;Curve capabilities
LINECAPS      	equ	30    ;Line capabilities
POLYGONALCAPS 	equ	32    ;Polygonal capabilities
TEXTCAPS      	equ	34    ;Text capabilities
CLIPCAPS      	equ	36    ;Clipping capabilities
RASTERCAPS    	equ	38    ;Bitblt capabilities
ASPECTX       	equ	40    ;Length of the X leg
ASPECTY       	equ	42    ;Length of the Y leg
ASPECTXY      	equ	44    ;Length of the hypotenuse

LOGPIXELSX    	equ	88    ;Logical pixels/inch in X
LOGPIXELSY    	equ	90    ;Logical pixels/inch in Y

SIZEPALETTE  	equ	104    ;Number of entries in physical palette
NUMRESERVED  	equ	106    ;Number of reserved entries in palette
COLORRES     	equ	108    ;Actual color resolution

;	Printing related DeviceCaps. These replace the appropriate Escapes

PHYSICALWIDTH   	equ	110 ;Physical Width in device units
PHYSICALHEIGHT  	equ	111 ;Physical Height in device units
PHYSICALOFFSETX 	equ	112 ;Physical Printable Area x margin
PHYSICALOFFSETY 	equ	113 ;Physical Printable Area y margin
SCALINGFACTORX  	equ	114 ;Scaling factor x
SCALINGFACTORY  	equ	115 ;Scaling factor y

;	RASTERCAPS return flags

RC_NONE		equ	0
RC_BITBLT      	equ	1       ; Can do standard BLT.
RC_BANDING     	equ	2       ; Device requires banding support
RC_SCALING     	equ	4       ; Device requires scaling support
RC_BITMAP64     equ	8       ; Device can support >64K bitmap
RC_GDI20_OUTPUT equ	0010h   ; has 2.0 output calls
RC_GDI20_STATE  equ	0020h
RC_SAVEBITMAP   equ	0040h
RC_DI_BITMAP    equ	0080h   ; supports DIB to memory
RC_PALETTE      equ	0100h   ; supports a palette
RC_DIBTODEV     equ	0200h   ; supports DIBitsToDevice
RC_BIGFONT      equ	0400h   ; supports >64K fonts
RC_STRETCHBLT   equ	0800h   ; supports StretchBlt
RC_FLOODFILL    equ	1000h   ; supports FloodFill
RC_STRETCHDIB   equ	2000h   ; supports StretchDIBits
RC_OP_DX_OUTPUT equ	4000h
RC_DEVBITS      equ	8000h

;	constants for Get/SetSystemPaletteUse()

SYSPAL_ERROR    equ	0
SYSPAL_STATIC   equ	1
SYSPAL_NOSTATIC equ	2

;	PeekMessage equates

PM_NOREMOVE		equ	0
PM_REMOVE		equ	1
PM_NOYIELD		equ	2

;	Dialog Box Command IDs

IDOK			     equ	1
IDCANCEL		     equ	2
IDABORT 		     equ	3
IDRETRY 		     equ	4
IDIGNORE		     equ	5
IDYES			     equ	6
IDNO			     equ	7
IDCLOSE         		equ	8
IDHELP          		equ	9


;	System Menu Command Values

SC_SIZE 		     equ	0F000h
SC_MOVE 		     equ	0F010h
SC_MINIMIZE		     equ	0F020h
SC_MAXIMIZE		     equ	0F030h
SC_NEXTWINDOW		     equ	0F040h
SC_PREVWINDOW		     equ	0F050h
SC_CLOSE		     equ	0F060h
SC_VSCROLL		     equ	0F070h
SC_HSCROLL		     equ	0F080h
SC_MOUSEMENU		     equ	0F090h
SC_KEYMENU		     equ	0F100h
SC_ARRANGE		     equ	0F110h
SC_RESTORE		     equ	0F120h
SC_TASKLIST		     equ	0F130h
SC_SCREENSAVE		     equ	0F140h
SC_HOTKEY		     equ	0F150h


;	Edit Control Styles

ES_LEFT 		     equ	00000h
ES_CENTER		     equ	00001h
ES_RIGHT		     equ	00002h
ES_MULTILINE		     equ	00004h
ES_UPPERCASE		     equ	00008h
ES_LOWERCASE		     equ	00010h
ES_PASSWORD		     equ	00020h
ES_AUTOVSCROLL		     equ	00040h
ES_AUTOHSCROLL		     equ	00080h
ES_NOHIDESEL		     equ	00100h
ES_OEMCONVERT		     equ	00400h
ES_READONLY		     equ	00800h
ES_WANTRETURN		     equ	01000h
ES_NUMBER		     equ	02000h


;	Edit Control Notification Codes

EN_SETFOCUS		     equ	00100h
EN_KILLFOCUS		     equ	00200h
EN_CHANGE		     equ	00300h
EN_UPDATE		     equ	00400h
EN_ERRSPACE		     equ	00500h
EN_MAXTEXT		     equ	00501h
EN_HSCROLL		     equ	00601h
EN_VSCROLL		     equ	00602h

;	Edit control EM_SETMARGIN parameters */

EC_LEFTMARGIN		     equ	00001h
EC_RIGHTMARGIN		     equ	00002h
EC_USEFONTINFO		     equ	0ffffh

;	Edit Control Messages

EM_GETSEL		     equ	000B0h
EM_SETSEL		     equ	000B1h
EM_GETRECT		     equ	000B2h
EM_SETRECT		     equ	000B3h
EM_SETRECTNP		     equ	000B4h
EM_SCROLL		     equ	000B5h
EM_LINESCROLL		     equ	000B6h
EM_SCROLLCARET		     equ	000B7h
EM_GETMODIFY		     equ	000B8h
EM_SETMODIFY		     equ	000B9h
EM_GETLINECOUNT 	     equ	000BAh
EM_LINEINDEX		     equ	000BBh
EM_SETHANDLE		     equ	000BCh
EM_GETHANDLE		     equ	000BDh
EM_GETTHUMB		     equ	000BEh
EM_LINELENGTH		     equ	000C1h
EM_REPLACESEL		     equ	000C2h
EM_GETLINE		     equ	000C4h
EM_LIMITTEXT		     equ	000C5h
EM_CANUNDO		     equ	000C6h
EM_UNDO 		     equ	000C7h
EM_FMTLINES		     equ	000C8h
EM_LINEFROMCHAR 	     equ	000C9h
EM_SETTABSTOPS		     equ	000CBh
EM_SETPASSWORDCHAR	     equ	000CCh
EM_EMPTYUNDOBUFFER	     equ	000CDh
EM_GETFIRSTVISIBLELINE	     equ	000CEh
EM_SETREADONLY		     equ	000CFh
EM_SETWORDBREAKPROC	     equ	000D0h
EM_GETWORDBREAKPROC	     equ	000D1h
EM_GETPASSWORDCHAR	     equ	000D2h
EM_SETMARGINS		     equ	000D3h
EM_GETMARGINS		     equ	000D4h
EM_SETLIMITTEXT 	     equ	EM_LIMITTEXT   ;win40 Name change
EM_GETLIMITTEXT 	     equ	000D5h
EM_POSFROMCHAR		     equ	000D6h
EM_CHARFROMPOS		     equ	000D7h

;	EDITWORDBREAKPROC code values

WB_LEFT 		     equ	0
WB_RIGHT		     equ	1
WB_ISDELIMITER		     equ	2

;	Button Control Styles

BS_PUSHBUTTON		     equ	000000000h
BS_DEFPUSHBUTTON	     equ	000000001h
BS_CHECKBOX		     equ	000000002h
BS_AUTOCHECKBOX 	     equ	000000003h
BS_RADIOBUTTON		     equ	000000004h
BS_3STATE		     equ	000000005h
BS_AUTO3STATE		     equ	000000006h
BS_GROUPBOX		     equ	000000007h
BS_USERBUTTON		     equ	000000008h
BS_AUTORADIOBUTTON	     equ	000000009h
BS_OWNERDRAW		     equ	00000000Bh
BS_LEFTTEXT		     equ	000000020h
BS_TEXT 		     equ	000000000h
BS_ICON 		     equ	000000040h
BS_BITMAP		     equ	000000080h
BS_LEFT 		     equ	000000100h
BS_RIGHT		     equ	000000200h
BS_CENTER		     equ	000000300h
BS_TOP			     equ	000000400h
BS_BOTTOM		     equ	000000800h
BS_VCENTER		     equ	000000C00h
BS_PUSHLIKE		     equ	000001000h
BS_MULTILINE		     equ	000002000h
BS_NOTIFY		     equ	000004000h
BS_FLAT 		     equ	000008000h
BS_RIGHTBUTTON		     equ	BS_LEFTTEXT

;	User Button Notification Codes

BN_CLICKED		     equ	0
BN_PAINT		     equ	1
BN_HILITE		     equ	2
BN_UNHILITE		     equ	3
BN_DISABLE		     equ	4
BN_DOUBLECLICKED	     equ	5
BN_PUSHED		     equ	BN_HILITE
BN_UNPUSHED		     equ	BN_UNHILITE
BN_DBLCLK		     equ	BN_DOUBLECLICKED
BN_SETFOCUS		     equ	6
BN_KILLFOCUS		     equ	7

;	Button Control Messages

BM_GETCHECK		     equ	000F0h
BM_SETCHECK		     equ	000F1h
BM_GETSTATE		     equ	000F2h
BM_SETSTATE		     equ	000F3h
BM_SETSTYLE		     equ	000F4h
BM_CLICK		     equ	000F5h
BM_GETIMAGE		     equ	000F6h
BM_SETIMAGE		     equ	000F7h

BST_UNCHECKED		     equ	00000h
BST_CHECKED		     equ	00001h
BST_INDETERMINATE	     equ	00002h
BST_PUSHED		     equ	00004h
BST_FOCUS		     equ	00008h

;	Static Control Constants

SS_LEFT 		     equ	000000000h
SS_CENTER		     equ	000000001h
SS_RIGHT		     equ	000000002h
SS_ICON 		     equ	000000003h
SS_BLACKRECT		     equ	000000004h
SS_GRAYRECT		     equ	000000005h
SS_WHITERECT		     equ	000000006h
SS_BLACKFRAME		     equ	000000007h
SS_GRAYFRAME		     equ	000000008h
SS_WHITEFRAME		     equ	000000009h
SS_USERITEM		     equ	00000000Ah
SS_SIMPLE		     equ	00000000Bh
SS_LEFTNOWORDWRAP	     equ	00000000Ch
SS_BITMAP		     equ	00000000Eh
SS_OWNERDRAW		     equ	00000000Dh
SS_ENHMETAFILE		     equ	00000000Fh
SS_ETCHEDHORZ		     equ	000000010h
SS_ETCHEDVERT		     equ	000000011h
SS_ETCHEDFRAME		     equ	000000012h
SS_TYPEMASK		     equ	00000001Fh
SS_NOPREFIX		     equ	000000080h ;Don't do "&" character translation
SS_NOTIFY		     equ	000000100h
SS_CENTERIMAGE		     equ	000000200h
SS_RIGHTJUST		     equ	000000400h
SS_REALSIZEIMAGE	     equ	000000800h
SS_SUNKEN		     equ	000001000h

;	Static Control Mesages

STM_SETICON		     equ	00170h
STM_GETICON		     equ	00171h
STM_SETIMAGE		     equ	00172h
STM_GETIMAGE		     equ	00173h
STN_CLICKED		     equ	0
STN_DBLCLK		     equ	1
STN_ENABLE		     equ	2
STN_DISABLE		     equ	3
STM_MSGMAX		     equ	00174h

;	Combo Box messages

CB_GETEDITSEL		     equ	00140h
CB_LIMITTEXT		     equ	00141h
CB_SETEDITSEL		     equ	00142h
CB_ADDSTRING		     equ	00143h
CB_DELETESTRING 	     equ	00144h
CB_DIR			     equ	00145h
CB_GETCOUNT		     equ	00146h
CB_GETCURSEL		     equ	00147h
CB_GETLBTEXT		     equ	00148h
CB_GETLBTEXTLEN 	     equ	00149h
CB_INSERTSTRING 	     equ	0014Ah
CB_RESETCONTENT 	     equ	0014Bh
CB_FINDSTRING		     equ	0014Ch
CB_SELECTSTRING 	     equ	0014Dh
CB_SETCURSEL		     equ	0014Eh
CB_SHOWDROPDOWN 	     equ	0014Fh
CB_GETITEMDATA		     equ	00150h
CB_SETITEMDATA		     equ	00151h
CB_GETDROPPEDCONTROLRECT     equ	00152h
CB_SETITEMHEIGHT	     equ	00153h
CB_GETITEMHEIGHT	     equ	00154h
CB_SETEXTENDEDUI	     equ	00155h
CB_GETEXTENDEDUI	     equ	00156h
CB_GETDROPPEDSTATE	     equ	00157h
CB_FINDSTRINGEXACT	     equ	00158h
CB_SETLOCALE		     equ	00159h
CB_GETLOCALE		     equ	0015Ah
CB_GETTOPINDEX		     equ	0015bh
CB_SETTOPINDEX		     equ	0015ch
CB_GETHORIZONTALEXTENT	     equ	0015dh
CB_SETHORIZONTALEXTENT	     equ	0015eh
CB_GETDROPPEDWIDTH	     equ	0015fh
CB_SETDROPPEDWIDTH	     equ	00160h
CB_INITSTORAGE		     equ	00161h
CB_MSGMAX		     equ	00162h

;	Listbox messages

LB_ADDSTRING		     equ	00180h
LB_INSERTSTRING 	     equ	00181h
LB_DELETESTRING 	     equ	00182h
LB_SELITEMRANGEEX	     equ	00183h
LB_RESETCONTENT 	     equ	00184h
LB_SETSEL		     equ	00185h
LB_SETCURSEL		     equ	00186h
LB_GETSEL		     equ	00187h
LB_GETCURSEL		     equ	00188h
LB_GETTEXT		     equ	00189h
LB_GETTEXTLEN		     equ	0018Ah
LB_GETCOUNT		     equ	0018Bh
LB_SELECTSTRING 	     equ	0018Ch
LB_DIR			     equ	0018Dh
LB_GETTOPINDEX		     equ	0018Eh
LB_FINDSTRING		     equ	0018Fh
LB_GETSELCOUNT		     equ	00190h
LB_GETSELITEMS		     equ	00191h
LB_SETTABSTOPS		     equ	00192h
LB_GETHORIZONTALEXTENT	     equ	00193h
LB_SETHORIZONTALEXTENT	     equ	00194h
LB_SETCOLUMNWIDTH	     equ	00195h
LB_ADDFILE		     equ	00196h
LB_SETTOPINDEX		     equ	00197h
LB_GETITEMRECT		     equ	00198h
LB_GETITEMDATA		     equ	00199h
LB_SETITEMDATA		     equ	0019Ah
LB_SELITEMRANGE 	     equ	0019Bh
LB_SETANCHORINDEX	     equ	0019Ch
LB_GETANCHORINDEX	     equ	0019Dh
LB_SETCARETINDEX	     equ	0019Eh
LB_GETCARETINDEX	     equ	0019Fh
LB_SETITEMHEIGHT	     equ	001A0h
LB_GETITEMHEIGHT	     equ	001A1h
LB_FINDSTRINGEXACT	     equ	001A2h
LB_SETLOCALE		     equ	001A5h
LB_GETLOCALE		     equ	001A6h
LB_SETCOUNT		     equ	001A7h
LB_INITSTORAGE		     equ	001A8h
LB_ITEMFROMPOINT	     equ	001A9h
LB_MSGMAX		     equ	001B0h


;	Combo Box return Values

CB_OKAY 		     equ	0
CB_ERR			     equ	-1
CB_ERRSPACE		     equ	-2

;	Combo Box Notification Codes

CBN_ERRSPACE		     equ	-1
CBN_SELCHANGE		     equ	1
CBN_DBLCLK		     equ	2
CBN_SETFOCUS		     equ	3
CBN_KILLFOCUS		     equ	4
CBN_EDITCHANGE		     equ	5
CBN_EDITUPDATE		     equ	6
CBN_DROPDOWN		     equ	7
CBN_CLOSEUP		     equ	8
CBN_SELENDOK		     equ	9
CBN_SELENDCANCEL	     equ	10

;	Listbox Return Values

LB_OKAY 		     equ	0
LB_ERR			     equ	-1
LB_ERRSPACE		     equ	-2

;	Listbox Notification Codes

LBN_ERRSPACE		     equ	-2
LBN_SELCHANGE		     equ	1
LBN_DBLCLK		     equ	2
LBN_SELCANCEL		     equ	3
LBN_SETFOCUS		     equ	4
LBN_KILLFOCUS		     equ	5

;	Scroll bar message codes

SB_LINEUP           equ		0
SB_LINELEFT         equ		0
SB_LINEDOWN         equ		1
SB_LINERIGHT        equ		1
SB_PAGEUP           equ		2
SB_PAGELEFT         equ		2
SB_PAGEDOWN         equ		3
SB_PAGERIGHT        equ		3
SB_THUMBPOSITION    equ		4
SB_THUMBTRACK       equ		5
SB_TOP              equ		6
SB_LEFT             equ		6
SB_BOTTOM           equ		7
SB_RIGHT            equ		7
SB_ENDSCROLL        equ		8

;	Scroll bar constants

SB_HORZ             equ		0
SB_VERT             equ		1
SB_CTL              equ		2
SB_BOTH             equ		3

DLL_PROCESS_ATTACH	equ	1
DLL_PROCESS_DETACH	equ	0

TRANSPARENT		equ	1
OPAQUE			equ	2

DEVICE_DEFAULT_FONT     equ     14
LF_FACESIZE             equ     32

TA_LEFT		EQU		000000000h
TA_RIGHT	EQU		000000002h
TA_CENTER	EQU		000000006h
TA_TOP		EQU		000000000h
TA_BOTTOM	EQU		000000008h
TA_BASELINE	EQU		000000018h

OUT_DEFAULT_PRECIS      equ	0
OUT_STRING_PRECIS       equ	1
OUT_CHARACTER_PRECIS    equ	2
OUT_STROKE_PRECIS       equ	3
OUT_TT_PRECIS           equ	4
OUT_DEVICE_PRECIS       equ	5
OUT_RASTER_PRECIS       equ	6
OUT_TT_ONLY_PRECIS      equ	7
OUT_OUTLINE_PRECIS      equ	8

CLIP_DEFAULT_PRECIS     equ	0
CLIP_CHARACTER_PRECIS   equ	1
CLIP_STROKE_PRECIS      equ	2
CLIP_MASK               equ	0Fh
CLIP_LH_ANGLES          equ	10h
CLIP_TT_ALWAYS          equ	20h
CLIP_EMBEDDED           equ	80h

DEFAULT_QUALITY         equ	0
DRAFT_QUALITY           equ	1
PROOF_QUALITY           equ	2
NONANTIALIASED_QUALITY  equ	3
ANTIALIASED_QUALITY     equ	4

DEFAULT_PITCH           equ	0
FIXED_PITCH             equ	1
VARIABLE_PITCH          equ	2
MONO_FONT               equ	8

ANSI_CHARSET            equ	0
DEFAULT_CHARSET         equ	1
SYMBOL_CHARSET          equ	2
SHIFTJIS_CHARSET        equ	128
HANGEUL_CHARSET         equ	129
GB2312_CHARSET          equ	134
CHINESEBIG5_CHARSET     equ	136
OEM_CHARSET             equ	255
JOHAB_CHARSET           equ	130
HEBREW_CHARSET          equ	177
ARABIC_CHARSET          equ	178
GREEK_CHARSET           equ	161
TURKISH_CHARSET         equ	162
THAI_CHARSET            equ	222
EASTEUROPE_CHARSET      equ	238
RUSSIAN_CHARSET         equ	204
MAC_CHARSET             equ	77
BALTIC_CHARSET          equ	186


LF_FACESIZE		equ	32	;max chrs in font face name
; Font Families

FF_DONTCARE         equ	00h  ; Don't care or don't know.
FF_ROMAN            equ	10h  ; Variable stroke width, serifed.
                             ; Times Roman, Century Schoolbook, etc.
FF_SWISS            equ	20h  ; Variable stroke width, sans-serifed.
                             ; Helvetica, Swiss, etc.
FF_MODERN           equ	30h  ; Constant stroke width, serifed or sans-serifed.
                             ; Pica, Elite, Courier, etc.
FF_SCRIPT           equ	40h  ; Cursive, etc.
FF_DECORATIVE       equ	50h  ; Old English, etc.

; Font Weights

FW_DONTCARE         equ	0
FW_THIN             equ	100
FW_EXTRALIGHT       equ	200
FW_LIGHT            equ	300
FW_NORMAL           equ	400
FW_MEDIUM           equ	500
FW_SEMIBOLD         equ	600
FW_BOLD             equ	700
FW_EXTRABOLD        equ	800
FW_HEAVY            equ	900
FW_ULTRALIGHT       equ	FW_EXTRALIGHT
FW_REGULAR          equ	FW_NORMAL
FW_DEMIBOLD         equ	FW_SEMIBOLD
FW_ULTRABOLD        equ	FW_EXTRABOLD
FW_BLACK            equ	FW_HEAVY

UDS_WRAP        EQU     00000001h
UDS_SETBUDDYINT EQU     00000002h
UDS_ALIGNRIGHT  EQU     00000004h
UDS_ALIGNLEFT   EQU     00000008h
UDS_AUTOBUDDY   EQU     00000010h
UDS_ARROWKEYS   EQU     00000020h
UDS_HORZ        EQU     00000040h
UDS_NOTHOUSANDS EQU     00000080h

;	Registry equates

HKEY_CLASSES_ROOT       equ 080000000h
HKEY_CURRENT_USER       equ 080000001h
HKEY_LOCAL_MACHINE      equ 080000002h
HKEY_USERS              equ 080000003h
HKEY_PERFORMANCE_DATA   equ 080000004h
HKEY_CURRENT_CONFIG     equ 080000005h
HKEY_DYN_DATA           equ 080000006h

ERROR_SUCCESS		equ	0
KEY_ALL_ACCESS		equ	2Fh
REG_OPTION_NON_VOLATILE	equ	0
REG_CREATED_NEW_KEY	equ	1
REG_OPENED_EXISTING_KEY	equ	2

;	Registry value types

REG_NONE		equ	0
REG_SZ			equ	1
REG_EXPAND_SZ		equ	2
REG_BINARY		equ	3
REG_DWORD		equ	4

;	Common dialog stuff

HELPMSGSTRINGA	equ	"commdlg_help"
HELPMSGSTRING	equ	HELPMSGSTRINGA

WH_MSGFILTER	equ	-1
MSGF_DIALOGBOX	equ	0

;	Bitmap values

BI_RGB		equ	0
BI_RLE8		equ	1
BI_RLE4		equ	2
BI_BITFIELDS	equ	3
DIB_PAL_COLORS	equ	1
DIB_RGB_COLORS	equ	0

;	Owner draw values

ODA_DRAWENTIRE	equ	1
ODA_SELECT	equ	2
ODA_FOCUS	equ	4

;	Property sheet messages and flags

PSP_DEFAULT		equ	0000h
PSP_DLGINDIRECT		equ	0001h
PSP_USEHICON		equ	0002h
PSP_USEICONID		equ	0004h
PSP_USETITLE		equ	0008h
PSP_RTLREADING		equ	0010h
PSP_HASHELP		equ	0020h
PSP_USEREFPARENT	equ	0040h
PSP_USECALLBACK		equ	0080h

PSH_DEFAULT		equ	0000h
PSH_PROPTITLE		equ	0001h
PSH_USEHICON		equ	0002h
PSH_USEICONID		equ	0004h
PSH_PROPSHEETPAGE	equ	0008h
PSH_WIZARD		equ	0020h
PSH_USEPSTARTPAGE	equ	0040h
PSH_NOAPPLYNOW		equ	0080h
PSH_USECALLBACK		equ	0100h
PSH_HASHELP		equ	0200h
PSH_MODELESS		equ	0400h
PSH_RTLREADING		equ	0800h

PSN_FIRST		EQU	0FFFFFF38h
PSN_SETACTIVE		EQU	PSN_FIRST-0
PSN_KILLACTIVE		EQU	PSN_FIRST-1
PSN_APPLY		EQU	PSN_FIRST-2
PSN_RESET		EQU	PSN_FIRST-3
PSN_HELP		EQU	PSN_FIRST-5
PSN_QUERYCANCEL		EQU	PSN_FIRST-9

DWL_MSGRESULT		EQU	0h

;	Chhose Color Common Dialog

CC_RGBINIT		equ	1
CC_FULLOPEN		equ	2

;	W95 extended window styles

WS_EX_TOOLWINDOW	equ	80h
WS_EX_WINDOWEDGE	equ	100h
WS_EX_CLIENTEDGE	equ	200h
WS_EX_CONTEXTHELP	equ	400h
WS_EX_STATICEDGE	equ	20000h

;	Polygon fill modes

ALTERNATE           equ         1
WINDING             equ         2
POLYFILL_LAST       equ         2

;	StretchBlt modes

BLACKONWHITE	equ	1
WHITEONBLACK	equ	2
COLORONCOLOR	equ	3
HALFTONE	equ	4

;	DEVMODE.dmField field selection bits

DM_ORIENTATION      equ	00000001h
DM_PAPERSIZE        equ	00000002h
DM_PAPERLENGTH      equ	00000004h
DM_PAPERWIDTH       equ	00000008h
DM_SCALE            equ	00000010h
DM_COPIES           equ	00000100h
DM_DEFAULTSOURCE    equ	00000200h
DM_PRINTQUALITY     equ	00000400h
DM_COLOR            equ	00000800h
DM_DUPLEX           equ	00001000h
DM_YRESOLUTION      equ	00002000h
DM_TTOPTION         equ	00004000h
DM_COLLATE          equ	00008000h
DM_FORMNAME         equ	00010000h
DM_LOGPIXELS        equ	00020000h
DM_BITSPERPEL       equ	00040000h
DM_PELSWIDTH        equ	00080000h
DM_PELSHEIGHT       equ	00100000h
DM_DISPLAYFLAGS     equ	00200000h
DM_DISPLAYFREQUENCY equ	00400000h
DM_ICMMETHOD	    equ	00800000h
DM_ICMINTENT	    equ	01000000h
DM_MEDIATYPE	    equ	02000000h
DM_DITHERTYPE	    equ	04000000h

;	Predefined Clipboard Formats

CF_TEXT             equ	1
CF_BITMAP           equ	2
CF_METAFILEPICT     equ	3
CF_SYLK             equ	4
CF_DIF              equ	5
CF_TIFF             equ	6
CF_OEMTEXT          equ	7
CF_DIB              equ	8
CF_PALETTE          equ	9
CF_PENDATA          equ	10
CF_RIFF             equ	11
CF_WAVE             equ	12
CF_UNICODETEXT      equ	13
CF_ENHMETAFILE      equ	14

;	Windows 4.00 added formats

CF_HDROP            equ	15
CF_LOCALE           equ	16
CF_MAX              equ	17

CF_OWNERDISPLAY     equ	0080h
CF_DSPTEXT          equ	0081h
CF_DSPBITMAP        equ	0082h
CF_DSPMETAFILEPICT  equ	0083h
CF_DSPENHMETAFILE   equ	008Eh

;	"Private" formats don't get GlobalFree()'d

CF_PRIVATEFIRST     equ	0200h
CF_PRIVATELAST      equ	02FFh

;	"GDIOBJ" formats do get DeleteObject()'d

CF_GDIOBJFIRST      equ	0300h
CF_GDIOBJLAST       equ	03FFh

;	mapping modes

MM_TEXT             equ	1
MM_LOMETRIC         equ	2
MM_HIMETRIC         equ	3
MM_LOENGLISH        equ	4
MM_HIENGLISH        equ	5
MM_TWIPS            equ	6
MM_ISOTROPIC        equ	7
MM_ANISOTROPIC      equ	8

;	Min and Max Mapping Mode values

MM_MIN              equ	MM_TEXT
MM_MAX              equ	MM_ANISOTROPIC
MM_MAX_FIXEDSCALE   equ	MM_TWIPS

;	Owner draw state

ODS_SELECTED        equ	0001h
ODS_GRAYED          equ 0002h
ODS_DISABLED        equ 0004h
ODS_CHECKED         equ 0008h
ODS_FOCUS           equ 0010h
ODS_DEFAULT         equ	0020h
ODS_COMBOBOXEDIT    equ	1000h

;	Virtual Memory

MEM_COMMIT	equ	1000h
MEM_RESERVE	equ	2000h
MEM_DECOMMIT	equ	4000h
MEM_RELEASE	equ	8000h
PAGE_NOACCESS	equ	0001h
PAGE_READWRITE	equ	0004h

;	Mouse activation

MA_ACTIVATEANDEAT	equ	2
MA_NOACTIVATEANDEAT	equ	4

;	DrawEdge constants

BF_RECT		equ	15
BF_FLAT		equ	4000h
BF_MONO		equ	8000h
BF_MIDDLE	equ	800h
BF_SOFT		equ	1000h

EDGE_SUNKEN	equ	0Ah
EDGE_RAISED	equ	5h
EDGE_ETCHED	equ	6h
EDGE_BUMP	equ	9h

;	GetDriveType results:

DRIVE_FIXED	equ	3

;	Infinite timeout:

INFINITE	equ	0FFFFFFFFh

;	Process sync & file mapping:

SYNCHRONIZE		equ	0100000h
ERROR_ALREADY_EXISTS	equ	183
STANDARD_RIGHTS_REQUIRED equ	000F0000h
FILE_MAP_ALL_ACCESS	equ	1Fh+STANDARD_RIGHTS_REQUIRED

RASTER_FONTTYPE		equ	1
TRUETYPE_FONTTYPE	equ	4
DEVICE_FONTTYPE		equ	2

STD_OUTPUT_HANDLE	equ	-11

;	DocumentProperties DEVMODE equates

DM_IN_BUFFER	equ	8
DM_IN_PROMPT	equ	4
DM_OUT_BUFFER	equ	2
DM_OUT_DEFAULT	equ	1

;	Printer Status flags

PRINTER_ATTRIBUTE_DEFAULT	equ	4

PRINTER_STATUS_PAUSED            equ	00000001h
PRINTER_STATUS_ERROR             equ	00000002h
PRINTER_STATUS_PENDING_DELETION  equ	00000004h
PRINTER_STATUS_PAPER_JAM         equ	00000008h
PRINTER_STATUS_PAPER_OUT         equ	00000010h
PRINTER_STATUS_MANUAL_FEED       equ	00000020h
PRINTER_STATUS_PAPER_PROBLEM     equ	00000040h
PRINTER_STATUS_OFFLINE           equ	00000080h
PRINTER_STATUS_IO_ACTIVE         equ	00000100h
PRINTER_STATUS_BUSY              equ	00000200h
PRINTER_STATUS_PRINTING          equ	00000400h
PRINTER_STATUS_OUTPUT_BIN_FULL   equ	00000800h
PRINTER_STATUS_NOT_AVAILABLE     equ	00001000h
PRINTER_STATUS_WAITING           equ	00002000h
PRINTER_STATUS_PROCESSING        equ	00004000h
PRINTER_STATUS_INITIALIZING      equ	00008000h
PRINTER_STATUS_WARMING_UP        equ	00010000h
PRINTER_STATUS_TONER_LOW         equ	00020000h
PRINTER_STATUS_NO_TONER          equ	00040000h
PRINTER_STATUS_PAGE_PUNT         equ	00080000h
PRINTER_STATUS_USER_INTERVENTION equ	00100000h
PRINTER_STATUS_OUT_OF_MEMORY     equ	00200000h
PRINTER_STATUS_DOOR_OPEN         equ	00400000h
PRINTER_STATUS_SERVER_UNKNOWN    equ	00800000h
PRINTER_STATUS_POWER_SAVE        equ	01000000h

SPI_GETWORKAREA		equ	48

RGN_AND		equ	1
RGN_OR		equ	2
RGN_XOR		equ	3
RGN_DIFF	equ	4
RGN_COPY	equ	5

LR_LOADFROMFILE		equ	10h
LR_LOADTRANSPARENT	equ	20h
LR_DEFAULTSIZE		equ	40h

IMAGE_BITMAP	equ	0
IMAGE_ICON	equ	1
IMAGE_CURSOR	equ	2

MOUSEEVENTF_ABSOLUTE	equ	8000h
MOUSEEVENTF_MOVE	equ	1
MOUSEEVENTF_LEFTDOWN	equ	2
MOUSEEVENTF_LEFTUP	equ	4
MOUSEEVENTF_MIDDLEDOWN	equ	20h
MOUSEEVENTF_MIDDLEUP	equ	40h
MOUSEEVENTF_RIGHTDOWN	equ	8
MOUSEEVENTF_RIGHTUP	equ	10h
MOUSEEVENTF_WHEEL	equ	800h

SHGFP_TYPE_CURRENT	equ	0
SHGFP_TYPE_DEFAULT	equ	1

CSIDL_DESKTOPDIRECTORY	equ	0010h
CSIDL_PROGRAMS		equ	0002h
CSIDL_PROGRAM_FILES	equ	0026h

SND_FILENAME		equ	00020000h
SND_ASYNC		equ	00000001h

