;	===============================================================
;	WIN32DTA.INC - Windows32 data types and structures
;	===============================================================
;	Copyright 1995 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 3-25-95
;	---------------------------------------------------------------

FARPROC		typedef		FAR PTR 
HWND		typedef		dword
HGLOBAL		typedef		dword
HFILE		typedef		dword
LPVOID		typedef		dword
LPSTR		typedef		dword
BOOL		typedef		dword

WNDCLASS	struc
style		dword	?
lpfnWndProc	dword	?
cbClsExtra	dword	?
cbWndExtra	dword	?
hInstance	dword	?
hIcon		dword	?
hCursor		dword	?
hbrBackground	dword	?
lpszMenuName	dword	?
lpszClassName	dword	?
WNDCLASS	ends

POINT		struc
x		dword	?
y		dword	?
POINT		ends

MSG		struc
hwnd		dword	?
message		dword	?
wParam		dword	?
lParam		dword	?
time		dword	?
pt		POINT	<?>
MSG		ends

; typedef struct tagRECT
; {   LONG    left;
;     LONG    top;
;     LONG    right;
;     LONG    bottom;
; } RECT, *PRECT, NEAR *NPRECT, FAR *LPRECT;

RECT		struct
left		dword	?
top		dword	?
right		dword	?
bottom		dword	?
RECT		ends

; typedef struct tagPAINTSTRUCT
; {   HDC         hdc;
;     BOOL        fErase;
;     RECT        rcPaint;
;     BOOL        fRestore;
;     BOOL        fIncUpdate;
;     BYTE        rgbReserved[32];
; } PAINTSTRUCT, *PPAINTSTRUCT, *NPPAINTSTRUCT, *LPPAINTSTRUCT;

PAINTSTRUCT	struct
hdc		dword	?
fErase		dword	?
rcPaint		RECT	<>
fRestore	dword	?
fIncUpdate	dword	?
rgbReserved	SBYTE	32 dup (?)
PAINTSTRUCT	ends

STARTUPINFO	struct
cb		dword	?
lpReserved	dword	?
lpDesktop	dword	?
lpTitle		dword	?
dwX		dword	?
dwY		dword	?
dwXSize		dword	?
dwYSize		dword	?
dwxCountChars	dword	?
dwYCountChars	dword	?
dwFillAttribute	dword	?
dwFlags		dword	?
dwShowWindow	word	?
cbReserved2	word	?
lpReserved2	dword	?
hStdInput	dword	?
hStdOutput	dword	?
hStdError	dword	?
STARTUPINFO	ends

TEXTMETRIC		struc
tmHeight		dword	?
tmAscent		dword	?
tmDescent		dword	?
tmInternalLeading	dword	?
tmExternalLeading	dword	?
tmAveCharWidth		dword	?
tmMaxCharWidth		dword	?
tmWeight		dword	?
tmOverhang		dword	?
tmDigitizedAspectX	dword	?
tmDigitizedAspectY	dword	?
tmFirstChar		SBYTE	?
tmLastChar		SBYTE	?
tmDefaultChar		SBYTE	?
tmBreakChar		SBYTE	?
tmItalic		SBYTE	?
tmUnderlined		SBYTE	?
tmStruckOut		SBYTE	?
tmPitchAndFamily	SBYTE	?
tmCharSet		SBYTE	?
TEXTMETRIC		ends

NEWTEXTMETRIC		struc
tmHeight		dword	?
tmAscent		dword	?
tmDescent		dword	?
tmInternalLeading	dword	?
tmExternalLeading	dword	?
tmAveCharWidth		dword	?
tmMaxCharWidth		dword	?
tmWeight		dword	?
tmOverhang		dword	?
tmDigitizedAspectX	dword	?
tmDigitizedAspectY	dword	?
tmFirstChar		SBYTE	?
tmLastChar		SBYTE	?
tmDefaultChar		SBYTE	?
tmBreakChar		SBYTE	?
tmItalic		SBYTE	?
tmUnderlined		SBYTE	?
tmStruckOut		SBYTE	?
tmPitchAndFamily	SBYTE	?
tmCharSet		SBYTE	?
ntmFlags		dword	?
ntmSizeEM		dword	?
ntmCellHeight		dword	?
ntmAvgWidth		dword	?
NEWTEXTMETRIC		ends

MEMORYSTATUS		struc
dwLength		dword	SIZEOF(MEMORYSTATUS)
dwMemoryLoad		dword	?
dwTotalPhys		dword	?
dwAvailPhys		dword	?
dwTotalPageFile		dword	?
dwAvailPageFile		dword	?
dwTotalVirtual		dword	?
dwAvailVirtual		dword	?
MEMORYSTATUS		ends

OPENFILENAME		struc
lStructSize		dword	0
hwndOwner		dword	0
hInstance		dword	0
lpstrFilter		dword	0
lpstrCustomFilter	dword	0
nMaxCustFilter		dword	0
nFilterIndex		dword	0
lpstrFile		dword	0
nMaxFile		dword	0
lpstrFileTitle		dword	0
nMaxFileTitle		dword	0
lpstrInitialDir		dword	0
lpstrTitle		dword	0
Flags			dword	0
nFileOffset		word	0
nFileExtension		word	0
lpstrDefExt		dword	0
lCustData		dword	0
lpfnHook		dword	0
lpTemplateName		dword	0
OPENFILENAME		ends

PRINTDLG		struc
lStructSize		dword	SIZEOF (PRINTDLG)
hwndOwner		dword	0
hDevMode		dword	0
hDevNames		dword	0
hDC			dword	0
Flags			dword	0
nFromPage		word	0
nToPage			word	0
nMinPage		word	0
nMaxPage		word	0
nCopies			word	0
hInstance		dword	0
lCustData		dword	0
lpfnPrintHook		dword	0
lpfnSetupHook		dword	0
lpPrintTemplateName	dword	0
lpSetupTemplateName	dword	0
hPrintTemplate		dword	0
hSetupTemplate		dword	0
PRINTDLG		ends

DOCINFO			struc
cbSize			dword	SIZEOF(DOCINFO)
lpszDocName		dword	0
lpszOutput		dword	NULL
DOCINFO			ends

DEVMODE			struc
dmDeviceName		db	32 dup (0)
dmSpecVersion		word	0
dmDriverVersion		word	0
dmSize			word	0
dmDriverExtra		word	0
dmFields		dword	0
dmOrientation		word	0
dmPaperSize		word	0
dmPaperLength		word	0
dmPaperWidth		word	0
dmScale			word	0
dmCopies		word	0
dmDefaultSource		word	0
dmPrintQuality		word	0
dmColor			word	0
dmDuplex		word	0
dmYResolution		word	0
dmTTOption		word	0
dmCollate		word	0
dmFormName		db	32 dup (0)
dmUnusedPadding		word	0
dmBitsPerPel		word	0
dmPelsWidth		dword	0
dmPelsHeight		dword	0
dmDisplayFlags		dword	0
dmDisplayFrequency	dword	0
DEVMODE			ends

SYSTEMTIME	struct
wYear		word	?
wMonth		word	?
wDayOfWeek	word	?
wDay		word	?
wHour		word	?
wMinute		word	?
wSecond		word	?
wMilliseconds	word	?
SYSTEMTIME	ends

FILETIME		struct
dwLowDateTime		DWORD	?
dwHighDateTime		DWORD	?
FILETIME		ends

MAX_PATH	equ	260

WIN32_FIND_DATA		struct
dwFileAttributes	DWORD	?
ftCreationTime		FILETIME	<>
ftLastAccessTime	FILETIME	<>
ftLastWriteTime		FILETIME	<>
nFileSizeHigh		DWORD	?
nFileSizeLow		DWORD	?
dwReserved0		DWORD	?
dwReserved1		DWORD	?
cFileName		SBYTE	MAX_PATH dup(?)
cAlternateFileName	SBYTE	14 dup(?)
WIN32_FIND_DATA		ends

LOGFONT		STRUCT 1t
lfHeight		DWORD		?
lfWidth			DWORD		?
lfEscapement		DWORD		?
lfOrientation		DWORD		?
lfWeight		DWORD		?
lfItalic		BYTE		?
lfUnderline		BYTE		?
lfStrikeOut		BYTE		?
lfCharSet		BYTE		?
lfOutPrecision		BYTE		?
lfClipPrecision		BYTE		?
lfQuality		BYTE		?
lfPitchAndFamily	BYTE		?
lfFaceName		SBYTE		32t DUP (?)
LOGFONT		ENDS

WINDOWPOS	STRUC
hwnd		dword	?
hwndInsertAfter	dword	?
x		dword	?
y		dword	?
countx		dword	?
county		dword	?
flags		dword	?
WINDOWPOS	ENDS

WINDOWPLACEMENT		STRUC
len			dword	sizeof(WINDOWPLACEMENT)
flags			dword	0
showCmd			dword	SW_SHOW
ptMinPosition		POINT	<>
ptMaxPosition		POINT	<>
rcNormalPosition	RECT	<>
WINDOWPLACEMENT		ENDS

_SIZE		STRUC
wid		dword	?
hgt		dword	?
_SIZE		ENDS

BITMAPFILEHEADER	STRUC
bfType			word	?
bfSize			dword	?
bfReserved1		word	?
bfReserved2		word	?
bfOffBits		dword	?
BITMAPFILEHEADER	ENDS

BITMAPINFOHEADER	STRUC
biSize			dword	?
biWidth			dword	?
biHeight		dword	?
biPlanes		word	?
biBitCount		word	?
biCompression		dword	?
biSizeImage		dword	?
biXPelsPerMeter		dword	?
biYPelsPerMeter		dword	?
biClrUsed		dword	?
biClrImportant		dword	?
BITMAPINFOHEADER	ENDS

BITMAP			STRUC
bmType			dword	?
bmWidth			dword	?
bmHeight		dword	?
bmWidthBytes		dword	?
bmPlanes		word	?
bmBitsPixel		word	?
bmBits			dword	?
BITMAP			ENDS

DRAWITEMSTRUCT		STRUC
CtlType			dword	?
CtlID			dword	?
itemID			dword	?
itemAction		dword	?
itemState		dword	?
hwndItem		dword	?
hDC			dword	?
rcItem			RECT	<>
itemData		dword	?
DRAWITEMSTRUCT		ENDS

MEASUREITEMSTRUCT	STRUC
CtlType			dword	?
CtlID			dword	?
itemID			dword	?
itemWidth		dword	?
itemHeight		dword	?
itemData		dword	?
MEASUREITEMSTRUCT	ENDS

PROPSHEETPAGE		struc
dwSize		DWORD	sizeof PROPSHEETPAGE
dwFlags		DWORD	PSP_USETITLE+PSP_USECALLBACK
hInstance	DWORD	0
pResource	DWORD	0
hIcon		DWORD	0
pszTitle	DWORD	0
pfnDlgProc	DWORD	0
lParam		DWORD	0
pfnCallback	DWORD	0
pcRefParent	DWORD	0
PROPSHEETPAGE		ends


PROPSHEETHEADER	struc
dwSize		DWORD	sizeof PROPSHEETHEADER
dwFlags		DWORD	PSH_PROPTITLE+PSH_PROPSHEETPAGE+PSH_USECALLBACK
hwndParent	DWORD	0
hInstance	DWORD	0
hIcon		DWORD	0
pszCaption	DWORD	0
nPages		DWORD	0
nStartPage	DWORD	0
ppsp		DWORD	0
pfnCallback	DWORD	0
PROPSHEETHEADER	ends

NMHDR			struc
hwndFrom	DWORD	0
idFrom		DWORD	0
code		DWORD	0
NMHDR			ends

CHOOSECOLOR	struc
lStructSize	dword	sizeof(CHOOSECOLOR)
hwndOwner	dword	0
hInstance	dword	0
rgbResult	dword	0
lpCustColors	dword	0
Flags		dword	CC_FULLOPEN
lCustData	dword	NULL
lpfnHook	dword	NULL
lpTemplateName	dword	NULL
CHOOSECOLOR	ends

CREATESTRUCT	struc
lpCreateParms	dword	0
hInstance	dword	0
hMenu		dword	0
hwndParent	dword	0
cy		dword	0
_cx		dword	0
y		dword	0
x		dword	0
style		dword	0
lpszName	dword	0
lpszClass	dword	0
dwExStyle	dword	0
CREATESTRUCT	ends

MINMAXINFO	struc
ptReserved	POINT	<>
ptMaxSize	POINT	<>
ptMaxPosition	POINT	<>
ptMinTrackSize	POINT	<>
ptMaxTrackSize	POINT	<>
MINMAXINFO	ends

METAFILEPICT	struc
_mm		dword	MM_ISOTROPIC
xExt		dword	0
yExt		dword	0
hMF		dword	0
METAFILEPICT	ends

PROCESS_INFORMATION	struc
hProcess	dword	0
hThread		dword	0
dwProcessId	dword	0
dwThreadId	dword	0
PROCESS_INFORMATION	ends

IID_IShellLink	equ	<IID_IShellLinkA>

LOGBRUSH	struc
lbStype		dword	BS_SOLID
lbColor		dword	0
lbHatch		dword	0
LOGBRUSH	ends

PRINTER_INFO_2	struc
pServerName	dword	0
pPrinterName	dword	0
pShareName	dword	0
pPortName	dword	0
pDriverName	dword	0
pComment	dword	0
pLocation	dword	0
pDevMode	dword	0
pSepFile	dword	0
pPrintProcessor	dword	0
pDatatype	dword	0
pParameters	dword	0
pSecurityDescriptor	dword	0
Attributes	dword	0
Priority	dword	0
DefaultPriority	dword	0
StartTime	dword	0
UntilTime	dword	0
Status		dword	0
cJobs		dword	0
AveragePPM	dword	0
PRINTER_INFO_2	ends

BROWSEINFO	struc
hwndOwner	dword	0
pidlRoot	dword	0
pszDisplayName	dword	0
lpszTitle	dword	0
ulFlags		dword	0
lpfn		dword	0
lParam		dword	0
iImage		dword	0
BROWSEINFO	ends

NONCLIENTMETRICS	struc
cbSize				dword	sizeof(NONCLIENTMETRICS)
iBorderWidth		dword	?
iScrollWidth		dword	?
iScrollHeight		dword	?
iCaptionWidth		dword	?
iCaptionHeight		dword	?
lfCaptionFont		LOGFONT <>
iSmCaptionWidth		dword	?
iSmCaptionHeight	dword	?
lfSmCaptionFont		LOGFONT <>
iMenuWidth			dword	?
iMenuHeight			dword	?
lfMenuFont			LOGFONT <>
lfStatusFont		LOGFONT <>
lfMessageFont		LOGFONT <>
NONCLIENTMETRICS	ends

