// 	===============================================================
// 	TStyles.h - Text Styles Infoblock Structure
// 	===============================================================
// 	Copyright 2000 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 4-Feb-2000
// 	===============================================================
//  Converted to C-Style 20-Feb-2000
//

#ifndef _TSTYLES_H_
#define _TSTYLES_H_

// 	Text style flags (TFlags byte):

#define TS_VERT 			1		// Vertical text flag
#define TS_ANGFIXED			8		// fixed angle (no rotate)
#define TS_BOLD 			16		// Bold text
#define TS_ITALIC			32		// Italic text
#define TS_UNDER			64		// Underscore text
#define TS_STRIKE			128		// Strikeout text
#define TS_OUTLINE			4		// outline-only text

// 	Text data flags (DFlags byte):

#define TD_FILE				1		// data is file name string
#define TD_METRICS			0x80	// use new text metrics

// 	Old V6 TFlags (word):

#define TSO_VERT 			1		// Vertical text flag
#define TSO_BOLD 			16		// Bold text
#define TSO_ITALIC 			32		// Italic text
#define TSO_UNDER			64		// Underscore text
#define TSO_STRIKE			128		// Strikeout text
#define TSO_OUTLINE			256		// outline-only text
#define TSO_METRICS			0x8000	// use new text metrics
#define TSO_ANGFIXED		512		// text angle doesn't transform

// 	Text justification codes (Just byte) as illustrated below

#define TJ_BL			0	// bottom left
#define TJ_BC			1	// bottom center
#define TJ_BR			2	// bottom right
#define TJ_ML			3	// mid left
#define TJ_MC			4	// mid center
#define TJ_MR			5	// mid right
#define TJ_TL			6	// top left
#define TJ_TC			7	// top center
#define TJ_TR			8	// top right
#define TJ_XML			9	// extended mid left
#define TJ_XMR			10	// extended mid right
#define TJ_XXBL			11	// extended bottom extended left
#define TJ_XBL			12	// extended bottom left
#define TJ_XBC			13	// extended bottom center
#define TJ_XBR			14	// extended bottom right
#define TJ_XXBR			15	// extended bottom extended right
#define TJ_XXTL			16	// extended top extended left
#define TJ_XTL			17	// extended top left
#define TJ_XTC			18	// extended top center
#define TJ_XTR			19	// extended top right
#define TJ_XXTR			20	// extended top extended right

//  	   16---17----------18----------19---20
// 	      |    |	         |           |    |
// 	      |    6-----------7-----------8    |
// 	      |    |           |           |    |
// 	      |    |           |           |    |
// 	      9----3-----------4-----------5---10
// 	      |    |           |           |    |
// 	      |    |           |           |    |
// 	      |    0-----------1-----------2    |
// 	      |    |           |           |    |
// 	     11---12----------13----------14---15

// 	===============================================================
// 	Text style structure in entity:
// 	===============================================================

typedef struct
{
	WORD	id;			// style id (0=use local values)
	float	Hgt;		// text height
	float	Stretch;	// text cell horiz stretch
	float	BAng;		// text baseline angle
	float	LSpace;		// inter-line spacing
	WORD	Font;    	// text font id #
	char	TFlags;  	// style flags
	char	DFlags;  	// data handling flags
	char	Just;    	// text justification code
}TSTY;


// 	===============================================================
// 	Structure record in TSTYLE Infoblock:
// 	===============================================================

typedef struct
{
	DWORD	RLen;				// this record length
	TSTY	TS;					// text style data
	char	SName[1];		// text style name text
}TSTYLE;

// 	===============================================================
// 	TStyle Infoblock record:
// 	===============================================================

#define IB_TSTYLE			 10
#define IB_TSTYLE_VER		0

typedef struct
{
	DWORD		ERLen;		
	char		EType;		
	char		IType;					// type of infoblock
	char		Ver;						// IB version number
	WORD		NextId;					// next free id # for new TStyle
	WORD		CurTStyleId;		// id # of current TStyle
	DWORD		CurTStyle;			// offset of CurTStyleId's TStyle struc
}TSTYLEIB;

// 	===============================================================

// 	There are 1 or more TStyle structures after CurTStyle,
// 	followed by a dword=0 end marker (included in length).

void _stdcall ListTStyle(DWORD pTSty);
void _stdcall TSpecDialog(TSTY *pTSty, DWORD TMode);

//	If pTSty = NULL then the current text style is edited

#define TMODE_NORM	  0	// normal settings dialog
#define TMODE_CHANGE	1	// CHANGE command edit
#define TMODE_EDIT	  2	// EDIT command edit


#endif