;	===============================================================
;	TStyles.CPY - Text Styles Infoblock Structure
;	===============================================================
;	Copyright 2000 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 4-Feb-2000
;	===============================================================

TSpecDialog	proto	stdcall,pTSty:dword,TMode:dword
ListTStyle	proto	stdcall,pTSty:dword

;	If pTSty = NULL then the current text style is edited

TMODE_NORM	equ	0	;normal settings dialog
TMODE_CHANGE	equ	1	;CHANGE command edit
TMODE_EDIT	equ	2	;EDIT command edit

;	Text style flags (TFlags byte):

TS_VERT 	equ	1	;Vertical text flag
TS_OUTLINE	equ	4	;outline-only text
TS_ANGFIXED	equ	8	;fixed angle (no rotate)
TS_BOLD 	equ	16	;Bold text
TS_ITALIC 	equ	32	;Italic text
TS_UNDER	equ	64	;Underscore text
TS_STRIKE	equ	128	;Strikeout text

;	Text data flags (DFlags byte):

TD_FILE		equ	1	;data is file name string
TD_HOTUPD	equ	40h	;style is auto-update
TD_METRICS	equ	80h	;use new text metrics

;	Old V6 TFlags (word):

TSO_VERT 	equ	1	;Vertical text flag
TSO_BOLD 	equ	16	;Bold text
TSO_ITALIC 	equ	32	;Italic text
TSO_UNDER	equ	64	;Underscore text
TSO_STRIKE	equ	128	;Strikeout text
TSO_OUTLINE	equ	256	;outline-only text
TSO_METRICS	equ	8000h	;use new text metrics
TSO_ANGFIXED	equ	512	;text angle doesn't transform

;	Text justification codes (Just byte) as illustrated below

TJ_BL		equ	0	;bottom left
TJ_BC		equ	1	;bottom center
TJ_BR		equ	2	;bottom right
TJ_ML		equ	3	;mid left
TJ_MC		equ	4	;mid center
TJ_MR		equ	5	;mid right
TJ_TL		equ	6	;top left
TJ_TC		equ	7	;top center
TJ_TR		equ	8	;top right
TJ_XML		equ	9	;extended mid left
TJ_XMR		equ	10	;extended mid right
TJ_XXBL		equ	11	;extended bottom extended left
TJ_XBL		equ	12	;extended bottom left
TJ_XBC		equ	13	;extended bottom center
TJ_XBR		equ	14	;extended bottom right
TJ_XXBR		equ	15	;extended bottom extended right
TJ_XXTL		equ	16	;extended top extended left
TJ_XTL		equ	17	;extended top left
TJ_XTC		equ	18	;extended top center
TJ_XTR		equ	19	;extended top right
TJ_XXTR		equ	20	;extended top extended right

; 	     16---17----------18----------19---20
;	      |    |	       |	   |	|
; 	      |    6-----------7-----------8	|
;	      |    |	       |	   |	|
;	      |    |	       |	   |	|
;	      9----3-----------4-----------5---10
;	      |    |	       |	   |	|
;	      |    |	       |	   |	|
;	      |    0-----------1-----------2	|
;	      |    |	       |	   |	|
;	     11---12----------13----------14---15

;	===============================================================
;	Text style structure in entity:
;	===============================================================

TSty		struc
id		word	0		;style id (0=use local values)
Hgt		real4	1.0		;text height
Stretch		real4	1.0		;text cell horiz stretch
BAng		real4	0.0		;text baseline angle
LSpace	 	real4	150.0		;inter-line spacing
Font    	word	0               ;text font id #
TFlags  	db	0               ;style flags
DFlags  	db	TD_METRICS      ;data handling flags
Just    	db	0               ;text justification code
TSty		ends

;	===============================================================
;	Structure record in TSTYLE Infoblock:
;	===============================================================

TStyle		struc
rlen		dword	sizeof(TStyle)	;this record length
TS		TSty	<>		;text style data
SName		db	0		;text style name text
TStyle		ends

;	===============================================================
;	TStyle Infoblock record:
;	===============================================================

IB_TSTYLE	equ	10
IB_TSTYLE_VER	equ	0

TStyleIB		struc
ERLen		dword	sizeof(TStyleIB)
EType		db	ET_IB
IType		db	IB_TSTYLE	;type of infoblock
Ver		db	IB_TSTYLE_VER	;IB version number
NextId		word	2		;next free id # for new TStyle
CurTStyleId	word	0		;id # of current TStyle
CurTStyle	dword	0		;offset of CurTStyleId's TStyle struc
TStyleIB	ends

;	There are 1 or more TStyle structures after CurTStyle,
;	followed by a dword=0 end marker (included in length).

