;	===============================================================
;	TOOLS.CPY - General-use macro definitions
;	===============================================================
;
;	Copyright 1995 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 4-26-95
;
;	---------------------------------------------------------------

pushq		macro	a
		push	dword ptr a+4
		push	dword ptr a
		endm

popq		macro	a
		pop	dword ptr a
		pop	dword ptr a+4
		endm

MOVEB		macro	d,s
		mov	al,s
		mov	d,al
		endm

MOVEW		macro	d,s
		mov	ax,s
		mov	d,ax
		endm

MOVEWB		macro	d,s
		mov	al,s
		and	ax,0FFh
		mov	d,ax
		endm

MOVEBW		macro	d,s
		mov	ax,s
		mov	d,al
		endm

MOVED		macro	d,s
		mov	eax,s
		mov	d,eax
		endm

MOVEDW		macro	d,s
		movzx	eax,s
		mov	d,eax
		endm

MOVEWD		macro	d,s
		mov	eax,s
		mov	d,ax
		endm

SWAPD		macro	a,b
		mov	eax,b
		xchg	eax,a
		mov	b,eax
		endm

CASEOF		macro	m,lbl
		cmp	eax,m
		jz	lbl
		endm

;	---------------------------------------------------------------
;	CALLNZ - Call the function at fnP if fnP!=0
;	---------------------------------------------------------------

CALLNZ	macro	fnP
	local	NoCall
	cmp	fnP,0
	jz	NoCall
	call	fnP
NoCall:	
	endm

;	---------------------------------------------------------------
;	DJNZ - jump if dword not zero
;	---------------------------------------------------------------

DJNZ	macro	var,lbl
	cmp	dword ptr var,0
	jnz	lbl
	endm

;	---------------------------------------------------------------
;	DJZ - jump if dword zero
;	---------------------------------------------------------------

DJZ	macro	var,lbl
	cmp	dword ptr var,0
	jz	lbl
	endm

;	---------------------------------------------------------------
;	STRLEN - Macro to return the length of a string (w/ 0 byte)
;	---------------------------------------------------------------
;	Entry:
;		edi -> Desired String
;	Exit:
;		ecx = length (including terminating 0)
;		edi -> next byte after terminating 0
;		Only al,edi and ecx are modified
;	---------------------------------------------------------------

STRLEN		Macro
		cld			;set forward scan
		xor	al,al		;we're looking for a ZERO
		mov	ecx,-1		;start with max string
		repne	scasb
		not	ecx		;convert to a positive count
		endm
