// 	================================================================
// 	TFORM.CPY - Transform Matrix Definitions
// 	================================================================
// 	Copyright (C) 1988-1999 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 2/6/88
// 	================================================================
// 	The 2D Transform matrix is fit inside the general 3D matrix:
// 
// 	M11 | M12 |  xx |  0		Note that no 2D transforms
// 	----|-----|-----|----		will change column 4 values.
// 	M21 | M22 |  xx |  0		The transform routines take
// 	----|-----|-----|----		advantage of this.
// 	 xx |  xx |  xx | xx
// 	----|-----|-----|----
// 	M41 | M42 |  xx |  1
// 
// 	symbols only need to store the 1st 3 columns as the
// 	4th column will always be [ 0 0 0 1] in a symbol.
// 	================================================================
//  Converted to C-Style 20-Feb-2000
//

#ifndef _TFORM_H_
#define _TFORM_H_

struct TMat
{
	double m11;
	double m21;
	double m31;
	double m41;
	double m12;
	double m22;
	double m32;
	double m42;
	double m13;
	double m23;
	double m33;
	double m43;
	double m14;
	double m24;
	double m34;
	double m44;
};

struct SymTMat	// SYMBOL TMat (last always [0 0 0 1])
{
	double m11;
	double m21;
	double m31;
	double m41;
	double m12;
	double m22;
	double m32;
	double m42;
	double m13;
	double m23;
	double m33;
	double m43;
};

typedef struct
{
	double	ScaleX;				// scale x by factor
	double	ScaleY;				// scale y by factor (negative if mirrored)
	double	ScaleZ;		
	double	ShearYX;				// shear y to vector ShearYX,ShearYY
	double	ShearYY;		
	double	ShearYZ;		
	double	RotXY;				// rotate planes
	double	RotYZ;		
	double	RotZX;		
	double	DeltaX;				// move by DeltaX, DeltaY
	double	DeltaY;		
	double	DeltaZ;		
}TSPEC3;

void XPCALL CTMI2(void);
void XPCALL CTMR2(double Ang);
void XPCALL PRER2(double Ang);
void XPCALL CTMS2(double XScale, double YScale);
void XPCALL PRES2(double XScale, double YScale);
void XPCALL CTMT2(double XTran, double YTran);
void XPCALL PRET2(double XTran, double YTran);
void XPCALL CTMT2S();
void XPCALL PREMUL2(TMat *pTM);
void XPCALL CTMMUL2(TMat *pTM);
void XPCALL MATTRN2(DWORD pSrc, DWORD pDest);
void XPCALL MATINV2(DWORD pSrc, DWORD pDest);
void XPCALL TRNP2(GPNT2 *pPt2);
void XPCALL TRNSP2(void);
void XPCALL TRNP2M(DWORD pPt2, TMat *pTM);
void XPCALL TRNSP2M(TMat *pTM);
void XPCALL TRNBA2(double Ang);

void XPCALL CTMPSH(void);
void XPCALL CTMPOP(void);
void XPCALL LDCTM(TMat *pTM);
void XPCALL STCTM(TMat *pTM);
void XPCALL LDSymTM(TMat *pTM);
void XPCALL STSymTM(TMat *pTM);
void XPCALL UseSymTM(TMat *pTM);
void XPCALL UseSymTM3(TMat *pTM, DWORD pOrgP3);
void XPCALL EndSymTM(void);

void XPCALL MATMUL3(DWORD pMA, DWORD pMB, DWORD pMC);
void XPCALL TRNSP3(void);
void XPCALL TRNSP3M(TMat *pTM);
void XPCALL TRNP3(GPNT3 *pPt3);
void XPCALL TRNP3M(DWORD pPt3, TMat *pTM);
void XPCALL CTMI3();
void XPCALL CTMRXY(double Ang);
void XPCALL PRERXY(double Ang);
void XPCALL CTMRYZ(double Ang);
void XPCALL PRERYZ(double Ang);
void XPCALL CTMRZX(double Ang);
void XPCALL PRERZX(double Ang);
void XPCALL CTMT3(double x, double y, double z);
void XPCALL PRET3(double X, double Y, double Z);
void XPCALL CTMS3(double X, double Y, double Z);
void XPCALL PRES3(double X, double Y, double Z);

void XPCALL CTMRXYS(void);
void XPCALL CTMRYZS(void);
void XPCALL CTMRZXS(void);
void XPCALL CTMT3S(void);
void XPCALL CTMS3S(void);
void XPCALL PRET3S(void);
void XPCALL PRES3S(void);
void XPCALL PREOA3(void);
void XPCALL NPONL3(GLINE3 *pLine3, GPNT3 *pNear3, GPNT3 *pOn3);

void XPCALL CTMMUL3(TMat *pTM);
void XPCALL PREMUL3(TMat *pTM);
void XPCALL TrnSymTM(SymTMat *pSymTM);
void XPCALL TrnSymTMM(SymTMat *pSymTM, TMat *pTM);
void XPCALL CALOA3(void);
void XPCALL CALOA3P(void);
TSPEC3 *XPCALL CTMSpec3(void);

BOOL XPCALL AskNUTran(TMat *pTM);
BOOL XPCALL AskMirTran(TMat *pTM);
int XPCALL ViewCalc(HANDLE hDWin, GPNT3* pFrom, GPNT3* pTo, GPNT3* pUp, double* Value, int* Wid, int* Hgt);
void _stdcall OA2DV3(double RXY, double RYZ, double RZX, DWORD pDV3);

#endif
