;	================================================================
;	TFORM.CPY - Transform Matrix Definitions
;	================================================================
;	Copyright (C) 1988-1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 2/6/88
;	================================================================
;	The 2D Transform matrix is fit inside the general 3D matrix:
;
;	M11 | M12 |  xx |  0		Note that no 2D transforms
;	----|-----|-----|----		will change column 4 values.
;	M21 | M22 |  xx |  0		The transform routines take
;	----|-----|-----|----		advantage of this.
;	 xx |  xx |  xx | xx
;	----|-----|-----|----
;	M41 | M42 |  xx |  1
;
;	symbols only need to store the 1st 3 columns as the
;	4th column will always be [ 0 0 0 1] in a symbol.
;	================================================================

MatSiz	equ	128		;matrix size in bytes
PMatSiz	equ	96		;4 rows x 3 columns partial size
SYMDEEP	equ	64		;max # nested TMs

TMat	STRUC			;identity matrix is default
m11	real8	1.0		;first column
m21	real8	0.0
m31	real8	0.0
m41	real8	0.0
m12	real8	0.0		;second column
m22	real8	1.0
m32	real8	0.0
m42	real8	0.0
m13	real8	0.0		;third column
m23	real8	0.0
m33	real8	1.0
m43	real8	0.0
m14	real8	0.0		;fourth column
m24	real8	0.0
m34	real8	0.0
m44	real8	1.0
TMat	ends
;
SymTMat	STRUC			;SYMBOL TMat (last always [0 0 0 1])
m11	real8	1.0		;first column
m21	real8	0.0
m31	real8	0.0
m41	real8	0.0
m12	real8	0.0		;second column
m22	real8	1.0
m32	real8	0.0
m42	real8	0.0
m13	real8	0.0		;third column
m23	real8	0.0
m33	real8	1.0
m43	real8	0.0
SymTMat	ends

TSpec3	STRUC
ScaleX	real8	0.0		;scale x by factor
ScaleY	real8	0.0		;scale y by factor (negative if mirrored)
ScaleZ	real8	0.0
ShearYX real8	0.0		;shear y to vector ShearYX,ShearYY
ShearYY real8	0.0
ShearYZ	real8	0.0
RotXY	real8	0.0		;rotate planes
RotYZ	real8	0.0
RotZX	real8	0.0
DeltaX	real8	0.0		;move by DeltaX, DeltaY
DeltaY	real8	0.0
DeltaZ	real8	0.0
TSpec3	ENDS

;	================================================================

CTMI2	proto	stdcall
CTMR2	proto	stdcall,Ang:real8
PRER2	proto	stdcall,Ang:real8
CTMS2	proto	stdcall,XScale:real8,YScale:real8
PRES2	proto	stdcall,XScale:real8,YScale:real8
CTMT2	proto	stdcall,XTran:real8,YTran:real8
PRET2	proto	stdcall,XTran:real8,YTran:real8
CTMT2S	proto	stdcall
PREMUL2	proto	stdcall,pTM:dword
CTMMUL2	proto	stdcall,pTM:dword
MATTRN2 proto	stdcall,pSrc:dword,pDest:dword
MATINV2 proto	stdcall,pSrc:dword,pDest:dword
TRNP2	proto	stdcall,pPt2:dword
TRNSP2	proto	stdcall
TRNP2M	proto	stdcall,pPt2:dword,pTM:dword
TRNSP2M	proto	stdcall,pTM:dword
TRNBA2	proto	stdcall,Ang:real8

CTMPSH		proto	stdcall
CTMPOP		proto	stdcall
LDCTM		proto	stdcall,pTM:dword
STCTM		proto	stdcall,pTM:dword
LDSymTM		proto	stdcall,pTM:dword
STSymTM		proto	stdcall,pTM:dword
UseSymTM	proto	stdcall,pTM:dword
UseSymTM3	proto	stdcall,pTM:dword,pOrgP3:dword
EndSymTM	proto	stdcall

MATMUL3		proto	stdcall,pMA:dword,pMB:dword,pMC:dword
TRNSP3		proto	stdcall
TRNSP3M		proto	stdcall,pTM:dword
TRNP3		proto	stdcall,pPt3:dword
TRNP3M		proto	stdcall,pPt3:dword,pTM:dword
CTMI3		proto	stdcall
CTMRXY		proto	stdcall,Ang:real8
PRERXY		proto	stdcall,Ang:real8
CTMRYZ		proto	stdcall,Ang:real8
PRERYZ		proto	stdcall,Ang:real8
CTMRZX		proto	stdcall,Ang:real8
PRERZX		proto	stdcall,Ang:real8
CTMT3		proto	stdcall,X:real8,Y:real8,Z:real8
PRET3		proto	stdcall,X:real8,Y:real8,Z:real8
CTMS3		proto	stdcall,X:real8,Y:real8,Z:real8
PRES3		proto	stdcall,X:real8,Y:real8,Z:real8

CTMRXYS		proto	stdcall
CTMRYZS		proto	stdcall
CTMRZXS		proto	stdcall
PRERXYS		proto	stdcall
PRERYZS		proto	stdcall
PRERZXS		proto	stdcall
CTMT3S		proto	stdcall
CTMS3S		proto	stdcall
PRET3S		proto	stdcall
PRES3S		proto	stdcall
PREOA3		proto	stdcall
NPONL3		proto	stdcall,pLine3:dword,pNear3:dword,pOn3:dword

CTMMUL3		proto	stdcall,pTM:dword
PREMUL3		proto	stdcall,pTM:dword
TrnSymTM	proto	stdcall,pSymTM:dword
TrnSymTMM	proto	stdcall,pSymTM:dword,pTM:dword
CALOA3		proto	stdcall
CALOA3P		proto	stdcall
CTMSpec3	proto	stdcall
OA2DV3		proto	stdcall,RXY:real8,RYZ:real8,RZX:real8,pDV3:dword

AskNUTran	proto	stdcall,pTM:dword
AskMirTran	proto	stdcall,pTM:dword
