;	===============================================================
;	STOOLS.CPY - Screen Tools Support
;	===============================================================
;	Copyright 2000 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 25-March-2000
;	===============================================================

;	Screen tools are all derived from the CtrlObj.cpy
;	general control structure. An XP that supports a custom
;	screen tool must initialize the following structure
;	and register it when the DLL is loaded with XPRegTool.

XPRegTool	proto	stdcall,pSTool:dword

EnumSTools	proto	stdcall,pCallback:dword
;Callback	proto	stdcall,hCtrl:dword

InsSymInst	proto	stdcall,pName:dword
InsSymInstEx	proto	stdcall,hDLSrc:dword,pSDef:dword
AbortToLiveCmd	proto	stdcall

ScrnTool	struc
fwd		dword	0		;link list for XPMgr use
back		dword	0
pKeyname	dword	0		;adrs of ctrlname KEYWORD (in .CFG)
pToolName	dword	0		;tool name stg (for Add dialog)
pReadCfg	dword	0		;adrs of proc that reads .CFG data
pWriteCfg	dword	0		;adrs of proc that write .CFG data
pAddCtl		dword	0		;adrs of proc to create a new instance
CFlags		dword	0		;class flags
;
CType		dword	0		;Control Type ID
ScrnTool	ends

;	Valid values for class flags are:

ST_MAIN		equ	1		;tool is a main screen control
ST_SUB		equ	2		;tool belongs in a container ctrl

;	Tools must support the following functions minimum:

STDelete	equ	0		;delete the control
STUpdate	equ	1		;update ctrl to screen
STResize	equ	2		;move/resize the control
STDraw		equ	3		;draw the control to BkImage
STMouse		equ	4		;process mouse event

;	===============================================================
;	ReadCfg scan helper tool routines
;	===============================================================

ScanCfgDirection proto	stdcall,ppScan:dword,pDirValue:dword
ScanCfgVisibility proto	stdcall,ppScan:dword,pVisValue:dword
ScanCfgWidth	proto	stdcall,ppScan:dword,pValue:dword
ScanCfgName	proto	stdcall,ppScan:dword,pName:dword
ScanCfgEOL	proto	stdcall,ppScan:dword
ScanCfgEMark	proto	stdcall,ppScan:dword

;	===============================================================
;	WriteCfg helper tool routines
;	===============================================================

WrCfgDirection	proto	stdcall,hBfr:dword,hCtrl:dword
WrCfgVisibility	proto	stdcall,hBfr:dword,hCtrl:dword
WrCfgWidth	proto	stdcall,hBfr:dword,hCtrl:dword
WrCfgInteger	proto	stdcall,hBfr:dword,IVal:dword
WrCfgCName	proto	stdcall,hBfr:dword,hCtrl:dword
WrCfgStg	proto	stdcall,hBfr:dword,pStg:dword
WrCfgEOL	proto	stdcall,hBfr:dword
WrCfgEMark	proto	stdcall,hBfr:dword
