;	===============================================================
;	SBar.CPY - Scroll Bar Control Object
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 28-October-1999
;	===============================================================

CreateSBar	proto	stdcall,pOwnerRect:dword,\
			pBkImage:dword,TakeFlags:dword,\
			pCallback:dword,pCBParm:dword

CreateHSBar	proto	stdcall,pOwnerRect:dword,\
			pBkImage:dword,TakeFlags:dword,\
			pCallback:dword,pCBParm:dword

CreateVSBar	proto	stdcall,pOwnerRect:dword,\
			pBkImage:dword,TakeFlags:dword,\
			pCallback:dword,pCBParm:dword

SBCtl		struc
pVTbl		dword	0
take		dword	0
SBRect		RECT	<>	;entire SBCtrl rectangle
MaxPos		dword	0	;largest scroll position value
CurPos		dword	0	;current item position value (0..MaxPos)
PgItems		dword	0	;# items on one page (page scroll by this-1)
flags		dword	0
;
hBI		dword	0	;BkImage to use for display
pCBack		dword	0	;notification callback adrs
pCBParm		dword	0	;callback parameter
TBHgt		dword	0	;thumb button height

SBWidth		dword	16	;system specs
SBAHgt		dword	16
SBTHgt		dword	16
;
IsVert		dword	0	;1=vertical, 0=horizontal
BRect0		RECT	<>	;top button rect (lowest posn value)
BRect1		RECT	<>	;bottom button rect (highest posn value)
SRect		RECT	<>	;scroll region rect (thumb moves through)
TRect		RECT	<>	;thumb button rect at current position
;
TCode		dword	0	;tracking status
OldMGF		dword	0	;prior mouse grab function
OldMGP		dword	0	;prior mouse grab parm
TOfst		dword	0	;thumb track topY-DigY at l.b. down
SBCtl		ends

;	values for SBCtl.TCode:

SB_NoTrack	equ	0
SB_Track0	equ	1	;tracking top button down
SB_Track1	equ	2	;tracking bottom button down
SB_TrackT	equ	3	;tracking thumb movement
SB_TrackP0	equ	4	;tracking in page up area
SB_TrackP1	equ	5	;tracking in page down area
SB_Start	equ	-1	;start (left-button click)

;	===============================================================

SBDestroy	equ	0	;COBJ SBDestroy,hSBar
SBUpdate	equ	1	;COBJ SBUpdate,hSBar
SBResize	equ	2	;COBJ SBResize,hSBar,pOwnerRect
SBMouse		equ	3	;COBJ SBMouse,iMsg,DigX,DigY
SBSetMax	equ	4	;COBJ SBSetMax,hSBar,nMax,nPgItms
SBSetPos	equ	5	;COBJ SBSetPos,hSBar,nPos
SBGetPos	equ	6	;COBJ SBGetPos,hSBar

;	===============================================================

;	The callback function has this prototype
;	and is called whenever the SB position changes:

SBCallback	proto	stdcall,hSBar:dword,nPos:dword,\
			iMsg:dword,pCBParm:dword

;	The nBtn value is one of the SBCtl.TCode values listed above
;	or the following during thumb motion:

SB_TMove	equ	6	;thumb still down tracking

;	===============================================================
