// 	===============================================================
// 	REGMGR.CPY - Registry Manager
// 	===============================================================
// 	Copyright 1999 Michael Riddle
// 	All rights reserved
// 	Written by Mike Riddle 1-7-1999
// 	===============================================================

#ifndef _REGMGR_H_
#define _REGMGR_H_

typedef struct
{
	void *hkey;		
	void *kname;		// address of key name string/rscid
	void *vname;		// address of value name string/rscid
	void *vbfr;			// adrs of value data bfr
	DWORD	vbfrmax;	// max chrs in vbfr
	DWORD	vtype;		// data type code
	DWORD	vbsize;		// actual data size returned
	DWORD	vbres;		// create/open key result code
}REGKEY;

void _stdcall RMGetValue(REGKEY *pRPkt);
void _stdcall RMSetValue(REGKEY *pRPkt);
void _stdcall RMDelValue(REGKEY *pRPkt);
void _stdcall RMKeyExists(DWORD hMain, DWORD pKey);
void _stdcall DelRegKey(DWORD hKey, DWORD pKName);

// 	Two registry "gotcha's" to watch out for:

// 	1) RMGetValue can change the data type code in a REGKEY packet,
// 	so you should have separate packets for loading and saving, and

// 	2) string data in Windows/NT is first loaded to your destination
// 	in Unicode, and then converted in place. This means that you
// 	MUST leave 2x the # characters space for all string data!

#endif