////////////////// RDATA.H - RDATA Packets - FastCAD-7 ///////////////////
//
//	Written by Mike Riddle 4-Nov-1999
//	(C)1999 Evolution Computing
//	All rights reserved
//
//////////////////////////////////////////////////////////////////////////

#ifndef _RDATA_H_
#define _RDATA_H_

void _stdcall ReceiveClear(void);					// clear key input bfr
void _stdcall ReceiveBad(void);
void _stdcall ClearSelect(void);					// clear select unhilite
void _stdcall PostSelect(void);						// clear+delay->sel
void _stdcall DiscardReq(void);						// discard current request
void _stdcall ReqHelpFile(DWORD pFile);		// spec help file for next DRQ

typedef void (_stdcall *PRCVPROC)(int Result);

void _stdcall	ReqData(
		int dType,		// desired data type code RD_XXXX
		void* pData,		// address of store data
		char* pPrompt,		// adrs of prompt string/pkt
		void* CsrId,		// cursor type/dyncsr proc adrs
		PRCVPROC pRcvProc,	// receive data callback
		int flags,		// options flags
		int help);		// help id code

void _stdcall	ReqDataX(
		int dType,		// desired data type code RD_XXXX
		void* pData,		// address of store data
		char* pPrompt,		// adrs of prompt string/pkt
		void* CsrId,		// cursor type/dyncsr proc adrs
		PRCVPROC pRcvProc,	// receive data callback
		int flags,		// options flags
		int help,		// help id code
		GLINE3 *pGLine3); // on 3d GLine


typedef struct
{
	DWORD	fwd;			// DRQ linked list
	DWORD	back;		
	DWORD	dType;		// RD_xxx data type
	DWORD	pData;		// data store address (0=don't)
	DWORD	pPrmp;		// prompt text FormSt packet adrs
	DWORD	pCsrProc;	// cursor id/procedure to use
	DWORD	pRcvProc;	// proc to call when data rdy
	DWORD	flags;		// RDF_xxx flags
	DWORD	nHelp;		// Help subject/context id
	DWORD	pHelpF;		// help file name

	GPNT3	PriorP;		// @ point at start of request
	GPNT3	OrgP;			// cursor origin at SOR
	GWIN3	XData;		// multi-pass extra data
	char	CDPrmp;		// room for ^D prompt
}RDATA;

//////////////////////////////////////////////////////////////////////////

//  Data type codes for dType:

#define RD_Word			0	// text string term (normal delimiters)
#define RD_Line			1	// line of text (return ends)
#define RD_Char			2	// single character string (2 bytes!)
#define	RD_DWin			3	// Pick a drawing window
#define	RD_RWin			4	// 3d real window

#define RD_2dC8			5	// 2d coordinate (double)
#define RD_2dC4			6	// 2d coordinate (float)
#define RD_3dC8			7	// 3d coordinate (double)
#define RD_3dC4			8	// 3d coordinate (float)
#define RD_Dist8		9	// real drawing distance (double)
#define RD_Dist4	 10	// real drawing distance (float)
#define RD_Brng8	 11	// bearing angle in radians, 0 right, ccw+
#define RD_Brng4	 12	// bearing angle in radians, 0 right, ccw+
#define RD_AngW8	 13	// Angle width in radians, ccw+
#define RD_AngW4	 14	// Angle width in radians, ccw+
#define RD_Real8	 15	// real non-distance value (double)
#define RD_Real4	 16	// real non-distance value (float)
#define RD_Int1		 17	// signed byte number
#define RD_Int2		 18	// signed word number
#define RD_Int4		 19	// signed dword number
#define	RD_MWC		 20	// main window integer coordinate
#define RD_Color	 21	// dword color value
#define	RD_Pick		 22	// select multiple entities
#define	RD_Pick1	 23	// pick single entity for modify
#define	RD_PickRef 24	// pick single entity for reference

#define	RD_Layer	 25	// get a layer id (dword)
#define	RD_FStyle	 26	// get a fill style id (dword)
#define	RD_LStyle	 27	// get a line style id (dword)
#define	RD_Font		 28	// get a font id (dword)
#define RD_TStyle	 29	// get a TStyle id (dword)
#define RD_DStyle	 30	// get a DStyle id (dword)
#define RD_Sheet	 31	// get dword ptr to Sheet by name
#define RD_Matrl	 32	// get a Material id (dword)
#define RD_PThick	 33	// get a pen thickness (real4)
#define RD_Color2	 34	// get fill color (dword)
#define RD_LWidth	 35	// get line width (real4)
#define RD_PickRO	 36	// pick multiple - read/only allowed
#define RD_WPlane	 37	// get workplane id (dword)

// Flag values for flags:

#define RDF_NONE		 0	// no flags
#define	RDF_PPKT		 1	// prompt text is a packet (norm = adrs/rsc)
#define RDF_ORTHO		 2	// ortho lock allowed
#define RDF_NOSNAP	 4	// no ortho or snap
#define	RDF_NOPRIOR	 8	// don't set this as @ prior point
#define	RDF_NODEPTH	 0x10	// disable depth mode for this point
#define	RDF_ONLY1	   0x20	// rcv proc can handle ONLY1 return
#define RDF_NOVARS	 0x40	// no variable expansion
#define RDF_LIVE		 0x8000000	// live input only (^D has been proc)
#define RDF_ONVEC		 0x4000000	// pt locks on the  XData 3d vector
#define RDF_SAMEX		 0x2000000	// use prior X
#define RDF_SAMEY		 0x1000000	// use prior Y
#define RDF_SAMEZ	   0x0800000	// use prior Z
#define RDF_NOATCH	 0x0400000	// no attach on this RDATA
#define RDF_ONLY1A	 0x0200000	// if Only1, then it is an angle value
#define RDF_NOWP		 0x0100000	// no workplane conversion

//	Data valid codes sent to RcvProc
 
#define RD_OK			0	// data ok
#define RD_BAD		1	// data bad
#define RD_DFLT		2	// data default
#define RD_ONLY1	3	// if only 1 val of 2 or 3
#define RD_CANCEL	4	// if data cancel
#define RD_JUMP		5	// jump into receive proc, not from RDataChk


#endif