;	===============================================================
;	RDATA.CPY - Request Data Structures & Equates
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 24-July-1999
;	===============================================================

ReceiveClear	proto	stdcall			;clear key input bfr
ReceiveBad	proto	stdcall
ClearSelect	proto	stdcall			;clear select unhilite
PostSelect	proto	stdcall			;clear+delay->sel
DiscardReq	proto	stdcall			;discard current request
ReqHelpFile	proto	stdcall,pFile:dword	;spec help file for next DRQ

;	ReqData(dtype,pData,pPrmp,pCsrProc,pRcvProc,flags,nHelp);

ReqData		proto	stdcall,\
			dType:dword,\		;data type RD_XXXX
			pData:dword,\		;address to store data
			pPrmp:dword,\		;adrs of prompt std
			pCsrProc:dword,\	;adrs/RDC_xx cursor
			pRcvProc:dword,\	;receive data callback
			flags:dword,\		;special handling flags
			nHelp:dword;		;help context id

ReqDataX	proto	stdcall,\
			dType:dword,\		;data type RD_XXXX
			pData:dword,\		;address to store data
			pPrmp:dword,\		;adrs of prompt std
			pCsrProc:dword,\	;adrs/RDC_xx cursor
			pRcvProc:dword,\	;receive data callback
			flags:dword,\		;special handling flags
			nHelp:dword,\		;help context id
			pGLine3:dword		;on 3d GLine

RDATA		STRUC
fwd		dword	0		;DRQ linked list
back		dword	0
dType		dword	0		;RD_xxx data type
pData		dword	0		;data store address (0=don't)
pPrmp		dword	0		;prompt text FormSt packet adrs
pCsrProc	dword	0		;cursor id/procedure to use
pRcvProc	dword	0		;proc to call when data rdy
flags		dword	0		;RDF_xxx flags
nHelp		dword	0		;Help subject/context id
pHelpF		dword	0		;help file name
;
PriorP		GPnt3	<>		;@ point at start of request
OrgP		GPnt3	<>		;cursor origin at SOR
XData		GWin3	<>		;multi-pass extra data
CDPrmp		db	128 dup (0)	;room for ^D prompt
RDATA		ENDS

;	RDATA.dtype: Data type requests

RD_Word		equ	0		;text string, space/tab/cr delimit, L/R btn different
RD_Line		equ	1		;text string, CR delimits
RD_Char		equ	2		;single keystroke
RD_DWin		equ	3		;pick a drawing window
RD_RWin		equ	4		;3d real window
;
;	All Real8 codes are odd, all real4 codes are even
;
RD_2dC8		equ	5		;2d double prec. coordinate
RD_2dC4		equ	6		;2d coordinate
RD_3dC8		equ	7		;3d double prec. coordinate
RD_3dC4		equ	8		;3d coordinate
;
RD_Dist8	equ	9		;real double-precision distance
RD_Dist4	equ	10		;real distance
RD_Brng8	equ	11		;real double-precision bearing
RD_Brng4	equ	12		;real bearing
RD_AngW8	equ	13		;real double-precision angle width
RD_AngW4	equ	14		;real angle width
;
RD_Real8	equ	15		;real double-precision value
RD_Real4	equ	16		;real value
RD_Scale8	equ	RD_Real8	;real scale factor
;
RD_Int1		equ	17		;signed byte number
RD_Int2		equ	18		;signed word number
RD_Int4		equ	19		;signed dword number
;
RD_MWC		equ	20		;main window coordinate
RD_Color	equ	21		;color id (dword)
;
RD_Pick		equ	22		;select multiple entities
RD_Pick1	equ	23		;pick single entity for modify
RD_PickRef	equ	24		;pick single entity for reference

RD_Layer	equ	25		;get a layer id (dword)
RD_FStyle	equ	26		;get a fill style id (dword)
RD_LStyle	equ	27		;get a line style id (dword)
RD_Font		equ	28		;get a font id (dword)
RD_TStyle	equ	29		;get a TStyle id (dword)
RD_DStyle	equ	30		;get a DStyle id (dword)
RD_Sheet	equ	31		;get dword ptr to Sheet by name
RD_Matrl	equ	32		;get a Material id (dword)
RD_PThick	equ	33		;get a pen thickness (real4)
RD_Color2	equ	34		;get fill color (dword)
RD_LWidth	equ	35		;get line width (real4)
RD_PickRO	equ	36		;pick multiple - read/only allowed
RD_WPlane	equ	37		;get workplane id (dword)

;	values for RDATA.flags:

RDF_NONE	equ	0		;no flags needed
RDF_PPKT	equ	1		;prompt is packet (norm=adrs/rsc)
RDF_ORTHO	equ	2		;point can ortho lock if enabled
RDF_NOSNAP	equ	4		;no ortho or snap
RDF_NOPRIOR	equ	8		;don't set prior point
RDF_NODEPTH	equ	10h		;disable depth mode for this point
RDF_ONLY1	equ	20h		;rcv proc can handle ONLY1 return
RDF_NOVARS	equ	40h		;no variable expansion
RDF_LIVE	equ	8000000h	;live input only (^D has been proc)
RDF_ONVEC	equ	4000000h	;pt locks on the  XData 3d vector
RDF_SAMEX	equ	2000000h	;use prior X
RDF_SAMEY	equ	1000000h	;use prior Y
RDF_SAMEZ	equ	0800000h	;use prior Z
RDF_NOATCH	equ	0400000h	;no attach on this RDATA
RDF_ONLY1A	equ	0200000h	;if Only1, then it is an angle value
RDF_NOWP	equ	0100000h	;no workplane conversion

;	Data receive code types:

RD_OK		equ	0	;valid data returned
RD_BAD		equ	1	;bad data entered
RD_DFLT		equ	2	;no data returned (empty stg, right click)
RD_ONLY1	equ	3	;only 1 real value returned
RD_CANCEL	equ	4	;input cancelled
RD_JUMP		equ	5	;jump into receive proc, not from RDataChk
RD_DFLT2	equ	6	;no data returned (text, left click)

;	Entity selection popup commands:

IDM_ES_LOW	equ	6000
IDM_ES_HI	equ	6099
IDM_ES_RDY	equ	6000
IDM_ES_CANCEL	equ	6001
IDM_ES_CONTINUE	equ	6002
IDM_ES_AND	equ	6003
IDM_ES_OR	equ	6004
IDM_ES_NOT	equ	6005
IDM_ES_ALL	equ	6006
IDM_ES_PRIOR	equ	6007
IDM_ES_WIN	equ	6008
IDM_ES_COLOR	equ	6009
IDM_ES_LAYER	equ	6010

IDM_ES_LSTYLE	equ	6011
IDM_ES_FSTYLE	equ	6012
IDM_ES_ETYPE	equ	6013
IDM_ES_FONT	equ	6014
IDM_ES_TAG	equ	6015
IDM_ES_HELP	equ	6016
IDM_ES_TSTYLE	equ	6017
IDM_ES_DSTYLE	equ	6018
IDM_ES_ETYPEN	equ	6019

AKEYDOWN	equ	8000h	;Get AsyncKeyState key currently down
