// 	===============================================================
// 	Math2.h - Geometry Math Support
// 	===============================================================
// 	Copyright 1999 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 4-Aug-1999
// 	===============================================================

#ifndef _MATH2_H_
#define _MATH2_H_

void _stdcall DistP2L(GPNT2 *pGPnt2, GLINE2 *pGLine2);
void _stdcall T2PL2(GLINE2 *pL2, double *pT, GPNT2 *pP2);
void _stdcall P2TL2(GLINE2 *pGL2, GPNT2 *pPt2, double *pT);
void _stdcall NearestP2(GPNT2 *pA, GPNT2 *pB, GPNT2 *pTest, GPNT2 *pResult);
void _stdcall NPOnL2(GLINE2 *pLine2, GPNT2 *pNear2, GPNT2 *pResPt);
BOOL _stdcall FDNZero(double *pA);
BOOL _stdcall FDNSame(double *pA, double *pB);
bool _stdcall DNSame(double A, double B);
double _stdcall DANorm(double val);
BOOL _stdcall FDNSame2(GPNT2 *pA, GPNT2 *pB);
BOOL _stdcall FDNSame3(GPNT3 *pA, GPNT3 *pB);
void _stdcall E2CAngleS(void);
void _stdcall C2EAngleS(void);
void _stdcall PtOnElp2(GELP2 *pGeo, double A, GPNT2 *pPt2);

BOOL _stdcall IntL2(GLINE2 *lpGeo1, GLINE2 *lpGeo2, GPNT3 *lpDest);
void _stdcall TRangeChk(void);
void _stdcall Copy3dP(DWORD pFrom, DWORD pTo);
void _stdcall Copy2dP(DWORD pFrom, DWORD pTo);
void _stdcall SymTMSP2(void);
void _stdcall SymTMSP3(void);

void _stdcall Elp2NearT(DWORD pGeo, GPNT2 *pPt, double *pT);
void _stdcall Elp2CalPt(DWORD pGeo, double *pT, GPNT2 *pPt);
void _stdcall ElA2NearT(DWORD pGeo, GPNT2 *pPt, double *pT);
void _stdcall ElA2CalPt(DWORD pGeo, double *pT, GPNT2 *pPt);
void _stdcall Elp2T2Ang(DWORD pGeo, double *pT, double *pA);
void _stdcall ElA2T2Ang(DWORD pGeo, double *pT, double *pA);
void _stdcall ElpTan2(DWORD pGeo, double CurT, double *pTan);
void _stdcall DeNormT(void);
void _stdcall NormT(void);

void _stdcall _RotatePt(double x,double y,double a,GPNT2* pResult);

#endif