//	================================================================
//	LightIB.h - Lights InfoBlock Structure
//	----------------------------------------------------------------
//	Copyright 2000 Evolution Computing
//	All rights reserved
//	================================================================

#define	IB_LIGHTS 13
#define	IB_LIGHTS_VER 1
typedef struct
{
	int	ERLen;
	char	EType;			// ET_IB infoblock
	char	IType;			// IB_LIGHTS
	char	Ver;			// IB_LIGHTS_VER
	short	NextId;			// next free id # for new light
	int		flags;			// RLF_xxx flags
	float	Brightness;		// range 0.0 -> 1.0 scale factor
	int		nCurrent;		// current selected light
} LIGHTSIB;

#define RLF_SHOW		1		// show schematic lights
#define	RLF_AUTO		2		// automatic lighting enabled
#define	RLF_NSHADOWS	4		// disable all shadowing

typedef	struct
{
	float	Red;
	float	Green;
	float	Blue;
	float	Intensity;
} LCOLOR;

typedef	struct
{
	int	rlen;				// record size in bytes
	int	id;					// light id 0..7 max for OpenGL
	int	LType;				// RLT_xxx light type
	int	flags;				// RL_xxx flags
	LCOLOR Color;

	GPNT3	At;				// light origin
	GPNT3	To;				// shining towards

	float	Ang;			// spotlight angle in radians
	float	Exp;			// spotlight focus exponent

	float	AtConst;		// attenuation constant
	float	AtLinear;		// linear attenuation
	float	AtQuad;			// quadratic attenuation

	char	LName;			// variable length ANSIZ string light name

} LIGHT;

#define	RLT_AMBIENT	0		// ambient light type
#define	RLT_DISTANT	1		// distant light type
#define	RLT_POINT	2		// point light type
#define	RLT_SPOT	3		// spotlight type
#define	RLT_EYE		4		// eye (viewpoint fwd) light

#define	RL_ON		1		// flag: light is turned on
#define	RL_SHADOWS	2		// this light casts shadows

//	================================================================
