// 	===============================================================
// 	Layers.h - Layers Infoblock Structure
// 	===============================================================
// 	Copyright 1999 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 25-July-1999
// 	===============================================================

#ifndef _LAYERS_H_
#define _LAYERS_H_

typedef struct
{
	DWORD	RLen;		
	WORD	id;		
	char	nNest;			// nesting level (0=outer)
	char	sNest;			// show to level (vis if sNest>=nNest)
	DWORD	Flags;			// hidden,readonly, etc.
	char	LName[1];		// ANSIZ string (var length)
}LAYER;

// 	Values for LAYER.flags:

#define LYR_HIDDEN			     1		// layer is hidden
#define LYR_RO					 2		// layer is read-only
#define LYR_NEST				 4		// layer contains nested sublayers
#define LYR_PROT			   	 8		// this LAYER may not be deleted
#define LYR_OVRHIDE				16		// override - hide
#define LYR_OVRSHOW				32		// override - show
#define LYR_USED			0x8000		// this layer contains entities
#define LYR_AUTOHIDE	   0x10000		// hide if not current layer

// 	===============================================================

#define IB_LAYER	4
#define IB_LAYER_VER	0

typedef struct
{
	DWORD	ERLen;		
	char	EType;		
	char	IType;				// type of infoblock
	char	Ver;					// IB version number
	WORD	NextId;				// next free id # for new layer
	WORD	CurLayerId;		// id # of current layer
	DWORD	CurLayer;			// offset of CurLayerId's LAYER struc
}LAYERIB;

// 	There are 1 or more LAYER structures after CurLayer,
// 	followed by a dword=0 end marker (included in length).

LAYER *_stdcall FindLayerName(DWORD	 pName);
LAYER *_stdcall FindLayerID(DWORD	 ID);
LAYER *_stdcall GetCurLayer(void);
LAYER *_stdcall SetCurLayer(DWORD	 ID);
void _stdcall LyrOvrSet(DWORD pList);
int  _stdcall LyrOvrGet(DWORD ppList); // return size in bytes
void _stdcall LyrOvrLoad(DWORD nCtrl); // init dlg list
void _stdcall LyrOvrPick(DWORD nCtrl, DWORD nCurItem);
void _stdcall LyrOvrDraw(DWORD nCtrl, DWORD nCmd, DWORD pIData);

#endif
