;	===============================================================
;	Layers.CPY - Layers Infoblock Structure
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 25-July-1999
;	===============================================================

FindLayerName	proto	stdcall,pName:dword	;return pLayer
FindLayerID	proto	stdcall,ID:dword	;return pLayer
GetCurLayer	proto	stdcall			;return pLayer
SetCurLayer	proto	stdcall,ID:dword	;return pLayer
LyrOvrSet	proto	stdcall,pList:dword
LyrOvrGet	proto	stdcall,ppList:dword	;return size in bytes
LyrOvrLoad	proto	stdcall,nCtrl:dword	;init dlg list
LyrOvrPick	proto	stdcall,nCtrl:dword,nCurItem:dword
LyrOvrDraw	proto	stdcall,nCtrl:dword,nCmd:dword,pIData:dword
AskLayerHidden	proto	stdcall,id:dword
AskLayerFrozen	proto	stdcall,id:dword

LAYER		struc
rlen		dword	0
id		word	0
nNest		db	0		;nesting level (0=outer)
sNest		db	0		;show to level (vis if sNest>=nNest)
flags		dword	0		;hidden,readonly, etc.
LName		db	0		;ANSIZ string (var length)
LAYER		ends

;	Values for LAYER.flags:

LYR_HIDDEN	equ	1		;layer is hidden
LYR_RO		equ	2		;layer is read-only
LYR_NEST	equ	4		;layer contains nested sublayers
LYR_PROT	equ	8		;this LAYER may not be deleted
LYR_OVRHIDE	equ	16		;override - hide
LYR_OVRSHOW	equ	32		;override - show
LYR_USED	equ	8000h		;this layer contains entities
LYR_AUTOHIDE	equ	10000h		;hide if not current layer

;	===============================================================

IB_LAYER	equ	4
IB_LAYER_VER	equ	0

LayerIB		struc
ERLen		dword	sizeof(LayerIB)
EType		db	ET_IB
IType		db	IB_LAYER	;type of infoblock
Ver		db	IB_LAYER_VER	;IB version number
NextId		word	2		;next free id # for new layer
CurLayerId	word	0		;id # of current layer
CurLayer	dword	0		;offset of CurLayerId's LAYER struc
LayerIB		ends

;	There are 1 or more LAYER structures after CurLayer,
;	followed by a dword=0 end marker (included in length).

