// 	===============================================================
// 	LStyles.CPY - LStyles Infoblock Structure
// 	===============================================================
// 	Copyright 1999-2000 Evolution Computing
// 	All rights reserved
// 	Revised by Mike Riddle 3-Jan-2000
// 	===============================================================

#ifndef _LSTYLES_H_
#define _LSTYLES_H_

#define IB_LSTYLE	    7
#define IB_LSTYLE_VER	1

typedef struct
{
	DWORD	ERLen;		
	char	EType;		
	char	IType;					// type of infoblock
	char	Ver;						// IB version number
	WORD	NextId;					// next free id # for new LStyle
	WORD	CurLStyleId;		// id # of current FStyle
	DWORD	CurLStyle;			// offset of CurFStyleId's FStyle struc
	float	LSScale;				// paper scale master pattern size
}LSTYLEIB;

// 	There are 2 or more LStyle structures after CurLStyle,
// 	followed by a dword=0 end marker (included in length).

// 	ID=0 is always solid line, id=1 is always no line (no outline)

// 	===============================================================
// 	Format of LStyle structure
// 	===============================================================

typedef struct
{
	DWORD	RLen;				// size of this LStyle
	WORD	id;					// LStyle ID
	char	LType;				// LStyle Type
	char	flags;				// used, etc.
	char	dofst;				// offset to style-specific data
	char	LSName[1];			// ANSIZ string (var length)
}LSTYLE;

// 	Values for LStyle.flags:

#define LS_RO				 1		// this LStyle may not be changed
#define LS_PROT			 2		// this LStyle may not be deleted
#define LS_USED		0x80		// this LStyle is used
#define LS_LOCAL	0x40		// this style shows in combobox

// 	Values for LStyle.LType:

#define LS_PSBIT	0		// paper-scale bit pattern
#define LS_FCW		1		// FCW file compatibility style

// 	===============================================================
// 	LSty0: line style class LS_PSBIT: Paper scale bit pattern
// 	===============================================================

typedef struct
{
	char	nRpt;					// # repeats to fill pattern LSSize
	char	nBits;				// # bits in BitPat
	DWORD	BitPat;				// draw bitpattern 1=draw
					 						// high bit draws first
	float	LSScale;			// paper scale pattern size
		 									// 0.0 = use master LSScale
}LSTY0;

// 	===============================================================
// 	LSty1: line style class LS_FCW: FCW compatible line style
// 	===============================================================

#define LS1_S1V		1		// segment 1 draws
#define LS1_ENDS	4		// scale to fit ends
#define LS1_PAPER	8		// paper-scale

typedef struct
{
	WORD	nSegs;			// # segments
	WORD	flags;			// 
	float	SLen;				// pattern real length
 										// 0.0 = use master LSScale
 										// nSegs instances of LSty1S follow
}LSTY1;

typedef struct
{
	float	SegTW;			// segment width in T 0..1
}LSTY1S;

// 	===============================================================

LSTYLE * _stdcall FindLStyleName(char *pName);
LSTYLE * _stdcall FindLStyleID(DWORD ID);
LSTYLE * _stdcall GetCurLStyle(void);
LSTYLE * _stdcall SetCurLStyle(DWORD ID);


#endif