;	===============================================================
;	LStyles.CPY - LStyles Infoblock Structure
;	===============================================================
;	Copyright 1999-2000 Evolution Computing
;	All rights reserved
;	Revised by Mike Riddle 3-Jan-2000
;	===============================================================

FindLStyleName	proto	stdcall,pName:dword	;return pLStyle
FindLStyleID	proto	stdcall,ID:dword	;return pLStyle
GetCurLStyle	proto	stdcall			;return pLStyle
SetCurLStyle	proto	stdcall,ID:dword	;return pLStyle

IB_LSTYLE	equ	7
IB_LSTYLE_VER	equ	1

LStyleIB	struc
ERLen		dword	sizeof(LStyleIB)
EType		db	ET_IB
IType		db	IB_LSTYLE	;type of infoblock
Ver		db	IB_LSTYLE_VER	;IB version number
NextId		word	2		;next free id # for new LStyle
CurLStyleId	word	0		;id # of current FStyle
CurLStyle	dword	0		;offset of CurFStyleId's FStyle struc
LSScale		real4	1.0		;paper scale master pattern size
LStyleIB	ends

;	There are 2 or more LStyle structures after CurLStyle,
;	followed by a dword=0 end marker (included in length).

;	ID=0 is always solid line, id=1 is always no line (no outline)

;	===============================================================
;	Format of LStyle structure
;	===============================================================

LStyle		struc
rlen		dword	0		;size of this LStyle
id		word	0		;LStyle ID
LType		db	0		;LStyle Type
flags		db	083h		;used, etc.
dofst		db	0		;offset to style-specific data
LSName		db	0		;ANSIZ string (var length)
LStyle		ends

;	Values for LStyle.flags:

LS_RO		equ	1		;this LStyle may not be changed
LS_PROT		equ	2		;this LStyle may not be deleted
LS_USED		equ	80h		;this LStyle is used
LS_LOCAL	equ	40h		;this style shows in combobox

;	Values for LStyle.LType:

LS_PSBIT	equ	0		;paper-scale bit pattern
LS_FCW		equ	1		;FCW file compatibility style

;	===============================================================
;	LSty0: line style class LS_PSBIT: Paper scale bit pattern
;	===============================================================

LSty0		struc
nRpt		db	1		;# repeats to fill pattern LSSize
nBits		db	1		;# bits in BitPat
BitPat		dword	-1		;draw bitpattern 1=draw
;					;high bit draws first
LSScale		real4	0.0		;paper scale pattern size
;					;0.0 = use master LSScale
LSty0		ends

;	===============================================================
;	LSty1: line style class LS_FCW: FCW compatible line style
;	===============================================================

LS1_S1V		equ	1		;segment 1 draws
LS1_ENDS	equ	4		;scale to fit ends
LS1_PAPER	equ	8		;paper-scale

LSty1		struc
nSegs		word	1		;# segments
flags		word	0		;
SLen		real4	0.0		;pattern real length
;					;0.0 = use master LSScale
;					;nSegs instances of LSty1S follow
LSty1		ends

LSty1S		struc
SegTW		real4	1.0		;segment width in T 0..1
LSty1S		ends

