;	===============================================================
;	LIGHTS.CPY - Lights Infoblock Structure
;	===============================================================
;	Copyright 2000 Evolution Computing
;	All rights reserved
;	Revised by Mike Riddle 24-June-2000
;	===============================================================

IB_LIGHTS	equ	13
IB_LIGHTS_VER	equ	2		;revised 26-Oct-00

LightsIB	struc
ERLen		dword	sizeof(LightsIB)
EType		db	ET_IB
IType		db	IB_LIGHTS	;type of infoblock
Ver		db	IB_LIGHTS_VER	;IB version number
NextId		word	0		;next free id # for new light
flags		dword	RLF_SHOW+RLF_AUTO+RLF_NSHADOWS
Brightness	real4	1.0		;range 0.0 -> 1.0 scale factor
nCurrent	dword	0		;current selected light
LightsIB	ends

;	This is followed by 0 or more Lights structures, then
;	a dword=0 end marker.

;	Values for LightsIB.flags:

RLF_SHOW	equ	1		;show schematic lights
RLF_AUTO	equ	2		;automatic lighting enabled
RLF_NSHADOWS	equ	4		;shadows disabled

;	===============================================================
;	3d LIGHT
;	===============================================================

LColor		struc
Red		real4	1.0
Green		real4	1.0
Blue		real4	1.0
Alpha		real4	1.0
LColor		ends

Light		struc
rlen		dword	sizeof(Light)
;
id		dword	0		;light id 0..7max for OpenGL
LType		dword	RLT_AMBIENT	;light type
flags		dword	RL_ON		;light flags
;
Color		LColor	<>		;light color
;
At		GPnt3	<>		;light position
To		GPnt3	<>		;look towards
;
Ang		real4	0.523598775	;spotlight angle (dflt 30 degrees)
Exp		real4	0.0		;spotlight focus exponent
;
AtConst		real4	1.0		;constant attenuation
AtLinear	real4	0.0		;linear attenuation
AtQuad		real4	0.0		;quadratic attenuation
;
LName		db	0		;ANSIZ light name
Light		ends

;	LType values:

RLT_AMBIENT	equ	0
RLT_DISTANT	equ	1
RLT_POINT	equ	2
RLT_SPOT	equ	3
RLT_EYE		equ	4

;	Flags values:

RL_ON		equ	1	;light is turned on
RL_SHADOWS	equ	2	;light casts shadows

;	===============================================================
