// 	===============================================================
// 	Header.CPY - Header InfoBlock
// 	===============================================================
// 	Copyright 1999 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 30-July-1999
// 	===============================================================

#ifndef _HEADER_H_
#define _HEADER_H_ 

void  _stdcall SetCStuff(void *pEnt);
void  _stdcall CopyCStuff(void *pFrom, void *pTo);
void  _stdcall CopyColor(void *pFrom, void *pTo);
void  _stdcall SetNewTag(void *pEnt);
DWORD _stdcall GetCurColor(void);
void  _stdcall SetCurColor(DWORD ColorV);
DWORD _stdcall GetBkgndColor(void *hDWin);
void  _stdcall SetBkgndColor(DWORD ColorV);
void  _stdcall SwitchMainDL(void *hDList);
void  _stdcall SwitchRefDL(void *hDList);
BOOL  _stdcall GetAtchStatus(void);
void  _stdcall SetAtchStatus(DWORD v);


#define IB_HDR			0
#define IB_HDR_VER		4
#define DB_VER			0

typedef struct
{
	DWORD	ERLen;		
	char	EType;			// record = infoblock
	char	IType;			// type of infoblock
	char	Ver;			// IB version number
	char	DBVer;			// database format version
 
	DWORD	CurColor;		// current outline color
	DWORD	BkgndColor;		// drawing background color
	DWORD	rsvd[20];		
	DWORD	SWFlags;		// switch status flags
	DWORD	LastTag;		// last tag number
 
	double	UnitV;			// inches per drawing unit
	char	AngFmt;			// angle display format:
						 		//  bit 4 set ANGW is dms
						 		//  bit 2 set BRNG is surveyors
						 		//  bit 1 set BRNG is dms
						 		//  else decimal degrees
	char	DistFmt;		// distance format
	char	DecP;				// decimal places
	char	FRnd;				// fractions to nearest (power of 2)
 
	char	CurThick;		// current pen thickness 0->25.4 mm
	DWORD	CurColor2;		// current fill color
	float	CurWidth;		// current edge width
	char	SplRes;			// current spline resolution
 
	char	PTFmt;			// 5=mm 1=inches, PThick display fmt
	char	fill1[22];
	float	TH1;			// 4 most recent text heights
	float	TH2;		
	float	TH3;		
	float	TH4;		
 
	float	CurPT;			// current pen thickness
	float	PT1;			// 4 most recent pen thicknesses
	float	PT2;		
	float	PT3;		
	float	PT4;		
 
	float	LW1;			// 4 most recent line widths
	float	LW2;		
	float	LW3;		
	float	LW4;		

	ASTY	ArwSty;			// current arrow style
	float	WallWidth;		// current wall width
	char	fill[512-215];
}HDR;

// 	Values for SWFlags are:

#define SW_Grid				1
#define SW_Snap				2
#define SW_CSnap			4
#define SW_Ortho			8
#define SW_Attach		0x10
#define SW_Unlock		0x20
#define SW_Depth		0x40
#define SW_SheetAH		0x80

// 	===============================================================

#endif