;	===============================================================
;	Grids.CPY - Grid System Object
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 4-June-2000
;	===============================================================

GetCurGridObj	proto	stdcall		;return handle to current gridobj

;	Grids exist in two forms: A Grid object for current use,
;	and as records in the infoblock

;	===============================================================
;	Grid Object Method Equates
;	===============================================================

GSDelete	equ	0		;delete the grid
GSSnap3		equ	1		;snap 3d point
GSOrtho3	equ	2		;ortho snap 3d
GSDraw		equ	3		;draw grid

;	===============================================================
;	hGrid=GridClass(pGrid,nFunc,nParm)
;	===============================================================

GridClass	proto	stdcall,pGrid:dword,nFunc:dword,nParm:dword

;	NULL specified for pGrid uses the current grid system record

;	Equates and parameters for nFunc:

GS_CREATE	equ	0	;hGrid=GridClass(pGrid,GS_CREATE,NULL);
GS_REORG	equ	1	;void=GridClass(pGrid,GS_REORG,pGPnt3);
GS_RESCALE	equ	2	;void=GridClass(pGrid,GS_RESCALE,pScale8);
GS_EDIT		equ	3	;BOOL=GridClass(pGrid,GS_EDIT,NULL);
GS_NEW		equ	4	;pGrid=GridClass(pGrid,GS_NEW,nClass);
GS_SETORG	equ	5	;void=GridClass(pGrid,GS_SETORG,pGPnt3);
GS_SETGV	equ	6	;void=GridClass(pGrid,GS_SETGV,pGPnt3);
GS_SETSV	equ	7	;void=GridClass(pGrid,GS_REORG,pInt4);
GS_SETAV	equ	8	;void=GridClass(pGrid,GS_REORG,pOA3);

;	===============================================================
;	The Grid Infoblock
;	===============================================================

IB_GRIDS	equ	2
IB_GRIDS_VER	equ	3

GridIB		struc
ERLen		dword	sizeof(GridIB)
EType		db	ET_IB
IType		db	IB_GRIDS	;type of infoblock
Ver		db	IB_GRIDS_VER	;IB version number
CurGrid		dword	0		;offset of current grid record
GridIB		ends

;	There are 1 or more grid structures after CurGrid,
;	followed by a dword=0 end marker (included in length).

;	===============================================================
;	Rectangular Grids
;	===============================================================

GS_GRIDR	equ	0		;grid class code

;	Rectangular Grid System Object:

GRIDR		struc			;assume size multiple of 4
pVTbl		dword	0		;->object vector table
flags		dword	0		;option flags
OrgP		GPnt3	<0.0,0.0,0.0>
Delta		GPnt3	<1.0,1.0,1.0>
SDelta		GPnt3	<0.25,0.25,0.25>
nSnap		dword	4
GRIDR		ends

;	Rectangular Grid System Record in GridIB:
;	A Grid structure followed by a GridR structure

Grid		struc			;assume size multiple of 4
RLen		dword	0		;record length (Grid+GRIDR)
GType		dword	0		;grid type = GRIDR
flags		dword	0		;flags
dofst		db	0		;offset to OrgP from RLen
GName		db	0		;ANSIZ grid system name
Grid		ends
;
GridR		struc
OrgP		GPnt3	<0.0,0.0,0.0>	;Grid origin point
Delta		GPnt3	<1.0,1.0,1.0>	;Grid spacing
nSnap		dword	4		;# snap pts per grid spacing
GridR		ends

;	Values for Grid.flags:

RGS_SQUARE	equ	1		;x spacing = y spacing
RGS_TRIGRID	equ	2		;y = x * tan(30) *1.5
GS_PROT		equ	80h		;protected - don't delete

;	===============================================================
;	Circular/Cylindrical Grids
;	===============================================================

GS_GRIDC	equ	1		;grid class code

;	Circular Grid System Object:

GRIDC		struc			;assume size multiple of 4
pVTbl		dword	0		;->object vector table
flags		dword	0		;option flags
OrgP		GPnt3	<0.0,0.0,0.0>
DeltaA		real8	0.261795	;15 deg
DeltaR		real8	1.0		;with DeltaA
DeltaZ		real8	1.0
OfstA		real8	0.0		;starting angle offset
SnapA		real8	0.087265	;snap increments
SnapR		real8	0.3333333
SnapZ		real8	1.0
nSnap		dword	4
RotXY		real8	0.0		;3d rotation angles for grid plane
RotYZ		real8	0.0
RotZX		real8	0.0
W2G		TMat	<>		;world coord to rect grid coord
G2W		TMat	<>		;rect grid to world coord
GRIDC		ends

;	Circular Grid System Record in GridIB:
;	A Grid structure followed by a GridC structure

GridC		struc
OrgP		GPnt3	<0.0,0.0,0.0>
DeltaA		real8	0.261795	;15 deg
DeltaR		real8	1.0		;with DeltaA
DeltaZ		real8	1.0
OfstA		real8	0.0		;starting angle offset
nSnap		dword	4
RotXY		real8	0.0		;3d rotation angles for grid plane
RotYZ		real8	0.0
RotZX		real8	0.0
GridC		ends

;	Values for GridC.flags:

;	===============================================================
;	Angular Grids
;	===============================================================

GS_GRIDA	equ	2		;grid class code

;	Angular Grid System Object:

GRIDA		struc			;assume size multiple of 4
pVTbl		dword	0		;->object vector table
flags		dword	0		;option flags
OrgP		GPnt3	<0.0,0.0,0.0>
Delta		GPnt3	<1.0,1.0,1.0>
SDelta		GPnt3	<0.25,0.25,0.25>
nSnap		dword	4
RotXY		real8	0.0		;3d rotation angles for grid plane
RotYZ		real8	0.0
RotZX		real8	0.0
W2G		TMat	<>		;world coord to rect grid coord
G2W		TMat	<>		;rect grid to world coord
GRIDA		ends

;	Angular Grid System Record in GridIB:
;	A Grid structure followed by a GridA structure

GridA		struc
OrgP		GPnt3	<0.0,0.0,0.0>	;Grid origin point
Delta		GPnt3	<1.0,1.0,1.0>	;Grid spacing
nSnap		dword	4		;# snap pts per grid spacing
RotXY		real8	0.0		;3d rotation angles for grid plane
RotYZ		real8	0.0
RotZX		real8	0.0
GridA		ends

;	Values for GridA.flags:

AGS_SQUARE	equ	1		;x spacing = y spacing

;	===============================================================
;	Hexagonal Grids
;	===============================================================

GS_GRIDX	equ	3		;grid class code

;	Hexagonal Grid System Object:

GRIDX		struc			;assume size multiple of 4
pVTbl		dword	0		;->object vector table
OrgP		GPnt3	<0.0,0.0,0.0>	;Grid origin point
;
Wid		real8	1.0		;hex cell width
Hgt		real8	1.154700538	;hex cell height
;
;	calculated cell offsets
;					;vertical	horizontal
hdelta		real8	1.0		;width		width*1.5
vdelta		real8	0.866025403	;width*sin(60)	width*.5
hofst		real8	0.5		;width*.5	width*.75
h1		real8	0.5		;width*.5	width*.25
h2		real8	0.25		;width*.25	width*.375
h3		real8	0.5		;width*.5	width*.5
v1		real8	0.288675134	;height*.25	height*.5
v2		real8	0.433012701	;height*.375	height*.25
v3		real8	0.433012701	;height*.5	height*.5
;
flags		dword	77h		;draw and snap flags
orient		dword	2		;1=horizontal, 2=vertical
GRIDX		ends

;	Hexagonal Grid System Record in GridIB:
;	A Grid structure followed by a GridX structure

GridX		struc
OrgP		GPnt3	<0.0,0.0,0.0>	;Grid origin point
;
Wid		real8	1.0		;hex cell width
Hgt		real8	1.154700538	;hex cell height
;
;	calculated cell offsets
;					;vertical	horizontal
hdelta		real8	1.0		;width		width*1.5
vdelta		real8	0.866025403	;width*sin(60)	width*.5
hofst		real8	0.5		;width*.5	width*.75
h1		real8	0.5		;width*.5	width*.25
h2		real8	0.25		;width*.25	width*.375
h3		real8	0.5		;width*.5	width*.5
v1		real8	0.288675134	;height*.25	height*.5
v2		real8	0.433012701	;height*.375	height*.25
v3		real8	0.433012701	;height*.5	height*.5
;
flags		dword	77h		;draw and snap flags
orient		dword	2		;1=horizontal, 2=vertical
GridX		ends

;	values for GridX.Flags:

XGS_DXCEN	equ	1		;draw center points
XGS_DXEPT	equ	2		;draw endpoints
XGS_DXMID	equ	4		;draw midpoints
XGS_SXCEN	equ	10h		;snap center points
XGS_SXEPT	equ	20h		;snap endpoints
XGS_SXMID	equ	40h		;snap midpoints

;	===============================================================
