// 	===============================================================
// 	GDraw.CPY - Geometry Drawing Objects
// 	===============================================================
// 	Copyright 1999 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 9-August-1999
// 	===============================================================

#ifndef _GDRAW_H_
#define _GDRAW_H_

// 	COBJ	GDStyle,hGDraw2:dword,Color:dword,Style:dword
// 	COBJ	GDxxxx2,hGDraw2:dword,pGeo:dword

struct GDRAW2
{
	// define color & style for drawing
  virtual void __stdcall GDStyle(DWORD Color, DWORD FSty, DWORD LSty, DWORD PThickC) = 0;	
	virtual void __stdcall GDLine2(void *hDW, GLINE2 *pGeo) = 0;
	virtual void __stdcall GDPath2(void *hDW, GPATH2 *pGeo) = 0;
	virtual void __stdcall GDPoly2(void *hDW, GPATH2 *pGeo) = 0;
	virtual void __stdcall GDCir2(void *hDW, GCIR2 *pGeo) = 0;
	virtual void __stdcall GDArc2(void *hDW, GARC2 *pGeo) = 0;
	virtual void __stdcall GDElp2(void *hDW, GELP2 *pGeo) = 0;
	virtual void __stdcall GDEla2(void *hDW, GELA2 *pGeo) = 0;
	virtual void __stdcall GDText2(void *hDW, GTEXT2 *pGeo) = 0;
};
/*	
GPkLine2	equ	9	// pick test a 2d line
GPkPath2	equ	10	// pick test 2d path
GPkPoly2	equ	11	// pick test 2d poly
GDMPoly		equ	12	// draw a multipoly
// 		COBJ	GDMPoly,hGD:dword,hDW:dword,hSubList:dword
GPkCir2		equ	13	// pick test a 2d circle
GPkArc2		equ	14	// pick test a 2d arc
GPkElp2		equ	15	// pick test a 2d ellipse
GPkElA2		equ	16	// pick test a 2d elliptical arc
GPkText2	equ	17	// pick test 2d text
GDStyleE	equ	18	// define color & style for erasing
// 		COBJ	GDStyleE,hGD:dword,Color:dword,\
// 			FSty:dword,LSty:dword,PThickC:dword
GDPoint2	equ	19	// draw 2d point
// 		COBJ	GDPoint2,hGD:dword,hDW:dword,pGeo:dword
GPkPoint2	equ	20	// pick test a 2d point
GDColor		equ	21	// spec outline & fill colosr only
// 		COBJ	GDrawColor,hGD:dword,Color:dword
GDColor2	equ	22	// spec fill color only
// 		COBJ	GDrawColor2,hGD:dword,Color:dword
GDPThick	equ	23	// spec pen thickness only
// 		COBJ	GDrawPThick,hGD:dword,PThickC:dword
GDWidth   equ 24  // spec line width only
//    COBJ  GDrawWidth,hGD:dword,pWIdth:dword
*/
// 	Helper routines in GPoint2.asm:

void _stdcall OSTest	(void);
void _stdcall CvtP2V	(DWORD hDWin, DWORD pRPnt, DWORD pIPnt);
void _stdcall CvtP2VX	(DWORD hDWin, DWORD pRPnt, DWORD pIPnt);
void _stdcall CvtD2R2	(DWORD hDWCtrl, DWORD DigX, DWORD DigY);
void _stdcall CvtV2P	(DWORD hDWin, DWORD pIPnt, DWORD pRPnt3);
//void _stdcall GXCheckP2S(DWORD pXT);
//void _stdcall GXCheckP2(DWORD pPoint, DWORD pXT);
void _stdcall GXCheckP3S(DWORD pXT);
void _stdcall GXCheckP3(DWORD pPoint, DWORD pXT);
void _stdcall XCheckTM(DWORD pTM);

// 	hGDraw3 functions:
/*
GDStyle3	equ	0	// define color & style for drawing
GDLine3		equ	1	// draw a 3d line
GPkLine3	equ	2	// pick test a 3d line
GDPath3		equ	3	// draw a 3d path
GDPoly3		equ	4	// draw a 3d poly
GPkPath3	equ	5	// pick test a 3d path
GPkPoly3	equ	6	// pick test a 3d poly
GDMPoly3	equ	7	// draw a 3d multipoly
GDPoly23	equ	8	// draw a 2d poly in a 3d view
GDCir23		equ	9	// draw a 2d circle in a 3d view
GDElp23		equ	10	// draw a 2d ellipse in a 3d view
GDNList3	equ	11	// draw a 3d node list as a multipoly
*/
// 	Misc support functions:

void _stdcall Make3dPanel2(DWORD pGLine, DWORD pTM, DWORD hDList);
void _stdcall Make3dPanel3(DWORD pGLine, DWORD pTM, DWORD hDList);

// 	Object access functions:

GDRAW2 * _stdcall GetGDraw2(void);
void _stdcall GetGDraw3(void);

// 	Geometry helper routines:

void _stdcall CvtP2V(DWORD hDWin, DWORD pRPnt, DWORD pIPnt);
void _stdcall CvtP2VX(DWORD hDWin, DWORD pRPnt, DWORD pIPnt);
void _stdcall GDrawUsePen(DWORD hDWin);
void _stdcall GDrawUseFill(DWORD hDWin);

void _stdcall XCheckGText2(GTEXT2 *pGText2, XTNT2 *pXT);
void _stdcall TranGText2(DWORD pGText2, DWORD pTM);
void _stdcall BoxText2(GTEXT2 *pGText2, DWORD hDW, DWORD pBox);
void _stdcall BLText2(GTEXT2 *pGText2, GLINE2 *pGLine2);
double _stdcall LenText2(GTEXT2 *pGText2, void *hDWin);
void _stdcall MLineSplit(DWORD pGeo, DWORD pCallback, DWORD hDW);
void _stdcall TEdit(DWORD pTx, DWORD pTS, DWORD nMax, DWORD nFlags, DWORD pTTl);
void _stdcall GGetL2(DWORD pGeo, DWORD GType, DWORD pParm, DWORD pResult);

void _stdcall ExpElp2	(GELP2 *pGElp2, DWORD nSegs);
void _stdcall ExpElA2	(GELA2 *pGElA2, DWORD nSegs);

#endif																		  