//////// FORMST.H - FormSt Packets - FastCAD-7 XP include file //////////
//
//	Written by Mike Riddle 11-4-1999
//	(C)1999 Evolution Computing
//	All rights reserved
//
//////////////////////////////////////////////////////////////////////////

#ifndef _FROMST_H_
#define _FROMST_H_

#define RSC(x) ((char *)(x)) // use this to pass equates in place of addresses

typedef struct {
DWORD	*vadr;	// var adrs/RSCID
char	tcode;	// type code
char	jcode;	// justification code
char	fwid;	// field width
char	ndecp;	// decimal places
} ItemFmt;

//	Codes for pVList:

#define FV_ASM	0		// VList follows dword ptr to pattern
#define FV_NONE	-1		// no VList needed,pPatrn is pat stg adrs

//	Data type codes for tcode:

#define FT_Ptr	0x80		// pointer to data flag
#define FT_Base	0x20		// var is offset from pBase

#define FT_MASK	0x0000001F	// mask for data type code only

#define FT_Stg		0	// ASCIIZ string
#define FT_UDec1	1	// unsigned byte
#define FT_UDec2	2	// unsigned word
#define FT_UDec4	3	// unsigned dword
#define FT_Dec2		4	// signed word
#define FT_Dec4		5	// signed dword
#define FT_Hex1		6	// hex byte
#define FT_Hex2		7	// hex word
#define FT_Hex4		8	// hex dword
#define FT_Real4	9	// dword real
#define FT_Real8	10	// qword real
#define FT_2dC4		11	// 2d dword X,Y dword coordinate
#define FT_2dC8		12	// 2d dword X,Y qword coordinate
#define FT_3dC4		13	// 3d dword X,Y,Z dword coordinate
#define FT_3dC8		14	// 3d dword X,Y,Z qword coordinate
#define FT_Dist4	15	// dword real distance
#define FT_Dist8	16	// qword real distance
#define FT_Brng4	17	// dword real bearing angle
#define FT_AngW4	18	// dword real angle width
#define FT_Brng8	19	// dword real bearing angle
#define FT_AngW8	20	// dword real angle width
#define FT_Area4	21	// dword real area
#define FT_Area8	22	// qword real area

#define FT_AltDist4	23	// alt Dist4 format

//  Justification codes for jcode:

#define FJ_Var		0	// variable width field
#define FJ_Left		1	// left justified
#define FJ_Cen		2	// center justified
#define FJ_Right	4	// right justified

//  Special handling codes for ndecp:

#define FDP_User	(unsigned char)0xFF	// current user-sel # dec place
#define	FDP_Dim		(unsigned char)0xFE	// current user-sel dimension # dec pl.

//  Special destination codes for *dest data

#define FD_MsgBox	1	// Message Box (generic, no icons)
#define FD_InfoBox	2	// Info icon message box
#define FD_WarnBox	3	// Warning (! icon) message box
#define FD_ErrorBox	4	// Critical error message box
#define FD_QuestBox	5	// Question (yes/no) message box
#define FD_CancelBox	6	// Yes/No/Cancel message box
#define FD_RetryBox	7	// Retry/Cancel message box
#define FD_Prompt	8	// prompt bar
#define FD_TxWin	9	// current text window
#define FD_Dlgtitle	10	// Dlg Box title
#define FD_Status	11	// Status bar
#define	FD_MaxStd	16	// for comparison to resource id #s
#define	FD_BTitle	32	// dboxes: pBase is adrs of title string

int _stdcall FormSt(void *pPatrn,void *VList,void *pBase,char *dest);
void _stdcall PadLMargin(int NrChrs,char CValue);
void _stdcall SetDecP	(DWORD nDecP);
void _stdcall SetDFmt	(DWORD nDFmt);
void _stdcall SetAltDFmt(DWORD nDFmt);
void _stdcall SetAFmt	(DWORD nAFmt);
void _stdcall SetFRnd	(DWORD nFRnd);
void _stdcall SetFSUnitV(double NewUnitV);

#define FORMST(_name,_patrn) \
	struct _##_name##tag { char* _szpatrn; } _name = { _patrn };

#define FORMSTPKT(_name,_patrn,_count) \
	struct _##_name##_tag { char* _sz##_name##; ItemFmt _item [_count];}\
	_name = {_patrn, { 

#define ITEMFMT(_var,_ft,_just,_width,_dp) \
	{(DWORD*)&_var,_ft,_just,_width,_dp},

#define FORMSTEND \
}};

#define InfoBox(str)   FormSt(str, RSC(FV_NONE),"Message",RSC(FD_MsgBox+FD_BTitle))
#define WarnBox(str)   FormSt(str, RSC(FV_NONE),"Warning",RSC(FD_WarnBox+FD_BTitle))
#define ErrorBox(str)  FormSt(str, RSC(FV_NONE),"Error",RSC(FD_ErrorBox+FD_BTitle))
#define QuestBox(str)  FormSt(str, RSC(FV_NONE),"",RSC(FD_QuestBox))
#define CancelBox(str) FormSt(str, RSC(FV_NONE),"",RSC(FD_CancelBox))

#endif