// 	===============================================================
// 	Fonts.CPY - Font Infoblock Structure
// 	===============================================================
// 	Copyright 2000 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 22-Jan-2000
// 	===============================================================

#ifndef _FONT_H_
#define _FONT_H_

typedef struct
{
	DWORD	RLen;	
	WORD	id;				// font id
	char	FType;			// font type
	char	Flags;			// flag bits
	HFONT	hFont;			// handle to font object
	DWORD	rsvd;			// (reserved)
	char	FName[1];		// ANSIZ font name
}FONT;

// 	Font type equates

#define FT_FNT		0		// FastCAD/DOS .FNT font file
#define FT_TT		1		// TrueType
#define FT_SHX		2		// ACAD SHX Font

// 	Font flags

#define FT_Used		0x80	// font is in use
#define FT_Sub		0x40	// font not found - substitue used
#define FT_PROT		   1	// this font can't be deleted

// 	===============================================================

#define IB_FONT		8
#define IB_FONT_VER	0

typedef struct
{
	DWORD	ERLen;	
	char	EType;		
	char	IType;			// type of infoblock
	char	Ver;			// IB version number
	WORD	NextId;			// next free id # for new font
	WORD	CurFontId;		// id # of current layer
	DWORD	CurFont;		// offset of CurFontId's Font struc
}FONTIB;

// 	There are 1 or more Font structures after CurFont,
// 	followed by a dword=0 end marker (included in length).

// 	Note that the CurFont/CurFontId is the most recent font used
// 	when the drawing is saved. The current font is now controlled
// 	by the TStyles Infoblock.


FONT *_stdcall FindFontName(char *pName);
FONT *_stdcall FindFontID(DWORD ID);
FONT *_stdcall GetCurFont(void);
FONT *_stdcall SetCurFont(DWORD ID);

#endif