;	===============================================================
;	Fonts.CPY - Font Infoblock Structure
;	===============================================================
;	Copyright 2000 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 22-Jan-2000
;	===============================================================

FindFontName	proto	stdcall,pName:dword	;return pFont
FindFontID	proto	stdcall,ID:dword	;return pFont
GetCurFont	proto	stdcall			;return pFont
SetCurFont	proto	stdcall,ID:dword	;return pFont

Font		struc
rlen		dword	sizeof(Font)
id		word	0		;font id
FType		db	FT_FNT		;font type
flags		db	0		;flag bits
hFont		dword	0		;handle to font object
rsvd		dword	0		;(reserved)
FName		db	0		;ANSIZ font name
Font		ends

;	Font type equates

FT_FNT		equ	0		;FastCAD/DOS .FNT font file
FT_TT		equ	1		;TrueType
FT_SHX		equ	2		;ACAD SHX Font

;	Font flags

FT_Used		equ	80h		;font is in use
FT_Sub		equ	40h		;font not found - substitute used
FT_PROT		equ	1		;this font can't be deleted

;	===============================================================

IB_FONT		equ	8
IB_FONT_VER	equ	0

FontIB		struc
ERLen		dword	sizeof(FontIB)
EType		db	ET_IB
IType		db	IB_FONT		;type of infoblock
Ver		db	IB_FONT_VER	;IB version number
NextId		word	2		;next free id # for new font
CurFontId	word	0		;id # of current layer
CurFont		dword	0		;offset of CurFontId's Font struc
FontIB		ends

;	There are 1 or more Font structures after CurFont,
;	followed by a dword=0 end marker (included in length).

;	Note that the CurFont/CurFontId is the most recent font used
;	when the drawing is saved. The current font is now controlled
;	by the TStyles Infoblock.
