// 	===============================================================
// 	FILEIO.CPY - File I/O Support Services
// 	===============================================================
// 	Copyright 1999 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 1-9-99
// 	===============================================================

#ifndef _FILEIO_H_
#define _FILEIO_H_

char* _stdcall FileTypeAdr(char *pFName);
char* XPCALL FullFileName(char* szSource, char* szDest);
char* XPCALL FullFilePath(char* szSource, char* szDest);
char *_stdcall GetOurPath(void);
void _stdcall CreateDir(char *pPath);
void _stdcall DelTree(char *pPath);
char *_stdcall GetCurDir(DWORD pDrive);
void _stdcall SetCurDir(char *pPath);

void _stdcall LoadFile(char *pFName, char **ppDatBfr, DWORD *pnDatChrs);
void _stdcall SaveFile(char *pFName, DWORD pDatBfr, DWORD nDatChrs);
void _stdcall LoadFileAt(char *pFName, DWORD pDatBfr, DWORD nDatChrs);

DWORD _stdcall FCreate(char *pFName);
DWORD _stdcall FOpen(char *pFName);
DWORD _stdcall FOpenRO(char *pFName);
void _stdcall FClose(DWORD hFile);
int _stdcall FSize(DWORD hFile);
DWORD _stdcall FRead(DWORD fHdl, DWORD nBytes, void *pData);
void _stdcall FWrite(DWORD fHdl, DWORD nBytes, void *pData);
void _stdcall FSeek(DWORD fHdl, DWORD nPosn);
void _stdcall FDelete(char *pFName);
BOOL _stdcall FExist(char *pFName);

void _stdcall SplitFileName(char *pPath, char *pFNamr);
void _stdcall ScanDirectory(char *pPath, DWORD pCallback, DWORD Flags);

void _stdcall MakeRelPath(char *SAdr, char *DAdr);

#endif