// 	===============================================================
// 	FStyles.CPY - FStyles Infoblock Structure
// 	===============================================================
// 	Copyright 1999 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 10-Nov-1999
// 	===============================================================

#ifndef _FSTYLE_H_
#define _FSTYLE_H_

typedef struct
{
	DWORD	RLen;		
	WORD	id;		
	char	fstype;			// type of fill style
	char	dofst;			// # bytes from rlen to data start
	char	Flags;			// used, etc.
	char	FSName[1];	// ANSIZ string (var length)
}FSTYLE;

// 	Values for FStyle.flags:

#define FS_NORM		   0		// normal FStyle
#define FS_RO		   4		// this FStyle may not be changed
#define FS_PROT		   8		// this FStyle may not be deleted
#define FS_NOUTL	  16		// style draws without outline
#define FS_USED		0x80		// this FStyle is used
#define FS_LOCAL	0x40		// this style shows in combobox

// 	Values for FStyle.fstype:

#define FS_HOLLOW	0	// hollow (no) fill
#define FS_SOLID	1	// solid fill
#define FS_PAT		2	// brush pattern style
#define FS_HATCH	3	// metric hatch style
#define FS_BMP		4	// bitmap file style
#define FS_SYM		5	// symbol fill style

// 	===============================================================

FSTYLE *_stdcall FindFStyleName(char *pName);
FSTYLE *_stdcall FindFStyleID(DWORD ID);
FSTYLE *_stdcall GetCurFStyle(void);
FSTYLE *_stdcall SetCurFStyle(DWORD ID);

// 	===============================================================

#define IB_FSTYLE	5
#define IB_FSTYLE_VER	3

typedef struct
{
	DWORD	ERLen;	
	char	EType;		
	char	IType;					// type of infoblock
	char	Ver;						// IB version number
	WORD	NextId;					// next free id # for new FStyle
	WORD	CurFStyleId;		// id # of current FStyle
	DWORD	CurFStyle;			// offset of CurFStyleId's FStyle struc
}FSTYLEIB;

// 	There are 1 or more FStyle structures after CurFStyle,
// 	followed by a dword=0 end marker (included in length).

// 	===============================================================
// 	Pattern Fstyles
// 	===============================================================

typedef struct
{
	DWORD	RLen;		
	WORD	id;		
	char	fstype;			// type of fill style
	char	dofst;			// # bytes from rlen to data start
	char	Flags;			// used, etc.
	char	LName[1];		// ANSIZ string (var length)
}FSTYLEP;

// 	This is followed by the following pattern data
// 	Use FStyleP.dofst to get to the data, as the style
// 	name is variable length.

typedef struct
{
	unsigned char	Bits[8];	// 0=top, 80h=left
}FSTYPDATA;

// 	===============================================================
// 	Hatch Fstyles
// 	===============================================================

typedef struct
{
	DWORD	RLen;		
	WORD	id;		
	char	fstype;				// type of fill style
	char	dofst;				// # bytes from rlen to data start
	char	Flags;				// used, etc.
	char	LName[1];			// ANSIZ string (var length)
}FSTYLEH;

typedef struct
{
	float	SegL;				// seg length, neg=pen up
}FSTYHS;

typedef struct
{
	float	Ang;				// line bearing angle in radians
	float	OrgX;		
	float	OrgY;		
	float	PLen;				// total pattern length
 								//   =sum of SegLs for this style
	float	Spacing;			// hatch line to line perpendicular
						 		//   gap distance
	DWORD	nSegs;				// # pen up/down segments
	float SegL[1];				// not included in the CPY-file
}FSTYHL;

typedef struct
{
	double SampleSize;			// sample size this pattern
	DWORD	nLines;				// # lines in this hatch
	float	Scale;				// hatch scale
	FSTYHL LineDef[1];			// not included in the CPY-file
}FSTYHDATA;

// 	The FStyleH header is followed by the FStyHData
// 	(FStyleH.dofst is the # bytes offset to this structure)

// 	This is followed by FStyHData.nLines of the following:

// 	FStyHL structure followed by FStyHL.nSegs of FStyHS
// 	structure.

// 	===============================================================
// 	Bitmap FStyles
// 	===============================================================

typedef struct
{
	DWORD	RLen;		
	WORD	id;		
	char	fstype;			// type of fill style
	char	dofst;			// # bytes from rlen to data start
	char	flags;			// used, etc.
	char	LName[1];		// ANSIZ string (var length)
}FSTYLEB;

typedef struct
{
	DWORD	tcolor;			// transparent color
	DWORD	flags;			// flags
	double XSize;			// non-zero for geometric sizing
	double YSize;		
	char	fit;				// type of fit
	char	BmpName[1];	// bitmap file name (ANSIZ)
}FSTYBDATA;

// 	The FStyleB structure is followed by one FStyBData structure.

// 	Bitmap fit code values

#define FS_STRETCH	0		// stretch to fill (a/r distorted)
#define FS_TILE			1		// tile to file
#define FS_EXPFILL	2		// expand to completly cover (a/r ok)
#define FS_EXPFIT		3		// expand to just fit inside (a/r ok)
#define FS_COPY			4		// copy to upper-left corner & clip

// 	===============================================================
// 	Symbol FStyles
// 	===============================================================

typedef struct
{
	DWORD	RLen;		
	WORD	id;		
	char	fstype;				// type of fill style
	char	dofst;				// # bytes from rlen to data start
	char	flags;				// used, etc.
	char	LName[1];			// ANSIZ string (var length)
}FSTYLES;

typedef struct
{
	double SampleSize;	// sample size this pattern
	double xstep;				// stepping distance between instances
	double ystep;		
	double xscale;			// symbol scaling
	double yscale;		
	double xyrot;				// symbol rotation
	double PatRot;			// pattern rotation
	DWORD	 DefAdr;			// SYMDEF address
	char   SymName[1];	// bitmap file name (ANSIZ)
}FSTYSDATA;

// 	The FStyleB structure is followed by one FStyBData structure.

#endif