;	===============================================================
;	FStyles.CPY - FStyles Infoblock Structure
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 10-Nov-1999
;	===============================================================

FindFStyleName	proto	stdcall,pName:dword	;return pFStyle
FindFStyleID	proto	stdcall,ID:dword	;return pFStyle
GetCurFStyle	proto	stdcall			;return pFStyle
GetCurFStyleId	proto	stdcall			;return id of fill style
SetCurFStyle	proto	stdcall,ID:dword	;return pFStyle
FStyleAppend	proto	stdcall,hDList:dword,ppIB:dword,pFSty:dword

FStyle		struc
rlen		dword	0
id		word	0
fstype		db	0		;type of fill style
dofst		db	0		;# bytes from rlen to data start
flags		db	0		;used, etc.
LName		db	0		;ANSIZ string (var length)
FStyle		ends

;	Values for FStyle.flags:

FS_NORM		equ	0		;normal FStyle
FS_RO		equ	4		;this FStyle may not be changed
FS_PROT		equ	8		;this FStyle may not be deleted
FS_NOUTL	equ	16		;style draws without outline
FS_USED		equ	80h		;this FStyle is used
FS_LOCAL	equ	40h		;this style shows in combobox

;	Values for FStyle.fstype:

FS_HOLLOW	equ	0	;hollow (no) fill
FS_SOLID	equ	1	;solid fill
FS_PAT		equ	2	;brush pattern style
FS_HATCH	equ	3	;metric hatch style
FS_BMP		equ	4	;bitmap file style
FS_SYM		equ	5	;symbol fill style
FS_AHATCH	equ	6	;acad-compatible hatch
FS_GRADIENT	equ	7	;v8 gradient (v7 does not support)

;	===============================================================

IB_FSTYLE	equ	5
IB_FSTYLE_VER	equ	3

FStyleIB	struc
ERLen		dword	sizeof(FStyleIB)
EType		db	ET_IB
IType		db	IB_FSTYLE	;type of infoblock
Ver		db	IB_FSTYLE_VER	;IB version number
NextId		word	2		;next free id # for new FStyle
CurFStyleId	word	0		;id # of current FStyle
CurFStyle	dword	0		;offset of CurFStyleId's FStyle struc
FStyleIB	ends

;	There are 1 or more FStyle structures after CurFStyle,
;	followed by a dword=0 end marker (included in length).

;	===============================================================
;	Pattern Fstyles
;	===============================================================

FStyleP		struc
rlen		dword	0
id		word	0
fstype		db	FS_PAT		;type of fill style
dofst		db	0		;# bytes from rlen to data start
flags		db	FS_NORM		;used, etc.
LName		db	0		;ANSIZ string (var length)
FStyleP		ends

;	This is followed by the following pattern data
;	Use FStyleP.dofst to get to the data, as the style
;	name is variable length.

FStyPData	struc
Bits		db	0,1,2,3,4,5,6,7	;0=top, 80h=left
FStyPData	ends

;	===============================================================
;	Hatch Fstyles
;	===============================================================

FStyleH		struc
rlen		dword	0
id		word	0
fstype		db	FS_HATCH	;type of fill style
dofst		db	0		;# bytes from rlen to data start
flags		db	FS_NORM		;used, etc.
LName		db	0		;ANSIZ string (var length)
FStyleH		ends

FStyHData	struc
SampleSize	real8	2.0		;sample size this pattern
nLines		dword	0		;# lines in this hatch
Scale		real4	1.0		;hatch scale
FStyHData	ends

FStyHL		struc
Ang		real4	0.0		;line bearing angle in radians
OrgX		real4	0.0
OrgY		real4	0.0
PLen		real4	0.0		;total pattern length
;					;=sum of SegLs for this style
Spacing		real4	0.0		;hatch ine to line perpendicular
;					;gap distance
nSegs		dword	0		;# pen up/down segments
FStyHL		ends

FStyHS		struc
SegL		real4	0.0		;seg length, neg=pen up
FStyHS		ends

;	The FStyleH header is followed by the FStyHData
;	(FStyleH.dofst is the # bytes offset to this structure)

;	This is followed by FStyHData.nLines of the following:

;	FStyHL structure followed by FStyHL.nSegs of FStyHS
;	structure.

;	===============================================================
;	Bitmap FStyles
;	===============================================================

FStyleB		struc
rlen		dword	0
id		word	0
fstype		db	FS_BMP		;type of fill style
dofst		db	0		;# bytes from rlen to data start
flags		db	FS_NORM		;used, etc.
LName		db	0		;ANSIZ string (var length)
FStyleB		ends

FStyBData	struc
tcolor		dword	0		;transparent color
flags		dword	0		;flags
XSize		real8	0.0		;non-zero for geometric sizing
YSize		real8	0.0
fit		db	FS_EXPFILL	;type of fit
BmpName		db	0		;bitmap file name (ANSIZ)
FStyBData	ends

;	The FStyleB structure is followed by one FStyBData structure.

;	Bitmap fit code values

FS_STRETCH	equ	0		;stretch to fill (a/r distorted)
FS_TILE		equ	1		;tile to file
FS_EXPFILL	equ	2		;expand to completly cover (a/r ok)
FS_EXPFIT	equ	3		;expand to just fit inside (a/r ok)
FS_COPY		equ	4		;copy to upper-left corner & clip

;	===============================================================
;	Symbol FStyles
;	===============================================================

FStyleS		struc
rlen		dword	0
id		word	0
fstype		db	FS_SYM		;type of fill style
dofst		db	0		;# bytes from rlen to data start
flags		db	FS_NORM		;used, etc.
LName		db	0		;ANSIZ string (var length)
FStyleS		ends

FStySData	struc
SampleSize	real8	2.0		;sample size this pattern
xstep		real8	1.0		;stepping distance between instances
ystep		real8	1.0
xscale		real8	1.0		;symbol scaling
yscale		real8	1.0
xyrot		real8	0.0		;symbol rotation
PatRot		real8	0.0		;pattern rotation
DefAdr		dword	0		;SYMDEF address
SymName		db	0		;bitmap file name (ANSIZ)
FStySData	ends

;	The FStyleB structure is followed by one FStyBData structure.

;	===============================================================
;	AutoCAD-compatible Hatch Fstyles
;	===============================================================

FStyleA		struc
rlen		dword	0
id		word	0
fstype		db	FS_AHATCH	;type of fill style
dofst		db	0		;# bytes from rlen to data start
flags		db	FS_NORM		;used, etc.
LName		db	0		;ANSIZ string (var length)
FStyleA		ends

FStyAData	struc
nLines		dword	0		;# of hatch lines
spacing		real8	0.0
angle		real8	0.0
flags		dword	0
FStyAData	ends

;	values for FStyAData.flags:

FSA_Double	equ	00000001h	;1 = double hatched

;	This is followed by FStyAData.nLines copies of the following sets:

FStyALine	struc			;each pattern line's data
LineAngle	real8	0.0
OriginX		real8	0.0
OriginY		real8	0.0
DeltaX		real8	0.0
DeltaY		real8	0.0
nDashes		word	0
FStyALine	ends

;	This is followed (for each FStyALine) by FStyALine.nDashes copies of:

FStyADash	struc
SegL		real8	0.0		;seg length, neg=pen up
FStyADash	ends

