////////////// ENTOPS.H - Entity Operations - FastCAD-7 //////////////////
//
//	Written by Mike Riddle 4-Nov-1999
//	(C)1999 Evolution Computing
//	All rights reserved
//
//////////////////////////////////////////////////////////////////////////

///////// !!!!!!!!!!!!!!!! Not updated !!!!!!!!!!!!!! ////////////////

#ifndef _ENTOPS_H_
#define _ENTOPS_H_

//void _stdcall SetCStuff(void * pEntRec);

void _stdcall ShowChanges(void);
void _stdcall CmdEnd(void);
void _stdcall GetDrawMode(void);
void _stdcall EDraw(void *hDWin, void * pEntRec);		// hDWin=NULL -> multiadd
void _stdcall ERender(void *hDWin, void * pEntRec);	// hDWin=single DW only
void _stdcall EMark(void *hDWin, void * pEntRec);
void _stdcall EErase(void *hDWin, void * pEntRec);
void _stdcall EDrawM(void *hDWin, void * pEntRec);
void _stdcall EPick(void * pEntRec);
void _stdcall ETran(void * pEntRec, TMat *pTM);
void _stdcall EExtrude(void * pEntRec, TMat *pTM, IDList *hDList);
void _stdcall EEdge3(void * pEntRec, DWORD hEList3);
void _stdcall ENList3(DWORD pEnt, DWORD phNList3, DWORD LType, DWORD ARes, DWORD LRes);
void _stdcall ETrim(void * pEntRec, double TTrim, double TPick);
void _stdcall EOffset(void * pEntRec, DWORD pODist, DWORD pCallback);
void _stdcall EEdit(void * pEntRec);
// 	Return 0 normally, 1 if no CMDEND should follow
void _stdcall EDynEdit(void * pEntRec);
// 	Return 0 normally, 1 if no CMDEND should follow
void _stdcall EAct(void * pEntRec, DWORD ACode);
void _stdcall EPlace(void * pEntRec, DWORD pPSpec);
void _stdcall EStdPlace(DWORD pEnt, DWORD pPSpec);
BOOL _stdcall EExplode(void * pEntRec, DWORD pCallback);
void _stdcall EMake3d(void * pEntRec);

void _stdcall EGet(void *pEntRec, DWORD GType, void *pParm, void *pResult);

void _stdcall EXCheck(void * pEntRec, XTNT3 *pXT);
void _stdcall GXCheckP2(GPNT2 *pPoint, XTNT3 *pXT);
void _stdcall GXCheckP2S(DWORD pXT);
 
void _stdcall EList(void * pEntRec);
DWORD _stdcall EInfo(void * pEntRec, DWORD nAsk);
void _stdcall ESplit(void * pEntRec, double T, DWORD ppNew1, DWORD ppNew2);
void _stdcall EBreak(DWORD pEntRec, DWORD pCLine3);

void _stdcall EStretch(void * pEntRec);

void _stdcall StrP2(DWORD pGPnt2);
void _stdcall StrP3(DWORD pGPnt3);

void _stdcall SetStrWin(void* hDW,GPNT3* pPtA,GPNT3* pPtB);

// DWORD _stdcall GetBkgndColor(void *hDW);

#define EDRAW			 0		// 0:draw the entity
#define EXCHECK		 1		// 1:extents check the entity
#define EINFO			 2		// 2:Get entity information
#define ELIST			 3		// 3:list the entity info
#define EPICK		   4		// 4:Pick test the entity
#define EEDGE3		 5		// 5:Add edges to EList3 object
#define ENLIST3		 6		// 6:Add nodes to NList3 object
#define EGET			 7		// 7:Get entity data
#define ERENDER		 8		// 8:draw entity in OpenGL window
#define ETRAN			 9		// 9:translate entity
#define ESTRETCH	10		// 10:stretch entity
#define EEXTRUDE	11		// 11:Extrude entity along 3d vector
#define ETRIM			12		// 12:Trim Entity
#define EEXPLODE	13		// 13:Explode Entity
#define EMAKE3D		14		// 14:Make entity 3d
#define ESPLIT		15		// 15:Split entity at T
#define EOFFSET		16		// 16:Offset entity
#define EEDIT			17		// 17:Edit (dialog) entity
#define EDYNED		18		// 18:Dynamic Edit
#define EACT			19		// 19:Actuate entity
#define EPLACE		20		// 20:Place SmartSym

// 	EINFO Ask Codes:

#define EI_EName	0		// 0 = get entity name string adr
#define EI_Class	1		// 1 = get entity class flags
#define EI_Caps		2		// 2 = get entity capabilities flags

// 	ENLIST3 LType Codes:

#define EN_3d			0		// 0 = return 3d point list
#define EN_3dDV		1		// 1 = return 3d point,direction vec
						 					//     to the "outside"

// 	EGET GType codes:

#define EGET_TP3	0		// get point along entity
						 					// pParm->Real8 0..1 parameter
						 					// pResult->GPnt3 structure

#define EGET_L3T	1		// get nearest point on entity
						 					// to the pParm->GLine3 (Real8s)
						 					// pResult->qword T value

#define EGET_P3T	2		// get nearest point on entity
						 					// to the pParm->GPnt3 (Real8s)
		 									// pResult->qword T value

#define EGET_EPT3	3		// get nearest endpoint
						 					// to the pParm->qword T value
						 					// pResult->GPnt3 structure

#define EGET_CEN3	4		// get center. If none, get T=0.5 point
						 					// pResult->GPnt3 structure

#define EGET_LEN	5		// get total length of entity
						 					// pResult -> Real8 length destination

#define EGET_TAN3	6		// get tangent at T on entity
						 					// pParm->Real8 0..1 parameter
						 					// pResult->GPnt3 structure

#define EGET_DIST	7		// get T at distance along entity
						 					// pParm->Real8 distance from T=0
						 					// pResult->qword T value

#define EGET_SEG	8		// get segment adrs containing T
						 					// pParm->Real8 0..1 parameter
						 					// pResult-> dword ptr to segment
						 					// EAX return =2 for 2d, 3 for 3d
						 					// EAX = 0, carry set if not valid

#define EGET_BRNG3	9		// get point on entity at bearing
							 					// pParm->Real8 0..2pi bearing
							 					// pResult->GPnt3 structure

#define EGET_CURVE	10		// get curvature at T
								 					// pParm->Real8 0..1 parameter
								 					// pResult-> Real8 curvature
								 					// EAX = 0, carry set if not valid

#define EGET_AREA	  11		// get total area of entity
							 						// pResult -> Real8 area destination

#define EGET_PKSEG	12		// get segment adrs for seg that
 													// passes current pick test
													// and is closest to the surface
 													// of the pick window.
 													// This is used to provide "dual"
 													// behavior for 3d polys for modifiers
 													// pParm not used
 													// pResult-> dword ptr to segment
 													// EAX return =2 for 2d, 3 for 3d
 													// EAX = 0, carry set if not valid


// 	GetDrawMode values:

#define DM_DRAW		0
#define DM_MARK		1
#define DM_ERASE	2

// 	EAct ACode values:

#define ACT_HITTEST	0
#define ACT_TOOLTIP	1
#define ACT_START		2


#endif
