;	===============================================================
;	ESTRUC.CPY - FC7 File Format Entity Definitions
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 21-July-1999
;	===============================================================

;	Entity Class flags returned by EInfo EI_Class

EIC_Point	equ	1	;1=point - can not be scanned
EIC_Linear	equ	2	;1=can be scanned T=0 to T=1
EIC_Area	equ	4	;1=entity encloses area
EIC_Volume	equ	8	;1=entity encloses volume
EIC_3d		equ	16	;0=2d, 1=3d
EIC_Multi	equ	32	;1=multiple-entity aggregate
EIC_Note	equ	64	;1=annotation entry (not geometry)
EIC_Curve	equ	128	;1=ent is curve that should be smoothed

;	Entity Handler Caps flags returned by EInfo EI_Caps

EIC_Std		equ	0	;only does required functions
EIC_NoDraw	equ	1	;1=entity normally does not draw
EIC_NUTGrow	equ	2	;entity can grow on a non-uniform tran
EIC_TMake	equ	4	;entity can clone Tfrom Tto of self

;	===============================================================
;	Common Stuff - Common to all drawable entities (32 bytes)
;	===============================================================

CStuff		struc
ERLen		dword	sizeof(CStuff)
EType		db	0
EThick		db	0	;pen thickness 0->2.54 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
CStuff		ends

;	===============================================================
;	2d POINT
;	===============================================================

ET_Point2	equ	1
EC_Point2	equ	EIC_Point
EH_Point2	equ	EIC_Std

Point2		struc
ERLen		dword	sizeof(Point2)
EType		db	ET_Point2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GPnt2	<>
MType		db	0	;marker type
Point2		ends

;	===============================================================
;	2d LINE
;	===============================================================

ET_Line2	equ	2
EC_Line2	equ	EIC_Linear
EH_Line2	equ	EIC_Std

Line2		struc
ERLen		dword	sizeof(Line2)
EType		db	ET_Line2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GLine2	<>
Line2		ends

;	===============================================================
;	2d PATH
;	===============================================================

ET_Path2	equ	3
EC_Path2	equ	EIC_Linear
EH_Path2	equ	EIC_Std

Path2		struc
ERLen		dword	sizeof(Path2)
EType		db	ET_Path2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GPath2	<>
Path2		ends

;	===============================================================
;	2d POLY
;	===============================================================

ET_Poly2	equ	4
EC_Poly2	equ	EIC_Linear+EIC_Area
EH_Poly2	equ	EIC_Std

Poly2		struc
ERLen		dword	sizeof(Poly2)
EType		db	ET_Poly2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GPath2	<>
Poly2		ends

;	A polygon duplicates its first node as the last node,
;	as this greatly simplifies & speeds up code, for the
;	minimal loss of memory. This duplicated node IS counted
;	in nNodes.

Box2		struc
ERLen		dword	sizeof(Box2)
EType		db	ET_Poly2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
nNodes		word	5
P1		GPnt2	<>
P2		GPnt2	<>
P3		GPnt2	<>
P4		GPnt2	<>
P5		GPnt2	<>
Box2		ends

;	===============================================================
;	2d TEXT
;	===============================================================

ET_Text2	equ	5
EC_Text2	equ	EIC_Point
EH_Text2	equ	EIC_Std

Text2		struc
ERLen		dword	sizeof(Text2)
EType		db	ET_Text2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GText2	<>
Text2		ends

;	===============================================================
;	2d CIRCLE
;	===============================================================

ET_Cir2		equ	6
EC_Cir2		equ	EIC_Linear+EIC_Area+EIC_Curve
EH_Cir2		equ	EIC_Std+EIC_NUTGrow+EIC_TMake

Cir2		struc
ERLen		dword	sizeof(Cir2)
EType		db	ET_Cir2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GCir2	<>
Cir2		ends

;	===============================================================
;	2d ARC
;	===============================================================

ET_Arc2		equ	7
EC_Arc2		equ	EIC_Linear+EIC_Curve
EH_Arc2		equ	EIC_Std+EIC_NUTGrow+EIC_TMake

Arc2		struc
ERLen		dword	sizeof(Arc2)
EType		db	ET_Arc2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GArc2	<>
Arc2		ends

;	===============================================================
;	2d ELLIPSE
;	===============================================================

ET_Elp2		equ	8
EC_Elp2		equ	EIC_Linear+EIC_Area+EIC_Curve
EH_Elp2		equ	EIC_Std+EIC_TMake

Elp2		struc
ERLen		dword	sizeof(Elp2)
EType		db	ET_Elp2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GElp2	<>
Elp2		ends

;	===============================================================
;	2d ELLIPTICAL ARC
;	===============================================================

ET_ElA2	equ	9
EC_ElA2		equ	EIC_Linear+EIC_Curve
EH_ElA2		equ	EIC_Std+EIC_TMake

ElA2		struc
ERLen		dword	sizeof(ElA2)
EType		db	ET_ElA2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GElA2	<>
ElA2		ends

;	===============================================================
;	2d GROUP (PART - Group is MASM keyword)
;	===============================================================

ET_Part		equ	10
EC_Part		equ	EIC_Point+EIC_Multi
EH_Part		equ	EIC_Std

Part		struc
ERLen		dword	sizeof(Part)
EType		db	ET_Part
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Part		ends

;	The entities in the part are in the Part entity's sublist

;	===============================================================
;	SYMDEF (2d/3d)
;	===============================================================

ET_SymDef	equ	11
EC_SymDef	equ	EIC_Point+EIC_Multi
EH_SymDef	equ	EIC_Std+EIC_NoDraw

SymDef		struc
ERLen		dword	sizeof(SymDef)
EType		db	ET_SymDef
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
flags		dword	0	;reserved
OrgPt		GPnt3	<>	;origin point of SYMDEF
SName		db	32 dup (0)
SymDef		ends

;	The entities in the SYMDEF are in the SYMDEF entity's sublist

;	The SName field is variable length and ends with a 0 byte EOS
;	marker. SymDef.ERLen is set to just include the EOS byte
;	Entities are *not* yet translated by -OrgPt.

;	Assigned values for flags:
ESDF_Joint	equ	40000000h	;SDJ_Electra JOINT symbol
ESDF_User	equ	80000000h	;flag available for user use

;	===============================================================
;	SYMREF
;	===============================================================

ET_SymRef	equ	12
EC_SymRef	equ	EIC_Point+EIC_Multi
EH_SymRef	equ	EIC_Std

SymRef		struc
ERLen		dword	sizeof(SymRef)
EType		db	ET_SymRef
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
DefAdr		dword	0
TM		SymTMat	<>
SName		db	32 dup (0)
SymRef		ends

;	The SName field is variable length and ends with a 0 byte EOS
;	marker. SymRef.ERLen is set to just include the EOS byte

;	===============================================================
;	2d MPOLY
;	===============================================================

ET_MPoly	equ	13
EC_MPoly	equ	EIC_Multi+EIC_Area
EH_MPoly	equ	EIC_Std

MPoly		struc
ERLen		dword	sizeof(MPoly)
EType		db	ET_MPoly
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
MPoly		ends

;	The entities in the MPoly are in the MPoly entity's sublist

;	===============================================================
;	3d LINE
;	===============================================================

ET_Line3	equ	14
EC_Line3	equ	EIC_Linear+EIC_3d
EH_Line3	equ	EIC_Std

Line3		struc
ERLen		dword	sizeof(Line3)
EType		db	ET_Line3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GLine3	<>
Line3		ends

;	===============================================================
;	3d PATH
;	===============================================================

ET_Path3	equ	15
EC_Path3	equ	EIC_Linear+EIC_3d
EH_Path3	equ	EIC_Std

Path3		struc
ERLen		dword	sizeof(Path3)
EType		db	ET_Path3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GPath3	<>
Path3		ends

;	===============================================================
;	3d POLY
;	===============================================================

ET_Poly3	equ	16
EC_Poly3	equ	EIC_Linear+EIC_Area+EIC_3d
EH_Poly3	equ	EIC_Std

Poly3		struc
ERLen		dword	sizeof(Poly3)
EType		db	ET_Poly3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GPath3	<>
Poly3		ends

;	A polygon duplicates its first node as the last node,
;	as this greatly simplifies & speeds up code, for the
;	minimal loss of memory. This duplicated node IS counted
;	in nNodes.

;	===============================================================
;	Panel3 - a 4-sided 3d polygon
;	===============================================================

Panel3		struc
ERLen		dword	sizeof(Panel3)
EType		db	ET_Poly3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
nNodes		word	5	;total # nodes
P1		GPnt3	<>
P2		GPnt3	<>
P3		GPnt3	<>
P4		GPnt3	<>
P5		GPnt3	<>
Panel3		ends

;	===============================================================
;	3d SOLID
;	===============================================================

ET_Solid3	equ	17
EC_Solid3	equ	EIC_Volume+EIC_3d
EH_Solid3	equ	EIC_Std

Solid3		struc
ERLen		dword	sizeof(Solid3)
EType		db	ET_Solid3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Solid3		ends

;	The Solid3 header is followed by one or more sections,
;	each section being a GPath3 geometry, with closing node
;	duplicating the first, and finally a GPath3 with 0 nodes
;	indicating the end of the solid.

;	Note that the solid sections are included in the Solid3.ERLen
;	total record size.

;	===============================================================
;	3d Surface of Revolution
;	===============================================================

ET_SREV3	equ	18
EC_SRev3	equ	EIC_Volume+EIC_3d+EIC_Area+EIC_Multi
EH_SRev3	equ	EIC_Std

SREV3		struc
ERLen		dword	sizeof(SREV3)
EType		db	ET_SREV3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
ARes		db	0		;angular resolution
LRes		db	0		;linear resolution
;
POrg		GPnt3	<>		;axis origin point
DVec		GPnt3	<>		;axis direction vector
AngW		real8	0.0		;revolved arc width 0..2pi
SREV3		ends

;	The entities defining the revolved surface are stored
;	in the SREV3 entity's sublist. Note there will be no gaps
;	between multiple entities - they will be connected from
;	the last node of one to the first node of the next.

;	===============================================================
;	3d Tabulated Profile
;	===============================================================

ET_TPRO3	equ	19
EC_TPro3	equ	EIC_Area+EIC_3d+EIC_Multi
EH_TPro3	equ	EIC_Std

TPRO3		struc
ERLen		dword	sizeof(TPRO3)
EType		db	ET_TPRO3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
ARes		db	0		;angular resolution
LRes		db	0		;linear resolution
;
TFlags		db	3		;1=first end closed 2=last end closed
;					;4=parallel extrusion (no tilts)
nSecs		word	0		;# sections that follow
;
;	nSecs copies of the TP3S section here
;
TPRO3		ends

TP3S		struc
X		real8	0.0		;tab path 3d point
Y		real8	0.0
Z		real8	0.0
ryz		real8	0.0		;intersect plane tilt angle
rzx		real8	0.0
sfac		real8	1.0		;section scale factor
TP3S		ends

;	The entities in the sublist define the tabulated cross section.

;	===============================================================
;	3d Ruled Surface
;	===============================================================

ET_RSURF3	equ	20
EC_RSurf3	equ	EIC_Area+EIC_3d+EIC_Multi
EH_RSurf3	equ	EIC_Std

RSURF3		struc
ERLen		dword	sizeof(RSURF3)
EType		db	ET_RSURF3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
ARes		db	0		;angular resolution
LRes		db	0		;linear resolution
flags		db	0		;1=flip ent1 scan 1..0
;					;2=flip ent2 scan 1..0
;
RSURF3		ends

;	The entities in the RSURF entity's sublist define the
;	edges of the ruled surface.

;	===============================================================
;	3d CIRCLE
;	===============================================================

ET_Cir3		equ	21
EC_Cir3		equ	EIC_Linear+EIC_Area+EIC_3d+EIC_Curve
EH_Cir3		equ	EIC_Std+EIC_NUTGrow

Cir3		struc
ERLen		dword	sizeof(Cir3)
EType		db	ET_Cir3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GCir3	<>
Cir3		ends

;	===============================================================
;	3d ARC
;	===============================================================

ET_Arc3		equ	22
EC_Arc3		equ	EIC_Linear+EIC_3d+EIC_Curve
EH_Arc3		equ	EIC_Std+EIC_NUTGrow

Arc3		struc
ERLen		dword	sizeof(Arc3)
EType		db	ET_Arc3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GArc3	<>
Arc3		ends

;	===============================================================
;	3d SPHERE
;	===============================================================

ET_Sph3		equ	23
EC_Sph3		equ	EIC_Volume+EIC_3d+EIC_Curve
EH_Sph3		equ	EIC_Std

Sph3		struc
ERLen		dword	sizeof(Sph3)
EType		db	ET_Sph3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
LRes		db	0		;longitude resolution
MRes		db	0		;Meridian resolution
SFlags		db	0		;1=dome has a hole
SType		db	0		;0=sphere,1=dome,2=dome section
;
Geo		GSph3	<>
Sph3		ends

;	===============================================================
;	3d MPOLY
;	===============================================================

ET_MPoly3	equ	24
EC_MPoly3	equ	EIC_Area+EIC_Multi+EIC_3d
EH_MPoly3	equ	EIC_Std

MPoly3		struc
ERLen		dword	sizeof(MPoly3)
EType		db	ET_MPoly3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
MPoly3		ends

;	The entities in the 3d MPoly are in the MPoly entity's sublist

;	===============================================================
;	3d CYLINDER
;	===============================================================

ET_Cyl3		equ	25
EC_Cyl3		equ	EIC_Volume+EIC_3d+EIC_Curve+EIC_Multi
EH_Cyl3		equ	EIC_Std

Cyl3		struc
ERLen		dword	sizeof(Cyl3)
EType		db	ET_Cyl3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
LRes		db	0	;longitude resolution
ARes		db	0	;Angular resolution
flags		db	3	;1=1st endcap, 2=2nd endcap
;
Geo		GCyl3	<>	;geometry
Cyl3		ends

;	===============================================================
;	2d SPLINE
;	===============================================================

ET_Spline2	equ	26
EC_Spline2	equ	EIC_Linear+EIC_Curve
EH_Spline2	equ	EIC_Std

Spline2		struc
ERLen		dword	sizeof(Spline2)
EType		db	ET_Spline2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GSpline2 <>
Spline2		ends

;	===============================================================
;	2d SPoly
;	===============================================================

ET_SPoly2	equ	27
EC_SPoly2	equ	EIC_Linear+EIC_Curve
EH_SPoly2	equ	EIC_Std

SPoly2		struc
ERLen		dword	sizeof(SPoly2)
EType		db	ET_SPoly2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GSpline2 <>
SPoly2		ends

;	SPoly2 geometry does NOT duplicate the first node

;	===============================================================
;	2d DIML - Linear Dimension
;	===============================================================

ET_DimL2	equ	28
EC_DimL2	equ	EIC_Note
EH_DimL2	equ	EIC_Std

DimL2		struc
ERLen		dword	sizeof(DimL2)
EType		db	ET_DimL2
EThick		db	0		;pen thickness 0->25.4 mm paper scale
EColor		dword	0		;outline color
EColor2		dword	0		;fill color
EFStyle		word	0		;0 hollow, 1 solid
ELStyle		word	0		;0 solid
EMatrl		word	0		;render material 0=plain
ELayer		word	1		;layer 0 merge 1 standard
EWidth		real4	0.0		;entity edge width (geometric)
EWPlane		word	0		;3d workplane
ETag		dword	0		;entity tag #
;
DimDS		DSty	<>		;dimension style data
;
POrg		GPnt2	<>		;dimension origin point
PTxt		GPnt2	<>		;user-fixed text position
BAng		real8	0.0		;baseline bearing angle
LLen0		real8	0.0		;leader #0 length to geo
LLen1		real8	0.0		;leader #1 length to geo
Dist		real8	0.0		;dim distance ldr0->ldr1
TValue		real8	0.0		;forced dim display value if <>0.0
;					;else display dim=abs(Dist)
ACode		db	0		;arrows 0=center 1=left 2=right
DCode		db	0		;see below
DText		db	0		;ANSIZ dim fixed text
DimL2		ends

;	DimL2.DCode flags:

LDC_PRL		equ	1		;parallel linear dimension
LDC_FIXTP	equ	2		;PTxt is user-fixed text origin
LDC_FORCEH	equ	4		;force horizontal dim (added 7.13)
LDC_FORCEV	equ	8		;force vertical dim (added 7.13)

;	===============================================================
;	2d DIMR/DIMD - Circular Dimension
;	===============================================================

ET_DimC2	equ	29
EC_DimC2	equ	EIC_Note
EH_DimC2	equ	EIC_Std

DimC2		struc
ERLen		dword	sizeof(DimC2)
EType		db	ET_DimC2
EThick		db	0		;pen thickness 0->25.4 mm paper scale
EColor		dword	0		;outline color
EColor2		dword	0		;fill color
EFStyle		word	0		;0 hollow, 1 solid
ELStyle		word	0		;0 solid
EMatrl		word	0		;render material 0=plain
ELayer		word	1		;layer 0 merge 1 standard
EWidth		real4	0.0		;entity edge width (geometric)
EWPlane		word	0		;3d workplane
ETag		dword	0		;entity tag #
;
DimDS		DSty	<>		;dimension style data
;
PCen		GPnt2	<>		;conic center point
PArw		GPnt2	<>		;dimension arrow point
PBend		GPnt2	<>		;dimension bend point
PLdr		GPnt2	<>		;dimension leader endpoint
PTxt		GPnt2	<>		;user-fixed text position
TValue		real8	0.0		;forced dim display value if <>0.0
;					;else display dim=abs(Dist)
TagRef		TREF	<>		;tag of reference entity (0=none)
DCode		db	0		;see below
DText		db	0		;ANSIZ dim fixed text
DimC2		ends

;	DimC2.DCode flags:

CDC_DIA		equ	1		;diameter dimension
CDC_RAD		equ	2		;radius dimension
CDC_FIXTP	equ	4		;PTxt is user-fixed text origin
CDC_PBEND	equ	8		;PBend point is valid
CDC_PLDR	equ	16		;PLdr point is valid

;	===============================================================
;	2d DIMA - Angular Dimension
;	===============================================================

ET_DimA2	equ	30
EC_DimA2	equ	EIC_Note
EH_DimA2	equ	EIC_Std

DimA2		struc
ERLen		dword	sizeof(DimA2)
EType		db	ET_DimA2
EThick		db	0		;pen thickness 0->25.4 mm paper scale
EColor		dword	0		;outline color
EColor2		dword	0		;fill color
EFStyle		word	0		;0 hollow, 1 solid
ELStyle		word	0		;0 solid
EMatrl		word	0		;render material 0=plain
ELayer		word	1		;layer 0 merge 1 standard
EWidth		real4	0.0		;entity edge width (geometric)
EWPlane		word	0		;3d workplane
ETag		dword	0		;entity tag #
;
DimDS		DSty	<>		;dimension style data
;
PCen		GPnt2	<>		;arc center point
Radius		real8	1.0		;arc radius
SAng		real8	0.0		;arc start angle
AngW		real8	0.0		;arc width
L0Rad		real8	0.0		;radius to inside start leader pt
L1Rad		real8	0.0		;radius to inside end leader pt
;
PTxt		GPnt2	<>		;user-fixed text position
TValue		real8	0.0		;forced dim display value if <>0.0
;					;else display dim=AngW
ACode		db	0		;arrows 0=by DSty 1=left 2=right
DCode		db	0		;see below
DText		db	0		;ANSIZ dim fixed text
DimA2		ends

;	DimA2.DCode flags:

ADC_LDR0	equ	1		;start leader exists
ADC_LDR1	equ	2		;end leader exists
ADC_FIXTP	equ	4		;PTxt is user-fixed text origin

;	===============================================================
;	2d DIMO - Ordinate Dimensions
;	===============================================================

ET_DimO2	equ	31
EC_DimO2	equ	EIC_Note
EH_DimO2	equ	EIC_Std

ODSet		struc
Dist		real8	0.0		;dist +- from origin
LLen		real8	0.0		;leader +- length from baseline
ODSet		ends

DimO2		struc
ERLen		dword	sizeof(DimO2)
EType		db	ET_DimO2
EThick		db	0		;pen thickness 0->25.4 mm paper scale
EColor		dword	0		;outline color
EColor2		dword	0		;fill color
EFStyle		word	0		;0 hollow, 1 solid
ELStyle		word	0		;0 solid
EMatrl		word	0		;render material 0=plain
ELayer		word	1		;layer 0 merge 1 standard
EWidth		real4	0.0		;entity edge width (geometric)
EWPlane		word	0		;3d workplane
ETag		dword	0		;entity tag #
;
DimDS		DSty	<>		;dimension style data
;
nLdrs		word	0		;# of leader lines (0=ACAD no origin)
BAng		real4	0.0		;baseline angle
POrg		GPnt2	<>		;baseline origin
OLen		real8	0.0		;origin +- leader len to geometry
DimO2		ends

;	The above structure is followed by nLdrs ODSet structures
;	which are included in the entity length

;	===============================================================
;	XP Custom Entity
;	===============================================================

ET_XP		equ	32
EC_XP		equ	0
EH_XP		equ	0

XPEnt		struc
ERLen		dword	sizeof(XPEnt)
EType		db	ET_XP
EThick		db	0		;pen thickness 0->25.4 mm paper scale
EColor		dword	0		;outline color
EColor2		dword	0		;fill color
EFStyle		word	0		;0 hollow, 1 solid
ELStyle		word	0		;0 solid
EMatrl		word	0		;render material 0=plain
ELayer		word	1		;layer 0 merge 1 standard
EWidth		real4	0.0		;entity edge width (geometric)
EWPlane		word	0		;3d workplane
ETag		dword	0		;entity tag #
;
XPID		dword	0		;XP ID # for custom entity SVC
;					;xp-specific data starts here
XPEnt		ends

;	All XP entities will start with the above structure and
;	may then contain whatever additional data is necessary.

;	===============================================================
;	Action Entity - Drawing actuated button macro
;	===============================================================

ET_Act2		equ	33
EC_Act2		equ	0
EH_Act2		equ	0

Act2		struc
ERLen		dword	sizeof(Act2)
EType		db	ET_Act2
EThick		db	0		;pen thickness 0->25.4 mm paper scale
EColor		dword	0		;outline color
EColor2		dword	0		;fill color
EFStyle		word	0		;0 hollow, 1 solid
ELStyle		word	0		;0 solid
EMatrl		word	0		;render material 0=plain
ELayer		word	1		;layer 0 merge 1 standard
EWidth		real4	0.0		;entity edge width (geometric)
EWPlane		word	0		;3d workplane
ETag		dword	0		;entity tag #
;
Win		GWin2	<>		;action pick window
Geo		GText2	<>		;action text
Act2		ends

;	===============================================================
;	Arrow Entity
;	===============================================================

ET_Arrow	equ	34
EC_Arrow	equ	EIC_Multi
EH_Arrow	equ	0

Arrow		struc
ERLen		dword	sizeof(Arrow)
EType		db	ET_Arrow
EThick		db	0		;pen thickness 0->25.4 mm paper scale
EColor		dword	0		;outline color
EColor2		dword	0		;fill color
EFStyle		word	0		;0 hollow, 1 solid
ELStyle		word	0		;0 solid
EMatrl		word	0		;render material 0=plain
ELayer		word	1		;layer 0 merge 1 standard
EWidth		real4	0.0		;entity edge width (geometric)
EWPlane		word	0		;3d workplane
ETag		dword	0		;entity tag #
;
Sty		ASty	<>		;arrowhead style
flags		dword	0		;flags
Arrow		ends

;	Arrow.flags values:

ARROW_T0	equ	1		;draw arrow at T0 end
ARROW_T1	equ	2		;draw arrow at T1 end

;	The arrow entity has a sublist, and the first entity
;	within it has the arrowheads attached at either end.

;	===============================================================
;	XREF- External File Reference Instance
;	===============================================================

ET_XREF		equ	35
EC_XREF		equ	0
EH_XREF		equ	0

XREF		struc
ERLen		dword	sizeof(XREF)
EType		db	ET_XREF
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
id		dword	0	;XREF id (link to XRefIB)
flags		dword	0	;instance flags
rsvd1		dword	0	;reserved
rsvd2		dword	0	;reserved
TM		TMat	<>	;insert transform
XREF		ends

;	Values for XREF.flags:

XREF_OVL	equ	1	;overlay file
XREF_PART	equ	2	;part file

;	===============================================================
;	SHEET- Sheet Group Instance
;	===============================================================

ET_SHEET	equ	36
EC_SHEET	equ	0
EH_SHEET	equ	0

SHEET		struc
ERLen		dword	sizeof(SHEET)
EType		db	ET_SHEET
EThick		db	0		;pen thickness 0->25.4 mm paper scale
EColor		dword	0		;outline color
EColor2		dword	0		;fill color
EFStyle		word	0		;0 hollow, 1 solid
ELStyle		word	0		;0 solid
EMatrl		word	0		;render material 0=plain
ELayer		word	1		;layer 0 merge 1 standard
EWidth		real4	0.0		;entity edge width (geometric)
EWPlane		word	0		;3d workplane
ETag		dword	0		;entity tag #
;
flags		dword	0		;sheet flags
SName		db	64 dup (0)	;ANSIZ Sheet name (variable length, resize if changed)
SHEET		ends

;	Values for SHEET.flags:

SHT_CUR		equ	1		;1 = sheet is current
SHT_VIS		equ	2		;2 = sheet is visible
SHT_LAYOUT	equ	4		;4 = sheet is ACAD layout
SHT_NEW		equ	100h		;new added sheet (erase if cancel)
SHT_DEL		equ	200h		;del sheet if ok

;	===============================================================
;	2d Atrib2
;	===============================================================

ET_Atrib2	equ	37
EC_Atrib2	equ	EIC_Point
EH_Atrib2	equ	EIC_Std

Atrib2		struc
ERLen		dword	sizeof(Atrib2)
EType		db	ET_Atrib2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
flags		word	0	;attribute flags
TagOfst		dword	0	;offset of tag text
PrmpOfst	dword	0	;offset of propmt text
ValOfst		dword	0	;offset of value text
;
Geo			GText2	<>	;Attribute display text geometry
Atrib2		ends

;	The Atrib2 header structure is followed by 3 ANSIZ text
;	strings, The first of which is part of the Geo text geometry,
;	and is the text to be displayed. This is the Tag text outside
;	any SymRef, and either the Value or Tag text, depending on
;	the AT_DSPTAG bit, if inside a SymRef.

;	A Symbol Reference will have the prototype attribute
;	entity in its definition, and a "use this one" copy
;	in its sublist. Only the one in its sublist will be
;	drawn.

;	Values for Atrib2.flags:

AT_NOPRMP		equ	1	;value is constant - no prompting
AT_HIDDEN		equ	2	;attribute not displayed in SYMREF
AT_DSPTAG		equ	4	;always display the tag text
AT_NOTRAN		equ	8	;no SYMREF transform
AT_INCREMENT	equ	16	;autoincrement tagged attribute
AT_REF			equ	8000h ;atrib is a SYMREF instance entity

;	When a symbol containing an attribute is entered, the prompt
;	tag, and default value is displayed. The user may change
;	the tag and value fields as desired.

;	AT_INCREMENT flag set:

;	No prompt on insertion. The SYMREF value text is created when
;	the SYMREF is created. It is the Tag text, with <> replaced
;	by the value text. This value text is displayed.

;	Then, the value text in the SYMDEF is parsed to an integer.
;	If a valid value is parsed, the value is incremented, and 
;	converted back to text, which replaces the prior SYMDEF value text.

;	===============================================================
;	Sublist Markers
;	---------------------------------------------------------------
;	An entity that has a sublist of entities has the sublist
;	stored on disk immediately following its owner entity.
;	It starts with a Marker 0 record, followed by the entities
;	in the sublist, and ends with a Marker 1 entity.
;
;	Note that this is only when the data is stored in a file
;	image. When the drawing is in memory, sublists are accessed
;	through sublist functions.
;	===============================================================

Mark0		struc			;sublist start marker
ERLen		dword	5
MType		db	0
Mark0		ends

Mark1		struc			;sublist end marker
ERLen		dword	5
MType		db	1
Mark1		ends

;	===============================================================
;	NOTE: Note entity structure (non-drawing entity)
;	===============================================================
NoteVer		equ	0		;structure version #

ET_Note		equ	81h		;entity type code

NOTE		struc
ERLen		dword	sizeof(NOTE)
EType		db	ET_Note
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
Version		db	NoteVer		;version #
flags		db	0		;options flags
;
NName		db	32 dup (0)	;Note Name
;
NData		db	0		;note data (ANSIZ multiline)
NOTE		ends

;	===============================================================
;	2d Wall
;	===============================================================

ET_Wall2	equ	38
EC_Wall2	equ	EIC_Point
EH_Wall2	equ	EIC_Std

Wall2		struc
ERLen		dword	sizeof(Wall2)
EType		db	ET_Wall2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
NextID		word	0		;next node id
;
;	list of nodes goes here:
;
FirstNode	word	0		;ID=0=end of node list
Wall2		ends

Wall2N		struc			;2d wall node record
ID		word	0		;node id #
nSpans		word	0		;# spans connected to this node
nVisit		word	0		;traversal counter
X		real8	0.0		;node location
Y		real8	0.0
Wall2N		ends

Wall2S		struc			;2d wall node span exit record
ToID		word	0		;exit to node #
flags		db	0
Thickness	real4	0.0		;exit thickness
Ang		real4	0.0		;exit angle
XData		dword	0		;extra data
Wall2S		ends

;	Values for Wall2S.flags

Wall_Exit	equ	1		;span exit has been taken

Wall_CF		equ	0		;span is center from
Wall_CT		equ	0		;span is center to
Wall_LF		equ	4		;span is left from
Wall_LT		equ	8		;span is left to
Wall_RF		equ	8		;span is right from
Wall_RT		equ	4		;span is right to

;	Each node record has its Wall2N.nSpans span records immediatly
;	following it before the next node record. After the last
;	node reocrd is a word=0 end marker (Wall2N.ID=0).

;	===============================================================
;	SmartSym Control Points Entity
;	===============================================================

ET_CtrlP	equ	39
EC_CtrlP	equ	EIC_Point
EH_CtrlP	equ	EIC_Std

CtrlP		struc
ERLen		dword	sizeof(CtrlP)
EType		db	ET_CtrlP
EThick		db	0		;pen thickness 0->25.4 mm paper scale
EColor		dword	0		;outline color
EColor2		dword	0		;fill color
EFStyle		word	0		;0 hollow, 1 solid
ELStyle		word	0		;0 solid
EMatrl		word	0		;render material 0=plain
ELayer		word	1		;layer 0 merge 1 standard
EWidth		real4	0.0		;entity edge width (geometric)
EWPlane		word	0		;3d workplane
ETag		dword	0		;entity tag #
;
P1		GPnt3	<>		;ctrl point 1
P2		GPnt3	<>		;ctrl point 2
P3		GPnt3	<>		;ctrl point 3
;
CFlags		dword	CP_ALN+CP_CUT	;control type flags
CtrlP		ends

;	Values for CtrlP.CFlags:

CP_ALN		equ	1		;align bearing with p1->p2
CP_CUT		equ	2		;cut at p1->p2
CP_SCALEY	equ	4		;scale Y to fit
CP_UDSCALE	equ	8		;use dyntrak scale
CP_OFFSET	equ	16		;offset from place point

;	===============================================================
;	Animate Point Of View Entity
;	===============================================================

ET_APOV		equ	40
EC_APOV		equ	EIC_Point
EH_APOV		equ	EIC_Std

APOV_VER	equ	0		;structure version

APOV		struc
ERLen		dword	sizeof(APOV)
EType		db	ET_APOV
EThick		db	0		;pen thickness 0->25.4 mm paper scale
EColor		dword	0		;outline color
EColor2		dword	0		;fill color
EFStyle		word	0		;0 hollow, 1 solid
ELStyle		word	0		;0 solid
EMatrl		word	0		;render material 0=plain
ELayer		word	1		;layer 0 merge 1 standard
EWidth		real4	0.0		;entity edge width (geometric)
EWPlane		word	0		;3d workplane
ETag		dword	0		;entity tag #
;
ver		dword	APOV_VER	;APOV structure version
flags		dword	0		;animation flags
;
AtPt		GPnt3	<>		;look at point (orbit)
UpDV		GPnt3	<>		;look up direction vector
;
nSteps		dword	40		;# of steps per loop
rsvd		dword	8 dup (0)	;for expansion
;
AName		db	0		;animation path name
APOV		ends

;	The APOV entity has a sublist containing the animation
;	camera path entity

;	Values for APOV.flags:

AP_LookAt	equ	1		;look at point (orbit)

;	===============================================================
;	3d SPLINE
;	===============================================================

ET_Spline3	equ	41
EC_Spline3	equ	EIC_Linear+EIC_Curve
EH_Spline3	equ	EIC_Std

Spline3		struc
ERLen		dword	sizeof(Spline3)
EType		db	ET_Spline3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GSpline3 <>
Spline3		ends

;	===============================================================
;	3d SPOLY
;	===============================================================

ET_SPoly3	equ	42
EC_SPoly3	equ	EIC_Linear+EIC_Curve
EH_SPoly3	equ	EIC_Std

SPoly3		struc
ERLen		dword	sizeof(SPoly3)
EType		db	ET_SPoly3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GSpline3 <>
SPoly3		ends

;	SPoly3 geometry does NOT duplicate the first node

;	===============================================================
;	3d Mesh Surface
;	===============================================================

ET_MSurf	equ	43
EC_MSurf	equ	EIC_3d+EIC_Area
EH_MSurf	equ	EIC_Std

MSurf		struc
ERLen		dword	sizeof(MSurf)
EType		db	ET_MSurf
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
flags		dword	0	;1=close nCol direction
;				;2=close nRow direction
;				;4=Cubic B-Spline smoothing
;				;8=indexed, 4-int index faces follow nodes
nCols		dword	1	;# rows of nodes (or # of indexed vertices)
nRows		dword	1	;# columns of nRows of nodes (or # of faces)
;
Nodes		GPnt3	<>	;all nCol then nRow
;				;if indexed, nRows sets of 4-integer face
;				;indexes follow nCols verticies)
MSurf		ends

;	===============================================================
;	3d Coons Surface
;	===============================================================

ET_CSURF3	equ	44
EC_CSurf3	equ	EIC_Area+EIC_3d+EIC_Curve
EH_CSurf3	equ	EIC_Std

CSURF3		struc
ERLen		dword	sizeof(CSURF3)
EType		db	ET_CSURF3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
ARes		db	0	;angular resolution
LRes		db	0	;linear resolution
CSURF3		ends

;	The 4 entities in the CSURF entity's sublist define the
;	4 edges of the coons surface.

;	===============================================================
;	2d Bezier Curve
;	===============================================================

ET_Bez2		equ	45
EC_Bez2		equ	EIC_Linear+EIC_Curve
EH_Bez2		equ	EIC_Std

Bez2		struc
ERLen		dword	sizeof(Bez2)
EType		db	ET_Bez2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GBez2	<>
Bez2		ends

;	===============================================================
;	3d Bezier Curve
;	===============================================================

ET_Bez3		equ	46
EC_Bez3		equ	EIC_Linear+EIC_Curve
EH_Bez3		equ	EIC_Std

Bez3		struc
ERLen		dword	sizeof(Bez3)
EType		db	ET_Bez3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GBez3	<>
Bez3		ends

;	===============================================================
;	VIEWPORT
;	===============================================================

ET_VPort	equ	47
EC_VPort	equ	EIC_Area+EIC_Multi+EIC_3d
EH_VPort	equ	EIC_Std

VPort		struc
ERLen		dword	sizeof(VPort)
EType		db	ET_VPort
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
flags		dword	VP_Frame+VP_BkFill ;options bits
View		ViewP	<>		;view spec for viewport
ShtTag		dword	0		;tag # of sheet (0=common/all)
ShtAdr		dword	0		;address of sheet (0=unknown)
;
VPScale		real4	1.0		;fixed display scale
;
LyrOvr		dword	0	;layer overrides
;				;+ = show id
;				;- = hide id
;				;0 = end of list (merge can't hide)
VPort		ends

;	VP Flag values:

VP_Scale	equ	1	;use VPScale for view scale
VP_FitH		equ	2	;scale to fit width
VP_FitV		equ	4	;scale to fit height
VP_Frame	equ	8	;show viewport frame entities
VP_BkFill	equ	16	;background fill flag

;	The VPORT entity's sublist defines the viewport boundaries.

;	===============================================================
;	3d TEXT
;	===============================================================

ET_Text3	equ	48
EC_Text3	equ	EIC_Point+EIC_3d
EH_Text3	equ	EIC_Std

Text3		struc
ERLen		dword	sizeof(Text3)
EType		db	ET_Text3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GText3	<>
Text3		ends

;	===============================================================
;	Text Table
;	===============================================================

ET_TTable	equ	49
EC_TTable	equ	EIC_Point+EIC_3d
EH_TTable	equ	EIC_Std

TTBL_VER	equ	1	;current structure version

TTable		struc
ERLen		dword	sizeof(TTable)
EType		db	ET_TTable
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
ts		TSty	<>	;text style
origin		GPnt3	<>	;table origin (fixed corner position)
ocode		dword	0	;origin code - ulsclw,ulsclh calc from this)
;				;(0 1 2 top, 3 4 5 middle, 6 7 8 bottom)
hdv		GPnt3	<1.0,0.0,0.0>	;horizontal unit direction vector
vdv		GPnt3	<0.0,1.0,0.0>	;vertical unit direction vector
;	table size
twidth		real8	0.0	;table width (total of field widths)
theight		real8	0.0	;table height (nlines*thgt*lspace)
;	origin to upper left corner scale * twidth and theight
ulsclw		real4	0.0	;UL 0 UR -1 LL 0  LR 1  CEN -0.5
ulsclh		real4	0.0	;UL 0 UR 0  LL -1 LR -1 CEN -0.5
;
bthick		real4	0.8	;border pen thickness (mm)
tuthick		real4	0.4	;title/header underline thickness (mm)
ruthick		real4	0.2	;row underline line thickness (mm)
ttxthick	real4	0.2	;title text thickness (mm)
htxthick	real4	0.0	;header text thickness (mm)
ctxthick	real4	0.0	;column text thickness (mm)
;
ncols		dword	0	;number of columns
nrows		dword	0	;# of body lines in table
minrows		dword	1	;minimum # of rows to draw
;
txcolor		dword	-1	;title & header text color (-1 = EColor)
bkcolor		dword	-1	;background color (-1 is dwg bkgnd color)
tflags		dword	0000FFFFh 	;table flags
hws		dword	0	;internal use, must be 0
tjust		dword	1	;title justification (0,1,2 only)
rsvd1		dword	0
rsvd2		dword	0
rsvd3		dword	0
rsvd4		dword	0
rsvd5		dword	0
ver		db	TTBL_VER ;this entity's structure version
;
fname		db	MAXPATH dup (0)	;last import file path\name
TTable		ends

;	The above is followed by nfields copies of the following structure:

TField		struc
fwidth		real8	0.0	;field width
vsthick		real4	0.0	;vertical separator line thickness
ctxthick	real4	0.0	;column text thickness
color		dword	-1	;column text color
just		dword	0	;column justification (0,1,2 only)
hjust		dword	1	;header justification (0,1,2 only)
fflags		dword	0000FFFFh	;column flags
rsvd1		dword	0	;unused, must be 0
rsvd2		dword	0
rsvd3		dword	0
TField		ends

;	The above is followed by a list of ANSIZ text strings for
;	each item in the table. The table ends with a 0FFh
;	end of list marker byte. Item #0 is the table title text,
;	and the field labels are items 1..ncols. Each column in
;	a row is represented by one string, in order, possible empty.
;	Every row must have exactly ncols strings, although
;	the end marker may occur earlier if all remaining items
;	in the table are empty.

;	For vector text, the text thickness is the EThick value.

;	Values for tflags:

TTBL_HDR	equ	1	;draw labels as a header line
TTBL_BORDER	equ	2	;draw outer border outline
TTBL_VSEP	equ	4	;draw vertical field separators
TTBL_HSEP	equ	8	;draw line separators
TTBL_TITLE	equ	16	;draw table title

;	Values for fflags:

TTBL_CTXCLR	equ	10000h	;individual column text color
TTBL_CTXTK	equ	20000h	;individual column text thickness
TTBL_CHIDE	equ	40000h	;hide this column
TTBL_RNUM	equ	80000h	;this column numbers the rows

;	===============================================================
;	2d TEXT ITEM
;	===============================================================

ET_TItem2	equ	50
EC_TItem2	equ	EIC_Point
EH_TItem2	equ	EIC_Std

TItem2		struc
ERLen		dword	sizeof(TItem2)
EType		db	ET_TItem2
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
nItem		dword	0	;type of text item
nFmt		dword	0	;item format
At		GPnt2	<>	;item at
TS		TSty	<>	;text style
TItem2		ends

;	codes for nItem:

TITEM_DATE	equ	0
TITEM_TIME	equ	1
TITEM_FULLFILE	equ	2
TITEM_FILEONLY	equ	3

;	format values:

TITEM_FMTUS	equ	0

;	===============================================================
;	Card Object
;	===============================================================

ET_Card		equ	51
EC_Card		equ	EIC_Point
EH_Card		equ	EIC_Std

Card		struc
ERLen		dword	sizeof(Card)
EType		db	ET_Card
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
;
At		GPnt3	<>	;location of card center
CWidth		real8	5.0	;card size
CHeight		real8	3.0
qrot		QROT	<>	;card 3d orientation (default = XY plane)
version		word	0	;card entity version
ctype		word	CARDTYPE_TEXT	;card type id
Card		ends

;	The basic record structure is followed by a variable
;	number of item records, each of which start with
;	a dword record length. The list has a dword = 0 end marker
;	after the last item.

;	The first item record is always the card style data
;	This is general information about the type of card

;	Card0 is the default text index card type:

Card0		struc
rlen		dword	sizeof(Card0)	;item record length
id		dword	CARDSTY_OBJDOC+0 ;item is card style
flags		dword	0	;unused
;
top			real4	0.8	;top title area height	
thgt		real4	0.4	;title text height
bhgt		real4	0.4	;body text height
tcolor		dword	0ff0000h ;title text color
tbkgnd		dword	0A0A0A0h ;title background color
bcolor		dword	0000000h ;body text color
rsvd		db		64 dup (0)
Card0		ends

CARDSTY_OBJDOC	equ	0

;	Card0.id card type identifier values:

CARDTYPE_TEXT		equ	0
CARDTYPE_MACRO		equ	1
CARDTYPE_TEXTFILE	equ	2
CARDTYPE_IMAGEFILE	equ	3

;	The Card0 item is followed by 3 text items,
;	all always present and in this order:
;
;	id = 1: title text
;	id = 2: body text
;	id = 3: link text
;
;	They each have the form:

CardTxt		struct
rlen		dword	sizeof(CardTxt)	;item record length
id		dword	CARDITEM_TEXT+0	;item id number 1..3
;
;		rlen-8 bytes of ANSIZ text follows here
CardTxt		ends

CARDITEM_TEXT	equ	00010000h
CARDITEM_LINK	equ	00020000h

;	The last item is followed by a dword = 0 end of list marker

;	===============================================================
;	3d Ellipse
;	===============================================================

ET_Elp3		equ	52
EC_Elp3		equ	EIC_Linear+EIC_Area+EIC_3d+EIC_Curve
EH_Elp3		equ	EIC_Std+EIC_NUTGrow

Elp3		struc
ERLen		dword	sizeof(Elp3)
EType		db	ET_Elp3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GElp3	<>
Elp3		ends

;	===============================================================
;	3d Elliptical Arc
;	===============================================================

ET_ElA3		equ	53
EC_ElA3		equ	EIC_Linear+EIC_3d+EIC_Curve
EH_ElA3		equ	EIC_Std+EIC_NUTGrow

ElA3		struc
ERLen		dword	sizeof(ElA3)
EType		db	ET_ElA3
EThick		db	0	;pen thickness 0->25.4 mm paper scale
EColor		dword	0	;outline color
EColor2		dword	0	;fill color
EFStyle		word	0	;0 hollow, 1 solid
ELStyle		word	0	;0 solid
EMatrl		word	0	;render material 0=plain
ELayer		word	1	;layer 0 merge 1 standard
EWidth		real4	0.0	;entity edge width (geometric)
EWPlane		word	0	;3d workplane
ETag		dword	0	;entity tag #
Geo		GElA3	<>
ElA3		ends

;	===============================================================
;	Picture Definition
;	===============================================================

ET_PictDef	equ	54
EC_PictDef	equ	EIC_Point
EH_PictDef	equ	EIC_Std

;	===============================================================
;	Picture Reference
;	===============================================================

ET_PictRef	equ	55
EC_PictRef	equ	EIC_Point
EH_PictRef	equ	EIC_Std

;	===============================================================
