;	===============================================================
;	EntOps.CPY - General Entity Operations
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 23-July-1999
;	===============================================================

ShowChanges	proto	stdcall
CmdEnd		proto	stdcall
GetDrawMode	proto	stdcall
EDraw		proto	stdcall,hDWin:dword,pEntity:dword
;					;hDWin=NULL -> multiadd
ERender		proto	stdcall,hDWin:dword,pEntity:dword
;					;hDWin=single DW only
EMark		proto	stdcall,hDWin:dword,pEntity:dword
EErase		proto	stdcall,hDWin:dword,pEntity:dword
EDrawM		proto	stdcall,hDWin:dword,pEntity:dword
EPick		proto	stdcall,pEntity:dword
ETran		proto	stdcall,pEntity:dword,pTM:dword
EExtrude	proto	stdcall,pEntity:dword,pTM:dword,hDList:dword
EEdge3		proto	stdcall,pEntity:dword,hEList3:dword
ENList3		proto	stdcall,pEnt:dword,phNList3:dword,\
			LType:dword,ARes:dword,LRes:dword
ETrim		proto	stdcall,pEntity:dword,TTrim:real8,TPick:real8
EOffset		proto	stdcall,pEntity:dword,pODist:dword,pCallback:dword
EEdit		proto	stdcall,pEntity:dword
;	Return 0 normally, 1 if no CMDEND should follow
EDynEdit	proto	stdcall,pEntity:dword
;	Return 0 normally, 1 if no CMDEND should follow
EAct		proto	stdcall,pEntity:dword,ACode:dword
EPlace		proto	stdcall,pEntity:dword,pPSpec:dword
EStdPlace	proto	stdcall,pEnt:dword,pPSpec:dword
EExplode	proto	stdcall,pEntity:dword,pCallback:dword
EMake3d		proto	stdcall,pEntity:dword
;	Return 0 if no change, new address if entity revised
EGet		proto	stdcall,pEntity:dword,GType:dword,\
			pParm:dword,pResult:dword

EXCheck		proto	stdcall,pEntity:dword,pXT:dword
GXCheckP2	proto	stdcall,pPoint:dword,pXT:dword
GXCheckP2S	proto	stdcall,pXT:dword
;
EList		proto	stdcall,pEntity:dword
EInfo		proto	stdcall,pEntity:dword,nAsk:dword
ESplit		proto	stdcall,pEntity:dword,T:real8,\
			ppNew1:dword,ppNew2:dword
EBreak		proto	stdcall,pEntRec:dword,pCLine3:dword
ETMake		proto	stdcall,pEntRec:dword,pTfrom:dword,pTto:dword

EStretch	proto	stdcall,pEntity:dword

StrP2		proto	stdcall,pGPnt2:dword
StrP3		proto	stdcall,pGPnt3:dword

SetStrWin	proto	stdcall,hDW:dword,pPtA3:dword,pPtB3:dword

DynEditFinish	proto	stdcall

EDRAW		equ	0		;0:draw the entity
EXCHECK		equ	1		;1:extents check the entity
EINFO		equ	2		;2:Get entity information
ELIST		equ	3		;3:list the entity info
EPICK		equ	4		;4:Pick test the entity
EEDGE3		equ	5		;5:Add edges to EList3 object
ENLIST3		equ	6		;6:Add nodes to NList3 object
EGET		equ	7		;7:Get entity data
ERENDER		equ	8		;8:draw entity in OpenGL window
ETRAN		equ	9		;9:translate entity
ESTRETCH	equ	10		;10:stretch entity
EEXTRUDE	equ	11		;11:Extrude entity along 3d vector
ETRIM		equ	12		;12:Trim Entity
EEXPLODE	equ	13		;13:Explode Entity
EMAKE3D		equ	14		;14:Make entity 3d
ESPLIT		equ	15		;15:Split entity at T
EOFFSET		equ	16		;16:Offset entity
EEDIT		equ	17		;17:Edit (dialog) entity
EDYNED		equ	18		;18:Dynamic Edit
EACT		equ	19		;19:Actuate entity
EPLACE		equ	20		;20:Place SmartSym
ETMAKE		equ	21		;21:make clone from Tfrom .. Tto

;	EINFO Ask Codes:

EI_EName	equ	0		;0 = get entity name string adr
EI_Class	equ	1		;1 = get entity class flags
EI_Caps		equ	2		;2 = get entity capabilities flags

;	ENLIST3 LType Codes:

EN_3d		equ	0		;0 = return 3d point list
EN_3dDV		equ	1		;1 = return 3d point,direction vec
;					;    to the "outside"

;	EGET GType codes:

EGET_TP3	equ	0		;get point along entity
;					;pParm->Real8 0..1 parameter
;					;pResult->GPnt3 structure

EGET_L3T	equ	1		;get nearest point on entity
;					;to the pParm->GLine3 (Real8s)
;					;pResult->qword T value

EGET_P3T	equ	2		;get nearest point on entity
;					;to the pParm->GPnt3 (Real8s)
;					;pResult->qword T value

EGET_EPT3	equ	3		;get nearest endpoint
;					;to the pParm->qword T value
;					;pResult->GPnt3 structure

EGET_CEN3	equ	4		;get center. If none, get T=0.5 point
;					;pResult->GPnt3 structure

EGET_LEN	equ	5		;get total length of entity
;					;pResult -> Real8 length destination

EGET_TAN3	equ	6		;get tangent at T on entity
;					;pParm->Real8 0..1 parameter
;					;pResult->GPnt3 structure

EGET_DIST	equ	7		;get T at distance along entity
;					;pParm->Real8 distance from T=0
;					;pResult->qword T value

EGET_SEG	equ	8		;get segment adrs containing T
;					;pParm->Real8 0..1 parameter
;					;pResult-> dword ptr to segment
;					;EAX return =2 for 2d, 3 for 3d
;					;EAX = 0, carry set if not valid

EGET_BRNG3	equ	9		;get point on entity at bearing
;					;pParm->Real8 0..2pi bearing
;					;pResult->GPnt3 structure

EGET_CURVE	equ	10		;get curvature at T
;					;pParm->Real8 0..1 parameter
;					;pResult-> Real8 curvature
;					;EAX = 0, carry set if not valid

EGET_AREA	equ	11		;get total area of entity
;					;pResult -> Real8 area destination

EGET_PKSEG	equ	12		;get segment adrs for seg that
;					;passes current pick test
;					;and is closest to the surface
;					;of the pick window.
;					;This is used to provide "dual"
;					;behavior for 3d polys for modifiers
;					;pParm not used
;					;pResult-> dword ptr to segment
;					;EAX return =2 for 2d, 3 for 3d
;					;EAX = 0, carry set if not valid

;	GetDrawMode values:

DM_DRAW		equ	0
DM_MARK		equ	1
DM_ERASE	equ	2

;	EAct ACode values:

ACT_HITTEST	equ	0
ACT_TOOLTIP	equ	1
ACT_START	equ	2

