/////////////// DLMGR.H - Drawing List Access - FastCAD-7 ////////////////
//
//	Written by Mike Riddle 4-Nov-1999
//	(C)1999 Evolution Computing
//	All rights reserved
//
//////////////////////////////////////////////////////////////////////////

#ifndef _DLMGR_H_
#define _DLMGR_H_


// 	Values for DList.flags:

#define DL_STD		1				// standard drawing list
#define DL_SubL		0x40		// this DList is a sublist
#define DL_Head		0x80		// all DLists have this set
								 					// to identify the end of list
								 					// No ECTL.flags ever has it set
#define DL_Private	2			// private use DList (no draw)
#define DL_XREF			4			// XREF overlay file
#define DL_RO				8			// DList is read-only
#define DL_SEP		 16			// Separate drawing
								 					// (main OPEN is also DL_STD)
#define DL_CHANGED 0x100	// dlist has been changed

struct IDList
{
  virtual void __stdcall DLDestroy(void) = 0;
  virtual pENTREC __stdcall DLApnd(void* pEntRec) = 0;
  virtual pENTREC __stdcall DLApndE(int etcode,int nbytes) = 0;
  virtual pENTREC __stdcall DLClone(void* pEntRec) = 0;
  virtual void __stdcall DLErase(void* pEntRec) = 0;
  virtual void __stdcall DLUnErase(void* pEntRec) = 0;
  virtual pENTREC __stdcall DLReplace(void* pOLD,void* pNEW) = 0;
  virtual void __stdcall DLDelete(void* pEntRec) = 0;
  virtual pENTREC __stdcall DLResize(void* pEntRec,int) = 0;
  virtual int __stdcall DLSave(void) = 0;
  virtual int __stdcall DLLoad(void) = 0;
  virtual int __stdcall DLScan(void* EntProc,int DSFlags, void* parm1, void* parm2) = 0;
  virtual void __stdcall DLEmpty(void) = 0;
  virtual void __stdcall DLRename(char*) = 0;
  virtual void __stdcall DLSelect(void* pEntRec) = 0;
  virtual void __stdcall DLUnSelect(void* pEntRec) = 0;
  virtual BOOL __stdcall DLAskSelected(void* pEntRec) = 0;
  virtual IDList* __stdcall DLMakeSublist(void* pEntRec) = 0;
  virtual IDList* __stdcall DLGetSublist(void* pEntRec) = 0;
  virtual void __stdcall DLReleaseSublist(void) = 0;
  virtual void __stdcall DLMark(void* pEntRec,int MFlag) = 0;
  virtual void __stdcall DLUnMark(void* pEntRec,int MFlag) = 0;
  virtual BOOL __stdcall DLAskMarked(void* pEntRec,int MFlag) = 0;
  virtual pENTREC __stdcall DLDup(void* pEntRec) = 0;
  virtual pENTREC __stdcall DLMoveB(void* pBefore, void* pEnt) = 0;
  virtual pENTREC __stdcall DLMoveA(void* pAfter, void* pEnt) = 0;
  virtual void __stdcall DLMarkUndo(void) = 0;
  virtual pENTREC __stdcall DLCopy(void* pEntRec) = 0;

  virtual BOOL __stdcall DLAskErased(void* pEntRec) = 0;		// ask if record is Erased
  virtual pENTREC __stdcall DLGetNext(void* pEntRec) = 0;		// get next record
  virtual pENTREC __stdcall DLGetPrev(void* pEntRec) = 0;		// get previous record
  virtual char* __stdcall DLGetFileName(void) = 0;				// get DList file name
  virtual void* __stdcall DLGetIBAdr(int IBNumber) = 0;			// Get Infoblock Address

  virtual void* __stdcall DListChkIBRec(void* pEntRec) = 0;		// Set Infoblock Address
  virtual void __stdcall DListOnClose(void* pProc,void* pData) = 0; //Spec DL Destroy PreCall
  virtual void __stdcall DListDelSubList(void* pEntRec) = 0;	// Delete entity's sublist
  virtual void __stdcall DListPack(void) = 0;					// Remove all undos fro DList
  virtual void* __stdcall DListSetCurSheet(void* pEntRec) = 0;	// Specify Current Sheet
  virtual pENTREC __stdcall DListGetScanSheet(void) = 0;		// DLScan into what sheet?
  virtual void __stdcall DListNoUndo(void* pEntRec) = 0;		// change to record can not undo
  virtual BOOL __stdcall DListAskChanged(void) = 0;				// Ask if file needs saving
  virtual void __stdcall DListSetChanged(void) = 0;				// Set file needs saving
  virtual void __stdcall DListClrChanged(void) = 0;				// Clear file needs saving
  virtual BOOL __stdcall DLAskEmpty(void) = 0;					// return TRUE if DList is empty
  virtual void __stdcall DListCopyOpLevel(IDList* hFromList) = 0; //Copy OpLevel from other DList
  virtual void* __stdcall DListAskOnClose(void) = 0;			// Get on close proc adrs
  virtual IDList* __stdcall DListGetLayout(void) = 0;			// Get layout sheet sublist if current sheet is layout
  virtual int __stdcall DListScanLayout(void* EntProc,int DSFlags, void* parm1, void* parm2) = 0; // Scan all or current layout
  virtual void __stdcall DListScanStop(void* pEntRec) = 0;		// stop scan at record
  virtual pENTREC __stdcall DListLastSelected(void) = 0;		// return last outer record selected for use with scanstop
  virtual void __stdcall DListNotThisOpLvl(void) = 0;			// Set scan ignore current oplvl records
  virtual void __stdcall DListThisOpLvlOk(void) = 0;			// Clear scan ignore current oplvl records
  virtual pENTREC __stdcall DLAskSubList(void* pEntRec) = 0;	// ask if entity has non-empty sublist
  virtual BOOL __stdcall DListValidate(void) = 0;				// return false if the list has no errors
};

//////////////////////////////////////////////////////////////////////////

IDList* _stdcall CreateDList(char*,int);
IDList* _stdcall GetWorkDL(void);

IDList** _stdcall GetDLMaster(void);

//AskValidDL	proto	stdcall,hDList:dword
//FlushDLExcept	proto	stdcall,hDLKeep:dword

//////////////////////////////////////////////////////////////////////////
// The C prototype for a DLScan EntProc function is:
//
// SCANPROC __stdcall ProcRec(IDList* hDList,
//                            pENTREC pEntRec, PARM parm1, PARM parm2)
// {
//	return 0;	// non-zero return ends the scan, and is
//			// returned from DLScan.
// }

typedef int (XPCALL *SCANCALLBACK)(IDList* hDList,
			pENTREC pEntRec,int parm1,int parm2);

//////////////////////////////////////////////////////////////////////////

//	Values currently valid for DLScan's DLFlags parameter:

#define	DLS_Sel			0x10000	// exclude non-selected entities
#define	DLS_NotSel	0x20000	// only unselected entities
#define	DLS_RO			0x40000	// allow read-only entities
#define	DLS_Erased	0x80000	// allow erased entities
#define	DLS_SL			0x01000	// scan sublist after owning entity
#define DLS_Undo		0x02000	// undo logic scan (internal use only!)
#define DLS_SeeXR		0x04000	// see overlay XREF (before expand)
#define DLS_NoXRX		0x08000	// no overlay XREF expand

#define DLS_SHEETS	0x00800	// See sheets instead of scan their sublist
#define DLS_HSHTOK	0x00400	// Ok to process hidden sheets

#define DLS_Std 		0	// standard all non-erased entities
#define	DLS_Edit		DLS_Std+DLS_Sel
#define	DLS_Info		DLS_Edit+DLS_RO
#define	DLS_All			DLS_Std+DLS_SL



//////////////////////////////////////////////////////////////////////////
#endif