// 	===============================================================
// 	DIALOG.CPY - Dialog box macros and definitions
// 	===============================================================
// 	Copyright 1999 Michael Riddle
// 	All rights reserved
// 	Written by Mike Riddle 1-9-99
// 	===============================================================

#ifndef _DIALOG_H_
#define _DIALOG_H_

// ===================================================================
//	v6-style dialog functions
// ===================================================================

#define hDLG void*		// dialog handle

#define XPDlog _XPDlog
int _stdcall XPDlog(hDLG pDlg,HINSTANCE hMod,int parm);

#define VCF_INVALID		1	// data is invalid
#define VCF_ENDDIALOG	2	// dialog should end
#define VCF_DBLCLICK	4	// item has been double-clicked

#define pDLGINIT void*
#define pDLGEND int*
#define pDLGDRAW void*
//#define pDLGVALID int*
typedef int (_stdcall *pDLGVALID)(void);
typedef int (_stdcall *pDLGCMD)(void);

hDLG _stdcall DefDlg(LPSTR DlgName,int Opts,int Hlp,\
		     pDLGINIT pInitF, pDLGEND pEndF, LPSTR CustHlp);

#define EDCTL _EDCTL
#define CHKCTL _CHKCTL
#define RBCTL _RBCTL
#define BTNCTL _BTNCTL
#define LSTCTL _LSTCTL
#define CMBCTL _CMBCTL

void _stdcall EDCTL(hDLG hDlg,int id,int Opt,int flags,int width,
		    void* VData,pDLGVALID pValidF);

void _stdcall CHKCTL(hDLG hDlg,int id,int Opt,int flags,
		    void* VData, int Mask, pDLGCMD pCmdF);

void _stdcall RBCTL(hDLG hDlg,int id,int Opt,int flags,
		    void* VData, int RetCode, pDLGCMD pCmdF);

void _stdcall BTNCTL(hDLG hDlg,int id,int Opt,int flags,
		     pDLGCMD pCmdF, pDLGDRAW pDrawF);

void _stdcall LSTCTL(hDLG hDlg,int id,int Opt,int flags,void* VData,
		     LPSTR VList,pDLGVALID pValidF,pDLGDRAW pDrawF);

void _stdcall CMBCTL(hDLG hDlg,int id,int Opt,int flags,void* VData,
		     LPSTR VList,pDLGVALID pValidF,pDLGDRAW pDrawF);

void _stdcall RelDlg(hDLG pDlg);

// ===================================================================

int _stdcall Dialog(hDLG pDlgCtl, HINSTANCE hModHdl, DWORD pBase);
void _stdcall InitDialogHelp(DWORD pCallback, DWORD nMsg);

void _stdcall HideCtl(DWORD nCtrl);
void _stdcall ShowCtl(DWORD nCtrl);
void _stdcall DsAbCtl(DWORD nCtrl);
void _stdcall EnAbCtl(DWORD nCtrl);
void _stdcall FocusCtl(DWORD nCtrl);
void _stdcall UpdCtlA(void);
void _stdcall UpdCtl(DWORD nCtrl);
void _stdcall SetCtlText(DWORD nCtrl, DWORD pText);
void _stdcall SetDlgTitle(DWORD pText);
void _stdcall ClrLstStr(DWORD nCtrl);
DWORD _stdcall AddLstStr(DWORD nCtrl, char *pStg);
DWORD _stdcall FndLstStr(DWORD nCtrl, char *pStg);
DWORD _stdcall GetLstStr(DWORD nCtrl, char *pStg);
void _stdcall GetLstStrN(DWORD nCtrl, DWORD nWant, char *pStg);
void _stdcall SetLstData(DWORD nCtrl, DWORD nItem, DWORD iData);
DWORD _stdcall GetLstData(DWORD nCtrl, DWORD nItem);
void _stdcall ClrCmbStr(DWORD nCtrl);
DWORD _stdcall AddCmbStr(DWORD nCtrl, char *pStg);
DWORD _stdcall FndCmbStr(DWORD nCtrl, char *pStg);
void _stdcall GetCmbStr(DWORD nCtrl, char *pStg);
void _stdcall SetCmbData(DWORD nCtrl, DWORD nItem, DWORD iData);
DWORD _stdcall GetCmbData(DWORD nCtrl, DWORD nItem);
HWND _stdcall GetDlgWin(void);
void _stdcall GetDlgDig(DWORD id, DWORD lppnt);
void _stdcall GetLstMSel(DWORD nCtrl, DWORD pSel, DWORD nMax);

// 	===============================================================
// 	The Dialog Control Table (pDlgCtl in Dialog call)
// 	===============================================================
// 
// 	This table starts with a dialog box header (SDlg) structure,
// 	followed by an ANSIZ dialog resource name,
// 	followed by none or more control packet (DCtrl) structures,
// 	ending with an ENDDLG macro (one word = 0).
// 

typedef int (_stdcall *DLGCBPROC)(void);


// 	---------------------------------------------------------------
// 	Dialog box header
// 	---------------------------------------------------------------

typedef struct
{
	DWORD			chain;			// offset of control data
	DWORD			Options;		// dialog box options
	DWORD			HlpCntxt;		// Help context number
	DLGCBPROC	InitCF;			// WM_INITDIALOG callback
	DLGCBPROC	EndCF;			// WM_DESTROY callback
	char      *HlpFile;		// optional custom help file
	char			DlgName[1];	// Resource name
}SDLG;

// 	---------------------------------------------------------------
// 	Dialog box control packet
// 	---------------------------------------------------------------

typedef struct
{
	WORD			CType;				// type
	WORD			Id;						// control Id
	WORD			Flags;		
	WORD			Options;		
	DWORD			Wdth;		
	DWORD			MaxVal;				// Max for Comm Ctrls
	DWORD			MinVal;				// Min for Comm Ctrls
	void			*Data1;				// data pointers
	void			*Data2;		
	DLGCBPROC	CB1;					// callback functions
	DLGCBPROC	OwnerDraw;		
}DCTRL;



// 	===============================================================
// 	Definitions
// 	===============================================================

// 		Dialog Option flags

#define DO_PRBAR		1
#define DO_MODELESS	2

// 		Control types

#define CT_EDIT 		 1
#define CT_CMB			 2
#define CT_CHK			 3
#define CT_LST			 4
#define CT_BTN			 5
#define CT_RB				 6
#define CT_BM				 7
#define CT_EDITUD		 8
#define CT_COLORPK	 9
#define CT_PATED		10
#define CT_PB				11
#define CT_PATED32	12

#define UDCtl_Offset	0x00010000
#define TBCtl_Offset	0x00020000
#define PBCtl_Offset	0x00030000

// 		Control Option flags

#define CO_CBOnKey	1				//  callback after each key press in edit/combo box item
#define CO_NoSel	2					//  do not initially select text in edit item
#define CO_Undet	4					//  Undetermined value - display grey check in check, 
														//  blank edit field etc
#define CO_BMVert	8					//  display bitmap over text in bitmap button
#define CO_EndDlg	16				// end dialog on control pick (buttons)
			  
// 		Validation callback flags

#define VCF_INVALID		1		// data is invalid
#define VCF_ENDDIALOG	2		// dialog should terminate
#define VCF_DBLCLICK	4		// item has been double clicked

// 		Combo Box callback functionality flags passed on esi
//  callback, eax:CBFlags, ebx:ctl ID. esi:fcf. on the return, eax:err code

#define FCF_EDEnd	16		// calling from edit updated
#define FCF_OnKey	17		// calling from key pressed
#define FCF_KF		18		// calling from kill focus
#define FCF_SC    19    // calling from sel change

// 	===============================================================
// 	Control IDs: Each control has an ID assigned in the
// 		resource file.
// 	===============================================================
// 
// 	Programmer defined ID's must be  100, < 256.

// 	These IDs are pre-defined in win32equ.inc:
// 
// 		IDOK
// 		IDCANCEL
// 		IDABORT
// 		IDRETRY
// 		IDIGNORE
// 		IDYES
// 		IDNO
// 		IDCLOSE
// 		IDHELP
// 
// 	ID = -1 means static control (text labels etc.)


// 	===============================================================
// 	Structures
// 	===============================================================

typedef struct
{
	char *lpCaption;		// caption on PSheet
	DWORD	nPages;				// # of pages
	DWORD	nStartPage;		// start page #
	DWORD	Options;			// options for PSheet
	DWORD	hwndPS;				// hwnd of PSheet window
}PSDATA;

typedef struct
{
	DWORD	chain;				// offset of control data
	DWORD	Options;			// dialog box options
	DWORD	HlpCntxt;			// Help context number
	DWORD	InitCF;				// WM_INITDIALOG callback
	DWORD	EndCF;				// WM_DESTROY callback
	DWORD	HlpFile;			// optional custom help file

//  above is same as SDlg struct.

	DWORD	lpRes;				// resource dlg name for the page
	DWORD	lpszTab;			// title(tab) of the page
	DWORD	pPSN_CB;			// callback for page notifications
	DWORD	hwndPSP;			// hwnd for the dlg
	DWORD	pNxtPage;			// pointer to next page
}PSPAGEDATA;

// 	===============================================================
// 
// 	Dialog box header macro
// 
// 	Parameters:
// 
// 		Rsc		Resource name
// 
// 		Opts		Dialog box option flags
// 					Supported: None
// 
// 		Hlp		Help context number (0=contents pg)
// 
// 		InitCF		Callback (ENTRY/EXIT)
// 				Dialog is being initialized.
// 				(message: WM_INITDIALOG)
// 
// 		EndCF		Callback (ENTRY/EXIT)
// 				Dialog is about to close.
// 				Entry:	ax=button id (e.g. IDOK)
// 				Return: ax=0 to allow close,
// 					ax=1 to stop close.
// 				(message: WM_DESTROY)
// 		HlpF		optional custom help file
// 	---------------------------------------------------------------
/*
DLG		macro	Rsc,Opts,Hlp,InitCF,EndCF,HlpF
		local	fin
		SDlg	<fin,Opts,Hlp,InitCF,EndCF,HlpF>
		db	Rsc,0
fin		label	byte
		endm

// 	---------------------------------------------------------------
// 	ENDDLG - Dialog control list termination macro
// 	---------------------------------------------------------------

ENDDLG		macro
		dw	0
		endm

// 	---------------------------------------------------------------
// 	Dialog edit control macro
// 
// 	Parameters:
// 
// 		Id		Control ID 
// 
// 		Options 	Edit options. Supported:
// 					CO_CBOnKey,CO_NoSel
// 
// 		Flags		Data address codes FT_Ptr or FT_EBX
// 				plus Format data type codes. Supported:
// 					T_Real4,T_Dist,T_Brng,T_AngW
// 
// 		Width		Max character count user can
// 					type into the control
// 
// 		VData		Pointer to the data to be modified
// 
// 		ValidCF 	Callback (ENTRY/EXIT)
// 				Item is losing input focus.
// 				Validate or change data.
// 				Entry:	esi -> data
// 					bx=item id
// 					eax=flags (VCF_INVALID, etc.) 
// 				Exit:	eax=flags (VCF_INVALID, VCF_ENDDIALOG)
// 
// 	Notes:	1.	To right justify numbers in an edit control,
// 			set both MULTILINE and RIGHT JUSTIFY on in the
// 			dialog box editor
// 	---------------------------------------------------------------

EDCTL		macro	Id,Options,Flags,Wdth,VData,ValidCF
		DCtrl	<CT_EDIT,Id,Flags,Options,Wdth,0,0,\
			VData,0,ValidCF>
		endm

// 	---------------------------------------------------------------
// 	Dialog edit control with spin ctrl macro
// 
// 	Parameters:
// 
// 		Id		Control ID 
// 
// 		Options 	Edit options. Supported:
// 					CO_CBOnKey,CO_NoSel
// 
// 		Flags		Data address codes FT_Ptr or FT_EBX
// 				plus Format data type codes. Supported:
// 					T_Real4,T_Dist,T_Brng,T_AngW
// 
// 		Width		Max character count user can
// 					type into the control
// 
// 		VData		Pointer to the data to be modified
// 		
// 		MaxVal		Max value of Spin Ctrl
// 		
// 		MinVal		Min value of Spin Ctrl
// 
// 		ValidCF 	Callback (ENTRY/EXIT)
// 				Item is losing input focus.
// 				Validate or change data.
// 				Entry:	esi -> data
// 					bx=item id
// 					eax=flags (VCF_INVALID, etc.)
// 				Exit:	eax=flags (VCF_INVALID, VCF_ENDDIALOG)
// 
// 	Notes:	1.	To right justify numbers in an edit control,
// 			set both MULTILINE and RIGHT JUSTIFY on in the
// 			dialog box editor
// 	---------------------------------------------------------------

EUDCTL		macro	Id,Options,Flags,Wdth,MaxVal,MinVal,VData,ValidCF
		DCtrl	<CT_EDITUD,Id,Flags,Options,Wdth,MaxVal,MinVal,\
			VData,0,ValidCF>
		endm

// 	---------------------------------------------------------------
// 	Dialog combo box control macro
// 
// 	Parameters:
// 
// 		Id		Control Id. 
// 
// 		Options 	Combo box options. Supported:
// 					None
// 
// 		Flags		Format data type codes. Supported:
// 					None
// 
// 		VData		Pointer to a word indicating
// 					position in combo box of
// 					currently selected string. 
// 
// 		LData		Pointer to list of strings to display
// 					(You can point to a null string
// 					and build the list at runtime
// 					with AddCmbStr)
// 
// 		ValidCF 	Callback (ENTRY/EXIT)
// 				Item is losing input focus.
// 				Validate or change data.
// 				Entry:	esi -> data
// 					bx=item id
// 					eax=flags (see callback flags)
// 					    (0 = data valid)
// 					esi=FCF flags (FCF_SC = picked)
// 						      (FCF_KF = focus chg)
// 				Exit:	eax=flags
// 					(Only VCF_INVALID or VCF_ENDDIALOG
// 					will be respected)
// 
// 		DrawCF		Callback (ENTRY/EXIT)
// 				Item needs to be drawn or measured
// 				Entry:	ax=0 if requesting item draw
// 					    then ES:di->DRAWITEMSTRUCT
// 					ax=1 if requesting list item
// 					    measure (combo and lists only)
// 					ax=2 if requesting edit box
// 					    measure (combo box only)
// 				Exit:	Measure values are returned in ax.
// 
// 	Notes:	1.	Currently, all combo boxes must be of
// 			sub-type CBS_DROPDOWNLIST
// 	---------------------------------------------------------------

CMBCTL		macro	Id,Options,Flags,VData,VList,ValidCF,DrawCF
		DCtrl	<CT_CMB,Id,Flags,Options,0,0,0,VData,\
			VList,ValidCF,DrawCF>
		endm

// 	---------------------------------------------------------------
// 	Dialog list box control macro
// 
// 	Parameters:
// 
// 		Id		Control Id. 
// 
// 		Options 	List options. Supported:
// 					None
// 
// 		Flags		Format data type codes. Supported:
// 					None
// 
// 		VData		Pointer to a word indicating
// 					position in list of
// 					currently selected string. 
// 
// 		LData		Pointer to list of strings to display
// 					(You can point to a null string
// 					and build the list at runtime
// 					with AddLstStr)
// 
// 		ValidCF 	Callback (ENTRY/EXIT)
// 				Item is losing input focus.
// 				Validate or change data.
// 				Entry:	esi -> data
// 					bx=item id
// 					eax=flags (see callback flags)
// 					    (0 = data valid)
// 					esi=FCF flags (FCF_SC = picked)
// 						      (FCF_KF = focus chg)
// 				Exit:	eax=flags
// 					(Only VCF_INVALID or VCF_ENDDIALOG
// 					will be respected)
// 
// 		DrawCF		Callback (ENTRY/EXIT)
// 				Item needs to be drawn or measured
// 				Entry:	ax=0 if requesting item draw
// 					    then ES:di->DRAWITEMSTRUCT
// 					ax=1 if requesting list item
// 					    measure (combo and lists only)
// 					ax=2 if requesting edit box
// 					    measure (combo box only)
// 				Exit:	Measure values are returned in ax.

// 	Notes:	1.	Set NOTIFY off in the dialog box editor unless
// 			you want ValidCF to be called every time the
// 			cursor bar is moved.
// 	---------------------------------------------------------------

LSTCTL		macro	Id,Options,Flags,VData,VList,ValidCF,DrawCF
		DCtrl	<CT_LST,Id,Flags,Options,0,0,0,VData,\
			VList,ValidCF,DrawCF>
		endm

// 	---------------------------------------------------------------
// 	Dialog check box control macro
// 
// 	Parameters:
// 
// 		Id		Control Id. 
// 
// 		Options 	Check box options. Supported:
// 					None
// 
// 		Flags		Data address codes FT_Ptr or FT_EBX
// 
// 		VData		Pointer to the data to be modified
// 
// 		Mask		Bit mask for destination
// 
// 		CmdCF		Callback (ENTRY/EXIT)
// 				Item has been pressed/activated
// 				Entry:	bx=item id
// 				Exit:	eax=flags
// 					(Only VCF_ENDDIALOG will be respected)
// 	---------------------------------------------------------------

CHKCTL		macro	Id,Options,Flags,VData,Mask,CmdCF
		DCtrl	<CT_CHK,Id,Flags,Options,0,0,0,\
			VData,Mask,CmdCF>
		endm

// 	---------------------------------------------------------------
// 	Dialog Color pick box control macro
// 
// 	Parameters:
// 
// 		Id		Control Id. 
// 
// 		Options 	Color pick box options. Supported:
// 					None
// 
// 		Flags		Data address codes FT_Ptr or FT_EBX
// 
// 		VData		Pointer to the color data to be modified
// 
// 		CmdCF		Callback (ENTRY/EXIT)
// 				Item has been pressed/activated
// 				Entry:	bx=item id
// 				Exit:	eax=flags
// 					(Only VCF_ENDDIALOG will be respected)
// 	---------------------------------------------------------------

CLRCTL		macro	Id,Options,Flags,VData,CmdCF
		DCtrl	<CT_COLORPK,Id,Flags,Options,0,0,0,\
			VData,0,CmdCF>
		endm

// 	---------------------------------------------------------------
// 	Pattern Edit control macro
// 
// 	Parameters:
// 
// 		Id		Control Id. 
// 
// 		Options 	Pattern edit options. Supported:
// 					None
// 
// 		Flags		Data address codes FT_Ptr or FT_EBX
// 
// 		VData		Pointer to the 8x8 pattern to be modified
// 
// 		CmdCF		Callback (ENTRY/EXIT)
// 				Item has been pressed/activated
// 				Entry:	bx=item id
// 				Exit:	eax=flags
// 					(Only VCF_ENDDIALOG will be respected)
// 	---------------------------------------------------------------

PEDCTL		macro	Id,Options,Flags,VData,CmdCF
		DCtrl	<CT_PATED,Id,Flags,Options,0,0,0,\
			VData,0,CmdCF>
		endm

// 	---------------------------------------------------------------
// 	DWord Pattern Edit control macro
// 
// 	Parameters:
// 
// 		Id		Control Id. 
// 
// 		Options 	Pattern edit options. Supported:
// 					None
// 
// 		Flags		Data address codes FT_Ptr or FT_EBX
// 
// 		VData		ptr-> 32-bit pattern to be modified
// 
// 		CmdCF		Callback (ENTRY/EXIT)
// 				Item has been pressed/activated
// 				Entry:	bx=item id
// 				Exit:	eax=flags
// 					(Only VCF_ENDDIALOG will be respected)
// 	---------------------------------------------------------------

PEDCTLD		macro	Id,Options,Flags,VData,CmdCF
		DCtrl	<CT_PATED32,Id,Flags,Options,0,0,0,\
			VData,0,CmdCF>
		endm

// 	---------------------------------------------------------------
// 	Dialog button control macro
// 
// 	Parameters:
// 
// 		Id		Control Id. 
// 
// 		Options 	Button options. Supported:
// 					CO_EndDlg end dialog when picked
// 
// 		CmdCF		Callback (ENTRY/EXIT)
// 				Item has been pressed/activated
// 				Entry:	bx=item id
// 				Exit:	eax=1 to close dialog
// 
// 		DrawCF		Callback (ENTRY/EXIT)
// 				Item needs to be drawn or measured
// 				Entry:	eax=0 if requesting item draw
// 					    then EDI->DRAWITEMSTRUCT
// 					eax=1 if requesting list item
// 					    measure (combo and lists only)
// 					eax=2 if requesting edit box
// 					    measure (combo box only)
// 				Exit:	Measure values are returned in eax.
// 	---------------------------------------------------------------

BTNCTL		macro	Id,Options,Flags,CmdCF,DrawCF
		DCtrl	<CT_BTN,Id,Flags,Options,0,0,0,\
			0,0,CmdCF,DrawCF>
		endm

// 	---------------------------------------------------------------
// 	Dialog radio button control macro
// 
// 	Parameters:
// 
// 		Id		Control Id. 
// 
// 		Options 	Radio button options. Supported:
// 					None
// 
// 		Flags		Data address codes FT_Ptr or FT_EBX
// 				FT_UDec1 can be used to spec 1-byte data
// 				else, dword data assumed.
// 
// 		VData		Pointer to the data to be modified
// 
// 		RetCode 	Data returned when this button selected
// 
// 		CmdCF		Callback (ENTRY/EXIT)
// 				Item has been pressed/activated
// 				Entry:	bx=item id
// 				Exit:	ax=1 to close dialog
// 	---------------------------------------------------------------

RBCTL		macro	Id,Options,Flags,VData,RetCode,CmdCF
		DCtrl	<CT_RB,Id,Flags,Options,0,0,0,\
			VData,RetCode,CmdCF>
		endm

// 	---------------------------------------------------------------
// 	Dialog bitmap button control macro
// 
// 	Parameters:
// 
// 		Id		Control Id. 
// 
// 		Options 	Button options. Supported:
// 					None
// 
// 		CmdCF		Callback (ENTRY/EXIT)
// 				Item has been pressed/activated
// 				Entry:	bx=item id
// 				Exit:	ax=1 to close dialog
// 
// 	Note:	The button must be declared owner draw in the resource
// 	---------------------------------------------------------------

BMCTL		macro	Id,Options,Flags,hBitmap,CmdCF
		DCtrl	<CT_BM,Id,Flags,Options,0,0,0,\
			hBitmap,0,CmdCF,0>
		endm

// 	---------------------------------------------------------------
// 	Dialog progress bar control macro
// 
// 	Parameters:
// 
// 		Id		Control Id. 
// 
// 		Options 	Button options. Supported:
// 					None
// 
// 	---------------------------------------------------------------

PBCTL		macro	Id,Options,Flags
		DCtrl	<CT_PB,Id,Flags,Options,0,0,0,\
			0,0,0,0>
		endm

// 	===============================================================
// 	Property Sheets
// 	===============================================================
// 	The property sheet size is determined by the size of the 1st
// 	page dialog resource template.
// 	---------------------------------------------------------------
// 	PSHEET - PropSheet Header macro
// 
// 	Parameters:
// 
// 		caption		Prop sheet title text adrs/rscid
// 
// 		npages		Number of pages
// 
// 		start page	Index of page to display on start (0..n-1)
// 
// 		Options		Currently support NoApplyBtn 
// 
// 		pCB		Callback when APPLY btn pressed 
// 				without options set NoApply
// 
// 	---------------------------------------------------------------
PSHEET		macro	caption,npages,startpage,option,CB
		PSData	<caption,npages,startpage,option,CB>
		endm

// 	---------------------------------------------------------------
// 	PSPAGE - PropSheet page data macro
// 
// 	Parameters:
// 
// 		res		Resource template name for
// 				the page dialog
// 
// 		caption 	Tab caption on the page
// 
// 		Opts		Options, currently set 0
// 
// 		Hlp		help #
// 
// 		InitCB		Callback when initialize 
// 
// 		EndCB		Callback when closing
// 
// 		FocusCB		Callback for page notification
// 				(currently called on PSN_APPLY 
// 				and PSN_SETACTIVE)
// 				Entry: edi = notification (PSN_*)
// 
// 		HlpF		help file
// 	---------------------------------------------------------------

PSPAGE		macro	res,caption,Opts,Hlp,InitCB,EndCB,NotifyCB,HlpF
		local	fin, resname
		PSPageData <fin,Opts,Hlp,InitCB,EndCB,HlpF,\
		resname,caption,NotifyCB>
resname		db	res,0
fin		label	byte
		endm
*/
// 	===============================================================
// 	Special purpose, predefined dialogs
// 	===============================================================

// 	---------------------------------------------------------------
// 	TDLG packet for SVC TEdit (Text-edit)
// 	---------------------------------------------------------------

typedef struct
{
	char *TxtAdr;			// ->Text to edit
	DWORD	MaxChar;		// max bytes
	DWORD	Flags;			// see below
	char *TtlAdr;			// ->title string (0="Edit Text")
	DWORD	HelpID;			// help context # (0=contents pg)
	DWORD	HelpFile;		// ->help file name (0=ours)
}TDLG;

// Defined in c:\program\vstudio6\vc98\include\prsht.h
// #define PSH_NOAPPLYNOW		0x0080

#define PSM_SETCURSEL			(WM_USER + 101)
#define PSM_REMOVEPAGE		(WM_USER + 102)
#define PSM_ADDPAGE				(WM_USER + 103)
#define PSM_CHANGED				(WM_USER + 104)
#define PSM_QUERYSIBLINGS	(WM_USER + 108)
#define PSM_UNCHANGED			(WM_USER + 109)
#define PSM_APPLY					(WM_USER + 110)
#define PSM_SETTITLEA			(WM_USER + 111)
#define PSM_SETTITLE			PSM_SETTITLEA

#define NoApplyBtn	0x0080		// flag for PSheet Options

#endif