// 	===============================================================
// 	DWinCtrl.CPY - Drawing Window Control Object
// 	===============================================================
// 	Copyright 1999 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 20-July-1999
// 	===============================================================

#ifndef _DWINCTRL_H_
#define _DWINCTRL_H_

#include <BKIMAGE.H>


typedef struct
{
	RECT	Scrn;					// proportional rectangle loc
	VIEWP	View;					// window view spec
}DWDEF;

#define DWIN2		0			// type of window in MDWin

typedef struct
{
	DWORD	ppCtrlVTbl;		// methods VTable
	DWORD	hPWinO;				// parent window Win object
	DWORD	hPCtrl;				// parent control object
	RECT	Loc;					// location rectangle
	RECT	Free;					// unallocated rectangle
					 						// This rectangle is the real dwg area
 											// DWCtrl.wid & .hgt calc from it
	DWORD	take;					// take flags
	DWORD	tsize;				// take size
	DWORD	tsizea;				// apportioned take
	DWORD	frame;				// frame style
	DWORD	flags;				// general flags
	WORD	CType;				// control type
	WORD	Stat;					// 1=control visible
	char	CName[64];		// control name
 
	DWORD	WClass;				// type of window
	BKIMAGE	*hBkImage;	// handle of DWIN BkImage
	BKIMAGE	*uBkImage;	// handle of BkImage to use
	DWORD	DWFlags;			// this DWIN flags
	RECT	Scrn;					// proportional rectangle loc
	RECT	Rest;					// scrn rect for restore
			 								// right=0=not maximized
	RECT	TBRect;				// title bar rect
	RECT	VIRect;				// View information rectangle
	RECT	DIRect;				// DList information rectangle
	RECT	CIRect;				// ctrl icon rectangle
 
	DWORD	hDList;				// DList to redraw
	VIEWP	View;					// window view spec
	double	AWidth;			// window actual width
	double	AHeight;		// window actual height
	GWIN2	Xtnt;					// current window edges
	DWORD	wid;					// win width in pixels
	DWORD	hgt;					// win hgt in pixels
	DWORD	ppi;					// pixels per inch
 
	TMat	W2VTM;				// world to view transform
	TMat	V2WTM;				// view to world transform
 
	double	XLow3;			// 3d clipping extents
	double	YLow3;		
	double	XHi3;		
	double	YHi3;		
 
	double	PSpecD;			// eye distance for perspective
	DWORD	hRender;			// active render object
	double	PSOfst;			// perspective offset (VNear)
	char	VName[64];		// window/view name

	int		fSBVis;			// 1=scroll bars visible, 0=hidden
	void*	hVSBar;			// vertical SBAR control or 0
	void*	hHSBar;			// horizontal SBAR control or 0
}DWCTRL;

// 	===============================================================
// 	Ctrl Object Method Equates
// 	===============================================================

struct DWList
{
  virtual void __stdcall DWDelete(void) = 0;		// delete the control
	

};
/*
#define DWDelete			 0		// delete the control
#define DWUpdate			 1		// update ctrl to the screen
#define DWResize			 2		// move/resize the control
#define DWDraw				 3		// draw the control
#define DWMouse				 4		// process mouse event
 
#define DWAddCtrl			 5		// ** add contained control
#define DWRmvCtrl			 6		// ** remove contained control
#define DWDrawFrame		 7		// draw frame & winctrl icon
#define DWReScale			 8		// rescale view
#define DWReOrg				 9		// reorigin view

// 	The following functions are not valid for the main container
// 	drawing window:

#define DWSetView2		10		// set view for DWIN
#define DWSetEPick		11		// set each pick window
#define DWSetWPick		12		// set win pick window
#define DWPaperScale	13		// paperscale value -> matching dwgUnits
#define DWSetWName		14		// specify window name string
#define DWAskXYAlign	15		// ask if DWIN aligned with XY plane


// 	The following functions are for the main drawing window
// 	container object only:

#define MDWinEmpty	10		// empty main dwin container
#define MDWinWalkFront	11		// walk windows to front
*/ 


void _stdcall CreateDWCtrl(DWORD hPWinO, DWORD hPCtrl, DWORD pDWDEF);
DWList *_stdcall CreateXWCtrl(VIEWP *pViewP, RECT *pDevRect, HDC hXDC);
void _stdcall ChangeAW(DWORD hCtrl);
void _stdcall DWinClipGWin2(DWORD hDW, DWORD hGWin2, DWORD hRWin2);
void _stdcall DWinFwdDV(DWORD hDW, DWORD pDV);
void _stdcall DWinBackDV(DWORD hDW, DWORD pDV);
void _stdcall Redraw(void);
void _stdcall RedrawCmd(void);
void _stdcall ZExtCmd(void);
void _stdcall ZLastCmd(void);
void _stdcall ZStdCmd(void);

// 	===============================================================

#endif