// 	===============================================================
// 	DStyles.CPY - Dimension Styles Infoblock Structure
// 	===============================================================
// 	Copyright 2000 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 4-Feb-2000
// 	===============================================================
//  Converted to C-Style 20-Feb-2000
//

#ifndef _DSTYLES_H_
#define _DSTYLES_H_

// 	Style data structure in entity:

typedef struct
{
	WORD	id;				// 0=individual, else style controls
	WORD	DFlags;			// style flags
	float	LdrExt;			// leader extends beyond dimension line
	float	LdrOfs;			// leader offset from geometry
	float	TolP;			// tolerance values
	float	TolM;		
	float	BSpacing;		// baseline spacing
	float	Scale;			// scale dimension value by
	ASTY	AS;				// arrowhead style
	char	DTDecP;			// number of decimal places (0 to 9)
	char	LThick;			// leader pen thickness
	float	THgt;			// text height
	WORD	Font;			// font id
	char	TThick;			// vector text thickness
	char	VPos;			// vert pos 0=below 1=cen 2=above
	char	HPos;			// 0=cen(auto-left) 1=cen(auto-right)
 							// 2=always cen 3=left 4=right
	char	rsvd;			// reserved
	char	TFmt;			// tolerance format
	char	DText[5];		// text format pattern
	DWORD	unused[15];

}DSTY;


// 	Values for DFlags:

#define DS2_TXALN		0x10	// 1=dim text aligned/0=always horiz
#define DS2_TOL			0x40	// specify tolerancing
#define DS2_RDCM		0x100	// show center mark
#define DS2_RDCL		0x200	// show center lines
#define DS2_HOTUPD		0x8000	// hot-link style changes to dims

//	Values for TFmt:

#define TOL_NONE	     0	// no tolerancing
#define TOL_SYMMETRICAL	 1	// val <plusminus> tol
#define TOL_DEVIATION	 2	// val <super>TolP <sub>TolM
#define TOL_LIMITS	     3	// <super>val+TolP<sub>val-TolM
#define TOL_BASIC	     4	// val in a box

// 	===============================================================

// 	Structure record in DSTYLE Infoblock:

typedef struct
{
	DWORD	rlen;			// this record length
	DSTY	DDS;			// dim style data
	char	SName;			// dim style name text
}DSTYLE;


#define IB_DSTYLE			9
#define IB_DSTYLE_VER		0

typedef struct
{
	DWORD	ERLen;
	char	EType;		
	char	IType;			// type of infoblock
	char	Ver;			// IB version number
	WORD	NextId;			// next free id # for new DStyle
	WORD	CurDStyleI;		// id # of current DStyle
	DWORD	CurDStyl;		// offset of CurDStyId's DStyle struc
}DSTYLEIB;


// 	There are 1 or more DStyle structures after CurDStyle,
// 	followed by a DWORD=0 end marker (included in length).

#endif