;	===============================================================
;	DStyles.CPY - Dimension Styles Infoblock Structure
;	===============================================================
;	Copyright 2000 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 4-Feb-2000
;	===============================================================

;	Style data structure in entity:

ASty		struc
ALen		real4	0.18		;arrowhead length
AHgt		real4	0.08		;arrowhead height
AStyle		db	0		;arrowhead type id
AThick		db	0		;arrowhead line thickness
ASty		ends

DSty		struc
id		dw	0		;0=individual, else style controls
DFlags		dw	0		;style flags
LdrExt		real4	0.18		;leader extends beyond dimension line
LdrOfs		real4	0.0625		;leader offset from geometry
TolP		real4	0.0		;tolerance values
TolM		real4	0.0
BSpacing	real4	0.4		;baseline spacing
Scale		real4	1.0		;scale dimension value by
AS		ASty	<0.18,0.08,0,0>	;arrowhead style
DTDecP		db	3		;number of decimal places (0 to 9)
LThick		db	0		;leader pen thickness
THgt		real4	0.2		;text height
Font		dw	0		;font id
TThick		db	0		;vector text thickness
VPos		db	1		;vert pos 0=below 1=cen 2=above
HPos		db	1		;0=cen(auto-left) 1=cen(auto-right)
;					;2=always cen 3=left 4=right
rsvd		db	0		;reserved
TFmt		db	0		;tolerance format
DText		db	'<>'		;text format pattern
		db	0,0,0
		dword	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
DSty		ends

;	Values for DFlags:

DS2_TXALN	equ	10h	;1=dim text aligned/0=always horiz
DS2_TOL		equ	40h	;specify tolerancing
DS2_RDCM	equ	100h	;show center mark
DS2_RDCL	equ	200h	;show center lines
DS2_HOTUPD	equ	8000h	;hot-link style changes to dims

;	Values for TFmt:

TOL_NONE	equ	0	;no tolerancing
TOL_SYMMETRICAL	equ	1	;val <plusminus> tol
TOL_DEVIATION	equ	2	;val <super>TolP <sub>TolM
TOL_LIMITS	equ	3	;<super>val+TolP<sub>val-TolM
TOL_BASIC	equ	4	;val in a box

;	===============================================================
;	Structure record in DSTYLE Infoblock:
;	===============================================================

DStyle		struc
rlen		dword	sizeof(DStyle)	;this record length
DDS		DSty	<>		;dim style data
SName		db	0		;dim style name text
DStyle		ends

;	===============================================================
;	DStyle Infoblock record:
;	===============================================================

IB_DSTYLE	equ	9
IB_DSTYLE_VER	equ	0

DStyleIB	struc
ERLen		dword	sizeof(DStyleIB)
EType		db	ET_IB
IType		db	IB_DSTYLE	;type of infoblock
Ver		db	IB_DSTYLE_VER	;IB version number
NextId		word	2		;next free id # for new DStyle
CurDStyleId	word	0		;id # of current DStyle
CurDStyle	dword	0		;offset of CurDStyleId's DStyle struc
DStyleIB	ends

;	There are 1 or more DStyle structures after CurDStyle,
;	followed by a dword=0 end marker (included in length).

