;	===============================================================
;	DLMgr.CPY - Drawing List Management Object
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 20-July-1999
;	===============================================================

CreateDList	proto	stdcall,pLName:dword,Flags:dword
AskValidDL	proto	stdcall,hDList:dword
FlushDLExcept	proto	stdcall,hDLKeep:dword

DL_NRREFPTRS	equ	32
IB_CSHEET	equ	32			;current sheet ptr

DList		struc
ppDLVTbl	dword	0			;->->VTBL for the object
fwd		dword	0			;->ECTL of prior record
back		dword	0			;->ECTL of next record
flags		dword	0			;DList flags
pOwner		dword	0			;sublist owner ECTL
hParent		dword	0			;OVL top parent (0=is top)
pCloseProc	dword	0			;call before destroy
pCloseData	dword	0			;data for pCloseProc
OpLvl		dword	0			;undo operation level
MaxOpLvl	dword	0			;highest oplevel in dlist
FName		db	MAXPATH dup (0)		;file name of DList
SName		db	64 dup (0)		;short name
ID		FileID	<>			;file ID block
RefPtrs		dword	DL_NRREFPTRS dup (0)	;reference pointers
pCSheet		dword	0			;ptr to current sheet
ScanStop	dword	0			;last recd of scan if non-zero
fNotThisOpLvl	dword	0		;1=DLScan ignore recds of current oplvl
DList		ends

;	Values for DList.flags:

DL_STD		equ	1		;standard drawing list
DL_SubL		equ	40h		;this DList is a sublist
DL_Head		equ	80h		;all DLists have this set
;					;to identify the end of list
;					;No ECTL.flags ever has it set
DL_Private	equ	2		;private use DList (no draw)
DL_XREF		equ	4		;XREF overlay file
DL_RO		equ	8		;DList is read-only
DL_SEP		equ	16		;Separate drawing
;					;(main OPEN is also DL_STD)
DL_CHANGED	equ	100h		;dlist has been changed

;	===============================================================
;	DList Object Method Equates
;	===============================================================

DLDestroy	equ	0		;Destroy the DList
DLApnd		equ	1		;Append record
DLApndE		equ	2		;Append Empty record
DLClone		equ	3		;Clone record
DLErase		equ	4		;Erase record
DLUnErase	equ	5		;UnErase record
DLReplace	equ	6		;Replace record
DLDelete	equ	7		;Delete record
DLResize	equ	8		;Resize record
DLSave		equ	9		;Save to File
DLLoad		equ	10		;Load from File
DLScan		equ	11		;Scan the DList
DLEmpty		equ	12		;Empty the DList
DLRename	equ	13		;Rename the DList
DLSelect	equ	14		;select record
DLUnSelect	equ	15		;unselect record
DLAskSelected	equ	16	;ask if record selected
DLMakeSubList	equ	17	;create entity sublist
DLGetSubList	equ	18	;get entity sublist
DLRelSubList	equ	19	;release sublist
DLMark		equ	20		;Mark record
DLUnMark	equ	21		;UnMark record
DLAskMarked	equ	22		;ask if record Marked
DLDup		equ	23		;duplicate recd & its sublist
DLMoveB		equ	24		;move before spec recd
DLMoveA		equ	25		;move after spec recd
DLMarkUndo	equ	26		;mark undo to now
DLCopy		equ	27		;append copy of rec incl SL
DLAskErased	equ	28		;ask if record is Erased
DLGetNext	equ	29		;get next record
DLGetPrev	equ	30		;get previous record
DLGetFileName	equ	31	;get DList file name
DLGetIBAdr	equ	32		;Get Infoblock Address
DLSetIBAdr	equ	33		;Set Infoblock Address
DLOnClose	equ	34		;Spec proc to call before 
;					;DList is destroyed
DLDelSubList	equ	35	;Delete entity sublist
DLPack		equ	36		;Remove all undo data
DLSetCurSheet	equ	37	;Set Current Sheet
DLGetScanSheet	equ	38	;Get scanned sheet during DLScan
DLNoUndo	equ	39		;change to record cant undo
DLAskChanged	equ	40	;ask if file changed (eax=1,stc yes)
DLSetChanged	equ	41	;Set file changed flag
DLClrChanged	equ	42	;Clear file changed flag
DLAskEmpty	equ	43		;return TRUE if DList is empty
DLCopyOpLevel	equ	44	;copy oplevel so sublists will copy
DLAskOnClose	equ	45	;get on-close proc
DLGetLayout	equ	46		;get current layout sheet sublist
DLScanLayout	equ	47	;Scan the DList or its current layout
DLScanStop		equ	48	;stop scan after specified record
DLLastSelected	equ	49	;get last selected outer record
DLNotThisOpLvl	equ	50	;set ignore current oplvl records
DLThisOpLvlOk	equ	51	;clear ignore current oplvl records
DLAskSubList	equ	52	;ask if entity has non-empty sublist
DLValidate		equ	53	;return 0 (clc) if list has no logic errors

;	===============================================================
;	ECTL - Entity Control Header Structure - prefix to each EntRec
;	===============================================================

ECTLSIG		equ		349ACFBEh	;identifies valid ECTL record

ECTL		struc
fwd			dword	0	;->ECTL of prior record
back		dword	0	;->ECTL of next record
flags		db		0	;entity control flags
sfwd		dword	0	;sublist if <> 0
sback		dword	0
sflags		db		0	;sublist end marker
EOpAdd		db		0	;Undo flags
EOpEra		db		0
sig			dword	0	;ECTL validate signature
ofst		dword	0	;recd length + sizeof ECTL
;						;offset to overwrite sig dword
;						;at end of record
ECTL		ends

;	values for ECTL.flags:

ECF_Sel		equ	1		;entity selected
ECF_Delay	equ	2		;entity will be selected
ECF_PSel	equ	4		;prior select bit (RDataSel)
ECF_Head	equ	80h		;no entity ever has this
;					;bit set - it identifies
;					;start of the DList
ECF_Hilite	equ	40h		;entity is hilighted
ECF_User	equ	20h		;XP can use this flag
;					;note it is not saved with dwg

;	Values for DLScan flags:

DLS_Sel		equ	10000h		;only selected entities
DLS_NotSel	equ	20000h		;only unselected entities
DLS_RO		equ	40000h		;allow read-only entities
DLS_Erased	equ	80000h		;all entities, even erased
DLS_SL		equ	01000h		;also ents in sublists
;							;after owner entity
DLS_Undo	equ	02000h		;undo logic scan (internal use only!)
DLS_SeeXR	equ	04000h		;see overlay XREF (before expand)
DLS_NoXRX	equ	08000h		;no overlay XREF expand
;
DLS_SHEETS	equ	00800h		;See sheets instead of scan
;							;their sublist
DLS_HSHTOK	equ	00400h		;Ok to process hidden sheets
;
DLS_Std		equ	0		;standard all non-erased ents
DLS_Edit	equ	DLS_Std+DLS_Sel	;entities to edit
DLS_Info	equ	DLS_Edit+DLS_RO	;entities to list
DLS_All		equ	DLS_Std+DLS_SL	;everything not erased

;	===============================================================

;	part helper functions

PartLoad	proto	stdcall,pFName:dword	;return hDL merged part
PartInsert	proto	stdcall,hSrcDL:dword,hDestDL:dword,
				pTM:dword,hMainDL:dword
PartWrite	proto	stdcall,pFName:dword,hSrcDL:dword,pTM:dword
LoadSymDef	proto	stdcall,pFName:dword

;	===============================================================
